/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.component;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.smarthse.modules.health.component.properties.TaskExecutorProperties;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootConfiguration
@EnableConfigurationProperties(value={TaskExecutorProperties.class})
public class CustomBeanConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomBeanConfig.class);
    private static final double BLOCKING_FACTOR = 0.8;
    int ioCorePoolSize = (int)Math.ceil((double)Runtime.getRuntime().availableProcessors() * 1.8);
    int ioMaxPoolSize = Math.min(this.ioCorePoolSize * 2, Integer.MAX_VALUE);

    @Bean(value={"commonThreadPoolExecutor"})
    @Primary
    public ThreadPoolExecutor threadPoolExecutor() {
        return new ThreadPoolExecutor(8, 20, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(2000));
    }

    @Bean(value={"gradeThreadPoolExecutor"})
    public ThreadPoolExecutor gradeThreadPoolExecutor() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 20, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNamePrefix("\u5206\u7c7b\u4efb\u52a1\u7ebf\u7a0b-").setUncaughtExceptionHandler((thread, throwable) -> log.error("\u7ebf\u7a0b\uff1a{}\uff0c \u5206\u7ea7\u5206\u7c7b\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0ce:", (Object)thread, (Object)throwable)).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        return executorService;
    }

    @Bean(value={"complianceReloadDataThreadPoolExecutor"})
    public ThreadPoolExecutor complianceReloadDataThreadPoolExecutor() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.ioCorePoolSize, this.ioMaxPoolSize, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNamePrefix("\u5408\u89c4\u4f01\u4e1a\u4e1a\u52a1\u6570\u636e\u52a0\u8f7d\u7ebf\u7a0b-").setUncaughtExceptionHandler((thread, throwable) -> log.error("\u5408\u89c4\u4f01\u4e1a\u4e1a\u52a1\u6570\u636e\u52a0\u8f7d\uff1a{}\uff0c \u5408\u89c4\u4f01\u4e1a\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0ce:", (Object)thread, (Object)throwable)).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        log.error("\u5408\u89c4\u4f01\u4e1a\u4e1a\u52a1\u6570\u636e\u52a0\u8f7d\uff1a{}\uff0c \u5f02\u5e38\u7ec8\u6b62\uff0ce:{}", (Object)Thread.currentThread(), (Object)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        return executorService;
    }

    @Bean(value={"batchBusinessUpdateThreadPoolExecutor"})
    public ThreadPoolExecutor batchBusinessUpdateThreadPoolExecutor() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.ioCorePoolSize, this.ioMaxPoolSize, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNamePrefix("\u4e1a\u52a1\u66f4\u65b0\u5408\u89c4\u4f01\u4e1a\u591a\u4e2a\u4efb\u52a1\u7ebf\u7a0b-").setUncaughtExceptionHandler((thread, throwable) -> log.error("\u4e1a\u52a1\u66f4\u65b0\u5408\u89c4\u4f01\u4e1a\u591a\u4e2a\u4efb\u52a1\u7ebf\u7a0b\uff1a{}\uff0c \u5408\u89c4\u4f01\u4e1a\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\uff0ce:", (Object)thread, (Object)throwable)).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        log.error("\u4e1a\u52a1\u66f4\u65b0\u5408\u89c4\u4f01\u4e1a\u591a\u4e2a\u4efb\u52a1\u7ebf\u7a0b\uff1a{}\uff0c \u5f02\u5e38\u7ec8\u6b62\uff0ce:{}", (Object)Thread.currentThread(), (Object)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        return executorService;
    }

    @Bean(name={"threadPoolTaskExecutorToCompanyChange"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutorToCompanyChange(TaskExecutorProperties taskExecutorProperties) {
        log.info("\u914d\u7f6e\u4fe1\u606f\u53d8\u66f4 ThreadPoolTaskExecutor\uff1a {}", (Object)taskExecutorProperties.getThreadNamePrefix());
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> log.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u65e0\u6cd5\u6267\u884c\u65b0\u4efb\u52a1\uff0c\u4efb\u52a1\u4e22\u5f03"));
        executor.initialize();
        return executor;
    }
}

