/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.task;

import cn.smarthse.common.util.Convert;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.compliance.dao.ComplianceAreaScoreMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceAreaScore;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceAreaScoreService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyExitItemService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemdataService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Component
public class ComplianceTask {
    Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    IComplianceScoreRefreshService scoreRefreshService;
    @Resource
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Resource
    IComplianceCompanyExitItemService exitItemService;
    @Resource
    IComplianceCompanyInfoService companyInfoService;
    @Resource
    IComplianceCompanyItemdataService itemdataService;
    @Resource
    IStaffInfoService staffInfoService;
    @Resource
    IComplianceAreaScoreService complianceAreaScoreService;
    @DubboReference(version="1.0.0")
    ISysAreaProvideService areaProvideService;
    final BigDecimal AREA_SCORE_HIGH = new BigDecimal(3);
    final BigDecimal AREA_SCORE_LOW = new BigDecimal(0);
    final BigDecimal CITY_SCORE_LOW = new BigDecimal(0);
    final BigDecimal CITY_SCORE_HIGH = new BigDecimal(2);
    final Double CITY_SCORE_BASE = 0.5;
    private static final List<String> EXCLUDED_AREAS = Arrays.asList("\u5f00\u53d1\u533a", "\u5b81\u6ce2\u676d\u5dde\u6e7e\u65b0\u533a", "\u897f\u6e56\u897f\u6eaa\u7ba1\u59d4\u4f1a");

    @XxlJob(value="ComplianceTask-PhysicalCheckCacheDelTask")
    public void PhysicalCheckCacheDelTask() {
        this.logger.info("\u5220\u9664\u5408\u89c4\u4f01\u4e1a\u7b2c\u4e94\u9879\u7f13\u5b58\u5f00\u59cb");
        Set keys = this.redisTemplate.keys((Object)"PhysicalCheckScoreCalcHandle:*");
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
        this.logger.info("\u5220\u9664\u5408\u89c4\u4f01\u4e1a\u7b2c\u4e94\u9879\u7f13\u5b58\u7ed3\u675f");
    }

    @XxlJob(value="ComplianceTask-refreshStatusTask")
    public void refreshStatusTask(List<Long> cidList, String itemCodeId) {
        this.scoreRefreshService.recordDailyChangeLog(cidList);
    }

    @XxlJob(value="ComplianceTask-loadExitTimeTask")
    public void loadExitTimeTask(List<Long> cidList) {
        long start = System.currentTimeMillis();
        this.logger.info("\u52a0\u8f7d\u7cfb\u7edf\u9000\u51fa\u9879\u6570\u636e\u4efb\u52a1\u5f00\u59cb");
        this.exitItemService.syncExitItem(cidList);
        this.logger.info("\u52a0\u8f7d\u7cfb\u7edf\u9000\u51fa\u9879\u6570\u636e\u4efb\u52a1\u7ed3\u675f,\u8017\u65f6\uff1a{}\u79d2", (Object)((System.currentTimeMillis() - start) / 1000L));
    }

    @XxlJob(value="ComplianceTask-loadNumCommitTask")
    public void loadNumCommitTask() {
        List allComplianceCids = this.companyInfoService.getAllComplianceCids(Arrays.asList(ComplianceInfoStatusEnum.COMPLIANT.getKey(), ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey()));
        if (CollectionUtils.isEmpty((Collection)allComplianceCids)) {
            return;
        }
        List allComplianceIdList = allComplianceCids.stream().map(ComplianceCompanyInfo::getId).distinct().collect(Collectors.toList());
        List cids = allComplianceCids.stream().map(ComplianceCompanyInfo::getCid).distinct().collect(Collectors.toList());
        XxlJobHelper.log((String)"\u9700\u5237\u65b0\u5408\u89c4\u4f01\u4e1a\u6570\uff1a{}", (Object[])new Object[]{allComplianceIdList.size()});
        Example example = new Example(ComplianceCompanyItemdata.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("itemcodeId", (Object)11303L).andIn("complianceId", allComplianceIdList).andIn("fieldName", Arrays.asList("localNumCommit", "outNumCommit"));
        List oldData = this.itemdataService.getListByExample(example);
        ArrayList<ComplianceCompanyItemdata> newData = new ArrayList<ComplianceCompanyItemdata>();
        List workNums = this.staffInfoService.getStaffInfoWorkNum(cids, null);
        Map<Long, StaffInfo> staffMap = workNums.stream().collect(Collectors.toMap(StaffInfo::getCid, v -> v));
        for (ComplianceCompanyInfo info : allComplianceCids) {
            ComplianceCompanyItemdata data1331 = new ComplianceCompanyItemdata();
            ComplianceCompanyItemdata data1332 = new ComplianceCompanyItemdata();
            StaffInfo workNum = staffMap.get(info.getCid());
            data1331.setComplianceId(info.getId());
            data1331.setItemcodeId(Long.valueOf(11303L));
            data1331.setFieldName("localNumCommit");
            data1331.setResultData(workNum != null ? Convert.toStr((Object)workNum.getLocalWorkNum()) : "0");
            newData.add(data1331);
            data1332.setComplianceId(info.getId());
            data1332.setItemcodeId(Long.valueOf(11303L));
            data1332.setFieldName("outNumCommit");
            data1332.setResultData(workNum != null ? Convert.toStr((Object)workNum.getOutWorkNum()) : "0");
            newData.add(data1332);
        }
        this.itemdataService.saveDataItemData(newData, oldData);
    }

    @XxlJob(value="ComplianceTask-countScoreByArea")
    @Transactional
    public void countScoreByArea() {
        this.complianceAreaScoreService.deleteAllComplianceAreaScores();
        List areaScoreList = this.complianceAreaScoreService.countAreaScoreByArea();
        Map<Long, List<ComplianceAreaScore>> groupedByCityId = areaScoreList.stream().peek(e -> {
            BigDecimal score = Optional.ofNullable(e.getComplianceCount()).filter(num -> num >= 5).map(num -> this.AREA_SCORE_HIGH).orElse(this.AREA_SCORE_LOW);
            e.setScore(score);
        }).collect(Collectors.groupingBy(ComplianceAreaScore::getCityId));
        List cityList = this.areaProvideService.getCityList(Long.valueOf(330000000000L));
        ArrayList finalScoreList = new ArrayList();
        cityList.forEach(e -> {
            ComplianceAreaScore cityScore = new ComplianceAreaScore();
            cityScore.setAreaId(e.getId());
            cityScore.setAreaLevel(e.getLevel());
            cityScore.setAreaName(e.getName());
            cityScore.setCityId(e.getCityId());
            cityScore.setId(Long.valueOf(IdWorker.getId()));
            cityScore.setIsValid(Boolean.valueOf(true));
            cityScore.setUpdateDate(new Date());
            List areaScores = Optional.ofNullable((List)groupedByCityId.get(e.getCityId())).orElseGet(Collections::emptyList);
            long count = areaScores.stream().peek(a -> {
                a.setIsValid(Boolean.valueOf(true));
                a.setId(Long.valueOf(IdWorker.getId()));
                a.setUpdateDate(new Date());
            }).filter(a -> EXCLUDED_AREAS.stream().noneMatch(area -> a.getAreaName().contains((CharSequence)area))).filter(a -> a.getComplianceCount() < 5).count();
            cityScore.setScore(count >= 4L ? this.CITY_SCORE_LOW : this.CITY_SCORE_HIGH.subtract(new BigDecimal(this.CITY_SCORE_BASE * (double)count)));
            finalScoreList.add(cityScore);
            finalScoreList.addAll(areaScores);
        });
        this.complianceAreaScoreService.batchUpdateOrInsert(finalScoreList, ComplianceAreaScoreMapper.class, (item, mapper) -> mapper.insert(item));
    }
}

