/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.task;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemcode;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ComplianceScoreRefreshTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceScoreRefreshTask.class);
    @Resource
    IComplianceScoreRefreshService scoreRefreshService;
    @Resource
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Resource
    IComplianceCompanyInfoService companyInfoService;
    @Autowired
    IComplianceCompanyItemcodeService itemcodeService;

    @XxlJob(value="ComplianceScoreRefreshTask-businessDataUpdateRefresh")
    public void businessDataUpdateRefresh(List<Long> cidList, String itemCodeId) {
        this.businessDataUpdateRefreshService.exeBussinessDataUpdateTask();
    }

    @XxlJob(value="ComplianceScoreRefreshTask-refreshAllCompliance")
    public void refreshAllCompliance() {
        List allComplianceCids = this.companyInfoService.getAllComplianceCids(Arrays.asList(ComplianceInfoStatusEnum.COMPLIANT.getKey(), ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey()));
        if (CollectionUtils.isEmpty((Collection)allComplianceCids)) {
            return;
        }
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObject = JSON.parseObject((String)jobParam);
        String itemCodeParam = null;
        if (jsonObject != null && jsonObject.containsKey((Object)"itemCode")) {
            itemCodeParam = jsonObject.getString("itemCode");
        }
        List allComplianceCidList = allComplianceCids.stream().map(ComplianceCompanyInfo::getCid).distinct().collect(Collectors.toList());
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        Set<String> codeSet = allItemcode.stream().filter(f -> Objects.equals(f.getType(), 1)).map(ComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        String[] itemCodes = codeSet.toArray(new String[codeSet.size()]);
        XxlJobHelper.log((String)"\u9700\u5237\u65b0\u5408\u89c4\u4f01\u4e1a\u6570\uff1a{}", (Object[])new Object[]{allComplianceCidList.size()});
        if (StringUtils.isNotBlank((CharSequence)itemCodeParam)) {
            XxlJobHelper.log((String)"\u5237\u65b0\u5355\u9879\u6570\u636e\uff0c itemCodeParam\uff1a{}", (Object[])new Object[]{itemCodeParam});
            this.scoreRefreshService.reloadRefData(allComplianceCidList, null, new String[]{itemCodeParam});
        } else {
            this.scoreRefreshService.reloadRefData(allComplianceCidList, null, itemCodes);
        }
    }

    @XxlJob(value="ComplianceScoreRefreshTask-refreshOrgCode03ByGradeLastReport")
    public void refreshOrgCode03ByGradeLastReport() {
        List allComplianceCids = this.companyInfoService.getAllComplianceCids(Arrays.asList(ComplianceInfoStatusEnum.COMPLIANT.getKey(), ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey()));
        if (CollectionUtils.isEmpty((Collection)allComplianceCids)) {
            return;
        }
        List allComplianceCidList = allComplianceCids.stream().map(ComplianceCompanyInfo::getCid).distinct().collect(Collectors.toList());
        this.scoreRefreshService.reloadRefData(allComplianceCidList, null, new String[]{"03"});
    }
}

