/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyVictimsInfo;
import cn.smarthse.modules.health.compliance.dao.RegisterToChuangdeMapper;
import cn.smarthse.modules.health.compliance.entity.RegisterToChuangde;
import cn.smarthse.modules.health.compliance.service.IRegisterToChuangdeService;
import cn.smarthse.modules.health.dataservice.entity.ChuangdeSystemAreaInfo;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.snowflake.IdWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional
public class RegisterToChuangdeServiceImpl
extends BaseServiceImpl<RegisterToChuangdeMapper, RegisterToChuangde>
implements IRegisterToChuangdeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegisterToChuangdeServiceImpl.class);
    @Autowired
    protected IdWorker idworker;
    @Autowired
    private RegisterToChuangdeMapper registerToChuangdeMapper;

    public List<SysArea> getAllArea() {
        return this.registerToChuangdeMapper.getAllArea();
    }

    public List<ChuangdeSystemAreaInfo> getAllChuangdeArea() {
        return this.registerToChuangdeMapper.getAllChuangdeArea();
    }

    public void batchUpdate(List<RegisterToChuangde> finalDataList) {
        this.registerToChuangdeMapper.batchUpdate(finalDataList);
    }

    public void AreaToChuangde(List<RegisterToChuangde> finalDataList) {
        this.registerToChuangdeMapper.AreaToChuangde(finalDataList);
    }

    public void registerDeduplication() {
        List<SysArea> sysAreas;
        Map<Long, SysArea> sysAreaMap;
        List<Company> companyList = this.registerToChuangdeMapper.selectAllCompanyByRegister();
        if (CollectionUtils.isNotEmpty(companyList) && MapUtils.isNotEmpty(sysAreaMap = (sysAreas = this.registerToChuangdeMapper.getAllArea()).stream().collect(Collectors.toMap(SysArea::getId, a -> a, (a1, a2) -> a1)))) {
            ArrayList<Company> companies = new ArrayList<Company>();
            for (Company company : companyList) {
                String provinceName;
                String cityName;
                String areaName;
                SysArea sysArea;
                String registerAddress = company.getRegisterAddress();
                Long registerAddressRegionId = company.getRegisterAddressRegionId();
                if (!StringUtils.isNotBlank((CharSequence)registerAddress) || !ObjectUtil.isNotNull((Object)registerAddressRegionId) || !ObjectUtil.isNotEmpty((Object)(sysArea = sysAreaMap.get(registerAddressRegionId)))) continue;
                String streetName = sysArea.getStreetName();
                if (StringUtils.isNotEmpty((CharSequence)streetName)) {
                    registerAddress = registerAddress.replace(streetName, "");
                }
                if (StringUtils.isNotEmpty((CharSequence)(areaName = sysArea.getAreaName()))) {
                    registerAddress = registerAddress.replace(areaName, "");
                }
                if (StringUtils.isNotEmpty((CharSequence)(cityName = sysArea.getCityName()))) {
                    registerAddress = registerAddress.replace(cityName, "");
                }
                if (StringUtils.isNotEmpty((CharSequence)(provinceName = sysArea.getProvinceName()))) {
                    registerAddress = registerAddress.replace(provinceName, "");
                }
                company.setRegisterAddress(registerAddress);
                companies.add(company);
            }
            if (companies.size() > 0) {
                for (Company company : companies) {
                    this.registerToChuangdeMapper.updateCompanyRegister(company);
                }
            }
        }
    }

    public List<CompanySuperviseModel> selectCompanyByCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return new ArrayList<CompanySuperviseModel>();
        }
        return this.registerToChuangdeMapper.selectCompanyByCids(cids);
    }

    public Integer updateStaffCount(List<CompanySuperviseModel> company) {
        return this.registerToChuangdeMapper.updateStaffCount(company);
    }

    public Integer updateIdentifyRealNum(List<CompanyVictimsInfo> companyVictimsInfo) {
        return this.registerToChuangdeMapper.updateIdentifyRealNum(companyVictimsInfo);
    }

    public Integer updateLegalCard(List<CompanyReportInfo> companyReportInfo) {
        return this.registerToChuangdeMapper.updateLegalCard(companyReportInfo);
    }

    public Integer updateLegalCardId(List<CompanyReportInfo> companyReportInfo) {
        return this.registerToChuangdeMapper.updateLegalCardId(companyReportInfo);
    }

    public List<CompanyReportInfo> getCompanyReportInfoByCids(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            return new ArrayList<CompanyReportInfo>();
        }
        return this.registerToChuangdeMapper.getCompanyReportInfoByCids(cidList);
    }

    public Integer updateLegalList(List<CompanySuperviseModel> updateLegalList) {
        return this.registerToChuangdeMapper.updateLegalList(updateLegalList);
    }
}

