/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.health.compliance.dao.home.HomeComplianceMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceAreaScore;
import cn.smarthse.modules.health.compliance.model.home.HomeComplianceModel;
import cn.smarthse.modules.health.compliance.service.IComplianceAreaScoreService;
import cn.smarthse.modules.health.compliance.service.home.IHomeComplianceService;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceBasicVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceGuideVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceHeadlineVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceIndustryDisVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceIndustryVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceInfoVo;
import cn.smarthse.modules.health.compliance.vo.home.HomeComplianceRemindVo;
import cn.smarthse.modules.health.newcompliance.dao.NewComplianceAreaScoreMapper;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceAreaScore;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.rpc.filter.AccessLogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class HomeComplianceServiceImpl
implements IHomeComplianceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeComplianceServiceImpl.class);
    @Autowired
    private HomeComplianceMapper homeComplianceMapper;
    @Autowired
    private NewComplianceAreaScoreMapper complianceAreaScoreMapper;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private IComplianceAreaScoreService complianceAreaScoreService;
    private static final String CACHE_NAME = "homeCompliance";
    private static final String PROVINCE_AVG_KEY = "provinceAvg";
    private static final long CACHE_TIMEOUT = 600L;

    @Transactional(readOnly=true)
    public HomeComplianceBasicVo getBasicVo(HomeComplianceModel model) {
        HomeComplianceBasicVo vo = this.homeComplianceMapper.getBasicVo(model);
        return vo;
    }

    public HomeComplianceBasicVo getProvinceAvgVo() {
        return (HomeComplianceBasicVo)this.redisClient.get(CACHE_NAME, PROVINCE_AVG_KEY, 600L, this::calculateProvinceAvg);
    }

    @Transactional(readOnly=true)
    public HomeComplianceHeadlineVo getHeadlineVo(HomeComplianceModel model) {
        HomeComplianceHeadlineVo headlineVo = this.homeComplianceMapper.getHeadlineVo(model);
        Byte areaLevel = model.getAreaLevel();
        Long areaId = model.getAreaId();
        Boolean thisLevel = model.getThisLevel();
        if (areaId == null) {
            return null;
        }
        if (thisLevel != null && thisLevel.booleanValue()) {
            areaLevel = 3;
        }
        HomeComplianceBasicVo provinceAvgVo = this.getProvinceAvgVo();
        NewComplianceAreaScore areaScore = this.complianceAreaScoreMapper.getOneAreaScore(areaId, areaLevel);
        if (areaLevel <= 1) {
            headlineVo.setCompanyNum(Integer.valueOf(Math.toIntExact(provinceAvgVo.getEligibleCount())));
        } else if (areaScore != null) {
            headlineVo.setCompanyNum(areaScore.getCompanyNum());
        }
        if (areaScore != null) {
            headlineVo.setComplianceCount2024(areaScore.getComplianceCount2024());
            headlineVo.setComplianceProportion2024(areaScore.getComplianceProportion2024());
        }
        headlineVo.setProvinceAvg(provinceAvgVo.getProvinceAvg());
        headlineVo.setProvinceAvgCount(provinceAvgVo.getProvinceAvgCount());
        return headlineVo;
    }

    @Transactional(readOnly=true)
    public HomeComplianceRemindVo getRemindVo(HomeComplianceModel model) {
        return this.homeComplianceMapper.getRemindVo(model);
    }

    public HomeComplianceGuideVo getGuideVoList(HomeComplianceModel model) {
        HomeComplianceGuideVo rst = new HomeComplianceGuideVo();
        List<Object> list = model.getAreaLevel() < 2 ? this.homeComplianceMapper.getGuideVoByProvince(model) : (model.getAreaLevel() == 2 ? this.homeComplianceMapper.getGuideVoByCity(model) : Collections.emptyList());
        rst.setList(list);
        rst.setAreaId(model.getAreaId());
        rst.setAreaName(model.getAreaName());
        rst.setAreaLevel(model.getAreaLevel());
        if (list != null && CollectionUtils.isNotEmpty(list)) {
            int totalGuideNum = list.stream().filter(vo -> vo.getGuideNum() != null).mapToInt(HomeComplianceGuideVo::getGuideNum).sum();
            rst.setGuideNum(Integer.valueOf(totalGuideNum));
        } else {
            rst.setGuideNum(Integer.valueOf(0));
        }
        return rst;
    }

    public HomeComplianceIndustryDisVo getIndustryDisVo(HomeComplianceModel model) {
        HomeComplianceIndustryDisVo vo = new HomeComplianceIndustryDisVo();
        List<HomeComplianceIndustryVo> list = this.homeComplianceMapper.getIndustryDisVo(model);
        if (list == null || list.isEmpty()) {
            vo.setCompliantCount(Integer.valueOf(0));
            vo.setIndustry(Collections.emptyList());
            return vo;
        }
        int compliantCount = list.stream().mapToInt(HomeComplianceIndustryVo::getCompliantCount).sum();
        vo.setCompliantCount(Integer.valueOf(compliantCount));
        ArrayList<HomeComplianceIndustryVo> industry = new ArrayList<HomeComplianceIndustryVo>();
        int size = list.size();
        if (size <= 5) {
            industry.addAll(list);
        } else {
            List<HomeComplianceIndustryVo> topFive = list.subList(0, 5);
            industry.addAll(topFive);
            int otherCompliantCount = list.subList(5, size).stream().mapToInt(HomeComplianceIndustryVo::getCompliantCount).sum();
            HomeComplianceIndustryVo other = new HomeComplianceIndustryVo();
            other.setImportantType(Integer.valueOf(0));
            other.setImportantTypeName("\u5176\u4ed6");
            other.setCompliantCount(Integer.valueOf(otherCompliantCount));
            industry.add(other);
        }
        vo.setIndustry(industry);
        return vo;
    }

    public boolean getHasThisLevel(Long cityId) {
        return this.homeComplianceMapper.getHasThisLevel(cityId);
    }

    public List<HomeComplianceInfoVo> getInfoVo(HomeComplianceModel model) {
        List<HomeComplianceInfoVo> list = this.homeComplianceMapper.getInfoVo(model);
        this.setListScore(list);
        return list;
    }

    private HomeComplianceBasicVo calculateProvinceAvg() {
        BigDecimal provinceAvg = BigDecimal.ZERO;
        Long provinceAvgCount = 0L;
        HomeComplianceBasicVo vo = new HomeComplianceBasicVo();
        try {
            HomeComplianceModel model = new HomeComplianceModel();
            model.setAreaLevel(Byte.valueOf((byte)1));
            model.setAreaId(Long.valueOf(330000000000L));
            vo = this.getBasicVo(model);
            if (vo != null && vo.getComplianceProportion() != null) {
                String p = vo.getComplianceProportion().trim();
                if (!"\u2014\u2014".equals(p) && p.contains("%")) {
                    p = p.replace("%", "").trim();
                }
                provinceAvg = new BigDecimal(p).setScale(2, RoundingMode.HALF_UP);
                Long compliantCount = vo.getCompliantCount();
                if (compliantCount != null && compliantCount > 0L) {
                    provinceAvgCount = compliantCount / 90L;
                    if (compliantCount % 90L != 0L) {
                        provinceAvgCount = provinceAvgCount + 1L;
                    }
                } else {
                    provinceAvgCount = 0L;
                }
            }
        }
        catch (Exception ex) {
            AccessLogFilter.logger.error("\u89e3\u6790\u5168\u7701\u5e73\u5747\u5408\u89c4\u7387\u5931\u8d25\uff0c\u4f7f\u7528 0 \u4f5c\u4e3a\u9ed8\u8ba4\u503c", (Throwable)ex);
            provinceAvg = BigDecimal.ZERO;
        }
        vo.setProvinceAvg(provinceAvg);
        vo.setProvinceAvgCount(provinceAvgCount);
        AccessLogFilter.logger.info("\u8ba1\u7b97\u5168\u7701\u5e73\u5747\u5408\u89c4\u7387\u5b8c\u6210\uff0c\u7ed3\u679c\u5df2\u7f13\u5b58");
        return vo;
    }

    private void setListScore(List<HomeComplianceInfoVo> list) {
        Example example = new Example(ComplianceAreaScore.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
        List scoreList = this.complianceAreaScoreService.getListByExample(example);
        Map<String, BigDecimal> scoreMap = scoreList.stream().collect(Collectors.toMap(score -> score.getAreaId() + "_" + score.getAreaLevel(), ComplianceAreaScore::getScore, (existing, replacement) -> existing));
        for (HomeComplianceInfoVo vo : list) {
            String key = vo.getAreaId() + "_" + vo.getAreaLevel();
            if (!scoreMap.containsKey(key)) continue;
            vo.setScore(scoreMap.get(key));
        }
    }
}

