/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.dao.ComplianceTryCompanyWorkMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceAssessmentInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceTryCompanyWork;
import cn.smarthse.modules.health.compliance.service.IComplianceAssessmentInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceTryCompanyWorkService;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class ComplianceTryCompanyWorkServiceImpl
extends BaseServiceImpl<ComplianceTryCompanyWorkMapper, ComplianceTryCompanyWork>
implements IComplianceTryCompanyWorkService {
    @Autowired
    private IComplianceAssessmentInfoService complianceAssessmentInfoService;

    public List<ComplianceTryCompanyWork> getTryCompanyRefInfo(Long workId) {
        ComplianceTryCompanyWork param = new ComplianceTryCompanyWork();
        param.setWorkId(workId);
        List<ComplianceTryCompanyWork> tryCompanyRefInfo = ((ComplianceTryCompanyWorkMapper)this.dao).getTryCompanyRefInfo(param);
        return tryCompanyRefInfo;
    }

    public Integer getListByWorkAndCid(Long cid, Long workId) {
        Example example = new Example(ComplianceTryCompanyWork.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("cid", (Object)cid).andEqualTo("workId", (Object)workId);
        return ((ComplianceTryCompanyWorkMapper)this.dao).selectCountByExample(example);
    }

    @Transactional(readOnly=false)
    public Integer batchUpdateCompanyWorkList(List<ComplianceTryCompanyWork> companyWorkList) throws HealthException {
        if (CollectionUtils.isEmpty(companyWorkList)) {
            return null;
        }
        int i = this.batchUpdateOrInsert(companyWorkList, ComplianceTryCompanyWorkMapper.class, (s, mapper) -> {
            s.setId(Long.valueOf(this.idworker.nextId()));
            return mapper.insertSelective(s);
        });
        Long workId = companyWorkList.get(0).getWorkId();
        if (ObjectUtil.isNull((Object)workId)) {
            throw new HealthException("\u672a\u6307\u5b9a\u5de5\u4f5c\u533a");
        }
        ComplianceAssessmentInfo byId = (ComplianceAssessmentInfo)this.complianceAssessmentInfoService.getById(workId);
        Example example = new Example(ComplianceTryCompanyWork.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("workId", (Object)workId);
        Long countByExample = this.getCountByExample(example);
        byId.setCompanyNum(countByExample);
        this.complianceAssessmentInfoService.update((Object)byId);
        return i;
    }
}

