/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.dao.ComplianceTryCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceTryCompanyInfo;
import cn.smarthse.modules.health.compliance.service.IComplianceTryCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceTryCompanyWorkService;
import cn.smarthse.modules.health.compliance.vo.ComplianceTryCompanyInfoVo;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class ComplianceTryCompanyInfoServiceImpl
extends BaseServiceImpl<ComplianceTryCompanyInfoMapper, ComplianceTryCompanyInfo>
implements IComplianceTryCompanyInfoService {
    @Autowired
    private IComplianceTryCompanyWorkService tryCompanyWorkService;

    @Transactional(readOnly=false)
    public void initComplianceTryCompanyInfo(Long workId) {
        List tryCompanyWorks = this.tryCompanyWorkService.getTryCompanyRefInfo(workId);
        if (CollectionUtils.isEmpty((Collection)tryCompanyWorks)) {
            return;
        }
        List tryCompanyInfos = tryCompanyWorks.stream().filter(f -> f.getId() == null).map(m -> {
            ComplianceTryCompanyInfo info = new ComplianceTryCompanyInfo();
            info.setCid(m.getCid());
            info.setId(Long.valueOf(this.idworker.nextId()));
            info.setIsValid(Boolean.valueOf(true));
            info.setCreateDate(new Date());
            return info;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tryCompanyInfos)) {
            this.batchUpdateOrInsert(tryCompanyInfos, ComplianceTryCompanyInfoMapper.class, (item, mapper) -> mapper.insert(item));
        }
    }

    public List<ComplianceTryCompanyInfo> getComplianceCids(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            return null;
        }
        Example e = new Example(ComplianceTryCompanyInfo.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true);
        if (cids.size() == 1) {
            criteria.andEqualTo("cid", (Object)cids.get(0));
        } else {
            criteria.andIn("cid", cids);
        }
        e.selectProperties(new String[]{"id", "cid"});
        List<ComplianceTryCompanyInfo> listByExample = this.getListByExample(e);
        return listByExample;
    }

    public PageInfo<ComplianceTryCompanyInfoVo> getComplianceTryCompanyList(JqGridParam pageParam, String workId) throws HealthException {
        if (StringUtil.isEmpty((String)workId)) {
            throw new HealthException("\u5de5\u4f5c\u533a\u672a\u786e\u5b9a");
        }
        if (StringUtil.isEmpty((String)pageParam.getSord())) {
            pageParam.setSord("desc");
        }
        PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<ComplianceTryCompanyInfoVo> complianceTryCompanyInfoVos = ((ComplianceTryCompanyInfoMapper)this.dao).selectComplianceTryCompanyPage(pageParam.getSord(), workId);
        PageInfo data = new PageInfo(complianceTryCompanyInfoVos);
        return data;
    }
}

