/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.dao.ComplianceStaffInfoMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceStaffInfo;
import cn.smarthse.modules.health.compliance.service.IComplianceStaffInfoService;
import cn.smarthse.modules.health.compliance.vo.ComplianceStaffInfoVo;
import cn.smarthse.snowflake.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(rollbackFor={Exception.class})
public class ComplianceStaffInfoServiceImpl
extends BaseServiceImpl<ComplianceStaffInfoMapper, ComplianceStaffInfo>
implements IComplianceStaffInfoService {
    @Autowired
    protected IdWorker idworker;

    public List<ComplianceStaffInfo> getStaffInfoList(Long trainId) {
        return ((ComplianceStaffInfoMapper)this.dao).getStaffInfoList(trainId);
    }

    public void addStaffInfoList(List<ComplianceStaffInfo> addList, Long userId) {
        if (CollectionUtils.isNotEmpty(addList)) {
            Date date = new Date();
            addList.forEach(e -> {
                e.setId(Long.valueOf(this.idworker.nextId()));
                e.setUpdateBy(userId);
                e.setUpdateDate(date);
            });
            this.batchUpdateOrInsert(addList, ComplianceStaffInfoMapper.class, (e, mapper) -> mapper.insertSelective(e));
        }
    }

    public void deleteStaffInfoList(List<Long> deleteIdList, Long userId) {
        if (CollectionUtils.isNotEmpty(deleteIdList)) {
            Example example = new Example(ComplianceStaffInfo.class);
            example.createCriteria().andIn("id", deleteIdList);
            ComplianceStaffInfo staffInfo = new ComplianceStaffInfo();
            staffInfo.setIsValid(Boolean.valueOf(false));
            staffInfo.setUpdateDate(new Date());
            staffInfo.setUpdateBy(userId);
            ((ComplianceStaffInfoMapper)this.dao).updateByExampleSelective(staffInfo, example);
        }
    }

    public List<ComplianceStaffInfoVo> queryCompletedWorkerTrainInfo(List<Long> staffIdList) {
        if (CollUtil.isEmpty(staffIdList)) {
            return Collections.emptyList();
        }
        return ((ComplianceStaffInfoMapper)this.dao).queryCompletedWorkerTrainInfo(staffIdList);
    }
}

