/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.compliance.dao.complianceGhcollectMonthReportMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceGhcollectWeekReport;
import cn.smarthse.modules.health.compliance.service.IComplianceGhcollectMonthReportService;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualParam;
import cn.smarthse.util.common.StringUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class ComplianceGhcollectMonthReportServiceImpl
extends BaseServiceImpl<complianceGhcollectMonthReportMapper, ComplianceGhcollectWeekReport>
implements IComplianceGhcollectMonthReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceGhcollectMonthReportServiceImpl.class);

    public List<ComplianceGhcollectWeekReport> selectAll(Integer weekNum) {
        Example e = new Example(ComplianceGhcollectWeekReport.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true);
        if (weekNum != null) {
            criteria.andEqualTo("weekNum", (Object)weekNum);
        }
        return this.getListByExample(e);
    }

    public List<ComplianceGhcollectWeekReport> getHgCollectData(ComplianceVisualParam param) {
        List<ComplianceGhcollectWeekReport> dataList = ((complianceGhcollectMonthReportMapper)this.dao).getHgCollectData(param);
        return dataList;
    }

    public String generateMapKey(ComplianceGhcollectWeekReport report) {
        Long provinceId = Optional.ofNullable(report).map(ComplianceGhcollectWeekReport::getProvinceId).orElse(0L);
        Long cityId = Optional.ofNullable(report).map(ComplianceGhcollectWeekReport::getCityId).orElse(0L);
        Long areaId = Optional.ofNullable(report).map(ComplianceGhcollectWeekReport::getAreaId).orElse(0L);
        Long streetId = Optional.ofNullable(report).map(ComplianceGhcollectWeekReport::getStreetId).orElse(0L);
        Integer monthNum = Optional.ofNullable(report).map(ComplianceGhcollectWeekReport::getWeekNum).orElse(0);
        return StringUtils.join((Object[])new Number[]{provinceId, cityId, areaId, streetId, monthNum});
    }

    @Transactional(readOnly=false)
    public void collectReport() {
        ImmutablePair weekNumber = DateUtil.getWeekNumber((LocalDate)LocalDate.now());
        List<ComplianceGhcollectWeekReport> oldDataList = this.selectAll((Integer)weekNumber.getRight());
        List<ComplianceGhcollectWeekReport> newDataList = ((complianceGhcollectMonthReportMapper)this.dao).collectReport();
        if (CollectionUtils.isEmpty(newDataList)) {
            return;
        }
        newDataList.forEach(i -> i.setWeekNum((Integer)weekNumber.getRight()));
        Map<Object, Object> okdMapKeyIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(oldDataList)) {
            okdMapKeyIdMap = oldDataList.stream().collect(Collectors.toMap(k -> this.generateMapKey((ComplianceGhcollectWeekReport)k), ComplianceGhcollectWeekReport::getId, (v1, v2) -> v1));
        }
        for (ComplianceGhcollectWeekReport complianceGhcollectMonthReport : newDataList) {
            String mapKey = this.generateMapKey(complianceGhcollectMonthReport);
            complianceGhcollectMonthReport.setId((Long)okdMapKeyIdMap.get(mapKey));
        }
        List partition = ListUtil.partition(newDataList, (int)1000);
        for (List complianceGhcollectMonthReports : partition) {
            this.batchUpdateOrInsert(complianceGhcollectMonthReports, complianceGhcollectMonthReportMapper.class, (item, mapper) -> {
                if (item.getId() == null) {
                    item.setId(Long.valueOf(this.idworker.nextId()));
                    item.setCreateDate(new Date());
                    item.setIsValid(Boolean.valueOf(true));
                    return mapper.insert(item);
                }
                item.setUpdateDate(new Date());
                return mapper.updateByPrimaryKeySelective(item);
            });
        }
    }
}

