/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.compliance.calcscore.CalcScoreBusService;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceApplyAppend;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyLabel;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyProcessRecord;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoLabelEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceObjectionStatusEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceProcessStatusEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyObjectionApplyParam;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceApplyAppendService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyLabelService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyProcessRecordService;
import cn.smarthse.modules.health.compliance.service.ICompliancePrepareSmsService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyLabelVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyObjectionApplyVo;
import cn.smarthse.modules.health.compliance.vo.CompliantItemcodeTypeVo;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategoryType;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ComplianceCompanyObjectionApplyServiceImpl
extends BaseServiceImpl<ComplianceCompanyObjectionApplyMapper, ComplianceCompanyObjectionApply>
implements IComplianceCompanyObjectionApplyService {
    @Autowired
    private ComplianceCompanyInfoMapper infoMapper;
    @Autowired
    private IComplianceCompanyLabelService labelService;
    @Autowired
    IComplianceScoreRefreshService scoreRefreshService;
    @Autowired
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    CalcScoreBusService calcScoreBusService;
    @Autowired
    private IComplianceCompanyProcessRecordService processRecordService;
    @Autowired
    private ComplianceCompanyExitItemMapper exitItemMapper;
    @Resource
    private IComplianceApplyAppendService complianceApplyAppendService;
    @Autowired
    private IImportantIndustryCategoryService importantIndustryCategoryService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService regionService;
    @Autowired
    private ICompliancePrepareSmsService prepareSmsService;
    private static final String COMPLIANCE_ITEM_TYPE = "03,06,09,11,12,13,14";
    private static final String APPLY_ITEM_TYPE = "00,01,03,04,05,06,07,08,10";
    private static final Map<String, String> APPLY_ITEM_MAP;

    public List<CompliantItemcodeTypeVo> getItemcodeTypeList() {
        return ((ComplianceCompanyObjectionApplyMapper)this.dao).getItemcodeTypeList(COMPLIANCE_ITEM_TYPE);
    }

    public PageInfo<ComplianceCompanyObjectionApplyVo> getObjectionPage(JqGridParam pageParam, ComplianceCompanyObjectionApplyParam objectionParam) {
        this.preSetRegionInfo(objectionParam);
        ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
        typeParam.setMenuSet(Integer.valueOf(1));
        List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
        if (CollUtil.isNotEmpty((Collection)typeList)) {
            List industries = typeList.stream().map(ImportantIndustryCategoryType::getImportantType).map(String::valueOf).collect(Collectors.toList());
            objectionParam.setIndustries(industries);
        }
        Page objectionPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        objectionParam.setSelectItemcodeKey(COMPLIANCE_ITEM_TYPE);
        List<ComplianceCompanyObjectionApplyVo> objectionList = ((ComplianceCompanyObjectionApplyMapper)this.dao).getObjectionPage(objectionParam);
        objectionList.forEach(v -> v.setObjectionTypeName(ComplianceObjectionStatusEnum.getValue((Integer)v.getObjectionType())));
        return new PageInfo((List)objectionPage);
    }

    public PageInfo<ComplianceCompanyObjectionApplyVo> getApplyPage(JqGridParam pageParam, ComplianceCompanyObjectionApplyParam applyParam) {
        this.preSetRegionInfo(applyParam);
        ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
        typeParam.setMenuSet(Integer.valueOf(1));
        List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
        if (CollUtil.isNotEmpty((Collection)typeList)) {
            List industries = typeList.stream().map(ImportantIndustryCategoryType::getImportantType).map(String::valueOf).collect(Collectors.toList());
            applyParam.setIndustries(industries);
        }
        Page applyPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        applyParam.setSelectItemcodeKey(APPLY_ITEM_TYPE);
        List<ComplianceCompanyObjectionApplyVo> applyList = ((ComplianceCompanyObjectionApplyMapper)this.dao).getApplyPage(applyParam);
        applyList.forEach(v -> v.setObjectionTypeName(ComplianceProcessStatusEnum.getValue((Integer)v.getObjectionType())));
        applyList.forEach(v -> v.setTitle(APPLY_ITEM_MAP.get(v.getItemcodeKey())));
        return new PageInfo((List)applyPage);
    }

    public void preSetRegionInfo(ComplianceCompanyObjectionApplyParam objectionApplyParam) {
        if (objectionApplyParam == null) {
            return;
        }
        Long regionId = objectionApplyParam.getRegionId();
        AreaModel region = this.regionService.getAreaById(regionId);
        if (region != null && region.getId() != null) {
            objectionApplyParam.setRegionLevel(region.getLevel());
        }
    }

    public List<ComplianceCompanyObjectionApply> getUnprocessedByCidAndItemcodeId(Long cid, Long itemcodeId, Integer type) {
        Example example = new Example(ComplianceCompanyObjectionApply.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("itemcodeId", (Object)itemcodeId).andEqualTo("status", (Object)1).andEqualTo("type", (Object)type).andEqualTo("isValid", (Object)true);
        return ((ComplianceCompanyObjectionApplyMapper)this.dao).selectByExample(example);
    }

    public List<ComplianceCompanyObjectionApply> listObjectionApply(Long complianceId, List<Long> itemcodeIdList, Integer type, List<Integer> status) {
        Example example = new Example(ComplianceCompanyObjectionApply.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("complianceId", (Object)complianceId).andEqualTo("isValid", (Object)true);
        if (type != null) {
            criteria.andEqualTo("type", (Object)type);
        }
        if (CollectionUtil.isNotEmpty(status)) {
            criteria.andIn("status", status);
        }
        if (CollectionUtil.isNotEmpty(itemcodeIdList)) {
            criteria.andIn("itemcodeId", itemcodeIdList);
        }
        return ((ComplianceCompanyObjectionApplyMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void raiseObjection(ComplianceCompanyInfo info, ComplianceCompanyObjectionApply moudel, Long userId) {
        Date now = new Date();
        moudel.setId(Long.valueOf(IdWorker.getId()));
        moudel.setCid(info.getCid());
        moudel.setUpdateDate(now);
        moudel.setCreateDate(now);
        moudel.setUpdatedBy(userId);
        moudel.setCreateBy(userId);
        moudel.setStatus(Integer.valueOf(1));
        moudel.setType(Integer.valueOf(1));
        moudel.setIsValid(Boolean.valueOf(true));
        ((ComplianceCompanyObjectionApplyMapper)this.dao).insert(moudel);
        this.labelService.updateBypLabel(info.getId(), ComplianceInfoLabelEnum.OBJECTION.getKey(), userId);
        if (info != null && info.getStatus() != ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey()) {
            info.setUpdateDate(now);
            info.setUpdateBy(userId);
            if (info.getStatus() == ComplianceInfoStatusEnum.COMPLIANT.getKey()) {
                this.prepareSmsService.addPrepareSms(info.getId());
                info.setLastExitQualifyDate(new Date());
            }
            info.setStatus(ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
            this.infoMapper.updateByPrimaryKey(info);
            ArrayList<ComplianceCompanyLabel> list = new ArrayList<ComplianceCompanyLabel>();
            ComplianceCompanyLabel label = new ComplianceCompanyLabel();
            label.setComplianceId(info.getId());
            label.setLabel(ComplianceInfoLabelEnum.OBJECTION.getKey());
            label.setCreateBy(userId);
            label.setCreateDate(now);
            label.setIsValid(Boolean.valueOf(true));
            list.add(label);
            this.labelService.updateClashLabel(list);
        }
    }

    @Transactional(readOnly=false)
    public void sendAppeal(ComplianceCompanyObjectionApply moudel, Long userId) {
        ComplianceCompanyInfo complianceCompanyInfo = this.infoMapper.getInfoById(moudel.getComplianceId());
        Date now = new Date();
        moudel.setId(Long.valueOf(IdWorker.getId()));
        moudel.setCid(complianceCompanyInfo.getCid());
        moudel.setUpdateDate(now);
        moudel.setCreateDate(now);
        moudel.setUpdatedBy(userId);
        moudel.setCreateBy(userId);
        moudel.setStatus(Integer.valueOf(1));
        moudel.setType(Integer.valueOf(2));
        moudel.setIsValid(Boolean.valueOf(true));
        ((ComplianceCompanyObjectionApplyMapper)this.dao).insert(moudel);
        Map appendConditions = moudel.getAppendConditions();
        if (MapUtils.isNotEmpty((Map)appendConditions)) {
            List appendList = appendConditions.keySet().stream().map(key -> {
                ComplianceApplyAppend append = new ComplianceApplyAppend();
                append.setApplyId(moudel.getId());
                append.setKey(key);
                append.setValue((String)appendConditions.get(key));
                append.setId(Long.valueOf(IdWorker.getId()));
                append.setUpdateDate(now);
                append.setCreateDate(now);
                append.setUpdatedBy(userId);
                append.setCreateBy(userId);
                append.setIsValid(Boolean.valueOf(true));
                return append;
            }).collect(Collectors.toList());
            this.complianceApplyAppendService.saveBatch(appendList);
        }
        complianceCompanyInfo.setUpdateDate(now);
        complianceCompanyInfo.setUpdateBy(userId);
        if (ComplianceInfoStatusEnum.COMPLIANT.getKey() == complianceCompanyInfo.getStatus()) {
            complianceCompanyInfo.setLastExitQualifyDate(now);
        }
        complianceCompanyInfo.setStatus(ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
        this.infoMapper.updateByPrimaryKey(complianceCompanyInfo);
        ArrayList<ComplianceCompanyLabel> list = new ArrayList<ComplianceCompanyLabel>();
        ComplianceCompanyLabel label = new ComplianceCompanyLabel();
        label.setComplianceId(complianceCompanyInfo.getId());
        label.setLabel(ComplianceInfoLabelEnum.APPEAL.getKey());
        label.setCreateBy(userId);
        label.setCreateDate(now);
        label.setIsValid(Boolean.valueOf(true));
        list.add(label);
        this.labelService.updateClashLabel(list);
    }

    @Transactional(readOnly=false)
    public void withdrawAppeal(ComplianceCompanyObjectionApply apply, Long userId) {
        apply.setStatus(Integer.valueOf(2));
        ComplianceCompanyProcessRecord record = new ComplianceCompanyProcessRecord();
        record.setStatus(ComplianceProcessStatusEnum.CANCEL.getKey());
        record.setCreateBy(userId);
        record.setCreateDate(new Date());
        record.setObjectionApplyId(apply.getId());
        record.setId(Long.valueOf(this.idworker.nextId()));
        this.processRecordService.add((Object)record);
        this.changeStatusAfterAudit(apply, userId, ComplianceInfoLabelEnum.APPEAL.getKey());
    }

    @Transactional(readOnly=false)
    public void changeStatusAfterAudit(ComplianceCompanyObjectionApply objectionApply, Long userId, Integer label) {
        objectionApply.setUpdateDate(new Date());
        objectionApply.setUpdatedBy(userId);
        ((ComplianceCompanyObjectionApplyMapper)this.dao).updateByPrimaryKey(objectionApply);
        this.labelService.updateBypLabel(objectionApply.getComplianceId(), label, userId);
        ComplianceCompanyLabelVo labelVo = this.labelService.selectLabelByComplianceId(objectionApply.getComplianceId(), null);
        Boolean exitExist = this.exitItemMapper.whetherExitItemsExist(objectionApply.getComplianceId());
        if (exitExist.booleanValue()) {
            ComplianceCompanyInfo info = this.infoMapper.getInfoById(objectionApply.getComplianceId());
            info.setStatus(ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey());
            info.setUpdateBy(userId);
            info.setUpdateDate(new Date());
            this.infoMapper.updateByPrimaryKey(info);
        } else if (!(labelVo == null || labelVo.getHasObjection().booleanValue() || labelVo.getHasAppeal().booleanValue() || labelVo.getHasExitItems().booleanValue() || labelVo.getPromiseDataClash().booleanValue())) {
            this.scoreRefreshService.syncRefresh(objectionApply.getCid(), null, new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14"});
        }
    }

    static {
        HashMap<String, String> applyMap = new HashMap<String, String>();
        applyMap.put("00", "\u30101.\u9000\u51fa\u9879\u3011");
        applyMap.put("01", "\u30102.\u804c\u4e1a\u536b\u751f\u5206\u7c7b\u548c\u98ce\u9669\u5316\u89e3\u3011 2.1\uff1a\u804c\u4e1a\u536b\u751f\u5206\u7c7b");
        applyMap.put("03", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.1\uff1a\u7ec4\u7ec7\u673a\u6784\u548c\u7ba1\u7406\u5236\u5ea6");
        applyMap.put("04", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.2\uff1a\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u201c\u4e09\u540c\u65f6\u201d");
        applyMap.put("05", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.3\uff1a\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5");
        applyMap.put("06", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.4\uff1a\u804c\u4e1a\u5065\u5eb7\u5f02\u5e38\u7ed3\u679c\u53ca\u65f6\u5904\u7f6e\u548c\u62a5\u544a");
        applyMap.put("07", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.5\uff1a\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u3001\u8bc4\u4ef7");
        applyMap.put("08", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.6\uff1a\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u6d53\u5ea6\u6216\u5f3a\u5ea6");
        applyMap.put("10", "\u30103.\u5408\u89c4\u4e3b\u8981\u5185\u5bb9\u5b8c\u6210\u60c5\u51b5\u3011 3.8\uff1a\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5");
        APPLY_ITEM_MAP = applyMap;
    }
}

