/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyLabelMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyLabel;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoLabelEnum;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyLabelService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyLabelVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ComplianceCompanyLabelServiceImpl
extends BaseServiceImpl<ComplianceCompanyLabelMapper, ComplianceCompanyLabel>
implements IComplianceCompanyLabelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceCompanyLabelServiceImpl.class);
    @Autowired
    private ComplianceCompanyExitItemMapper exitItemMapper;
    @Autowired
    private ComplianceCompanyObjectionApplyMapper objectionApplyMapper;
    @Autowired
    private ComplianceCompanyItemMapper itemMapper;

    @Transactional
    public void updateBypLabel(Long complianceId, Integer label, Long userId) {
        if (complianceId == null || label == null) {
            return;
        }
        List<ComplianceCompanyLabel> list = this.toComplianceCompanyLabelList(complianceId, label, userId);
        boolean shouldSave = false;
        boolean shouldDelete = false;
        ComplianceInfoLabelEnum enumValue = null;
        for (ComplianceInfoLabelEnum value : ComplianceInfoLabelEnum.values()) {
            if (value.getKey() != label) continue;
            enumValue = value;
            break;
        }
        if (enumValue != null) {
            switch (enumValue) {
                case EXITITEMS: {
                    shouldSave = this.exitItemMapper.hasExitItems(complianceId);
                    break;
                }
                case OBJECTION: {
                    shouldSave = this.objectionApplyMapper.getUnprocessedBycomplianceId(complianceId, (byte)1);
                    break;
                }
                case APPEAL: {
                    shouldSave = this.objectionApplyMapper.getUnprocessedBycomplianceId(complianceId, (byte)2);
                    break;
                }
                case PROMISEDATACLASH: {
                    shouldSave = this.itemMapper.hasPromisedataclash(complianceId);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        boolean bl = shouldDelete = !shouldSave;
        if (shouldSave) {
            this.updateClashLabel(list);
        } else if (shouldDelete) {
            this.delLabels(list);
        }
    }

    private List<ComplianceCompanyLabel> toComplianceCompanyLabelList(Long complianceId, Integer label, Long userId) {
        ArrayList<ComplianceCompanyLabel> list = new ArrayList<ComplianceCompanyLabel>();
        ComplianceCompanyLabel companyLabel = new ComplianceCompanyLabel();
        Date now = new Date();
        companyLabel.setComplianceId(complianceId);
        companyLabel.setLabel(label);
        companyLabel.setCreateBy(userId);
        companyLabel.setUpdateBy(userId);
        companyLabel.setCreateDate(now);
        companyLabel.setUpdateDate(now);
        companyLabel.setIsValid(Boolean.valueOf(true));
        list.add(companyLabel);
        return list;
    }

    public ComplianceCompanyLabelVo selectLabelByComplianceId(Long complianceId, Integer label) {
        return ((ComplianceCompanyLabelMapper)this.dao).selectLabelByComplianceId(complianceId, label);
    }

    @Transactional(readOnly=false)
    public void updateClashLabel(List<ComplianceCompanyLabel> labels) {
        if (CollectionUtils.isEmpty(labels)) {
            return;
        }
        Set complianceIdSet = labels.stream().map(ComplianceCompanyLabel::getComplianceId).collect(Collectors.toSet());
        Integer label = labels.get(0).getLabel();
        Example e = new Example(ComplianceCompanyLabel.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true).andIn("complianceId", complianceIdSet).andEqualTo("label", (Object)label);
        e.selectProperties(new String[]{"id", "complianceId", "isValid"});
        List dbLabels = ((ComplianceCompanyLabelMapper)this.dao).selectByExample(e);
        Map<Object, Object> dbDataMap = new HashMap();
        if (dbLabels != null && dbLabels.size() > 0) {
            dbDataMap = dbLabels.stream().collect(Collectors.toMap(k -> k.getComplianceId(), Function.identity(), (v1, v2) -> v1));
        }
        ArrayList<ComplianceCompanyLabel> needUpdateList = new ArrayList<ComplianceCompanyLabel>();
        for (ComplianceCompanyLabel newLabel : labels) {
            if (dbDataMap.containsKey(newLabel.getComplianceId())) {
                ComplianceCompanyLabel dbData = (ComplianceCompanyLabel)dbDataMap.get(newLabel.getComplianceId());
                if (Objects.equals(dbData.getIsValid(), newLabel.getIsValid())) continue;
                newLabel.setId(dbData.getId());
                needUpdateList.add(newLabel);
                continue;
            }
            needUpdateList.add(newLabel);
        }
        if (CollectionUtils.isNotEmpty(needUpdateList)) {
            for (List complianceCompanyLabels : ListUtil.partition(needUpdateList, (int)1000)) {
                this.batchUpdateOrInsert(complianceCompanyLabels, ComplianceCompanyLabelMapper.class, (item, mapper) -> {
                    if (item.getId() == null) {
                        if (Objects.equals(item.getIsValid(), false)) {
                            return 0;
                        }
                        item.setId(Long.valueOf(this.idworker.nextId()));
                        item.setCreateDate(new Date());
                        item.setIsValid(Boolean.valueOf(true));
                        return mapper.insert(item);
                    }
                    item.setUpdateDate(new Date());
                    return mapper.updateByPrimaryKeySelective(item);
                });
            }
        }
    }

    @Transactional
    public void delLabels(List<ComplianceCompanyLabel> list) {
        ((ComplianceCompanyLabelMapper)this.dao).delLabels(list);
    }
}

