/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyItemdataMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.enums.ComplianceObjectionStatusEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDataModel;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDataScoreModel;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemdataService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyObjectionApplyVo;
import cn.smarthse.modules.health.compliance.vo.HealthTrainCertStaffInfo;
import cn.smarthse.util.common.StringUtils;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class ComplianceCompanyItemdataServiceImpl
extends BaseServiceImpl<ComplianceCompanyItemdataMapper, ComplianceCompanyItemdata>
implements IComplianceCompanyItemdataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceCompanyItemdataServiceImpl.class);
    @Resource(name="complianceReloadDataThreadPoolExecutor")
    private ThreadPoolExecutor complianceReloadDataThreadPoolExecutor;

    public List<ComplianceCompanyItemdata> listItemDataByCodeId(Long complianceId, Long ... itemcodeIds) {
        Example e = new Example(ComplianceCompanyItemdata.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("complianceId", (Object)complianceId).andEqualTo("isValid", (Object)true);
        if (itemcodeIds.length == 1) {
            criteria.andEqualTo("itemcodeId", (Object)itemcodeIds[0]);
        } else {
            criteria.andIn("itemcodeId", Arrays.asList(itemcodeIds));
        }
        e.selectProperties(new String[]{"id", "complianceId", "itemcodeId", "fieldName", "resultData"});
        List<ComplianceCompanyItemdata> listByExample = this.getListByExample(e);
        return listByExample;
    }

    public List<ComplianceCompanyItemdata> listItemDataByCode(Long complianceId, String code) {
        if (StringUtils.isBlank((CharSequence)code) || complianceId == null) {
            return null;
        }
        return ((ComplianceCompanyItemdataMapper)this.dao).listItemDataByCode(code, complianceId);
    }

    public List<ComplianceCompanyDataModel> listItemDataByCid(List<Long> cids, List<String> codes, Boolean isTrytool) {
        if (CollectionUtils.isEmpty(cids)) {
            return null;
        }
        List<ComplianceCompanyDataModel> complianceCompanyDataModels = ((ComplianceCompanyItemdataMapper)this.dao).listItemDataByCid(cids, codes, null, isTrytool);
        return complianceCompanyDataModels;
    }

    public List<ComplianceCompanyDataModel> listItemDataByCidCodeId(List<Long> cids, Long codeId) {
        if (CollectionUtils.isEmpty(cids)) {
            return null;
        }
        List<ComplianceCompanyDataModel> complianceCompanyDataModels = ((ComplianceCompanyItemdataMapper)this.dao).listItemDataByCid(cids, null, codeId, false);
        return complianceCompanyDataModels;
    }

    public String geneMapKey(ComplianceCompanyItemdata itemdata) {
        if (itemdata == null) {
            return null;
        }
        return String.valueOf(itemdata.getComplianceId()) + "_" + String.valueOf(itemdata.getItemcodeId()) + "_" + itemdata.getFieldName();
    }

    @Transactional(readOnly=false)
    public void saveDataItemData(List<ComplianceCompanyItemdata> newItemDataList, List<ComplianceCompanyItemdata> dbItemDataList) {
        Object groupMap;
        if (CollectionUtils.isEmpty(newItemDataList)) {
            return;
        }
        ArrayList<ComplianceCompanyItemdata> actionList = new ArrayList<ComplianceCompanyItemdata>();
        HashMap<String, ComplianceCompanyItemdata> itemCodeIdMap = new HashMap<String, ComplianceCompanyItemdata>();
        if (CollectionUtils.isNotEmpty(dbItemDataList) && MapUtils.isNotEmpty((Map)(groupMap = dbItemDataList.stream().collect(Collectors.groupingBy(g -> this.geneMapKey((ComplianceCompanyItemdata)g)))))) {
            for (String mapKey : groupMap.keySet()) {
                List complianceCompanyItemdatas = (List)groupMap.get(mapKey);
                if (CollectionUtils.isEmpty((Collection)complianceCompanyItemdatas)) continue;
                itemCodeIdMap.put(mapKey, (ComplianceCompanyItemdata)((List)groupMap.get(mapKey)).get(0));
                for (int i = 1; i < complianceCompanyItemdatas.size(); ++i) {
                    ComplianceCompanyItemdata del = (ComplianceCompanyItemdata)complianceCompanyItemdatas.get(i);
                    del.setIsValid(Boolean.valueOf(false));
                    del.setUpdateDate(new Date());
                    del.setUpdateBy(Long.valueOf(110L));
                    actionList.add(del);
                }
            }
        }
        for (ComplianceCompanyItemdata itemdata : newItemDataList) {
            String mapKey;
            mapKey = this.geneMapKey(itemdata);
            if (itemCodeIdMap.containsKey(mapKey)) {
                ComplianceCompanyItemdata dbItemData = (ComplianceCompanyItemdata)itemCodeIdMap.get(mapKey);
                if (!Objects.equals(itemdata.getResultData(), dbItemData.getResultData())) {
                    itemdata.setUpdateDate(new Date());
                }
                itemdata.setId(((ComplianceCompanyItemdata)itemCodeIdMap.get(mapKey)).getId());
                itemCodeIdMap.remove(mapKey);
            }
            if (itemdata.getFormat() != null) continue;
            itemdata.setFormat(Integer.valueOf(1));
        }
        Map<String, List<ComplianceCompanyItemdata>> surplusInfoIdCodeIdMap = itemCodeIdMap.values().stream().filter(f -> f != null && Objects.equals(f.getDataType(), 2)).collect(Collectors.groupingBy(g -> String.valueOf(g.getComplianceId()) + String.valueOf(g.getItemcodeId())));
        for (ComplianceCompanyItemdata complianceCompanyItemdata : newItemDataList) {
            List<ComplianceCompanyItemdata> needDelList;
            actionList.add(complianceCompanyItemdata);
            String m = String.valueOf(complianceCompanyItemdata.getComplianceId()) + String.valueOf(complianceCompanyItemdata.getItemcodeId());
            if (!surplusInfoIdCodeIdMap.containsKey(m) || CollectionUtils.isEmpty(needDelList = surplusInfoIdCodeIdMap.get(m))) continue;
            for (ComplianceCompanyItemdata needDel : needDelList) {
                ComplianceCompanyItemdata del = new ComplianceCompanyItemdata();
                del.setId(needDel.getId());
                del.setIsValid(Boolean.valueOf(false));
                actionList.add(del);
            }
        }
        if (CollectionUtils.isEmpty(actionList)) {
            return;
        }
        this.batchUpdateOrInsert(actionList, ComplianceCompanyItemdataMapper.class, (newItemdata, mapper) -> {
            if (newItemdata.getId() == null) {
                newItemdata.setCreateDate(new Date());
                newItemdata.setUpdateDate(new Date());
                newItemdata.setId(Long.valueOf(this.idworker.nextId()));
                newItemdata.setIsValid(Boolean.valueOf(true));
                return mapper.insert(newItemdata);
            }
            return mapper.updateItemdata((ComplianceCompanyItemdata)newItemdata);
        });
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void saveDataItemDataV2(List<ComplianceCompanyItemdata> newItemDataList, List<ComplianceCompanyItemdata> dbItemDataList) {
        Object groupMap;
        if (CollectionUtils.isEmpty(newItemDataList)) {
            return;
        }
        ArrayList<ComplianceCompanyItemdata> actionList = new ArrayList<ComplianceCompanyItemdata>();
        HashMap<String, ComplianceCompanyItemdata> itemCodeIdMap = new HashMap<String, ComplianceCompanyItemdata>();
        if (CollectionUtils.isNotEmpty(dbItemDataList) && MapUtils.isNotEmpty((Map)(groupMap = dbItemDataList.stream().collect(Collectors.groupingBy(g -> this.geneMapKey((ComplianceCompanyItemdata)g)))))) {
            for (String mapKey : groupMap.keySet()) {
                List complianceCompanyItemdatas = (List)groupMap.get(mapKey);
                if (CollectionUtils.isEmpty((Collection)complianceCompanyItemdatas)) continue;
                itemCodeIdMap.put(mapKey, (ComplianceCompanyItemdata)((List)groupMap.get(mapKey)).get(0));
                for (int i = 1; i < complianceCompanyItemdatas.size(); ++i) {
                    ComplianceCompanyItemdata del = (ComplianceCompanyItemdata)complianceCompanyItemdatas.get(i);
                    del.setIsValid(Boolean.valueOf(false));
                    del.setUpdateDate(new Date());
                    del.setUpdateBy(Long.valueOf(110L));
                    actionList.add(del);
                }
            }
        }
        for (ComplianceCompanyItemdata complianceCompanyItemdata : newItemDataList) {
            String mapKey;
            mapKey = this.geneMapKey(complianceCompanyItemdata);
            if (itemCodeIdMap.containsKey(mapKey)) {
                ComplianceCompanyItemdata dbItemData = (ComplianceCompanyItemdata)itemCodeIdMap.get(mapKey);
                if (!Objects.equals(complianceCompanyItemdata.getResultData(), dbItemData.getResultData())) {
                    complianceCompanyItemdata.setUpdateDate(new Date());
                }
                complianceCompanyItemdata.setId(((ComplianceCompanyItemdata)itemCodeIdMap.get(mapKey)).getId());
                itemCodeIdMap.remove(mapKey);
            }
            if (complianceCompanyItemdata.getFormat() != null) continue;
            complianceCompanyItemdata.setFormat(Integer.valueOf(1));
        }
        Map<String, List<ComplianceCompanyItemdata>> surplusInfoIdCodeIdMap = itemCodeIdMap.values().stream().filter(f -> f != null && Objects.equals(f.getDataType(), 2)).collect(Collectors.groupingBy(g -> String.valueOf(g.getComplianceId()) + String.valueOf(g.getItemcodeId())));
        for (ComplianceCompanyItemdata complianceCompanyItemdata : newItemDataList) {
            List<ComplianceCompanyItemdata> needDelList;
            actionList.add(complianceCompanyItemdata);
            String m = String.valueOf(complianceCompanyItemdata.getComplianceId()) + String.valueOf(complianceCompanyItemdata.getItemcodeId());
            if (!surplusInfoIdCodeIdMap.containsKey(m) || CollectionUtils.isEmpty(needDelList = surplusInfoIdCodeIdMap.get(m))) continue;
            for (ComplianceCompanyItemdata needDel : needDelList) {
                ComplianceCompanyItemdata del = new ComplianceCompanyItemdata();
                del.setId(needDel.getId());
                del.setIsValid(Boolean.valueOf(false));
                actionList.add(del);
            }
        }
        if (CollectionUtils.isEmpty(actionList)) {
            return;
        }
        List list = ListUtil.partition(actionList, (int)1000);
        CountDownLatch cdl = new CountDownLatch(list.size());
        for (List partition : list) {
            this.complianceReloadDataThreadPoolExecutor.execute(() -> {
                try {
                    this.batchUpdateOrInsert(partition, ComplianceCompanyItemdataMapper.class, (newItemdata, mapper) -> {
                        if (newItemdata.getId() == null) {
                            newItemdata.setCreateDate(new Date());
                            newItemdata.setUpdateDate(new Date());
                            newItemdata.setId(Long.valueOf(this.idworker.nextId()));
                            newItemdata.setIsValid(Boolean.valueOf(true));
                            return mapper.insert(newItemdata);
                        }
                        return mapper.updateItemdata((ComplianceCompanyItemdata)newItemdata);
                    });
                }
                finally {
                    cdl.countDown();
                }
            });
        }
        cdl.await();
    }

    public List<ComplianceCompanyDataScoreModel> listItemDataScoreModel(Long complianceId, String code, List<Long> codeIds) {
        if (complianceId == null) {
            return null;
        }
        return ((ComplianceCompanyItemdataMapper)this.dao).listItemDataScoreModel(complianceId, code, codeIds);
    }

    public List<HealthTrainCertStaffInfo> getHealthTrainCertStaffInfo(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return null;
        }
        return ((ComplianceCompanyItemdataMapper)this.dao).getHealthTrainCertStaffInfo(cidList);
    }

    public List<ComplianceCompanyObjectionApplyVo> querySubItemObjectionInfo(Long complianceId, String itemCode) {
        if (complianceId == null || CharSequenceUtil.isBlank((CharSequence)itemCode)) {
            return Collections.emptyList();
        }
        List<ComplianceCompanyObjectionApplyVo> objectionList = ((ComplianceCompanyItemdataMapper)this.dao).querySubItemObjectionInfo(complianceId, itemCode);
        objectionList.forEach(v -> v.setObjectionTypeName(ComplianceObjectionStatusEnum.getValue((Integer)v.getObjectionType())));
        return objectionList;
    }

    @Transactional
    public void addDefaultValue(Long complianceId, String type) {
        if (CharSequenceUtil.isBlank((CharSequence)type)) {
            return;
        }
        if (type.equals("del") && complianceId != null) {
            Example example = new Example(ComplianceCompanyItemdata.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("complianceId", (Object)complianceId);
            criteria.andIn("itemcodeId", Arrays.asList(11105L, 11106L, 11107L, 11108L));
            criteria.andEqualTo("isValid", (Object)true);
            ((ComplianceCompanyItemdataMapper)this.dao).deleteByExample(example);
            return;
        }
        if (type.equals("add")) {
            Example example = new Example(ComplianceCompanyItemdata.class);
            Example.Criteria criteria = example.createCriteria();
            if (complianceId != null) {
                criteria.andEqualTo("complianceId", (Object)complianceId);
            }
            criteria.andEqualTo("isValid", (Object)true);
            example.selectProperties(new String[]{"complianceId"});
            Set<Long> allComplianceId = this.getListByExample(example).stream().filter(Objects::nonNull).map(ComplianceCompanyItemdata::getComplianceId).collect(Collectors.toSet());
            Date date = new Date();
            this.addDefaultValueMethod(complianceId, allComplianceId, 11105L, "fcState", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11105L, "fcFileName", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11105L, "fcFileId", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11106L, "ydState", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11106L, "ydFileName", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11106L, "ydFileId", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11107L, "gwState", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11107L, "gwFileName", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11107L, "gwFileId", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11108L, "jxState", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11108L, "jxFileName", date);
            this.addDefaultValueMethod(complianceId, allComplianceId, 11108L, "jxFileId", date);
        }
    }

    private void addDefaultValueMethod(Long complianceId, Set<Long> allComplianceId, Long itemcodeId, String fieldName, Date date) {
        Example example = new Example(ComplianceCompanyItemdata.class);
        Example.Criteria criteria2 = example.createCriteria();
        if (complianceId != null) {
            criteria2.andEqualTo("complianceId", (Object)complianceId);
        }
        criteria2.andEqualTo("itemcodeId", (Object)itemcodeId);
        criteria2.andEqualTo("fieldName", (Object)fieldName);
        criteria2.andEqualTo("isValid", (Object)true);
        example.selectProperties(new String[]{"complianceId"});
        Set already = this.getListByExample(example).stream().filter(Objects::nonNull).map(ComplianceCompanyItemdata::getComplianceId).collect(Collectors.toSet());
        ArrayList<ComplianceCompanyItemdata> list = new ArrayList<ComplianceCompanyItemdata>();
        for (Long id : allComplianceId) {
            if (id == null || already.contains(id)) continue;
            ComplianceCompanyItemdata itemData = new ComplianceCompanyItemdata();
            itemData.setId(Long.valueOf(this.idworker.nextId()));
            itemData.setComplianceId(id);
            itemData.setItemcodeId(itemcodeId);
            itemData.setFieldName(fieldName);
            itemData.setIsValid(Boolean.valueOf(true));
            itemData.setUpdateDate(date);
            itemData.setCreateDate(date);
            list.add(itemData);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            ((ComplianceCompanyItemdataMapper)this.dao).insertList2(list);
        }
    }
}

