/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyItemMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItem;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemcode;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.compliance.vo.ComplianceItemCollectInfo;
import cn.smarthse.util.common.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class ComplianceCompanyItemServiceImpl
extends BaseServiceImpl<ComplianceCompanyItemMapper, ComplianceCompanyItem>
implements IComplianceCompanyItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceCompanyItemServiceImpl.class);
    @Autowired
    IComplianceCompanyItemcodeService itemcodeService;

    public List<ComplianceCompanyItem> getItemByComplianceId(Long id) {
        Example e = new Example(ComplianceCompanyItem.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("complianceId", (Object)id).andEqualTo("isValid", (Object)true);
        List<ComplianceCompanyItem> list = this.getListByExample(e);
        return list;
    }

    public List<ComplianceCompanyItem> getItemByInfoIdCode(Long complianceId, String code) {
        Example e = new Example(ComplianceCompanyItem.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("complianceId", (Object)complianceId).andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotBlank((CharSequence)code)) {
            criteria.andEqualTo("itemcodeCode", (Object)code);
        }
        List<ComplianceCompanyItem> list = this.getListByExample(e);
        return list;
    }

    public void addNewComplianceItem(Long infoId, Long loginStaffId) {
        ArrayList<ComplianceCompanyItem> itemList = new ArrayList<ComplianceCompanyItem>();
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        List<ComplianceCompanyItem> itemByInfoIdCode = this.getItemByInfoIdCode(infoId, null);
        Map<Object, Object> codeItemMap = new HashMap();
        if (CollectionUtils.isNotEmpty(itemByInfoIdCode)) {
            codeItemMap = itemByInfoIdCode.stream().collect(Collectors.toMap(ComplianceCompanyItem::getItemcodeCode, Function.identity(), (v1, v2) -> v1));
        }
        Set codeSet = allItemcode.stream().map(ComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        for (String code : codeSet) {
            ComplianceCompanyItem item2 = new ComplianceCompanyItem();
            ComplianceCompanyItem dbitem = (ComplianceCompanyItem)codeItemMap.get(code);
            if (dbitem != null) {
                item2.setId(dbitem.getId());
            }
            item2.setComplianceId(infoId);
            item2.setItemcodeCode(code);
            item2.setCreateBy(loginStaffId);
            item2.setCreateDate(new Date());
            item2.setIsValid(Boolean.valueOf(true));
            itemList.add(item2);
        }
        this.batchUpdateOrInsert(itemList, ComplianceCompanyItemMapper.class, (item, mapper) -> {
            if (item.getId() == null) {
                item.setCreateDate(new Date());
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setIsValid(Boolean.valueOf(true));
                return mapper.insert(item);
            }
            item.setUpdateDate(new Date());
            return mapper.updateByPrimaryKeySelective(item);
        });
    }

    public List<ComplianceItemCollectInfo> judgeComplianceItemHasObjectionOrAppeal(Long complianceId) {
        return complianceId == null ? Collections.emptyList() : ((ComplianceCompanyItemMapper)this.dao).judgeComplianceItemHasObjectionOrAppeal(complianceId);
    }

    public void delInvalid(List<ComplianceCompanyItem> delitemList) {
        if (CollectionUtils.isEmpty(delitemList)) {
            return;
        }
        ((ComplianceCompanyItemMapper)this.dao).delInvalid(delitemList);
    }
}

