/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.health.compliance.constants.ComplianceCompanyConstants;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItem;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemcode;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDataScoreModel;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyInfoLabelModel;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyPromiseModel;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyQueryParam;
import cn.smarthse.modules.health.compliance.model.ComplianceNeedRefreshModel;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemdataService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.compliance.service.IComplianceGhcollectMonthReportService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCollectInfo;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyCardInfo;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyCountVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyListVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyObjectionApplyVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceItemCollectInfo;
import cn.smarthse.modules.health.compliance.vo.ComplianceItemDataVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceItemInfoVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceSubItemVo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.ms.IMsInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategoryType;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualModel;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualParam;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import cn.smarthse.modules.health.vo.base.company.HealthManagementInfoVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class ComplianceCompanyInfoServiceImpl
extends BaseServiceImpl<ComplianceCompanyInfoMapper, ComplianceCompanyInfo>
implements IComplianceCompanyInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceCompanyInfoServiceImpl.class);
    @Autowired
    private IComplianceCompanyItemService itemService;
    @Autowired
    private IComplianceCompanyItemdataService itemdataService;
    @Autowired
    private IComplianceScoreRefreshService refreshService;
    @Autowired
    IComplianceCompanyItemcodeService itemcodeService;
    @DubboReference
    CompanyReportInfoService companyReportInfoService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    ICompanyFunctionalOrganizationMemberService functionalOrganizationMemberService;
    @DubboReference
    IMsInfoService msInfoService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private ILiteArchiveFilePersonalService personalService;
    @Autowired
    ComplianceCompanyObjectionApplyMapper applyMapper;
    @Autowired
    ComplianceCompanyExitItemMapper exitItemMapper;
    @Autowired
    IComplianceGhcollectMonthReportService hgcollectMonthReportService;
    @Autowired
    IComplianceCompanyObjectionApplyService objectionApplyService;
    @Autowired
    IImportantIndustryCategoryService importantIndustryCategoryService;
    @Value(value="${sms.switch}")
    private Boolean smsSwitch;
    @DubboReference
    private ISMSProvideMasService smsProvideMasService;
    @Autowired
    RedissonClient redissonClient;

    public List<ComplianceCompanyInfo> getComplianceCids(List<Long> cids) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cids)) {
            return null;
        }
        return this.getComplianceCids(cids, null);
    }

    public List<ComplianceCompanyInfo> listReformRemainDateInfo(List<Long> cids) {
        return ((ComplianceCompanyInfoMapper)this.dao).listReformRemainDateInfo(cids);
    }

    public List<ComplianceCompanyInfo> getAllComplianceCids(List<Integer> status) {
        Example e = new Example(ComplianceCompanyInfo.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isOut", (Object)0);
        e.selectProperties(new String[]{"id", "cid"});
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(status)) {
            criteria.andIn("status", status);
        }
        List<ComplianceCompanyInfo> listByExample = this.getListByExample(e);
        return listByExample;
    }

    public List<ComplianceCompanyInfo> getComplianceCids(List<Long> cids, List<Integer> status) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cids)) {
            return null;
        }
        Example e = new Example(ComplianceCompanyInfo.class);
        Example.Criteria criteria = e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isOut", (Object)0);
        if (cids.size() == 1) {
            criteria.andEqualTo("cid", (Object)cids.get(0));
        } else {
            criteria.andIn("cid", cids);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(status)) {
            criteria.andIn("status", status);
        }
        e.selectProperties(new String[]{"id", "cid"});
        List<ComplianceCompanyInfo> listByExample = this.getListByExample(e);
        return listByExample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public ComplianceCompanyInfo addCompliance(Long cid, Long loginStaffId) {
        Example e = new Example(ComplianceCompanyInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andEqualTo("isOut", (Object)0);
        RLock lock = this.redissonClient.getLock("ComplianceCompanyInfoServiceImpl:addCompliance:" + cid);
        ComplianceCompanyInfo info = new ComplianceCompanyInfo();
        try {
            if (lock.tryLock(5L, TimeUnit.MINUTES)) {
                List listByExample = this.getListByExample(e);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(listByExample)) {
                    ComplianceCompanyInfo complianceCompanyInfo = (ComplianceCompanyInfo)listByExample.get(0);
                    return complianceCompanyInfo;
                }
                info.setCid(cid);
                info.setFirstTimeInPromisepage(Boolean.valueOf(true));
                info.setStatus(ComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey());
                this.add(info, loginStaffId, null);
            }
        }
        catch (Exception exce) {
            log.error("\u65b0\u589e\u5408\u89c4\u6570\u636e\u51fa\u9519\uff1a", (Object)e);
        }
        finally {
            lock.unlock();
        }
        new Thread(() -> this.personalService.addPersonalArchiveByCid(Collections.emptyList(), cid, loginStaffId, null)).start();
        return info;
    }

    public ComplianceCompanyInfo submitCompliance(Long cid, Long complianceId, Long loginStaffId) {
        ComplianceCompanyInfo info = new ComplianceCompanyInfo();
        info.setId(complianceId);
        info.setFirstPromiseDate(new Date());
        info.setStep(Byte.valueOf((byte)3));
        info.setStatus(ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
        this.update(info, loginStaffId);
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        Set<String> codeSet = allItemcode.stream().filter(f -> Objects.equals(f.getType(), 1)).map(ComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        this.refreshService.reloadRefData(Arrays.asList(cid), null, codeSet.toArray(new String[0]));
        return (ComplianceCompanyInfo)this.getById(complianceId);
    }

    public Boolean savePromiseData(List<ComplianceCompanyItemdata> promiseDataList) {
        return this.refreshService.savePromiseData(promiseDataList);
    }

    public ComplianceItemInfoVo getItemVo(Long infoId, String code, List<Long> codeIds, boolean isTrytool) {
        List scoreModelList = this.itemdataService.listItemDataScoreModel(infoId, code, codeIds);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)scoreModelList)) {
            return null;
        }
        ComplianceItemInfoVo vo = new ComplianceItemInfoVo();
        vo.setItemScore(((ComplianceCompanyDataScoreModel)scoreModelList.get(0)).getScore());
        Map<Long, List<ComplianceCompanyDataScoreModel>> codeIdModelMap = scoreModelList.stream().collect(Collectors.groupingBy(ComplianceCompanyDataScoreModel::getItemcodeId));
        ArrayList<ComplianceSubItemVo> subItemVoList = new ArrayList<ComplianceSubItemVo>();
        if (MapUtils.isNotEmpty(codeIdModelMap)) {
            codeIdModelMap.forEach((codeId, modelList) -> {
                ComplianceCompanyDataScoreModel dataScoreModel = (ComplianceCompanyDataScoreModel)modelList.get(0);
                BigDecimal loseScore = dataScoreModel.getLoseScore();
                ComplianceSubItemVo subItemVo = new ComplianceSubItemVo();
                subItemVo.setLoseScore(loseScore);
                subItemVo.setPromiseDataClashFieldname(dataScoreModel.getPromiseDataClashFieldname());
                Optional<Date> date = modelList.stream().filter(m -> m.getSubUpdate() != null).map(ComplianceCompanyDataScoreModel::getSubUpdate).max(Comparator.naturalOrder());
                if (date.isPresent()) {
                    subItemVo.setSubUpdate(date.get());
                }
                subItemVo.setItemCodeId(dataScoreModel.getItemcodeId());
                subItemVoList.add(subItemVo);
                List itemDataVoList = modelList.stream().map(m -> {
                    ComplianceItemDataVo itemDataVo = new ComplianceItemDataVo();
                    itemDataVo.setFieldName(m.getFieldName());
                    itemDataVo.setFormat(m.getFormat());
                    itemDataVo.setResultData(m.getResultData());
                    return itemDataVo;
                }).collect(Collectors.toList());
                subItemVo.setFieldDataList(itemDataVoList);
            });
        }
        vo.setSubItemList(subItemVoList);
        if (Objects.equals(isTrytool, false)) {
            this.setSubItemObjectionInfo(infoId, code, subItemVoList);
        }
        return vo;
    }

    public ComplianceCollectInfo getItemCollectInfo(Long infoId) {
        ComplianceCompanyInfo info = (ComplianceCompanyInfo)this.getById(infoId);
        if (info == null) {
            return null;
        }
        ComplianceCollectInfo collectInfo = new ComplianceCollectInfo();
        collectInfo.setScore(info.getComplianceScore());
        collectInfo.setStatus(info.getStatus());
        List itemList = this.itemService.getItemByComplianceId(infoId);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)itemList)) {
            List<ComplianceItemCollectInfo> itemCollectInfoList = itemList.stream().map(m -> {
                ComplianceItemCollectInfo itemCollectInfo = new ComplianceItemCollectInfo();
                itemCollectInfo.setStatus(Integer.valueOf(m.getStatus() == null ? 1 : m.getStatus()));
                itemCollectInfo.setScore(m.getScore());
                itemCollectInfo.setPromiseDataClash(m.getPromiseDataClash());
                itemCollectInfo.setCode(m.getItemcodeCode());
                return itemCollectInfo;
            }).collect(Collectors.toList());
            this.judgeComplianceItemHasObjectionOrAppeal(infoId, itemCollectInfoList);
            List addScoreItemList = itemList.stream().filter(f -> Objects.equals(f.getItemcodeCode(), "15")).collect(Collectors.toList());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(addScoreItemList)) {
                BigDecimal score = ((ComplianceCompanyItem)addScoreItemList.get(0)).getScore();
                collectInfo.setAddItemScore(score);
            } else {
                collectInfo.setAddItemScore(BigDecimal.ZERO);
            }
            collectInfo.setItemList(itemCollectInfoList);
        }
        return collectInfo;
    }

    public PageInfo<ComplianceCompanyListVo> listData(JqGridParam param, ComplianceCompanyQueryParam queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ComplianceCompanyListVo> list = ((ComplianceCompanyInfoMapper)this.dao).listData(queryParam);
        ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
        typeParam.setMenuSet(Integer.valueOf(1));
        List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
        List<Object> typeNameList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)typeList)) {
            typeNameList = typeList.stream().map(ImportantIndustryCategoryType::getImportantTypeName).collect(Collectors.toList());
        }
        ArrayList finalTypeNameList = typeNameList;
        list.forEach(vo -> {
            vo.init();
            String importantTypeName = vo.getImportantTypeName();
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)importantTypeName)) {
                List strings = CommonUtil.str2list((String)importantTypeName);
                Set validInduSet = strings.stream().filter(f -> finalTypeNameList.contains(f)).collect(Collectors.toSet());
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(validInduSet)) {
                    vo.setImportantTypeName(StringUtils.join(validInduSet, (String)","));
                } else {
                    vo.setImportantTypeName("");
                }
            } else {
                vo.setImportantTypeName("");
            }
        });
        PageInfo page = new PageInfo(list);
        return page;
    }

    public ComplianceCompanyCountVo countByArea(ComplianceCompanyQueryParam queryParam) {
        ComplianceCompanyCountVo companyCountVo = ((ComplianceCompanyInfoMapper)this.dao).countByArea(queryParam);
        companyCountVo.setAreaId(queryParam.getAreaId());
        companyCountVo.setAreaName(queryParam.getAreaName());
        return companyCountVo;
    }

    public ComplianceCompanyListVo getDetailById(Long complianceId) {
        ComplianceCompanyListVo detail = ((ComplianceCompanyInfoMapper)this.dao).getDetailById(complianceId);
        if (detail == null) {
            throw new ServiceException("\u4f20\u5165ID\u6709\u8bef\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u5408\u89c4\u4f01\u4e1a");
        }
        detail.init();
        if (detail.getImportantTypeName() != null) {
            String importantTypeName = detail.getImportantTypeName();
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)importantTypeName)) {
                ImportantIndustryCategoryType typeParam = new ImportantIndustryCategoryType();
                typeParam.setMenuSet(Integer.valueOf(1));
                List typeList = this.importantIndustryCategoryService.listCategoryType(typeParam);
                List<Object> typeNameList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)typeList)) {
                    typeNameList = typeList.stream().map(ImportantIndustryCategoryType::getImportantTypeName).collect(Collectors.toList());
                }
                ArrayList finalTypeNameList = typeNameList;
                List strings = CommonUtil.str2list((String)importantTypeName);
                Set validInduSet = strings.stream().filter(f -> finalTypeNameList.contains(f)).collect(Collectors.toSet());
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(validInduSet)) {
                    detail.setImportantTypeName(StringUtils.join(validInduSet, (String)","));
                } else {
                    detail.setImportantTypeName("");
                }
            } else {
                detail.setImportantTypeName("");
            }
        }
        return detail;
    }

    public ComplianceCompanyListVo getTrytoolDetailById(Long complianceId) {
        return ((ComplianceCompanyInfoMapper)this.dao).getTrytoolDetailById(complianceId);
    }

    public ComplianceCompanyInfo getLastByCid(Long loginStaffCompanyId) {
        return ((ComplianceCompanyInfoMapper)this.dao).getLastByCid(loginStaffCompanyId);
    }

    public ComplianceCompanyCardInfo getComplianceCompanyCardInfo(Long complianceId) {
        if (complianceId == null) {
            return null;
        }
        ComplianceCompanyCardInfo card = ((ComplianceCompanyInfoMapper)this.dao).getComplianceCompanyCardInfo(complianceId);
        this.setComplianceStatus(card);
        this.calcReformRemainDays(card);
        return card;
    }

    public ComplianceCompanyInfo getInfoById(Long complianceId) {
        return ((ComplianceCompanyInfoMapper)this.dao).getInfoById(complianceId);
    }

    private void setComplianceStatus(ComplianceCompanyCardInfo compliance) {
        if (compliance != null) {
            String value = ComplianceInfoStatusEnum.getValue((Integer)compliance.getStatus());
            if (StrUtil.isNotBlank((CharSequence)value)) {
                value = value.split("-")[0];
            }
            compliance.setStatusName(value);
        }
    }

    private void calcReformRemainDays(ComplianceCompanyCardInfo compliance) {
        if (compliance == null) {
            return;
        }
        String reformRemainDate = compliance.getReformRemainDate();
        if (reformRemainDate != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime targetDate = LocalDateTime.parse(reformRemainDate, formatter);
            LocalDateTime now = LocalDateTime.now();
            Duration duration = Duration.between(now, targetDate);
            long days = duration.toDays();
            compliance.setReformRemainDays(Long.valueOf(days));
        }
    }

    private void judgeComplianceItemHasObjectionOrAppeal(Long complianceId, List<ComplianceItemCollectInfo> itemCollectList) {
        List infoList = this.itemService.judgeComplianceItemHasObjectionOrAppeal(complianceId);
        Map itemMap = infoList.stream().collect(Collectors.toMap(ComplianceItemCollectInfo::getCode, Function.identity(), (v1, v2) -> v1));
        for (ComplianceItemCollectInfo item : itemCollectList) {
            ComplianceItemCollectInfo info = (ComplianceItemCollectInfo)itemMap.get(item.getCode());
            if (info == null) continue;
            item.setHasObjection(info.getHasObjection());
            item.setHasAppeal(info.getHasAppeal());
        }
    }

    private void setSubItemObjectionInfo(Long complianceId, String itemCode, List<ComplianceSubItemVo> subItemList) {
        List objectionList = this.itemdataService.querySubItemObjectionInfo(complianceId, itemCode);
        Map objectionMap = objectionList.stream().collect(Collectors.toMap(ComplianceCompanyObjectionApplyVo::getItemcodeId, Function.identity(), (v1, v2) -> v2));
        subItemList.forEach(sub -> sub.setObjectionVo((ComplianceCompanyObjectionApplyVo)objectionMap.get(sub.getItemCodeId())));
        List itemcodeList = this.itemcodeService.getCacheAllItemcode();
        List codeIdList = itemcodeList.stream().filter(f -> Objects.equals(f.getCode(), itemCode)).map(ComplianceCompanyItemcode::getId).collect(Collectors.toList());
        List complianceCompanyObjectionApplies = this.objectionApplyService.listObjectionApply(complianceId, codeIdList, Integer.valueOf(2), Arrays.asList(1));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)complianceCompanyObjectionApplies)) {
            Map itemCodeObjectionApplyMap = complianceCompanyObjectionApplies.stream().collect(Collectors.toMap(ComplianceCompanyObjectionApply::getItemcodeId, Function.identity(), (v1, v2) -> v2));
            subItemList.forEach(sub -> sub.setAppealObj((ComplianceCompanyObjectionApply)itemCodeObjectionApplyMap.get(sub.getItemCodeId())));
        }
    }

    public List<ComplianceCompanyItemdata> getCommitmentContent(Long cid, String type, Map<String, Object> map) {
        ArrayList<ComplianceCompanyItemdata> list = new ArrayList<ComplianceCompanyItemdata>();
        if (cid == null || com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)type) || MapUtils.isEmpty(map) || map.get("complianceId") == null) {
            return list;
        }
        switch (type) {
            case "staffBasicInfo": {
                return this.getStaffBasicInfo(cid, list, map);
            }
            case "healthManagementInfo": {
                return this.getHealthManagementInfo(cid, list);
            }
            case "institutionInfo": {
                List institutionInfo = this.msInfoService.getInstitutionInfo(cid, Collections.emptyMap());
                list.addAll(institutionInfo);
                return list;
            }
        }
        return list;
    }

    public List<Long> getCidList() {
        Example example = new Example(ComplianceCompanyInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("isOut", (Object)false).andNotIn("status", Arrays.asList(ComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANCE.getKey()));
        example.selectProperties(new String[]{"cid"});
        example.setDistinct(true);
        List listByExample = this.getListByExample(example);
        return listByExample.stream().map(ComplianceCompanyInfo::getCid).collect(Collectors.toList());
    }

    public Integer recalculateComplianceStatus(Long complianceId) {
        ComplianceCompanyInfo info = (ComplianceCompanyInfo)((ComplianceCompanyInfoMapper)this.dao).selectByPrimaryKey(complianceId);
        if (info == null || info.getComplianceScore() == null) {
            return ComplianceInfoStatusEnum.NON_COMPLIANCE.getKey();
        }
        BigDecimal score = info.getComplianceScore();
        if (this.exitItemMapper.whetherExitItemsExist(complianceId).booleanValue()) {
            return ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey();
        }
        boolean hasExitItems = this.exitItemMapper.hasExitItems(complianceId);
        boolean hasApplyOrObjection = this.applyMapper.hasApplyOrObjection(complianceId);
        boolean hasProgress = ((ComplianceCompanyInfoMapper)this.dao).hasProgressOrPromise(complianceId);
        if (hasExitItems || hasApplyOrObjection || hasProgress) {
            return ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey();
        }
        if (score.compareTo(ComplianceCompanyConstants.COMPLIANT_SCORE) >= 0) {
            return ComplianceInfoStatusEnum.COMPLIANT.getKey();
        }
        if (score.compareTo(ComplianceCompanyConstants.BASIC_COMPLIANT_SCORE) >= 0) {
            return ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey();
        }
        return ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey();
    }

    public List<ComplianceCompanyInfo> queryScoreByCidList(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((ComplianceCompanyInfoMapper)this.dao).queryScoreByCidList(cidList);
    }

    public List<ImportantIndustryCategory> getImportantTypeByCids(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((ComplianceCompanyInfoMapper)this.dao).getImportantTypeByCids(cidList);
    }

    public ComplianceCompanyPromiseModel queryPromiseInfoById(Long complianceId) {
        if (complianceId == null) {
            return null;
        }
        return ((ComplianceCompanyInfoMapper)this.dao).queryPromiseInfoById(complianceId);
    }

    public ComplianceVisualModel collectVisualCompliance(ComplianceVisualParam searchVo) {
        if (searchVo == null || searchVo.getAreaId() == null || searchVo.getAreaLevel() == null) {
            return null;
        }
        ImmutablePair weekNumber = DateUtil.getWeekNumber((LocalDate)LocalDate.now());
        searchVo.setWeekNum((Integer)weekNumber.getLeft());
        ComplianceVisualModel model = ((ComplianceCompanyInfoMapper)this.dao).collectVisualCompliance(searchVo);
        if (model == null) {
            model = new ComplianceVisualModel();
            model.setHgTotal(Long.valueOf(0L));
            model.setZzHgTotal(Long.valueOf(0L));
            model.setMzjjHgTotal(Long.valueOf(0L));
            model.setQtHgTotal(Long.valueOf(0L));
            model.setSubmitHgTotal(Long.valueOf(0L));
            model.setJbHgTotal(Long.valueOf(0L));
            model.setIngHgTotal(Long.valueOf(0L));
            model.setLe80OrHasOutHgTotal(Long.valueOf(0L));
            model.setDescend(Long.valueOf(0L));
            return model;
        }
        List hgCollectData = this.hgcollectMonthReportService.getHgCollectData(searchVo);
        if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)hgCollectData)) {
            Long preMonthHgNum = hgCollectData.stream().filter(f -> f != null && f.getHgNum() != null).map(f -> f.getHgNum()).reduce(0L, Long::sum);
            Long hgTotal = model.getHgTotal();
            model.setPreWeekHgTotal(preMonthHgNum);
            if (preMonthHgNum != null && hgTotal != null && !preMonthHgNum.equals(BigDecimal.ZERO)) {
                model.setPreWeekHgDiffTotal(Long.valueOf(hgTotal - preMonthHgNum));
                String preMonthHgDiffPercen = new BigDecimal(model.getPreWeekHgDiffTotal()).divide(new BigDecimal(preMonthHgNum), 2, 4).multiply(new BigDecimal(100)).setScale(2, 4).stripTrailingZeros().toPlainString();
                model.setPreWeekHgDiffPercen(preMonthHgDiffPercen);
            }
        }
        Long hgTotal = model.getHgTotal();
        BigDecimal num = hgTotal != null ? BigDecimal.valueOf((double)hgTotal.longValue() * 2.25).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        model.setFreePunishAmountNowYear(this.convertUnit(num));
        return model;
    }

    private String convertUnit(BigDecimal punishAmount) {
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal tenThousand = new BigDecimal("10000.0");
        if (punishAmount.compareTo(BigDecimal.ZERO) >= 0 && punishAmount.compareTo(one) < 0) {
            return String.format("%s \u5143", punishAmount.multiply(tenThousand));
        }
        if (punishAmount.compareTo(one) >= 0 && punishAmount.compareTo(tenThousand) < 0) {
            return String.format("%s \u4e07\u5143", punishAmount);
        }
        if (punishAmount.compareTo(tenThousand) >= 0) {
            return String.format("%s \u4ebf\u5143", punishAmount.divide(tenThousand, 2, RoundingMode.HALF_UP));
        }
        return "";
    }

    public List<ComplianceNeedRefreshModel> judgeExistObjectionByCidList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((ComplianceCompanyInfoMapper)this.dao).judgeExistObjectionByCidList(cidList);
    }

    private List<ComplianceCompanyItemdata> getStaffBasicInfo(Long cid, List<ComplianceCompanyItemdata> list, Map<String, Object> map) {
        Integer staffTotalNum = this.companyReportInfoService.getCompanyReportInfoStaffCount(cid);
        Integer localWorkNum = 0;
        Integer outWorkNum = 0;
        List staffInfoList = this.staffInfoService.getStaffInfoWorkNum(Collections.singletonList(cid), null);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)staffInfoList) && staffInfoList.get(0) != null) {
            localWorkNum = ((StaffInfo)staffInfoList.get(0)).getLocalWorkNum();
            outWorkNum = ((StaffInfo)staffInfoList.get(0)).getOutWorkNum();
        }
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("staffTotalNum").setResultData(String.valueOf(staffTotalNum)));
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("localNum").setResultData(String.valueOf(localWorkNum)));
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("outNum").setResultData(String.valueOf(outWorkNum)));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(map) && map.get("complianceId") == null) {
            return list;
        }
        Example example = new Example(ComplianceCompanyItemdata.class);
        example.createCriteria().andEqualTo("complianceId", map.get("complianceId")).andIn("itemcodeId", Arrays.asList(11201L, 11202L, 11303L)).andEqualTo("isValid", (Object)true);
        list.addAll(this.itemdataService.getListByExample(example));
        return list;
    }

    private List<ComplianceCompanyItemdata> getHealthManagementInfo(Long cid, List<ComplianceCompanyItemdata> list) {
        Integer majorNum = 0;
        Integer healthManageNum = 0;
        Integer healthManageZZNum = 0;
        Integer healthManageJZNum = 0;
        Integer complianceManageNum = 0;
        List data = this.functionalOrganizationMemberService.getListHealthManagementInfoVo(Collections.singletonList(cid), Collections.emptyMap());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)data) && data.get(0) != null) {
            majorNum = ((HealthManagementInfoVo)data.get(0)).getMajorNum();
            healthManageNum = ((HealthManagementInfoVo)data.get(0)).getHealthManageNum();
            complianceManageNum = ((HealthManagementInfoVo)data.get(0)).getComplianceManageNum();
            if (((HealthManagementInfoVo)data.get(0)).getHealthManageZZNum() != null) {
                healthManageZZNum = ((HealthManagementInfoVo)data.get(0)).getHealthManageZZNum();
            }
            if (((HealthManagementInfoVo)data.get(0)).getHealthManageJZNum() != null) {
                healthManageJZNum = ((HealthManagementInfoVo)data.get(0)).getHealthManageJZNum();
            }
        }
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("majorNum").setResultData(String.valueOf(majorNum)));
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("healthManageNum").setResultData(String.valueOf(healthManageNum)));
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("healthManageZZNum").setResultData(String.valueOf(healthManageZZNum)));
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("healthManageJZNum").setResultData(String.valueOf(healthManageJZNum)));
        list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("complianceManageNum").setResultData(String.valueOf(complianceManageNum)));
        return list;
    }

    public List<ComplianceCompanyInfoLabelModel> selectComplianceInfoLabels(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return null;
        }
        return ((ComplianceCompanyInfoMapper)this.dao).selectComplianceInfoLabels(cidList);
    }

    public List<ComplianceCompanyInfo> getComplianceStatus(List<Long> cidList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(cidList)) {
            return null;
        }
        return ((ComplianceCompanyInfoMapper)this.dao).getComplianceStatus(cidList);
    }

    public Map<Long, Long> getComplianceIdByCidList(List<Long> cidList) {
        List<ComplianceCompanyInfo> complianceCids = this.getComplianceCids(cidList);
        return complianceCids.stream().collect(Collectors.toMap(ComplianceCompanyInfo::getCid, ComplianceCompanyInfo::getId));
    }

    public Boolean getCompanyIsComplianceItem(Long cid) {
        return ((ComplianceCompanyInfoMapper)this.dao).getCompanyIsComplianceItem(cid);
    }

    public void sendNonComplianceSms(Long complianceId, String text) {
        ComplianceCompanyListVo infoVo = ((ComplianceCompanyInfoMapper)this.dao).getDetailById(complianceId);
        if (infoVo == null) {
            return;
        }
        try {
            if (this.smsSwitch.booleanValue()) {
                if (infoVo.getOccManagerTel() != null && !infoVo.getOccManagerTel().isEmpty()) {
                    this.smsProvideMasService.sendSms(infoVo.getOccManagerTel(), text);
                } else {
                    log.warn("\u4f01\u4e1a: {} \u7f3a\u5c11\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u8054\u7cfb\u4eba\u7535\u8bdd", (Object)infoVo.getName());
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    public Set<Long> getCidsByVictimnullorgt3() {
        return ((ComplianceCompanyInfoMapper)this.dao).getCidsByVictimnullorgt3();
    }
}

