/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.convert.Convert;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.busilog.RecordOperationTypeEnum;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyChangeRecordMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemRecordMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyInfoBakMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyItemdataMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyLabelMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyObjectionApplyMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyProcessRecordMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanySubitemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceScoreChangeRecordMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceAreaScore;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyExitItem;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyExitItemRecord;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItem;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyLabel;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyProcessRecord;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanySubitem;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyQueryParam;
import cn.smarthse.modules.health.compliance.service.IComplianceAreaScoreService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoManagerService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyCountVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceLogVo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class ComplianceCompanyInfoManagerServiceImpl
implements IComplianceCompanyInfoManagerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceCompanyInfoManagerServiceImpl.class);
    private final ComplianceCompanyInfoMapper infoMapper;
    private final ComplianceCompanyInfoBakMapper infoBakMapper;
    private final IComplianceCompanyInfoService infoService;
    private final ComplianceCompanyItemMapper itemMapper;
    private final ComplianceCompanyItemdataMapper itemdataMapper;
    private final ComplianceCompanyExitItemMapper exitItemMapper;
    private final ComplianceCompanyExitItemRecordMapper exitItemRecordMapper;
    private final ComplianceCompanySubitemMapper subitemMapper;
    private final ComplianceCompanyChangeRecordMapper changeRecordMapper;
    private final IComplianceCompanyObjectionApplyService objectionApplyService;
    private final ComplianceCompanyProcessRecordMapper processRecordMapper;
    private final ComplianceScoreChangeRecordMapper scoreChangeRecordMapper;
    private final ComplianceCompanyLabelMapper labelMapper;
    private final IComplianceAreaScoreService complianceAreaScoreService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryService;

    @Transactional
    public ResponseData<String> resetComplianceData(Long id, Long loginUserId) {
        ComplianceCompanyInfo info = this.infoService.getInfoById(id);
        if (info == null) {
            return ResponseData.fail((String)"\u4f20\u5165id\u6709\u8bef\uff0c\u67e5\u4e0d\u5230\u5408\u89c4\u6570\u636e");
        }
        Date now = new Date();
        this.updateComplianceCompanyInfo(info, loginUserId);
        this.updateComplianceCompanyItem(id, loginUserId, now);
        this.updateComplianceCompanyItemData(id, loginUserId, now);
        this.updateComplianceCompanySubitem(id, loginUserId, now);
        this.updateComplianceCompanyExitItem(id, loginUserId, now);
        this.updateComplianceCompanyExitItemRecord(info.getCid(), loginUserId, now);
        this.updateComplianceCompanyLabel(id, loginUserId, now);
        Example objectionApplyExample = this.createComplianceIdExample(ComplianceCompanyObjectionApply.class, id);
        List objectionApplyList = this.objectionApplyService.getListByExample(objectionApplyExample);
        if (objectionApplyList != null && !objectionApplyList.isEmpty()) {
            this.objectionApplyService.batchUpdateOrInsert(objectionApplyList, ComplianceCompanyObjectionApplyMapper.class, (item, mapper) -> {
                item.setUpdatedBy(loginUserId);
                item.setUpdateDate(now);
                item.setIsValid(Boolean.valueOf(false));
                return mapper.updateByPrimaryKeySelective(item);
            });
            List objectionApplyIds = objectionApplyList.stream().map(ComplianceCompanyObjectionApply::getId).collect(Collectors.toList());
            Example processRecordExample = new Example(ComplianceCompanyProcessRecord.class);
            processRecordExample.createCriteria().andIn("objectionApplyId", objectionApplyIds);
            this.processRecordMapper.deleteByExample(processRecordExample);
        }
        this.scoreChangeRecordMapper.cleanTableByComplianceId(id);
        this.changeRecordMapper.cleanTableByComplianceId(id);
        this.staffInfoService.cleanTable(Collections.singletonList(info.getCid()));
        return ResponseData.success();
    }

    public PageInfo<ComplianceCompanyCountVo> listCountByArea(JqGridParam param, ComplianceCompanyQueryParam queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<Object> list = new ArrayList();
        list = Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak()) ? (queryParam.getThisLevel() != null && queryParam.getThisLevel().booleanValue() ? this.infoBakMapper.listThisLevelCountByArea2024(queryParam) : this.infoBakMapper.listCountByArea2024(queryParam)) : (queryParam.getThisLevel() != null && queryParam.getThisLevel() != false ? this.infoMapper.listThisLevelCountByArea(queryParam) : this.infoMapper.listCountByArea(queryParam));
        this.setListScore(list, queryParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    private void setListScore(List<ComplianceCompanyCountVo> list, ComplianceCompanyQueryParam queryParam) {
        List scoreList;
        if (Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak())) {
            scoreList = this.complianceAreaScoreService.getList20241231();
        } else {
            Example example = new Example(ComplianceAreaScore.class);
            example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE);
            scoreList = this.complianceAreaScoreService.getListByExample(example);
        }
        Map<String, BigDecimal> scoreMap = scoreList.stream().collect(Collectors.toMap(score -> score.getAreaId() + "_" + score.getAreaLevel(), ComplianceAreaScore::getScore, (existing, replacement) -> existing));
        for (ComplianceCompanyCountVo vo : list) {
            String key = vo.getAreaId() + "_" + vo.getAreaLevel();
            if (!scoreMap.containsKey(key)) continue;
            vo.setScore(scoreMap.get(key));
        }
    }

    public Long listCountByAreaCount(ComplianceCompanyQueryParam queryParam) {
        Long count = Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak()) ? (queryParam.getThisLevel() != null && queryParam.getThisLevel().booleanValue() ? this.infoBakMapper.listThisLevelCountByAreaCount2024(queryParam) : this.infoBakMapper.listCountByAreaCount2024(queryParam)) : (queryParam.getThisLevel() != null && queryParam.getThisLevel() != false ? this.infoMapper.listThisLevelCountByAreaCount(queryParam) : this.infoMapper.listCountByAreaCount(queryParam));
        return count;
    }

    public ComplianceCompanyCountVo countByArea(ComplianceCompanyQueryParam queryParam) {
        List list;
        ComplianceCompanyCountVo companyCountVo = Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak()) ? this.infoBakMapper.countAndCompanyNumByArea2024(queryParam) : this.infoMapper.countAndCompanyNumByArea(queryParam);
        companyCountVo.setAreaId(queryParam.getAreaId());
        companyCountVo.setAreaName(queryParam.getAreaName());
        if (queryParam.getThisLevel() != null && queryParam.getThisLevel().booleanValue()) {
            companyCountVo.setAreaName(companyCountVo.getAreaName() + "\u5e02\u672c\u7ea7");
        }
        Example example = new Example(ComplianceAreaScore.class);
        Example.Criteria criteria = example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("areaId", (Object)companyCountVo.getAreaId()).andEqualTo("areaLevel", (Object)companyCountVo.getAreaLevel());
        if (Objects.nonNull(queryParam.getQueryBak()) && Objects.equals("2024", queryParam.getQueryBak())) {
            String startDate = "2024-12-31 00:00:00";
            String endDate = "2025-01-01 00:00:00";
            criteria.andGreaterThanOrEqualTo("updateDate", (Object)startDate).andLessThan("updateDate", (Object)endDate);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.complianceAreaScoreService.getListByExample(example)))) {
            companyCountVo.setScore(((ComplianceAreaScore)list.get(0)).getScore());
        }
        return companyCountVo;
    }

    public PageInfo<ComplianceLogVo> getComplianceLog(JqGridParam param, ComplianceCompanyQueryParam queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<ComplianceLogVo> list = this.infoMapper.getComplianceLog(queryParam);
        ArrayList<Long> industryRegisterIdList = new ArrayList<Long>();
        for (ComplianceLogVo vo : list) {
            if (vo.getBeforeInfo() != null && !"null".equalsIgnoreCase(vo.getBeforeInfo())) {
                industryRegisterIdList.add(Long.valueOf(vo.getBeforeInfo()));
            }
            if (!"null".equalsIgnoreCase(vo.getAfterInfo())) {
                industryRegisterIdList.add(Long.valueOf(vo.getAfterInfo()));
            }
            vo.setChangeType(RecordOperationTypeEnum.getValue((Byte)vo.getBusiType()));
        }
        Map<Long, SysParamModel> irMap = this.batchGetIndustryRegister(industryRegisterIdList);
        for (ComplianceLogVo vo : list) {
            String befIndustry;
            SysParamModel befParam = irMap.get(Convert.toLong((Object)vo.getBeforeInfo()));
            SysParamModel aftParam = irMap.get(Convert.toLong((Object)vo.getAfterInfo()));
            String string = "null".equalsIgnoreCase(vo.getBeforeInfo()) ? "-" : (befIndustry = Objects.isNull(befParam) ? "-" : befParam.getParamCode() + "-" + befParam.getParamValue());
            String aftIndustry = "null".equalsIgnoreCase(vo.getAfterInfo()) ? "-" : (Objects.isNull(aftParam) ? "-" : aftParam.getParamCode() + "-" + aftParam.getParamValue());
            vo.setBeforeInfoStr(befIndustry);
            vo.setAfterInfoStr(aftIndustry);
        }
        return new PageInfo(list);
    }

    private void updateComplianceCompanyInfo(ComplianceCompanyInfo info, Long loginUserId) {
        info.setIsValid(Boolean.valueOf(false));
        this.infoService.update((Object)info, loginUserId);
    }

    private void updateComplianceCompanyItem(Long id, Long loginUserId, Date now) {
        Example itemExample = this.createComplianceIdExample(ComplianceCompanyItem.class, id);
        ComplianceCompanyItem item = new ComplianceCompanyItem();
        item.setIsValid(Boolean.valueOf(false));
        item.setUpdateDate(now);
        item.setUpdateBy(loginUserId);
        int num = this.itemMapper.updateByExampleSelective(item, itemExample);
        log.info("\u5408\u89c4\u5355\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyItemData(Long id, Long loginUserId, Date now) {
        Example itemDataExample = this.createComplianceIdExample(ComplianceCompanyItemdata.class, id);
        ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
        itemdata.setIsValid(Boolean.valueOf(false));
        itemdata.setUpdateDate(now);
        itemdata.setUpdateBy(loginUserId);
        int num = this.itemdataMapper.updateByExampleSelective(itemdata, itemDataExample);
        log.info("\u5408\u89c4\u5c0f\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanySubitem(Long id, Long loginUserId, Date now) {
        Example subitemExample = this.createComplianceIdExample(ComplianceCompanySubitem.class, id);
        ComplianceCompanySubitem subitem = new ComplianceCompanySubitem();
        subitem.setIsValid(Boolean.valueOf(false));
        subitem.setUpdateDate(now);
        subitem.setUpdateBy(loginUserId);
        int num = this.subitemMapper.updateByExampleSelective(subitem, subitemExample);
        log.info("\u5b50\u5408\u89c4\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyExitItem(Long id, Long loginUserId, Date now) {
        Example exitItemExample = this.createComplianceIdExample(ComplianceCompanyExitItem.class, id);
        ComplianceCompanyExitItem exitItem = new ComplianceCompanyExitItem();
        exitItem.setIsValid(Boolean.valueOf(false));
        exitItem.setUpdateDate(now);
        exitItem.setUpdateBy(loginUserId);
        int num = this.exitItemMapper.updateByExampleSelective(exitItem, exitItemExample);
        log.info("\u9000\u51fa\u9879\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyExitItemRecord(Long id, Long loginUserId, Date now) {
        Example exitItemRecordExample = this.createCidExample(ComplianceCompanyExitItemRecord.class, id);
        ComplianceCompanyExitItemRecord exitItemRecord = new ComplianceCompanyExitItemRecord();
        exitItemRecord.setIsValid(Boolean.valueOf(false));
        exitItemRecord.setUpdateDate(now);
        exitItemRecord.setUpdatedBy(loginUserId);
        int num = this.exitItemRecordMapper.updateByExampleSelective(exitItemRecord, exitItemRecordExample);
        log.info("\u9000\u51fa\u9879\u8bb0\u5f55\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private void updateComplianceCompanyLabel(Long id, Long loginUserId, Date now) {
        Example labelExample = this.createComplianceIdExample(ComplianceCompanyLabel.class, id);
        ComplianceCompanyLabel label = new ComplianceCompanyLabel();
        label.setIsValid(Boolean.valueOf(false));
        label.setUpdateDate(now);
        label.setUpdateBy(loginUserId);
        int num = this.labelMapper.updateByExampleSelective(label, labelExample);
        log.info("\u6807\u7b7e\u6570\u636e\u5220\u9664\u6761\u6570\uff1a{}", (Object)num);
    }

    private <T> Example createComplianceIdExample(Class<T> clazz, Long id) {
        Example example = new Example(clazz);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("complianceId", (Object)id);
        return example;
    }

    private <T> Example createCidExample(Class<T> clazz, Long id) {
        Example example = new Example(clazz);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)id);
        return example;
    }

    private Map<Long, SysParamModel> batchGetIndustryRegister(List<Long> industryRegisterIdList) {
        Map<Long, SysParamModel> irMap = new HashMap<Long, SysParamModel>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(industryRegisterIdList)) {
            String industryRegisterIds = industryRegisterIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            List industryRegisterList = this.industryService.getListByIds(industryRegisterIds);
            irMap = industryRegisterList.stream().collect(Collectors.toMap(SysParamModel::getId, r -> r, (a, b) -> a));
        }
        return irMap;
    }

    @Generated
    public ComplianceCompanyInfoManagerServiceImpl(ComplianceCompanyInfoMapper infoMapper, ComplianceCompanyInfoBakMapper infoBakMapper, IComplianceCompanyInfoService infoService, ComplianceCompanyItemMapper itemMapper, ComplianceCompanyItemdataMapper itemdataMapper, ComplianceCompanyExitItemMapper exitItemMapper, ComplianceCompanyExitItemRecordMapper exitItemRecordMapper, ComplianceCompanySubitemMapper subitemMapper, ComplianceCompanyChangeRecordMapper changeRecordMapper, IComplianceCompanyObjectionApplyService objectionApplyService, ComplianceCompanyProcessRecordMapper processRecordMapper, ComplianceScoreChangeRecordMapper scoreChangeRecordMapper, ComplianceCompanyLabelMapper labelMapper, IComplianceAreaScoreService complianceAreaScoreService) {
        this.infoMapper = infoMapper;
        this.infoBakMapper = infoBakMapper;
        this.infoService = infoService;
        this.itemMapper = itemMapper;
        this.itemdataMapper = itemdataMapper;
        this.exitItemMapper = exitItemMapper;
        this.exitItemRecordMapper = exitItemRecordMapper;
        this.subitemMapper = subitemMapper;
        this.changeRecordMapper = changeRecordMapper;
        this.objectionApplyService = objectionApplyService;
        this.processRecordMapper = processRecordMapper;
        this.scoreChangeRecordMapper = scoreChangeRecordMapper;
        this.labelMapper = labelMapper;
        this.complianceAreaScoreService = complianceAreaScoreService;
    }
}

