/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.compliance.calcscore.CalcScoreBusService;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemRecordMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyExitItem;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyExitItemRecord;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyLabel;
import cn.smarthse.modules.health.compliance.enums.ComplianceExitTypeEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoLabelEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceNeedRefreshModel;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyExitItemRecordService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyExitItemService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyLabelService;
import cn.smarthse.modules.health.compliance.service.ICompliancePrepareSmsService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyExitItemRecordVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyExitItemVo;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.ISupervisionLawService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import jakarta.annotation.Resource;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ComplianceCompanyExitItemServiceImpl
extends BaseServiceImpl<ComplianceCompanyExitItemMapper, ComplianceCompanyExitItem>
implements IComplianceCompanyExitItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceCompanyExitItemServiceImpl.class);
    @Autowired
    private ComplianceCompanyInfoMapper complianceCompanyInfoMapper;
    @Autowired
    private ComplianceCompanyExitItemRecordMapper exitItemRecordMapper;
    @Autowired
    private IComplianceCompanyExitItemRecordService exitItemRecordService;
    @Autowired
    private IComplianceCompanyInfoService complianceCompanyInfoService;
    @Autowired
    private IComplianceCompanyLabelService complianceCompanyLabelService;
    @Resource
    private ISupervisionLawService supervisionLawService;
    @DubboReference
    private IBxZybService bxZybService;
    @Autowired
    IComplianceScoreRefreshService scoreRefreshService;
    @Autowired
    ICompliancePrepareSmsService prepareSmsService;
    @Resource
    CalcScoreBusService calcScoreBusService;

    public List<ComplianceCompanyExitItemVo> getItemByComplianceIdAndType(Long complianceId, Byte type) {
        return ((ComplianceCompanyExitItemMapper)this.dao).getItemByCidAndType(complianceId, type);
    }

    @Transactional
    public void saveItem(ComplianceCompanyExitItem item, Long userId) {
        java.util.Date now = new java.util.Date();
        ComplianceCompanyInfo info = this.complianceCompanyInfoMapper.getInfoById(item.getComplianceId());
        if (info == null) {
            throw new ServiceException("\u4f20\u5165complianceId\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u5408\u89c4\u4f01\u4e1a");
        }
        item.setCid(info.getCid());
        if (item.getId() == null) {
            item.setCreateDate(now);
            item.setCreateBy(userId);
            item.setIsValid(Boolean.TRUE);
            item.setId(Long.valueOf(IdWorker.getId()));
            ((ComplianceCompanyExitItemMapper)this.dao).insertSelective(item);
            this.exitItemRecordService.addExitItemRecord(null, item, userId, now, (byte)2);
        } else {
            ComplianceCompanyExitItem oldItem = (ComplianceCompanyExitItem)((ComplianceCompanyExitItemMapper)this.dao).selectByPrimaryKey(item.getId());
            if (oldItem.getBusinessId() != null) {
                if (item.getStatus() == 1) {
                    String content = oldItem.getContent();
                    String[] split = content.split("; ");
                    for (int i = 0; i < split.length; ++i) {
                        if (i == 0) {
                            item.setDate(DateUtils.parseDate((Object)split[i]));
                        }
                        if (i != 1) continue;
                        if (split[i].contains("\u7f5a\u6b3e")) {
                            item.setLevel(Byte.valueOf((byte)2));
                        }
                        if (!split[i].contains("\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a")) continue;
                        item.setLevel(Byte.valueOf((byte)3));
                    }
                }
                item.setContent(oldItem.getContent());
            }
            item.setUpdateBy(userId);
            item.setUpdateDate(now);
            item.setIsValid(Boolean.TRUE);
            ((ComplianceCompanyExitItemMapper)this.dao).updateByPrimaryKey(item);
            this.exitItemRecordService.addExitItemRecord(oldItem, item, userId, now, (byte)3);
        }
    }

    private void setInitialDateIfNeeded(ComplianceCompanyExitItem item) {
        if (item.getDate() == null) {
            LocalDate initialDate = null;
            switch (item.getType()) {
                case 2: {
                    initialDate = LocalDate.now().minusYears(2L).withMonth(1).withDayOfMonth(1);
                    break;
                }
                case 3: {
                    initialDate = LocalDate.now().minusYears(5L).withMonth(1).withDayOfMonth(1);
                    break;
                }
            }
            item.setDate((java.util.Date)Date.valueOf(initialDate));
        }
    }

    @Transactional
    public void delItem(Long id, Long userId) {
        ComplianceCompanyExitItem item = (ComplianceCompanyExitItem)((ComplianceCompanyExitItemMapper)this.dao).selectByPrimaryKey(id);
        if (item == null) {
            throw new ServiceException("\u4f20\u5165ID\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
        }
        java.util.Date now = new java.util.Date();
        item.setIsValid(Boolean.FALSE);
        item.setUpdateBy(userId);
        item.setUpdateDate(now);
        ((ComplianceCompanyExitItemMapper)this.dao).updateByPrimaryKey(item);
        this.exitItemRecordService.addExitItemRecord(null, item, userId, now, (byte)4);
    }

    @Transactional
    public Boolean submitItem(List<ComplianceCompanyExitItemVo> list, Long userId) {
        Long cid = list.get(0).getCid();
        Long complianceId = list.get(0).getComplianceId();
        Integer type = list.get(0).getType();
        java.util.Date now = new java.util.Date();
        boolean hasStatusOne = false;
        LocalDate latestDate = null;
        boolean needSync = false;
        if (Objects.equals(ComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_1_2.getKey(), type) || Objects.equals(ComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_3_4.getKey(), type) || Objects.equals(ComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_5.getKey(), type)) {
            Example example = new Example(ComplianceCompanyExitItem.class);
            example.createCriteria().andEqualTo("complianceId", (Object)complianceId).andEqualTo("isValid", (Object)true).andEqualTo("type", (Object)ComplianceExitTypeEnum.REFERENCE_DATA.getKey());
            List referenceList = ((ComplianceCompanyExitItemMapper)this.dao).selectByExample(example);
            for (ComplianceCompanyExitItem item : referenceList) {
                item.setUpdateBy(userId);
                item.setUpdateDate(now);
                item.setStatus(Integer.valueOf(3));
                ((ComplianceCompanyExitItemMapper)this.dao).updateByPrimaryKeySelective(item);
            }
        }
        for (ComplianceCompanyExitItemVo vo : list) {
            boolean shouldUpdateLatestDate = false;
            if (type == 1 && (vo.getLevel() == null || vo.getLevel() != 1 && vo.getLevel() != 5)) {
                if (vo.getStatus() != null && vo.getStatus() != 2) {
                    hasStatusOne = true;
                    shouldUpdateLatestDate = true;
                }
            } else if (type != 1 && vo.getStatus() != null && vo.getStatus() == 1) {
                hasStatusOne = true;
                shouldUpdateLatestDate = true;
            }
            if (!shouldUpdateLatestDate || vo.getDate() == null) continue;
            LocalDate date = Instant.ofEpochMilli(vo.getDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            if (latestDate != null && !date.isAfter(latestDate)) continue;
            latestDate = date;
        }
        this.complianceCompanyLabelService.updateBypLabel(complianceId, Integer.valueOf(1), userId);
        ComplianceCompanyInfo info = this.complianceCompanyInfoMapper.getInfoById(complianceId);
        if (hasStatusOne && latestDate != null) {
            int currentYear = LocalDate.now().getYear();
            int itemYear = latestDate.getYear();
            if (Objects.equals(ComplianceExitTypeEnum.FINE.getKey(), type) || Objects.equals(ComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_1_2.getKey(), type)) {
                if (itemYear >= currentYear - 1) {
                    this.updateInfoWithOut(info, userId, now);
                } else if (info != null && (info.getStatus() == ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey() || info.getStatus() == ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) {
                    needSync = this.updateInfoByStatus(info, userId, now);
                }
            } else if (Objects.equals(ComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_5.getKey(), type) || Objects.equals(ComplianceExitTypeEnum.FALSIFICATION.getKey(), type) || Objects.equals(ComplianceExitTypeEnum.OCCUPATIONAL_DISEASE_3_4.getKey(), type)) {
                if (itemYear >= currentYear - 3) {
                    this.updateInfoWithOut(info, userId, now);
                } else if (info != null && (info.getStatus() == ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey() || info.getStatus() == ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) {
                    needSync = this.updateInfoByStatus(info, userId, now);
                }
            }
        } else if (info != null && (info.getStatus() == ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey() || info.getStatus() == ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey())) {
            needSync = this.updateInfoByStatus(info, userId, now);
        }
        return needSync;
    }

    public List<ComplianceCompanyExitItemRecordVo> getRecordData(Long cid, Byte itemType) {
        return this.exitItemRecordMapper.getRecordData(cid, itemType);
    }

    public PageInfo<ComplianceCompanyExitItemRecordVo> getRecordDataPage(JqGridParam pageParam, ComplianceCompanyExitItemRecord record) {
        Page page = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        this.exitItemRecordMapper.getRecordDataPage(record);
        return new PageInfo((List)page);
    }

    public List<ComplianceNeedRefreshModel> queryIsExistExitItems(List<Long> cidList) {
        return ((ComplianceCompanyExitItemMapper)this.dao).queryIsExistExitItems(cidList);
    }

    @Transactional
    public Boolean updateInfoByStatus(ComplianceCompanyInfo info, Long userId, java.util.Date now) {
        boolean needSync = false;
        if (info == null) {
            return needSync;
        }
        Boolean itemsExist = ((ComplianceCompanyExitItemMapper)this.dao).whetherExitItemsExist(info.getId());
        if (!itemsExist.booleanValue()) {
            info.setStatus(ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
            this.complianceCompanyInfoService.update((Object)info);
            needSync = true;
        }
        return needSync;
    }

    @Transactional
    public void syncExitItem(List<Long> cidList) {
        if (CollectionUtils.isEmpty(cidList)) {
            cidList = this.complianceCompanyInfoService.getCidList();
        }
        List lawExitItems = this.supervisionLawService.countCompliancePunishmentNum(cidList);
        List zybExitItems = this.bxZybService.countComplianceZybNum(cidList);
        lawExitItems.addAll(zybExitItems);
        if (CollectionUtils.isEmpty((Collection)lawExitItems)) {
            return;
        }
        Map complianceIdMap = this.complianceCompanyInfoService.getComplianceIdByCidList(cidList);
        this.batchUpdateOrInsert(lawExitItems, ComplianceCompanyExitItemMapper.class, (item, mapper) -> {
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setIsValid(Boolean.valueOf(true));
            item.setCreateDate(new java.util.Date());
            item.setUpdateDate(new java.util.Date());
            item.setCreateBy(Long.valueOf(0L));
            item.setUpdateBy(Long.valueOf(0L));
            Long complianceId = (Long)complianceIdMap.get(item.getCid());
            item.setComplianceId(complianceId);
            if (StringUtils.isNotBlank((CharSequence)item.getDeside())) {
                if (item.getDeside().contains("\u7f5a\u6b3e")) {
                    item.setLevel(Byte.valueOf((byte)2));
                }
                if (item.getDeside().contains("\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a")) {
                    item.setLevel(Byte.valueOf((byte)3));
                }
                String deside = "";
                if (item.getDeside().contains("\u7f5a\u6b3e")) {
                    deside = "\u7f5a\u6b3e";
                }
                if (item.getDeside().contains("\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a")) {
                    deside = "\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a";
                }
                item.setContent(DateUtils.formatDate((java.util.Date)item.getDate()).concat("; ").concat(deside));
            }
            return mapper.insert(item);
        });
        ArrayList<ComplianceCompanyInfo> infos = new ArrayList<ComplianceCompanyInfo>();
        ArrayList<ComplianceCompanyLabel> labels = new ArrayList<ComplianceCompanyLabel>();
        for (ComplianceCompanyExitItem lawExitItem : lawExitItems) {
            ComplianceCompanyInfo info2 = this.complianceCompanyInfoMapper.getInfoById(lawExitItem.getComplianceId());
            if (ComplianceInfoStatusEnum.COMPLIANT.getKey() == info2.getStatus()) {
                this.prepareSmsService.addPrepareSms(lawExitItem.getComplianceId());
                info2.setLastExitQualifyDate(new java.util.Date());
            }
            infos.add(ComplianceCompanyInfo.builder().id(lawExitItem.getComplianceId()).status(ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey()).updateDate(new java.util.Date()).build());
            labels.add(ComplianceCompanyLabel.builder().complianceId(lawExitItem.getComplianceId()).label(ComplianceInfoLabelEnum.EXITITEMS.getKey()).updateBy(Long.valueOf(0L)).updateDate(new java.util.Date()).createBy(Long.valueOf(0L)).createDate(new java.util.Date()).isValid(Boolean.valueOf(true)).build());
        }
        this.complianceCompanyInfoService.batchUpdateOrInsert(infos, ComplianceCompanyInfoMapper.class, (info, mapper) -> mapper.refreshComplianceWithoutReformRemainDate((ComplianceCompanyInfo)info));
        this.complianceCompanyLabelService.updateClashLabel(labels);
        this.exitItemRecordService.batchAddExitItemRecord(lawExitItems, Long.valueOf(0L), new java.util.Date(), (byte)1);
    }

    public List<ComplianceCompanyExitItem> queryHasExititems(Long complianceId) {
        return ((ComplianceCompanyExitItemMapper)this.dao).queryHasExititems(complianceId);
    }

    private void updateInfoWithOut(ComplianceCompanyInfo info, Long userId, java.util.Date now) {
        if (info != null) {
            Integer oldStatus = info.getStatus();
            info.setUpdateBy(userId);
            info.setUpdateDate(now);
            info.setStatus(ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey());
            info.setComplianceScore(null);
            info.setReformRemainDate(null);
            if (ComplianceInfoStatusEnum.COMPLIANT.getKey() == oldStatus) {
                this.prepareSmsService.addPrepareSms(info.getId());
                info.setLastExitQualifyDate(new java.util.Date());
            }
            this.complianceCompanyInfoMapper.updateByPrimaryKey(info);
        }
    }
}

