/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyExitItemRecordMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyExitItem;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyExitItemRecord;
import cn.smarthse.modules.health.compliance.enums.ComplianceExitTypeEnum;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyExitItemRecordService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyExitItemRecordVo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ComplianceCompanyExitItemRecordServiceImpl
extends BaseServiceImpl<ComplianceCompanyExitItemRecordMapper, ComplianceCompanyExitItemRecord>
implements IComplianceCompanyExitItemRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceCompanyExitItemRecordServiceImpl.class);

    public List<ComplianceCompanyExitItemRecordVo> getRecordData(Long cid, Byte itemType) {
        return ((ComplianceCompanyExitItemRecordMapper)this.dao).getRecordData(cid, itemType);
    }

    @Transactional
    public void addExitItemRecord(ComplianceCompanyExitItem oldItem, ComplianceCompanyExitItem item, Long createBy, Date time, byte type) {
        ComplianceCompanyExitItemRecord record = new ComplianceCompanyExitItemRecord();
        StringBuilder sb = new StringBuilder();
        if (oldItem != null) {
            this.appendPunishmentInfo(sb, oldItem);
            record.setOldData(sb.toString());
            sb.setLength(0);
        }
        this.appendPunishmentInfo(sb, item);
        record.setComment(sb.toString());
        sb.setLength(0);
        Optional.ofNullable(item.getProveFile()).filter(proveFile -> !proveFile.isEmpty()).ifPresent(arg_0 -> ((ComplianceCompanyExitItemRecord)record).setProveFile(arg_0));
        record.setCid(item.getCid());
        record.setItemId(item.getId());
        record.setItemType(item.getType());
        record.setType(Byte.valueOf(type));
        record.setCreateBy(createBy);
        record.setCreateDate(time);
        record.setIsValid(Boolean.TRUE);
        record.setId(Long.valueOf(IdWorker.getId()));
        ((ComplianceCompanyExitItemRecordMapper)this.dao).insert(record);
    }

    public void batchAddExitItemRecord(List<ComplianceCompanyExitItem> items, Long createBy, Date time, byte type) {
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<ComplianceCompanyExitItemRecord> list = new ArrayList<ComplianceCompanyExitItemRecord>();
        for (ComplianceCompanyExitItem item2 : items) {
            ComplianceCompanyExitItemRecord record = new ComplianceCompanyExitItemRecord();
            StringBuilder sb = new StringBuilder();
            this.appendPunishmentInfo(sb, item2);
            record.setComment(sb.toString());
            sb.setLength(0);
            Optional.ofNullable(item2.getProveFile()).filter(proveFile -> !proveFile.isEmpty()).ifPresent(arg_0 -> ((ComplianceCompanyExitItemRecord)record).setProveFile(arg_0));
            record.setCid(item2.getCid());
            record.setItemId(item2.getId());
            record.setItemType(item2.getType());
            record.setType(Byte.valueOf(type));
            record.setCreateBy(createBy);
            record.setCreateDate(time);
            record.setIsValid(Boolean.TRUE);
            record.setId(Long.valueOf(IdWorker.getId()));
            list.add(record);
        }
        this.batchUpdateOrInsert(list, ComplianceCompanyExitItemRecordMapper.class, (item, mapper) -> mapper.insert(item));
    }

    private void appendPunishmentInfo(StringBuilder sb, ComplianceCompanyExitItem item) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        if (item.getDate() != null) {
            sb.append("\u5904\u7f5a\u65f6\u95f4\uff1a").append(format.format(item.getDate())).append("\uff1b");
        }
        if (item.getType() == ComplianceExitTypeEnum.FINE.getKey() && item.getLevel() != null) {
            switch (item.getLevel()) {
                case 1: {
                    sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u7f5a\u6b3e\u4ee5\u4e0b\uff1b");
                    break;
                }
                case 2: {
                    sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u7f5a\u6b3e\uff1b");
                    break;
                }
                case 3: {
                    sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a\uff1b");
                    break;
                }
                case 4: {
                    sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u5176\u4ed6(\u9000\u51fa\u5408\u89c4\u4f01\u4e1a)\uff1b");
                    break;
                }
                case 5: {
                    sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u5176\u4ed6(\u4e0d\u9000\u51fa\u5408\u89c4\u4f01\u4e1a)\uff1b");
                    break;
                }
                default: {
                    sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u65e0\u5904\u7f5a\u7b49\u7ea7\uff1b");
                }
            }
        }
        if (item.getType() != ComplianceExitTypeEnum.FINE.getKey() && item.getStatus() != null) {
            if (item.getStatus() == 0) {
                sb.append("\u5904\u7f5a\u7ed3\u679c\uff1a").append("\u4e0d\u5b58\u5728\uff1b");
            } else if (item.getStatus() == 1) {
                sb.append("\u5904\u7f5a\u7ed3\u679c\uff1a").append("\u5b58\u5728\uff1b");
            }
        }
    }
}

