/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.compliance.calcscore.CalcScoreBusService;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyChangeRecordMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceApplyAppend;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyChangeRecord;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemcode;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyObjectionApply;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.enums.CompliantRecordTypeEnum;
import cn.smarthse.modules.health.compliance.enums.SourceEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyRecordParam;
import cn.smarthse.modules.health.compliance.service.IComplianceApplyAppendService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyChangeRecordService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyExitItemService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyObjectionApplyService;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyExitItemVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceCompanyRecordVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceScoreChangeRecordVo;
import cn.smarthse.modules.health.compliance.vo.CompliantRecordTypeVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class ComplianceCompanyChangeRecordServiceImpl
extends BaseServiceImpl<ComplianceCompanyChangeRecordMapper, ComplianceCompanyChangeRecord>
implements IComplianceCompanyChangeRecordService {
    private final OssClientBean ossBean;
    private final IComplianceCompanyItemcodeService companyItemcodeService;
    private final IComplianceCompanyObjectionApplyService objectionApplyService;
    private final CalcScoreBusService calcScoreBusService;
    private final IComplianceCompanyExitItemService exitItemService;
    private final IComplianceApplyAppendService complianceApplyAppendService;

    public List<CompliantRecordTypeVo> getRecordTypeList() {
        return Arrays.stream(CompliantRecordTypeEnum.values()).map(type -> new CompliantRecordTypeVo(type.getKey(), type.getValue())).collect(Collectors.toList());
    }

    public PageInfo<ComplianceCompanyRecordVo> getRecordPage(JqGridParam pageParam, ComplianceCompanyRecordParam recordParam) {
        if (recordParam == null || recordParam.getCid() == null || recordParam.getComplianceId() == null) {
            return null;
        }
        Page recordPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        recordParam.setRecordKeys(CharSequenceUtil.join((CharSequence)",", (Iterable)CollUtil.toList((Object[])new Integer[]{CompliantRecordTypeEnum.INFO_EDIT.getKey()})));
        List<ComplianceCompanyRecordVo> recordList = ((ComplianceCompanyChangeRecordMapper)this.dao).getRecordList(recordParam);
        this.setOperationTypeName(recordList);
        return new PageInfo((List)recordPage);
    }

    public List<ComplianceCompanyRecordVo> getObjectionProcess(ComplianceCompanyRecordParam recParam) {
        Long complianceId = recParam.getComplianceId();
        Long itemcodeId = recParam.getItemcodeId();
        SourceEnum source = recParam.getSource();
        if (complianceId == null || itemcodeId == null) {
            throw new ServiceException("\u5408\u89c4id\u3001\u5355\u9879id\uff0c\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        ArrayList objectionRecordKeyList = CollUtil.toList((Object[])new Integer[]{CompliantRecordTypeEnum.OBJECTION.getKey(), CompliantRecordTypeEnum.OBJECTION_SUBMIT.getKey(), CompliantRecordTypeEnum.OBJECTION_REJECT.getKey(), CompliantRecordTypeEnum.OBJECTION_APPROVE.getKey()});
        ComplianceCompanyRecordParam recordParam = new ComplianceCompanyRecordParam().setComplianceId(complianceId).setItemcodeId(itemcodeId).setRecordKeys(CharSequenceUtil.join((CharSequence)",", (Iterable)objectionRecordKeyList));
        List<ComplianceCompanyRecordVo> recordList = ((ComplianceCompanyChangeRecordMapper)this.dao).getObjectionProcessList(recordParam);
        this.setCompanyLatestEditData(complianceId, itemcodeId, recordList, source, 1);
        this.setOperationTypeName(recordList);
        this.setOperationFileInfo(recordList);
        return recordList;
    }

    public List<ComplianceCompanyRecordVo> getApplyProcess(ComplianceCompanyRecordParam recParam) {
        Long complianceId = recParam.getComplianceId();
        Long itemcodeId = recParam.getItemcodeId();
        SourceEnum source = recParam.getSource();
        if (complianceId == null || itemcodeId == null) {
            throw new ServiceException("\u5408\u89c4id\u3001\u5355\u9879id\uff0c\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        ArrayList applyRecordKeyList = CollUtil.toList((Object[])new Integer[]{CompliantRecordTypeEnum.APPLY.getKey(), CompliantRecordTypeEnum.APPLY_APPROVE.getKey(), CompliantRecordTypeEnum.APPLY_REJECT.getKey(), CompliantRecordTypeEnum.APPLY_CANCEL.getKey()});
        ComplianceCompanyRecordParam recordParam = new ComplianceCompanyRecordParam().setComplianceId(complianceId).setItemcodeId(itemcodeId).setRecordKeys(CharSequenceUtil.join((CharSequence)",", (Iterable)applyRecordKeyList));
        List<ComplianceCompanyRecordVo> recordList = ((ComplianceCompanyChangeRecordMapper)this.dao).getApplyProcessList(recordParam);
        this.setCompanyLatestEditData(complianceId, itemcodeId, recordList, source, 2);
        this.setOperationTypeName(recordList);
        this.setOperationFileInfo(recordList);
        this.setAppendConditions(recordList);
        return recordList;
    }

    private void setAppendConditions(List<ComplianceCompanyRecordVo> recordList) {
        List applyIdList = recordList.stream().filter(record -> CompliantRecordTypeEnum.APPLY.getKey().equals(record.getRecordKey())).map(ComplianceCompanyRecordVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(applyIdList)) {
            return;
        }
        List complianceApplyAppends = this.complianceApplyAppendService.getLIstByApplyIdList(applyIdList);
        if (CollectionUtils.isNotEmpty((Collection)complianceApplyAppends)) {
            HashMap<Long, Map<String, String>> totalMap = new HashMap<Long, Map<String, String>>();
            Map<Long, List<ComplianceApplyAppend>> map = complianceApplyAppends.stream().collect(Collectors.groupingBy(ComplianceApplyAppend::getApplyId));
            for (Long applyId : map.keySet()) {
                List<ComplianceApplyAppend> tempList = map.get(applyId);
                Map<String, String> appendConditions = tempList.stream().collect(Collectors.toMap(ComplianceApplyAppend::getKey, ComplianceApplyAppend::getValue));
                totalMap.put(applyId, appendConditions);
            }
            recordList.forEach(record -> {
                if (totalMap.get(record.getId()) != null) {
                    record.setAppendConditions((Map)totalMap.get(record.getId()));
                }
            });
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void doSaveRecordLog(List<ComplianceCompanyChangeRecord> changeRecordList) {
        if (CollUtil.isNotEmpty(changeRecordList)) {
            ((ComplianceCompanyChangeRecordMapper)this.dao).insertList2(changeRecordList);
        }
    }

    public PageInfo<ComplianceScoreChangeRecordVo> getComplianceScoreChangeRecord(JqGridParam pageParam, Long complianceId) {
        if (complianceId == null) {
            throw new ServiceException("\u5408\u89c4id\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Page recordPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<ComplianceScoreChangeRecordVo> recordList = ((ComplianceCompanyChangeRecordMapper)this.dao).getComplianceScoreChangeRecord(complianceId);
        this.calculateScoreChanges(recordList, pageParam, complianceId);
        return new PageInfo((List)recordPage);
    }

    public void calculateScoreChanges(List<ComplianceScoreChangeRecordVo> recordList, JqGridParam pageParam, Long complianceId) {
        if (CollUtil.isEmpty(recordList)) {
            return;
        }
        recordList.sort(Comparator.comparing(ComplianceScoreChangeRecordVo::getUpdateDate));
        String previousScore = null;
        for (ComplianceScoreChangeRecordVo r : recordList) {
            String currentScore = r.getComplianceScore();
            Integer status = r.getStatus();
            boolean hgIng = Objects.equals(status, ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
            if (currentScore == null || hgIng) {
                String statusName = ComplianceInfoStatusEnum.getValue((Integer)status);
                if (statusName.contains("-")) {
                    statusName = statusName.substring(statusName.indexOf("-") + 1);
                }
                r.setComplianceScore(statusName);
                r.setChangeScore("--");
                continue;
            }
            if (previousScore == null) {
                for (int i = recordList.indexOf(r) - 1; i >= 0; --i) {
                    if (recordList.get(i).getComplianceScore() == null) continue;
                    previousScore = recordList.get(i).getComplianceScore();
                    break;
                }
            }
            if (previousScore == null) {
                pageParam.setPage(pageParam.getPage() + 1);
                Page nextRecordPage = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
                List<ComplianceScoreChangeRecordVo> nextRecordList = ((ComplianceCompanyChangeRecordMapper)this.dao).getComplianceScoreChangeRecord(complianceId);
                if (CollUtil.isNotEmpty(nextRecordList)) {
                    ComplianceScoreChangeRecordVo scoreRec = nextRecordList.get(0);
                    previousScore = scoreRec.getComplianceScore();
                }
            }
            if (ComplianceCompanyChangeRecordServiceImpl.isNumeric(previousScore)) {
                BigDecimal scoreChange = Convert.toBigDecimal((Object)currentScore).subtract(Convert.toBigDecimal(previousScore));
                r.setChangeScore(String.valueOf(scoreChange));
            } else {
                r.setChangeScore(currentScore);
            }
            previousScore = currentScore;
        }
        Collections.reverse(recordList);
    }

    public static boolean isNumeric(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        String regex = "^(\\d+(\\.\\d+)?)$";
        return str.matches(regex);
    }

    private static String replaceTemplateData(Map<String, ComplianceCompanyItemdata> dataMap, String template) {
        String result = template;
        for (Map.Entry<String, ComplianceCompanyItemdata> data : dataMap.entrySet()) {
            String placeholder = data.getKey();
            String replacement = data.getValue().getResultData();
            result = result.replaceAll("\\b" + placeholder + "\\b", replacement);
        }
        return result;
    }

    public void setCompanyLatestEditData(Long complianceId, Long itemcodeId, List<ComplianceCompanyRecordVo> recordList, SourceEnum source, Integer type) {
        ComplianceCompanyObjectionApply oa;
        String pageData;
        HashSet<Long> validItemCodes = new HashSet<Long>(Arrays.asList(10001L, 10002L, 10003L, 10004L, 10005L));
        if (validItemCodes.contains(itemcodeId) && type == 2) {
            List exitItemVoList = this.exitItemService.getItemByComplianceIdAndType(complianceId, Byte.valueOf((byte)(itemcodeId - 10000L)));
            if (exitItemVoList == null || exitItemVoList.isEmpty()) {
                return;
            }
            pageData = this.exitItemVoList2PageData(exitItemVoList, itemcodeId);
        } else {
            ComplianceCompanyItemcode item = (ComplianceCompanyItemcode)this.companyItemcodeService.getById(itemcodeId);
            if (item == null) {
                return;
            }
            List<ComplianceCompanyItemdata> dataList = ((ComplianceCompanyChangeRecordMapper)this.dao).queryCompanyLatestEditData(complianceId, itemcodeId);
            String template = switch (Convert.toInt((Object)itemcodeId)) {
                case 10501 -> "\u5c97\u524d\u672a\u4f53\u68c0\u4eba\u6570${noBeforeWorkNum}";
                case 10502 -> "\u5c97\u4e2d\u672a\u4f53\u68c0\u4eba\u6570${noOnWorkNum}";
                case 10503 -> "\u79bb\u5c97\u672a\u4f53\u68c0\u4eba\u6570${noLeaveWorkNum}";
                default -> item.getTemplate();
            };
            Map<String, ComplianceCompanyItemdata> dataMap = dataList.stream().collect(Collectors.toMap(ComplianceCompanyItemdata::getFieldName, Function.identity(), (v1, v2) -> v1));
            pageData = this.calcScoreBusService.replaceTemplateData(item.getCode(), itemcodeId, dataMap, template);
        }
        ComplianceCompanyRecordVo rec = new ComplianceCompanyRecordVo().setItemcodeId(itemcodeId).setRecordTime(new Date()).setSource(source.getKey());
        Example e = new Example(ComplianceCompanyObjectionApply.class);
        Example.Criteria c = e.createCriteria();
        c.andEqualTo("complianceId", (Object)complianceId).andEqualTo("itemcodeId", (Object)itemcodeId).andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("type", (Object)type).andEqualTo("status", (Object)1);
        List oaList = this.objectionApplyService.getListByExample(e);
        if (source == SourceEnum.COMPANY) {
            if (CollUtil.isNotEmpty((Collection)oaList)) {
                oa = (ComplianceCompanyObjectionApply)oaList.get(0);
                rec.setCid(oa.getCid());
                rec.setObjectionApplyId(oa.getId());
                rec.setBeforeData(oa.getComplianceData());
                rec.setProductionTime(oa.getProductionTime());
            }
            rec.setAfterData(pageData);
        }
        if (source == SourceEnum.SUPERVISE) {
            rec.setBeforeData(pageData);
            if (CollUtil.isNotEmpty((Collection)oaList)) {
                oa = (ComplianceCompanyObjectionApply)oaList.get(0);
                rec.setProductionTime(oa.getProductionTime());
            }
        }
        recordList.add(0, rec);
    }

    private String exitItemVoList2PageData(List<ComplianceCompanyExitItemVo> exitItemVoList, Long itemcodeId) {
        if (exitItemVoList == null || exitItemVoList.isEmpty()) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        StringBuilder sb = new StringBuilder();
        switch (itemcodeId.intValue()) {
            case 10001: {
                sb.append("\u8fd12\u5e74\u6536\u5230\u7f5a\u6b3e\u53ca\u4ee5\u4e0a\u7684\u804c\u4e1a\u5065\u5eb7\u884c\u653f\u5904\u7f5a /n");
                break;
            }
            case 10002: {
                sb.append("\u8fd12\u5e74\u53d1\u751f\u804c\u4e1a\u75c5(1-2\u4eba)\u4e14\u6ca1\u6709\u9020\u6210\u4e25\u91cd\u5065\u5eb7\u635f\u5bb3 /n");
                break;
            }
            case 10003: {
                sb.append("\u8fd15\u5e74\u53d1\u751f5\u4eba\u53ca\u4ee5\u4e0a\u804c\u4e1a\u75c5\u6216\u80051\u4eba\u53ca\u4ee5\u4e0a\u91cd\u5ea6\u4f24\u6b8b\u3001\u6b7b\u4ea1\u7b49\u804c\u4e1a\u75c5\u5371\u5bb3\u4e8b\u6545 /n");
                break;
            }
            case 10004: {
                sb.append("\u8fd15\u5e74\u4ee5\u5f04\u865a\u4f5c\u5047\u3001\u8d3f\u8d42\u7b49\u975e\u6cd5\u624b\u6bb5\u83b7\u5f97\u804c\u4e1a\u5065\u5eb7\u5408\u89c4\u8fbe\u6807 /n");
                break;
            }
            case 10005: {
                sb.append("\u8fd12\u5e74\u53d1\u751f\u804c\u4e1a\u75c5(3-4\u4eba)\u4e14\u6ca1\u6709\u9020\u6210\u4e25\u91cd\u5065\u5eb7\u635f\u5bb3 /n");
                break;
            }
            default: {
                return "";
            }
        }
        for (ComplianceCompanyExitItemVo item : exitItemVoList) {
            if (item.getType() == 1) {
                sb.append("\u6570\u636e\u7c7b\u578b\uff1a").append(item.getBusinessId() != null ? "\u7cfb\u7edf\u6570\u636e\uff1b" : "\u76d1\u7ba1\u65b0\u589e\uff1b");
            }
            if (item.getDate() != null) {
                sb.append("\u5904\u7f5a\u65f6\u95f4\uff1a").append(format.format(item.getDate())).append("\uff1b");
            }
            if (item.getType() == 1 && item.getLevel() != null) {
                switch (item.getLevel()) {
                    case 1: {
                        sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u7f5a\u6b3e\u4ee5\u4e0b\uff1b");
                        break;
                    }
                    case 2: {
                        sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u7f5a\u6b3e\uff1b");
                        break;
                    }
                    case 3: {
                        sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u8d23\u4ee4\u505c\u4ea7\u505c\u4e1a\uff1b");
                        break;
                    }
                    case 4: {
                        sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u5176\u4ed6(\u9000\u51fa\u5408\u89c4\u4f01\u4e1a)\uff1b");
                        break;
                    }
                    case 5: {
                        sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u5176\u4ed6(\u4e0d\u9000\u51fa\u5408\u89c4\u4f01\u4e1a)\uff1b");
                        break;
                    }
                    default: {
                        sb.append("\u5904\u7f5a\u7b49\u7ea7\uff1a\u65e0\u5904\u7f5a\u7b49\u7ea7\uff1b");
                    }
                }
            }
            if (item.getType() != 1 && item.getStatus() != null) {
                sb.append("\u5904\u7f5a\u7ed3\u679c\uff1a").append(item.getStatus() == 0 ? "\u4e0d\u5b58\u5728\uff1b" : "\u5b58\u5728\uff1b");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void setOperationTypeName(List<ComplianceCompanyRecordVo> recordList) {
        recordList.forEach(v -> v.setRecordValue(CompliantRecordTypeEnum.getValue((Integer)v.getRecordKey())));
    }

    private void setOperationFileInfo(List<ComplianceCompanyRecordVo> recordList) {
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        recordList.forEach(rec -> {
            String fileIds = rec.getFileIds();
            if (CharSequenceUtil.isNotBlank((CharSequence)fileIds)) {
                List oneIdList = CharSequenceUtil.splitTrim((CharSequence)fileIds, (char)',').stream().map(Convert::toLong).collect(Collectors.toList());
                fileIdList.addAll(oneIdList);
            }
        });
        List fileList = fileIdList.isEmpty() ? Collections.emptyList() : ((ComplianceCompanyChangeRecordMapper)this.dao).selectFileInfoBatch(fileIdList);
        Map<Long, String> fileIdNameMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, SysFileModel::getFileName, (a, b) -> b));
        Map<Long, String> fileIdUrlMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, file -> this.ossBean.getUrl(file.getOssUrl()), (a, b) -> b));
        for (ComplianceCompanyRecordVo rec2 : recordList) {
            String fileIds = rec2.getFileIds();
            if (!CharSequenceUtil.isNotBlank((CharSequence)fileIds)) continue;
            List oneFileIdList = CharSequenceUtil.splitTrim((CharSequence)fileIds, (char)',').stream().map(Convert::toLong).collect(Collectors.toList());
            List oneFileList = oneFileIdList.stream().map(i -> new SysFileModel().setId(i).setFileName((String)fileIdNameMap.get(i)).setOssUrl((String)fileIdUrlMap.get(i))).collect(Collectors.toList());
            rec2.setFileList(Optional.of(oneFileList).orElse(Collections.emptyList()));
        }
    }

    @Generated
    public ComplianceCompanyChangeRecordServiceImpl(OssClientBean ossBean, IComplianceCompanyItemcodeService companyItemcodeService, IComplianceCompanyObjectionApplyService objectionApplyService, CalcScoreBusService calcScoreBusService, IComplianceCompanyExitItemService exitItemService, IComplianceApplyAppendService complianceApplyAppendService) {
        this.ossBean = ossBean;
        this.companyItemcodeService = companyItemcodeService;
        this.objectionApplyService = objectionApplyService;
        this.calcScoreBusService = calcScoreBusService;
        this.exitItemService = exitItemService;
        this.complianceApplyAppendService = complianceApplyAppendService;
    }
}

