/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.service;

import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.Convert;
import cn.smarthse.modules.health.compliance.dao.ComplianceAssessmentInfoMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceAssessmentInfo;
import cn.smarthse.modules.health.compliance.service.IComplianceAssessmentInfoService;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional
public class ComplianceAssessmentInfoServiceImpl
extends BaseServiceImpl<ComplianceAssessmentInfoMapper, ComplianceAssessmentInfo>
implements IComplianceAssessmentInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceAssessmentInfoServiceImpl.class);

    public ComplianceAssessmentInfo addComplianceAssessmentInfo(String name, Long loginStaffId) throws HealthException {
        String normalize = Convert.toDBC((String)name);
        Example example = new Example(ComplianceAssessmentInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("name", (Object)normalize);
        List complianceAssessmentInfos = ((ComplianceAssessmentInfoMapper)this.dao).selectByExample(example);
        if (!complianceAssessmentInfos.isEmpty()) {
            throw new HealthException("\u5408\u89c4\u8bc4\u4f30\u5de5\u4f5c\u540d\u79f0\u91cd\u590d");
        }
        ComplianceAssessmentInfo complianceAssessmentInfo = new ComplianceAssessmentInfo();
        complianceAssessmentInfo.setName(normalize);
        complianceAssessmentInfo.setCompanyNum(Long.valueOf(0L));
        complianceAssessmentInfo.setCreateBy(loginStaffId);
        complianceAssessmentInfo.setUpdateBy(loginStaffId);
        ComplianceAssessmentInfo add = this.add(complianceAssessmentInfo);
        return add;
    }

    public PageInfo<ComplianceAssessmentInfo> getComplianceAssessmentInfoPage(JqGridParam gridParam, String title) {
        title = Convert.toDBC((String)title);
        PageMethod.startPage((int)gridParam.getPage(), (int)gridParam.getRows());
        List<ComplianceAssessmentInfo> complianceAssessmentInfos = ((ComplianceAssessmentInfoMapper)this.dao).selectComplianceAssessmentInfoPage(title);
        PageInfo data = new PageInfo(complianceAssessmentInfos);
        return data;
    }

    public Date updateLastTime(Long workId, Long loginStaffId) {
        if (workId == null) {
            log.warn("workId\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u66f4\u65b0...");
            return null;
        }
        ComplianceAssessmentInfo byId = (ComplianceAssessmentInfo)this.getById(workId);
        if (ObjectUtil.isNull((Object)byId)) {
            log.warn("workId\u4e0d\u5b58\u5728\u4e0d\u8fdb\u884c\u66f4\u65b0...");
            return null;
        }
        Date date = new Date();
        byId.setLastUpdateDate(date);
        this.updateByPrimaryKey(byId, loginStaffId);
        return date;
    }

    @Transactional
    public void delComplianceWork(Long workId, Long userId) {
        Long countByExample;
        ComplianceAssessmentInfo byId;
        if (ObjectUtil.isNotEmpty((Object)workId) && ObjectUtil.isNotNull((Object)(byId = (ComplianceAssessmentInfo)this.getById(workId))) && (countByExample = ((ComplianceAssessmentInfoMapper)this.dao).getCountByWorkId(workId)) == 0L) {
            byId.setCompanyNum(Long.valueOf(0L));
            byId.setIsValid(Boolean.valueOf(false));
            byId.setUpdateDate(new Date());
            byId.setUpdateBy(userId);
            this.update(byId);
        }
    }

    public ComplianceAssessmentInfo getComplianceWorkById(Long workId) {
        ComplianceAssessmentInfo companyInfo = null;
        if (ObjectUtil.isNotNull((Object)workId)) {
            Example example = new Example(ComplianceAssessmentInfo.class);
            example.createCriteria().andEqualTo("id", (Object)workId).andEqualTo("isValid", (Object)true);
            companyInfo = (ComplianceAssessmentInfo)this.getOneByExample(example);
        }
        return companyInfo;
    }
}

