/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanySubitem;
import cn.smarthse.modules.health.pojo.ComplianceTsProjectCount;
import cn.smarthse.modules.health.service.work.thirdtime.simple.ITsProjectSimpleService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class TsProjectSimpleScoreCalcHandle
implements ScoreCalcHandle {
    @DubboReference
    private ITsProjectSimpleService tsProjectSimpleService;

    @Override
    public String support() {
        return "04";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("5");
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List complianceTsProjectCount = this.tsProjectSimpleService.getComplianceTsProjectCount(cids, Integer.valueOf(5));
        Map<Long, List<ComplianceTsProjectCount>> cidMap = complianceTsProjectCount.stream().collect(Collectors.groupingBy(ComplianceTsProjectCount::getCid));
        ArrayList<ComplianceCompanyItemdata> list = new ArrayList<ComplianceCompanyItemdata>();
        for (Long cid : cids) {
            ComplianceTsProjectCount tsCount = new ComplianceTsProjectCount();
            List<ComplianceTsProjectCount> complianceTsProjectCounts = cidMap.get(cid);
            if (CollectionUtils.isNotEmpty(complianceTsProjectCounts)) {
                tsCount = complianceTsProjectCounts.get(0);
            }
            ComplianceCompanyItemdata itemData = new ComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(10401L));
            itemData.setCid(cid);
            itemData.setFieldName("startedNum");
            itemData.setResultData(tsCount.getStartedNum().toString());
            list.add(itemData);
            itemData = new ComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(10401L));
            itemData.setCid(cid);
            itemData.setFieldName("notStartNum");
            itemData.setResultData(tsCount.getNotStartNum().toString());
            list.add(itemData);
            itemData = new ComplianceCompanyItemdata();
            itemData.setItemcodeId(Long.valueOf(10401L));
            itemData.setCid(cid);
            itemData.setFieldName("totalNum");
            itemData.setResultData(tsCount.getTotalNum().toString());
            list.add(itemData);
        }
        return list;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (MapUtils.isEmpty(fieldsItemDataMap)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        ComplianceCompanyItemdata notStartData = fieldsItemDataMap.get("notStartNum");
        ComplianceCompanyItemdata totalData = fieldsItemDataMap.get("totalNum");
        if (totalData != null && StringUtils.isNotEmpty((String)totalData.getResultData()) && "0".equalsIgnoreCase(totalData.getResultData())) {
            return new BigDecimal("0");
        }
        if (notStartData != null && StringUtils.isNotEmpty((String)notStartData.getResultData()) && !"0".equalsIgnoreCase(notStartData.getResultData())) {
            int notStartNum = Integer.parseInt(notStartData.getResultData());
            if (notStartNum >= 5) {
                bigDecimal = new BigDecimal("-5");
            } else {
                for (int i = 0; i < notStartNum; ++i) {
                    bigDecimal = bigDecimal.subtract(new BigDecimal("1"));
                }
            }
        }
        return bigDecimal;
    }

    public BigDecimal calcSubItemScore(List<ComplianceCompanySubitem> subItemList) {
        BigDecimal totalScore = new BigDecimal("5");
        if (CollectionUtils.isNotEmpty(subItemList)) {
            for (ComplianceCompanySubitem subitem : subItemList) {
                totalScore.add(subitem.getLoseScore());
            }
        }
        return totalScore;
    }

    public boolean isComplete(List<ComplianceCompanySubitem> subItemList) {
        return false;
    }

    @Generated
    public TsProjectSimpleScoreCalcHandle() {
    }
}

