/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.service.work.reform.ICompanyRiskCompletionService;
import cn.smarthse.modules.health.vo.work.reform.RiskTypeVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RiskScoreCalcHandle
implements ScoreCalcHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RiskScoreCalcHandle.class);
    @DubboReference
    private ICompanyRiskCompletionService riskCompletionService;
    static final List<String> riskTypeName = Arrays.asList("declare_riskType", "detection_riskType", "physicalExamination_riskType", "training_riskType", "threeTime_riskType", "protective_riskType", "warningMark_riskType", "healthArchive_riskType");

    @Override
    public String support() {
        return "02";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("3");
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        if (CollectionUtils.isEmpty(cids)) {
            return result;
        }
        List riskTypeVos = this.riskCompletionService.selectRiskTypeListData(cids, true);
        for (RiskTypeVo riskTypeVo : riskTypeVos) {
            if (riskTypeVo == null) continue;
            if ("declare_riskType".equals(riskTypeVo.getRiskTypeCode()) && "\u6682\u65e0\u7533\u62a5\u6570\u636e".equals(riskTypeVo.getRiskTypeStatus())) {
                riskTypeVo.setRiskTypeStatus("\u6682\u65e0\u98ce\u9669");
            }
            result.add(new ComplianceCompanyItemdata().setCid(riskTypeVo.getCid()).setFieldName(riskTypeVo.getRiskTypeCode()).setItemcodeId(Long.valueOf(10201L)).setResultData(riskTypeVo.getRiskTypeStatus()));
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (CollectionUtils.isEmpty(fieldsItemDataMap) || itemcodeId != 10201L) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalLoseScore = new BigDecimal("0.0");
        for (Map.Entry<String, ComplianceCompanyItemdata> entry : fieldsItemDataMap.entrySet()) {
            ComplianceCompanyItemdata value;
            if (StringUtils.isBlank((CharSequence)entry.getKey()) || !riskTypeName.contains(entry.getKey()) || (value = entry.getValue()) == null || !StringUtils.isNotBlank((CharSequence)value.getResultData()) || !value.getResultData().contains("\u672a\u5316\u89e3")) continue;
            totalLoseScore = totalLoseScore.add(new BigDecimal("-0.5"));
        }
        return totalLoseScore;
    }

    @Generated
    public RiskScoreCalcHandle() {
    }
}

