/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.hutool.core.lang.Pair;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffPhySicalCheckModel;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.noEnvo.PhcPhysicalStaffCheckInfoNoEn;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PhysicalCheckScoreCalcHandle
implements ScoreCalcHandle {
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    private static final List<String> beforeWorkStatus = Collections.singletonList("1");
    private static final List<String> onWorkStatus = Arrays.asList("2", "5");
    private static final List<String> leaveWorkStatus = Arrays.asList("3", "4");
    private static final String ZyjjzConlution = "4";
    private static final String YszybConlution = "3";
    private static final Byte BEFORE_WORK = 1;
    private static final Byte ON_WORK = 2;
    private static final Byte LEAVE_WORK = 3;

    @Override
    public String support() {
        return "05";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("10");
    }

    public Map<Long, List<StaffPhySicalCheckModel>> loadStaffPhysicalCheckMap(List<Long> cids) {
        List phcPhysicalStaffCheckInfos = this.phcPhysicalStaffCheckInfoService.queryCompliancePhysicalCheckInfo(cids);
        List staffPhySicalCheckModelList = this.staffInfoService.queryPhysicalStaffList(cids);
        Map<Long, List<StaffPhySicalCheckModel>> staffPhySicalCheckMap = staffPhySicalCheckModelList.stream().filter(i -> i.getCardId() != null).peek(i -> i.setCardId(i.getCardId().toLowerCase())).collect(Collectors.groupingBy(StaffPhySicalCheckModel::getCid));
        ArrayList<StaffPhySicalCheckModel> tempList = new ArrayList<StaffPhySicalCheckModel>();
        ArrayList<StaffPhySicalCheckModel> AllList = new ArrayList<StaffPhySicalCheckModel>();
        HashMap<Long, List<StaffPhySicalCheckModel>> resultMap = new HashMap<Long, List<StaffPhySicalCheckModel>>();
        Map<Long, Map<String, List<PhcPhysicalStaffCheckInfoNoEn>>> physicalCheckMap = phcPhysicalStaffCheckInfos.stream().filter(i -> StringUtils.isNotEmpty((String)i.getIdcardCode())).peek(i -> i.setIdcardCode(i.getIdcardCode().toUpperCase())).collect(Collectors.groupingBy(PhcPhysicalStaffCheckInfoNoEn::getCid, Collectors.groupingBy(PhcPhysicalStaffCheckInfoNoEn::getIdcardCode)));
        for (Long cid : cids) {
            List<StaffPhySicalCheckModel> staffList = staffPhySicalCheckMap.get(cid);
            if (CollectionUtils.isEmpty(staffList)) continue;
            Map<String, List<PhcPhysicalStaffCheckInfoNoEn>> idCardPhyCheckMap = physicalCheckMap.get(cid);
            for (StaffPhySicalCheckModel checkModel : staffList) {
                List<StaffPhySicalCheckModel> resultList = this.setCheckInfo(checkModel, idCardPhyCheckMap);
                tempList.addAll(resultList);
            }
            resultMap.put(cid, tempList);
            AllList.addAll(tempList);
            tempList = new ArrayList();
        }
        this.staffInfoService.reloadCheckData(AllList);
        return resultMap;
    }

    private List<StaffPhySicalCheckModel> setCheckInfo(StaffPhySicalCheckModel checkModel, Map<String, List<PhcPhysicalStaffCheckInfoNoEn>> idCardPhyCheckMap) {
        Date compareDate;
        PhcPhysicalStaffCheckInfoNoEn lastBefore;
        Date compareDate2;
        int count;
        List finalYears;
        List<Object> staffCheckInfoList;
        if (MapUtils.isEmpty(idCardPhyCheckMap)) {
            idCardPhyCheckMap = Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(staffCheckInfoList = idCardPhyCheckMap.get(checkModel.getCardId()))) {
            staffCheckInfoList = Collections.emptyList();
        }
        boolean isDoCheck = false;
        HashSet<StaffPhySicalCheckModel> resultSet = new HashSet<StaffPhySicalCheckModel>();
        StaffPhySicalCheckModel result = new StaffPhySicalCheckModel();
        Date DATE_2023_01_01 = DateUtil.getDate((String)"2023-01-01", (String)"yyyy-MM-dd");
        Date DATE_2023_03_01 = DateUtil.getDate((String)"2023-03-01", (String)"yyyy-MM-dd");
        Date DATE_2024_01_01 = DateUtil.getDate((String)"2024-01-01", (String)"yyyy-MM-dd");
        if (Objects.isNull(checkModel.getLeaveTime())) {
            checkModel.setLeaveTime(DATE_2024_01_01);
        }
        if (Objects.nonNull(checkModel.getBeginTime()) && checkModel.getBeginTime().getTime() >= DATE_2023_01_01.getTime()) {
            checkModel.setNeedCheckType(BEFORE_WORK);
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        PhcPhysicalStaffCheckInfoNoEn beforeWork = staffCheckInfoList.stream().filter(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType())).findFirst().orElse(null);
        PhcPhysicalStaffCheckInfoNoEn onWork = staffCheckInfoList.stream().filter(staffCheckInfo -> onWorkStatus.contains(staffCheckInfo.getBodyCheckType())).findFirst().orElse(null);
        PhcPhysicalStaffCheckInfoNoEn leaveWork = staffCheckInfoList.stream().filter(staffCheckInfo -> leaveWorkStatus.contains(staffCheckInfo.getBodyCheckType())).findFirst().orElse(null);
        if (Objects.nonNull(onWork) && Objects.nonNull(leaveWork) && leaveWork.getCheckTime().getTime() <= onWork.getCheckTime().getTime()) {
            checkModel.setNeedCheckType(BEFORE_WORK);
            isDoCheck = staffCheckInfoList.stream().filter(s -> s.getCheckTime().getTime() >= leaveWork.getCheckTime().getTime() && s.getCheckTime().getTime() <= onWork.getCheckTime().getTime()).anyMatch(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (Objects.isNull(checkModel.getBeginTime())) {
            checkModel.setNeedCheckType(BEFORE_WORK);
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        Date firstBeginTime = Objects.isNull(checkModel.getFirstBeginTime()) ? DateUtil.getDate((String)"2022-12-31", (String)"yyyy-MM-dd") : checkModel.getFirstBeginTime();
        Date leaveTime = Objects.isNull(checkModel.getLeaveTime()) ? DATE_2024_01_01 : checkModel.getLeaveTime();
        Date beginTime = checkModel.getBeginTime();
        List years = DateUtil.findWholeYearsBetween((Date)firstBeginTime, (Date)new Date()).stream().map(Integer::parseInt).filter(i -> i > 2022).collect(Collectors.toList());
        if (StaffWorkStatusEnum.ONWORKING.getValue().equals(checkModel.getWorkStatus()) && CollectionUtils.isNotEmpty(years)) {
            finalYears = years;
            count = (int)staffCheckInfoList.stream().filter(staffCheckInfo -> finalYears.contains(DateUtils.getYear((Date)staffCheckInfo.getCheckTime()))).count();
            isDoCheck = count >= years.size();
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.NOWORKED.getValue().equals(checkModel.getWorkStatus()) && CollectionUtils.isNotEmpty(years = DateUtil.findWholeYearsBetween((Date)firstBeginTime, (Date)leaveTime).stream().map(Integer::parseInt).filter(i -> i > 2022).collect(Collectors.toList()))) {
            finalYears = years;
            count = (int)staffCheckInfoList.stream().filter(staffCheckInfo -> finalYears.contains(DateUtils.getYear((Date)staffCheckInfo.getCheckTime()))).count();
            isDoCheck = count >= years.size();
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.ONWORKING.getValue().equals(checkModel.getWorkStatus()) && Objects.nonNull(compareDate2 = Objects.nonNull(lastBefore = (PhcPhysicalStaffCheckInfoNoEn)staffCheckInfoList.stream().filter(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfoNoEn::getCheckTime)).orElse(null)) ? DateUtils.chooseLastDate((Date)beginTime, (Date)lastBefore.getCheckTime()) : beginTime) && DateUtils.isExpired((Date)DateUtils.addYears((Date)compareDate2, (int)1))) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> onWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && !DateUtils.isMoreThanYearApart((Date)new Date(), (Date)staffCheckInfo.getCheckTime(), (int)1));
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.NOWORKED.getValue().equals(checkModel.getWorkStatus()) && leaveTime.getTime() >= DATE_2024_01_01.getTime() && Objects.nonNull(compareDate = Objects.nonNull(lastBefore = (PhcPhysicalStaffCheckInfoNoEn)staffCheckInfoList.stream().filter(staffCheckInfo -> beforeWorkStatus.contains(staffCheckInfo.getBodyCheckType())).max(Comparator.comparing(PhcPhysicalStaffCheckInfoNoEn::getCheckTime)).orElse(null)) ? DateUtils.chooseLastDate((Date)beginTime, (Date)lastBefore.getCheckTime()) : beginTime) && leaveTime != null && leaveTime.compareTo(DateUtils.addYears((Date)compareDate, (int)1)) > 0) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> onWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && !DateUtils.isMoreThanYearApart((Date)leaveTime, (Date)staffCheckInfo.getCheckTime(), (int)1));
            checkModel.setNeedCheckType(ON_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.ONWORKING.getValue().equals(checkModel.getWorkStatus()) && Objects.nonNull(beforeWork) && Objects.nonNull(onWork) && beforeWork.getCheckTime().getTime() > onWork.getCheckTime().getTime()) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> leaveWorkStatus.contains(staffCheckInfo.getBodyCheckType()));
            checkModel.setNeedCheckType(LEAVE_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        if (StaffWorkStatusEnum.NOWORKED.getValue().equals(checkModel.getWorkStatus()) && checkModel.getLeaveTime().getTime() >= DATE_2023_03_01.getTime()) {
            isDoCheck = staffCheckInfoList.stream().anyMatch(staffCheckInfo -> leaveWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && staffCheckInfo.getCheckTime().getTime() >= DateUtils.addMonth((Date)checkModel.getLeaveTime(), (int)-3).getTime() || onWorkStatus.contains(staffCheckInfo.getBodyCheckType()) && staffCheckInfo.getCheckTime().getTime() >= DateUtils.addMonth((Date)checkModel.getLeaveTime(), (int)-3).getTime() || !DateUtils.isMoreThanMonthsApart((Date)checkModel.getLeaveTime(), (Date)staffCheckInfo.getCheckTime(), (int)3));
            checkModel.setNeedCheckType(LEAVE_WORK);
            checkModel.setDoCheck(Boolean.valueOf(isDoCheck));
            result = new StaffPhySicalCheckModel();
            BeanUtils.copyProperties((Object)checkModel, (Object)result);
            resultSet.add(result);
        }
        Map<Long, List<StaffPhySicalCheckModel>> map = resultSet.stream().collect(Collectors.groupingBy(StaffPhySicalCheckModel::getStaffId));
        for (StaffPhySicalCheckModel staffPhySicalCheckModel : resultSet) {
            boolean noDoOnCheck;
            if (!BEFORE_WORK.equals(staffPhySicalCheckModel.getNeedCheckType()) || staffPhySicalCheckModel.getDoCheck().booleanValue()) continue;
            List<Object> list = map.get(result.getStaffId());
            if (CollectionUtils.isEmpty(list)) {
                list = Collections.emptyList();
            }
            staffPhySicalCheckModel.setDoOnWorkCheck(Boolean.valueOf(!(noDoOnCheck = list.stream().anyMatch(s -> ON_WORK.equals(s.getNeedCheckType()) && s.getDoCheck() == false))));
            if (noDoOnCheck) continue;
            boolean hasProblem = staffCheckInfoList.stream().anyMatch(s -> DateUtils.getYear((Date)s.getCheckTime()) > 2024 && (ZyjjzConlution.equalsIgnoreCase(s.getBodyCheckType()) || YszybConlution.equalsIgnoreCase(s.getBodyCheckType())));
            staffPhySicalCheckModel.setProblem(Boolean.valueOf(hasProblem));
        }
        return new ArrayList<StaffPhySicalCheckModel>(resultSet);
    }

    private Map<Long, Integer> loadYszybMap(List<Long> cids) {
        List phcPhysicalCheckV3221s = this.phcPhysicalStaffCheckInfoService.countYszybNum(cids, Integer.valueOf(2024));
        return phcPhysicalCheckV3221s.stream().collect(Collectors.toMap(PhcPhysicalCheckV3221::getCid, PhcPhysicalCheckV3221::getNumberOfYszyb));
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        Map<Long, List<StaffPhySicalCheckModel>> staffPhySicalCheckMap = this.loadStaffPhysicalCheckMap(cids);
        Map noWorkStatusMap = this.staffInfoService.countNoWorkStatusNum(cids);
        Map<Long, Integer> yszybMap = this.loadYszybMap(cids);
        for (Long cid : cids) {
            List<Object> list = staffPhySicalCheckMap.get(cid);
            if (CollectionUtils.isEmpty(list)) {
                list = Collections.emptyList();
            }
            List beforeWork = list.stream().filter(item -> Objects.equals(BEFORE_WORK, item.getNeedCheckType())).collect(Collectors.toList());
            long noBeforeWorkNum = beforeWork.stream().filter(s -> s.getDoCheck() == false).count();
            long noBeforeWorkWitOnWorkNoProblemNum = beforeWork.stream().filter(s -> s.getDoCheck() == false && s.getDoOnWorkCheck() != false && s.getProblem() == false).count();
            long zyjjzNum = beforeWork.stream().filter(s -> s.getDoCheck() == false && s.getDoOnWorkCheck() != false && s.getZyjjz() != false).count();
            long noOnWorkNum = list.stream().filter(item -> Objects.equals(ON_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            long noLeaveWorkNum = list.stream().filter(item -> Objects.equals(LEAVE_WORK, item.getNeedCheckType()) && item.getDoCheck() == false).count();
            ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
            itemdata.setItemcodeId(Long.valueOf(10501L));
            itemdata.setCid(cid);
            itemdata.setFieldName("noBeforeWorkNum");
            itemdata.setResultData(String.valueOf(noBeforeWorkNum));
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setItemcodeId(Long.valueOf(10501L));
            itemdata.setCid(cid);
            itemdata.setFieldName("noBeforeWorkWitOnWorkNoProblemNum");
            itemdata.setResultData(String.valueOf(noBeforeWorkWitOnWorkNoProblemNum));
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setItemcodeId(Long.valueOf(10501L));
            itemdata.setCid(cid);
            itemdata.setFieldName("zyjjzNum");
            itemdata.setResultData(String.valueOf(zyjjzNum));
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setItemcodeId(Long.valueOf(10502L));
            itemdata.setCid(cid);
            itemdata.setFieldName("noOnWorkNum");
            itemdata.setResultData(String.valueOf(noOnWorkNum));
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setItemcodeId(Long.valueOf(10503L));
            itemdata.setCid(cid);
            itemdata.setFieldName("noLeaveWorkNum");
            itemdata.setResultData(String.valueOf(noLeaveWorkNum));
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            Integer ysZybNum = yszybMap.get(cid);
            if (null == ysZybNum) {
                ysZybNum = 0;
            }
            itemdata.setItemcodeId(Long.valueOf(10504L));
            itemdata.setCid(cid);
            itemdata.setFieldName("ysZybNum");
            itemdata.setResultData(String.valueOf(ysZybNum));
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            Integer noWorkStatusNum = (Integer)noWorkStatusMap.get(cid);
            if (null == noWorkStatusNum) {
                noWorkStatusNum = 0;
            }
            itemdata.setItemcodeId(Long.valueOf(10505L));
            itemdata.setCid(cid);
            itemdata.setFieldName("noWorkStatusNum");
            itemdata.setResultData(String.valueOf(noWorkStatusNum));
            result.add(itemdata);
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (itemcodeId == 10501L) {
            BigDecimal result = new BigDecimal(0);
            ComplianceCompanyItemdata noBeforeWorkNum = fieldsItemDataMap.get("noBeforeWorkNum");
            ComplianceCompanyItemdata noBeforeWorkWitOnWorkNoProblemNum = fieldsItemDataMap.get("noBeforeWorkWitOnWorkNoProblemNum");
            if (noBeforeWorkNum != null && StringUtils.isNotEmpty((String)noBeforeWorkNum.getResultData()) && noBeforeWorkWitOnWorkNoProblemNum != null && StringUtils.isNotEmpty((String)noBeforeWorkWitOnWorkNoProblemNum.getResultData())) {
                int noBeforeWorkNumIntValue = Integer.parseInt(noBeforeWorkNum.getResultData());
                int noBeforeWorkWithOnWorkNoProblemNumIntValue = Integer.parseInt(noBeforeWorkWitOnWorkNoProblemNum.getResultData());
                result = BigDecimal.valueOf(noBeforeWorkWithOnWorkNoProblemNumIntValue).multiply(BigDecimal.valueOf(-0.1)).add(BigDecimal.valueOf((double)(noBeforeWorkNumIntValue - noBeforeWorkWithOnWorkNoProblemNumIntValue) * -0.5));
            }
            return result.compareTo(new BigDecimal(-5)) < 0 ? new BigDecimal(-5) : result;
        }
        if (itemcodeId == 10502L) {
            ComplianceCompanyItemdata noOnWorkNum = fieldsItemDataMap.get("noOnWorkNum");
            BigDecimal result = this.getLoseScore(noOnWorkNum, 1.0);
            return result.compareTo(new BigDecimal(-5)) < 0 ? new BigDecimal(-5) : result;
        }
        if (itemcodeId == 10503L) {
            ComplianceCompanyItemdata noLeaveWorkNum = fieldsItemDataMap.get("noLeaveWorkNum");
            BigDecimal result = this.getLoseScore(noLeaveWorkNum, 0.2);
            return result.compareTo(new BigDecimal(-2)) < 0 ? new BigDecimal(-2) : result;
        }
        if (itemcodeId == 10504L) {
            ComplianceCompanyItemdata noLeaveWorkNum = fieldsItemDataMap.get("ysZybNum");
            return this.getLoseScore(noLeaveWorkNum, 1.0);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getLoseScore(ComplianceCompanyItemdata noBeforeWorkNum, double x) {
        if (Objects.nonNull(noBeforeWorkNum) && StringUtils.isNotEmpty((String)noBeforeWorkNum.getResultData())) {
            int i = Integer.parseInt(noBeforeWorkNum.getResultData());
            return BigDecimal.valueOf(-x).multiply(new BigDecimal(i));
        }
        return BigDecimal.ZERO;
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        int noWorkStatusNum;
        String noWorkStatusNumStr;
        Pair result = new Pair((Object)false, (Object)"");
        if (itemcodeId == 10505L && StringUtils.isNumber((String)(noWorkStatusNumStr = Optional.ofNullable(fieldsItemDataMap.get("noWorkStatusNum")).map(ComplianceCompanyItemdata::getResultData).orElse("0"))) && (noWorkStatusNum = Integer.parseInt(noWorkStatusNumStr)) > 0) {
            result = new Pair((Object)true, (Object)"noWorkStatusNum");
        }
        return result;
    }

    @Generated
    public PhysicalCheckScoreCalcHandle() {
    }
}

