/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.hutool.core.lang.Pair;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.calcscore.rule.FristStepDataValidRule;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanySubitem;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class PhysicalAbnormalScoreCalcHandle
implements ScoreCalcHandle {
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;

    @Override
    public String support() {
        return "06";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("15");
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        int year = 2024;
        List reformItemBasicList = this.reformItemBasicNewService.getPhysicalAbnormalReform(cids, Integer.valueOf(year));
        List ljYszybList = this.phcPhysicalStaffCheckInfoService.countYszybNum(cids, Integer.valueOf(year));
        Map<Long, List<PhcPhysicalCheckV3221>> ljYszybMap = ljYszybList.stream().collect(Collectors.groupingBy(PhcPhysicalCheckV3221::getCid));
        Map<Long, List<ReformItemBasic>> reformMap = reformItemBasicList.stream().collect(Collectors.groupingBy(ReformItemBasic::getCid));
        List<Byte> wcList = Arrays.asList(ReformStatusEnum.WC.getValue(), ReformStatusEnum.WXZG.getValue());
        for (Long cid : cids) {
            List<Object> list = reformMap.get(cid);
            if (CollectionUtils.isEmpty(list)) {
                list = Collections.emptyList();
            }
            List zyjjzList = list.stream().filter(r -> ReformGenerationSourceEnum.JJZ.getValue().equals(r.getGenerationSource())).collect(Collectors.toList());
            String totalNum = String.valueOf(zyjjzList.size());
            String dispositionNum = String.valueOf(zyjjzList.stream().filter(r -> wcList.contains(r.getStatus())).count());
            String notDispositionNum = String.valueOf(zyjjzList.stream().filter(r -> !wcList.contains(r.getStatus())).count());
            ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            itemdata.setItemcodeId(Long.valueOf(10601L));
            itemdata.setFieldName("zyjjzTotalNum");
            itemdata.setResultData(totalNum);
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            itemdata.setItemcodeId(Long.valueOf(10601L));
            itemdata.setFieldName("zyjjzDispositionNum");
            itemdata.setResultData(dispositionNum);
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            itemdata.setItemcodeId(Long.valueOf(10601L));
            itemdata.setFieldName("zyjjzNotDispositionNum");
            itemdata.setResultData(notDispositionNum);
            result.add(itemdata);
            List yszybList = list.stream().filter(r -> ReformGenerationSourceEnum.YSZYB.getValue().equals(r.getGenerationSource())).collect(Collectors.toList());
            totalNum = String.valueOf(yszybList.size());
            dispositionNum = String.valueOf(yszybList.stream().filter(r -> wcList.contains(r.getStatus())).count());
            notDispositionNum = String.valueOf(yszybList.stream().filter(r -> !wcList.contains(r.getStatus())).count());
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            itemdata.setItemcodeId(Long.valueOf(10602L));
            itemdata.setFieldName("yszybTotalNum");
            itemdata.setResultData(totalNum);
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            itemdata.setItemcodeId(Long.valueOf(10602L));
            itemdata.setFieldName("yszybDispositionNum");
            itemdata.setResultData(dispositionNum);
            result.add(itemdata);
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            itemdata.setItemcodeId(Long.valueOf(10602L));
            itemdata.setFieldName("yszybNotDispositionNum");
            itemdata.setResultData(notDispositionNum);
            result.add(itemdata);
            List<PhcPhysicalCheckV3221> phcPhysicalCheckV3221s = ljYszybMap.get(cid);
            String ljYszybTotalNum = CollectionUtils.isEmpty(phcPhysicalCheckV3221s) ? "0" : String.valueOf(phcPhysicalCheckV3221s.get(0).getNumberOfYszyb());
            itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            itemdata.setItemcodeId(Long.valueOf(10604L));
            itemdata.setFieldName("ljYszybTotalNum");
            itemdata.setResultData(ljYszybTotalNum);
            result.add(itemdata);
        }
        return result;
    }

    @Override
    public List<FristStepDataValidRule> fristStepDataValueRule(String importantTypeStr) {
        ArrayList<FristStepDataValidRule> rules = new ArrayList<FristStepDataValidRule>();
        rules.add(new FristStepDataValidRule(10603L, "fcTotalNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10603L, "fcDispositionNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10603L, "fcNotDispositionNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10604L, "ljYszybTotalNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10604L, "ljYszybDispositionNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10604L, "ljYszybNotDispositionNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10605L, "ljZybTotalNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10605L, "ljZybDispositionNum", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(10605L, "ljZybNotDispositionNum", 1, "\u672a\u586b\u5199"));
        return rules;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        BigDecimal score = BigDecimal.ZERO;
        Set<String> keySet = fieldsItemDataMap.keySet();
        ComplianceCompanyItemdata itemdata = null;
        Optional<String> notDispositionNumOptional = keySet.stream().filter(key -> key.contains("NotDispositionNum")).findFirst();
        if (notDispositionNumOptional.isPresent()) {
            String notDispositionNumKey = notDispositionNumOptional.get();
            itemdata = fieldsItemDataMap.get(notDispositionNumKey);
        }
        double basicScore = -3.0;
        if (itemcodeId == 10603L) {
            basicScore = -0.5;
        } else if (itemcodeId == 10604L || itemcodeId == 10605L) {
            basicScore = -1.0;
        }
        if (itemdata != null) {
            score = score.add(new BigDecimal(basicScore * Double.parseDouble(itemdata.getResultData())));
        }
        return score;
    }

    public BigDecimal calcSubItemScore(List<ComplianceCompanySubitem> subItemList) {
        BigDecimal totalScore = new BigDecimal("10");
        if (CollectionUtils.isNotEmpty(subItemList)) {
            for (ComplianceCompanySubitem subitem : subItemList) {
                totalScore = totalScore.add(subitem.getLoseScore());
            }
        }
        if (totalScore.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return totalScore;
    }

    public boolean isComplete(List<ComplianceCompanySubitem> subItemList) {
        return false;
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        Pair result = new Pair((Object)false, null);
        if (itemcodeId == 10604L) {
            int ljYszybNotDispositionNum;
            int ljYszybDispositionNum;
            int ljYszybTotalNum;
            ComplianceCompanyItemdata ljYszybTotal = fieldsItemDataMap.get("ljYszybTotalNum");
            ComplianceCompanyItemdata ljYszybDisposition = fieldsItemDataMap.get("ljYszybDispositionNum");
            ComplianceCompanyItemdata ljYszybNotDisposition = fieldsItemDataMap.get("ljYszybNotDispositionNum");
            if (ljYszybTotal != null && ljYszybDisposition != null && ljYszybNotDisposition != null && (ljYszybTotalNum = Integer.parseInt(ljYszybTotal.getResultData())) != (ljYszybDispositionNum = Integer.parseInt(ljYszybDisposition.getResultData())) + (ljYszybNotDispositionNum = Integer.parseInt(ljYszybNotDisposition.getResultData()))) {
                result = new Pair((Object)true, (Object)"ljYszybNumClash");
            }
        }
        return result;
    }

    @Generated
    public PhysicalAbnormalScoreCalcHandle() {
    }
}

