/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.compliance.calcscore.CalcLog;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectSimpleStateEnum;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFilePersonalService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.util.LiteArchiveUtils;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import cn.smarthse.modules.health.vo.litearchive.TsLiteArchiveVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LiteArchiveScoreCalcHandle
implements ScoreCalcHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveScoreCalcHandle.class);
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @DubboReference
    private ILiteArchiveFilePersonalService personalService;
    @Autowired
    private RedisClient redisClient;
    @Resource(name="complianceReloadDataThreadPoolExecutor")
    private ThreadPoolExecutor complianceReloadDataThreadPoolExecutor;

    @Override
    public String support() {
        return "14";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("3");
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        String archiveYears = MapUtil.getStr(params, (Object)"archiveYears");
        String archiveTypeStrs = MapUtil.getStr(params, (Object)(ComplianceCodeEnum.CODE14.getCode() + ":archiveTypeStr"));
        if (StringUtils.isBlank((CharSequence)archiveTypeStrs)) {
            archiveTypeStrs = "1,2,3,4,5,6";
        }
        List archiveYearList = LiteArchiveUtils.getHgArchiveYear();
        if (StringUtils.isNotBlank((CharSequence)archiveYears)) {
            archiveYearList = CommonUtil.str2IntegerList((String)archiveYears, (String)",");
        }
        CopyOnWriteArrayList<ComplianceCompanyItemdata> result = new CopyOnWriteArrayList<ComplianceCompanyItemdata>();
        List archiveTypeList = CommonUtil.str2IntegerList((String)archiveTypeStrs, (String)",");
        CountDownLatch cd = new CountDownLatch(4);
        long jobId = XxlJobHelper.getJobId();
        this.complianceReloadDataThreadPoolExecutor.execute(() -> {
            try {
                CalcLog timeLog = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":litearchive1");
                List<ComplianceCompanyItemdata> archive1Data = this.loadLiteArchive1Data(cids, archiveTypeList);
                timeLog.stop();
                if (CollUtil.isNotEmpty(archive1Data)) {
                    result.addAll(archive1Data);
                }
            }
            finally {
                cd.countDown();
            }
        });
        List finalArchiveYearList = archiveYearList;
        this.complianceReloadDataThreadPoolExecutor.execute(() -> {
            try {
                CalcLog timeLog = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":litearchive2");
                List<ComplianceCompanyItemdata> archive234Data = this.loadLiteArchive234Data(cids, archiveTypeList, finalArchiveYearList);
                timeLog.stop();
                if (CollUtil.isNotEmpty(archive234Data)) {
                    result.addAll(archive234Data);
                }
            }
            finally {
                cd.countDown();
            }
        });
        this.complianceReloadDataThreadPoolExecutor.execute(() -> {
            try {
                CalcLog timeLog = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":litearchive5");
                List<ComplianceCompanyItemdata> archive5Data = this.loadLiteArchive5Data(cids, archiveTypeList);
                timeLog.stop();
                if (CollUtil.isNotEmpty(archive5Data)) {
                    result.addAll(archive5Data);
                }
            }
            finally {
                cd.countDown();
            }
        });
        this.complianceReloadDataThreadPoolExecutor.execute(() -> {
            try {
                CalcLog timeLog = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":litearchive6");
                List<ComplianceCompanyItemdata> archive6Data = this.loadLiteArchive6Data(cids, archiveTypeList);
                timeLog.stop();
                if (CollUtil.isNotEmpty(archive6Data)) {
                    result.addAll(archive6Data);
                }
            }
            finally {
                cd.countDown();
            }
        });
        cd.await();
        return result;
    }

    private List<ComplianceCompanyItemdata> loadLiteArchive6Data(List<Long> cids, List<Integer> archiveTypeList) {
        archiveTypeList = (List)CollUtil.removeAny((Collection)CollUtil.newArrayList(archiveTypeList), (Object[])new Integer[]{1, 2, 3, 4, 5});
        if (CollUtil.isEmpty(cids) || CollUtil.isEmpty((Collection)archiveTypeList)) {
            return Collections.emptyList();
        }
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("isThirdParty", false);
        Map workNumMap = this.personalService.getCompletedNumByCidPersonal(cids, param);
        Set hasArchiveCidList = this.personalService.getHasArchiveCidList(cids);
        for (Long cid : cids) {
            String localWorkNum = workNumMap.get(cid) == null ? "0" : ((StaffInfo)workNumMap.get(cid)).getLocalWorkNum().toString();
            String outWorkNum = workNumMap.get(cid) == null ? "0" : ((StaffInfo)workNumMap.get(cid)).getOutWorkNum().toString();
            int totalWorkNum = workNumMap.get(cid) == null ? 0 : ((StaffInfo)workNumMap.get(cid)).getTotalWorkNum();
            result.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("totalWorkNum").setItemcodeId(Long.valueOf(11406L)).setResultData(String.valueOf(totalWorkNum)));
            result.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("localWorkNum").setItemcodeId(Long.valueOf(11406L)).setResultData(localWorkNum));
            result.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("outWorkNum").setItemcodeId(Long.valueOf(11406L)).setResultData(outWorkNum));
            int completedNum = workNumMap.get(cid) == null ? 0 : ((StaffInfo)workNumMap.get(cid)).getCompletedNum();
            int unCompletedNum = totalWorkNum - completedNum;
            result.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("completedNum").setItemcodeId(Long.valueOf(11406L)).setResultData(String.valueOf(completedNum)));
            result.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("unCompletedNum").setItemcodeId(Long.valueOf(11406L)).setResultData(String.valueOf(unCompletedNum)));
            String hasArchive = CollectionUtils.isNotEmpty((Collection)hasArchiveCidList) && hasArchiveCidList.contains(cid) ? "true" : "false";
            result.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName("hasArchive").setItemcodeId(Long.valueOf(11406L)).setResultData(hasArchive));
        }
        return result;
    }

    private List<ComplianceCompanyItemdata> loadLiteArchive5Data(List<Long> cids, List<Integer> archiveTypeList) {
        archiveTypeList = (List)CollUtil.removeAny((Collection)CollUtil.newArrayList(archiveTypeList), (Object[])new Integer[]{1, 2, 3, 4, 6});
        if (CollUtil.isEmpty(cids) || CollUtil.isEmpty((Collection)archiveTypeList)) {
            return Collections.emptyList();
        }
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        List archiveList = this.liteArchiveService.queryComplianceArchive5Data(cids);
        List checkList = this.phcPhysicalCheckV3221Service.queryCompliancePhysical5Data(cids, Integer.valueOf(DateUtil.getYear() - 2));
        Map<Long, List<LiteArchiveFileItem>> archiveMap = archiveList.stream().collect(Collectors.groupingBy(LiteArchiveFileItem::getCid));
        Map<Long, List<PhcPhysicalStatisticsModel>> checkMap = checkList.stream().collect(Collectors.groupingBy(PhcPhysicalStatisticsModel::getCid));
        for (Long cid : cids) {
            int totalCount = 3;
            int finishCount = 0;
            boolean yszyb = false;
            List<LiteArchiveFileItem> fileItems = archiveMap.get(cid);
            List<PhcPhysicalStatisticsModel> checkModels = checkMap.get(cid);
            if (CollectionUtils.isNotEmpty(checkModels)) {
                finishCount += 2;
                PhcPhysicalStatisticsModel checkModel = checkModels.get(0);
                if (checkModel.getNumberOfYszyb() > 0) {
                    ++finishCount;
                    totalCount += 2;
                    yszyb = true;
                }
            }
            if (CollectionUtils.isNotEmpty(fileItems)) {
                for (LiteArchiveFileItem fileItem : fileItems) {
                    if (fileItem.getFileNameId().equals(503L) && StringUtils.isNotEmpty((String)fileItem.getFileIds())) {
                        ++finishCount;
                    }
                    if (!fileItem.getFileNameId().equals(506L) || !StringUtils.isNotEmpty((String)fileItem.getFileIds()) || !yszyb) continue;
                    ++finishCount;
                }
            }
            JSONObject json = new JSONObject();
            json.put("totalCount", (Object)totalCount);
            json.put("finishCount", (Object)finishCount);
            ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
            itemdata.setItemcodeId(Long.valueOf(11405L));
            itemdata.setFormat(Integer.valueOf(2));
            itemdata.setFieldName("archive5");
            itemdata.setResultData(json.toJSONString());
            itemdata.setCid(cid);
            result.add(itemdata);
        }
        return result;
    }

    public List<ComplianceCompanyItemdata> loadLiteArchive1Data(List<Long> cidList, List<Integer> archiveTypeList) {
        archiveTypeList = (List)CollUtil.removeAny((Collection)CollUtil.newArrayList(archiveTypeList), (Object[])new Integer[]{2, 3, 4, 5, 6});
        if (CollUtil.isEmpty(cidList) || CollUtil.isEmpty((Collection)archiveTypeList)) {
            return Collections.emptyList();
        }
        Long itemcodeId = 11401L;
        String filedName = "archive1";
        List archiveList = this.liteArchiveService.queryComplianceTsLiteArchiveList(cidList);
        List archiveIdList = archiveList.stream().map(LiteArchive::getId).collect(Collectors.toList());
        List detailList = this.liteArchiveService.queryComplianceArchiveDetailList(archiveIdList);
        archiveList = archiveList.stream().filter(a -> {
            boolean finish = a.getMissingItem() == null && a.getProjectFinishTime() != null;
            Date projectTime = a.getProjectTime();
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -5);
            Date pre = calendar.getTime();
            boolean within = projectTime.after(pre) || projectTime.equals(pre);
            return finish && within;
        }).collect(Collectors.toList());
        int index = 0;
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        for (TsLiteArchiveVo archive : archiveList) {
            ComplianceCompanyItemdata data = new ComplianceCompanyItemdata().setCid(archive.getCid()).setItemcodeId(itemcodeId).setFieldName("archive1_" + archive.getId());
            this.processCompleteFinishTsArchiveData(archive, detailList, data);
            data.setFormat(Integer.valueOf(2));
            result.add(data);
            ++index;
        }
        return result;
    }

    private void processCompleteFinishTsArchiveData(TsLiteArchiveVo archive, List<LiteArchiveFileDetailVo> detailList, ComplianceCompanyItemdata data) {
        Long archiveId = archive.getId();
        Map<Long, List<LiteArchiveFileDetailVo>> detailMap = detailList.stream().collect(Collectors.groupingBy(LiteArchiveFileDetailVo::getLiteArchiveId));
        List<LiteArchiveFileDetailVo> dList = detailMap.get(archiveId);
        List<Long> requireList = this.getCompleteFinishRequireList(archive);
        Map requireMap = requireList.stream().collect(Collectors.toMap(Function.identity(), i -> Boolean.FALSE));
        if (CollUtil.isNotEmpty(dList)) {
            dList.stream().filter(d -> requireList.contains(d.getFileNameId()) && CharSequenceUtil.isNotBlank((CharSequence)d.getFileIds())).forEach(d -> requireMap.put(d.getFileNameId(), Boolean.TRUE));
        }
        int totalCount = requireList.size();
        long finishCount = requireMap.values().stream().filter(Boolean::booleanValue).count();
        JSONObject json = new JSONObject();
        json.put("title", (Object)archive.getTitle());
        json.put("archiveId", (Object)archiveId);
        json.put("totalCount", (Object)totalCount);
        json.put("finishCount", (Object)finishCount);
        json.put("completeFinish", (Object)1);
        data.setResultData(json.toJSONString());
    }

    private List<Long> getCompleteFinishRequireList(TsLiteArchiveVo archive) {
        ArrayList<Long> requireList = new ArrayList<Long>();
        if (TsProjectSimpleStateEnum.FINISH.getCode().equals(archive.getEvalState())) {
            requireList.addAll(CollUtil.toList((Object[])new Long[]{104L, 103L, 105L}));
        }
        if (TsProjectSimpleStateEnum.FINISH.getCode().equals(archive.getDesignState())) {
            requireList.addAll(CollUtil.toList((Object[])new Long[]{106L, 107L}));
        }
        if (TsProjectSimpleStateEnum.FINISH.getCode().equals(archive.getControlState())) {
            requireList.addAll(CollUtil.toList((Object[])new Long[]{109L, 108L, 110L, 111L, 1120L}));
        }
        requireList.addAll(CollUtil.toList((Object[])new Long[]{102L, 101L}));
        return requireList;
    }

    private String generaMapKey(ComplianceCompanyItemdata d) {
        return StringUtils.concatStr((String)",", (String[])new String[]{String.valueOf(d.getCid()), String.valueOf(d.getItemcodeId()), d.getFieldName()});
    }

    public List<ComplianceCompanyItemdata> loadLiteArchive234Data(List<Long> cids, List<Integer> archiveTypeList, List<Integer> archiveYear) {
        archiveTypeList = (List)CollUtil.removeAny((Collection)CollUtil.newArrayList(archiveTypeList), (Object[])new Integer[]{1, 5, 6});
        if (CollectionUtils.isEmpty(cids) || CollectionUtils.isEmpty((Collection)archiveTypeList)) {
            return null;
        }
        List yearArr = archiveYear.stream().map(String::valueOf).collect(Collectors.toList());
        ArrayList<ComplianceCompanyItemdata> initDataList = new ArrayList<ComplianceCompanyItemdata>();
        for (Long cid2 : cids) {
            for (Integer archiveType : archiveTypeList) {
                ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
                if (Objects.equals(archiveType, 2)) {
                    itemdata.setItemcodeId(Long.valueOf(11402L));
                } else if (Objects.equals(archiveType, 3)) {
                    itemdata.setItemcodeId(Long.valueOf(11403L));
                } else if (Objects.equals(archiveType, 4)) {
                    itemdata.setItemcodeId(Long.valueOf(11404L));
                }
                JSONArray jsonArray = new JSONArray();
                JSONObject json = new JSONObject();
                for (String title : yearArr) {
                    json.put("year", (Object)(title + "\u5e74"));
                    json.put("archiveId", (Object)"");
                    json.put("finishCount", (Object)0);
                    json.put("nodata", (Object)true);
                    json.put("finishstatus", (Object)false);
                    if (Objects.equals(archiveType, 2)) {
                        json.put("totalCount", (Object)11);
                    } else if (Objects.equals(archiveType, 3)) {
                        json.put("totalCount", (Object)4);
                    } else if (Objects.equals(archiveType, 4)) {
                        json.put("totalCount", (Object)6);
                    }
                    jsonArray.add((Object)json);
                }
                itemdata.setCid(cid2);
                itemdata.setDataType(Integer.valueOf(2));
                itemdata.setFieldName("archive" + archiveType);
                itemdata.setResultData(jsonArray.toJSONString());
                initDataList.add(itemdata);
            }
        }
        List liteArchives = this.liteArchiveService.listArchiveComplianceScoreVo(cids, new ArrayList(archiveTypeList), yearArr);
        if (CollectionUtils.isEmpty((Collection)liteArchives)) {
            return initDataList;
        }
        Map<String, ComplianceCompanyItemdata> initDataMap = initDataList.stream().collect(Collectors.toMap(k -> this.generaMapKey((ComplianceCompanyItemdata)k), v -> v, (v1, v2) -> v1));
        Map<Long, List<LiteArchiveFileDetailVo>> cidListArchiveMap = liteArchives.stream().collect(Collectors.groupingBy(LiteArchiveFileDetailVo::getCid));
        ArrayList result = new ArrayList();
        cidListArchiveMap.forEach((cid, cidLiteArchiveList) -> {
            if (CollectionUtils.isNotEmpty((Collection)cidLiteArchiveList)) {
                Map<Integer, List<LiteArchiveFileDetailVo>> archiveTypeMap = cidLiteArchiveList.stream().collect(Collectors.groupingBy(LiteArchiveFileDetailVo::getArchiveType));
                archiveTypeMap.forEach((archiveType, typeArchiveList) -> {
                    if (CollectionUtils.isNotEmpty((Collection)typeArchiveList)) {
                        ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
                        itemdata.setCid(cid);
                        if (Objects.equals(archiveType, 2)) {
                            itemdata.setItemcodeId(Long.valueOf(11402L));
                        } else if (Objects.equals(archiveType, 3)) {
                            itemdata.setItemcodeId(Long.valueOf(11403L));
                        } else if (Objects.equals(archiveType, 4)) {
                            itemdata.setItemcodeId(Long.valueOf(11404L));
                        }
                        JSONArray jsonArray = new JSONArray();
                        Map archiveTitleMap = typeArchiveList.stream().sorted(Comparator.comparing(LiteArchiveFileDetailVo::getTitle, Comparator.naturalOrder())).collect(Collectors.groupingBy(LiteArchiveFileDetailVo::getTitle, LinkedHashMap::new, Collectors.toList()));
                        archiveTitleMap.forEach((title, archiveTitleList) -> {
                            Long liteArchiveId = ((LiteArchiveFileDetailVo)archiveTitleList.get(0)).getLiteArchiveId();
                            long totalCount = LiteArchiveUtils.getHgRequiredListVo((List)archiveTitleList, null).size();
                            long finishCount = LiteArchiveUtils.getHgRequiredListVo((List)archiveTitleList, (Boolean)true).size();
                            JSONObject json = new JSONObject();
                            json.put("year", (Object)(title + "\u5e74"));
                            json.put("archiveId", Convert.convert(String.class, (Object)liteArchiveId));
                            json.put("totalCount", (Object)totalCount);
                            json.put("finishCount", (Object)finishCount);
                            json.put("finishstatus", (Object)(finishCount >= totalCount ? 1 : 0));
                            jsonArray.add((Object)json);
                        });
                        itemdata.setFieldName("archive" + archiveType);
                        itemdata.setResultData(jsonArray.toJSONString());
                        itemdata.setFormat(Integer.valueOf(2));
                        result.add(itemdata);
                    }
                });
            }
        });
        if (CollectionUtils.isNotEmpty(result)) {
            for (ComplianceCompanyItemdata itemdata : result) {
                String mapKey = this.generaMapKey(itemdata);
                if (!initDataMap.containsKey(mapKey)) continue;
                initDataMap.put(mapKey, itemdata);
            }
        }
        List<ComplianceCompanyItemdata> finalResultList = initDataMap.values().stream().collect(Collectors.toList());
        return finalResultList;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        BigDecimal score = BigDecimal.ZERO;
        if (MapUtil.isEmpty(fieldsItemDataMap)) {
            return this.itemTotalScore().negate();
        }
        if (Objects.equals(itemcodeId, 11401L)) {
            score = this.calculateScoreForArchive1(fieldsItemDataMap, score);
        }
        if (Objects.equals(itemcodeId, 11402L) || Objects.equals(itemcodeId, 11403L) || Objects.equals(itemcodeId, 11404L) || Objects.equals(itemcodeId, 11405L)) {
            for (ComplianceCompanyItemdata itemdata : fieldsItemDataMap.values()) {
                String resultData = itemdata.getResultData();
                try {
                    if (!JSONValidator.from((String)resultData).validate()) continue;
                    List<JSONObject> jsonArray = new ArrayList();
                    if (JSON.isValidArray((String)resultData)) {
                        jsonArray = JSON.parseArray((String)resultData, JSONObject.class);
                    } else if (JSON.isValidObject((String)resultData)) {
                        JSONObject jsonObject = JSON.parseObject((String)resultData);
                        jsonArray.add(jsonObject);
                    }
                    if (!CollectionUtils.isNotEmpty(jsonArray)) continue;
                    for (JSONObject jsonObject : jsonArray) {
                        Boolean nodata = jsonObject.getBoolean("nodata");
                        if (Objects.equals(nodata, true)) {
                            return this.itemTotalScore().negate();
                        }
                        long totalCount = jsonObject.getLongValue("totalCount");
                        long finishCount = jsonObject.getLongValue("finishCount");
                        BigDecimal totalCountb = new BigDecimal(String.valueOf(totalCount));
                        BigDecimal finishCountb = new BigDecimal(String.valueOf(finishCount));
                        score = score.subtract(totalCountb.subtract(finishCountb).multiply(new BigDecimal("0.1")));
                    }
                }
                catch (Exception e) {
                    log.error("\u89e3\u6790json\u51fa\u9519", (Throwable)e);
                }
            }
        }
        if (Objects.equals(itemcodeId, 11406L)) {
            if (fieldsItemDataMap.get("hasArchive") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("hasArchive").getResultData()) && "false".equals(fieldsItemDataMap.get("hasArchive").getResultData())) {
                return this.itemTotalScore().negate();
            }
            if (fieldsItemDataMap.get("unCompletedNum") != null && StringUtils.isNotBlank((CharSequence)fieldsItemDataMap.get("unCompletedNum").getResultData())) {
                String unCompletedNum = Optional.ofNullable(fieldsItemDataMap.get("unCompletedNum").getResultData()).orElse("0");
                score = new BigDecimal(unCompletedNum).multiply(new BigDecimal("-0.1"));
            }
        }
        return score;
    }

    private BigDecimal calculateScoreForArchive1(Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, BigDecimal score) {
        for (ComplianceCompanyItemdata itemdata : fieldsItemDataMap.values()) {
            String resultData = itemdata.getResultData();
            try {
                JSONObject jsonObject;
                Optional<Integer> completeFinish;
                if (!JSONValidator.from((String)resultData).validate() || !(completeFinish = Optional.ofNullable((jsonObject = JSON.parseObject((String)resultData)).getInteger("completeFinish"))).isPresent() || completeFinish.get() != 1) continue;
                BigDecimal totalCount = Convert.toBigDecimal((Object)jsonObject.getString("totalCount"));
                BigDecimal finishCount = Convert.toBigDecimal((Object)jsonObject.getString("finishCount"));
                score = score.subtract(totalCount.subtract(finishCount).multiply(Convert.toBigDecimal((Object)"0.1")));
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u4e09\u540c\u65f6\u6863\u6848json\u51fa\u9519", (Throwable)e);
            }
        }
        return score;
    }
}

