/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.calcscore.rule.FristStepDataValidRule;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class LaborDispatchingScoreCalcHandle
implements ScoreCalcHandle {
    @DubboReference
    private IStaffInfoService staffInfoService;

    @Override
    public String support() {
        return "12";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("5");
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        List workNums = this.staffInfoService.getStaffInfoWorkNum(cids, params);
        Map<Long, StaffInfo> staffMap = workNums.stream().collect(Collectors.toMap(StaffInfo::getCid, v -> v));
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        for (Long cid : cids) {
            StaffInfo workNum = staffMap.get(cid);
            String resultNum = "0";
            if (workNum != null && workNum.getOutWorkNum() != null) {
                resultNum = Convert.toStr((Object)workNum.getOutWorkNum());
            }
            ComplianceCompanyItemdata data122 = new ComplianceCompanyItemdata();
            data122.setCid(cid);
            data122.setItemcodeId(Long.valueOf(11202L));
            data122.setFieldName("laborDispatchCount");
            data122.setResultData(resultNum);
            result.add(data122);
            ComplianceCompanyItemdata data121 = new ComplianceCompanyItemdata();
            data121.setCid(cid);
            data121.setItemcodeId(Long.valueOf(11201L));
            data121.setFieldName("laborDispatchCount");
            data121.setResultData(resultNum);
            result.add(data121);
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        String itemCodeStr = String.valueOf(itemcodeId);
        if (StringUtils.isBlank((CharSequence)itemCodeStr)) {
            return BigDecimal.ZERO;
        }
        switch (itemCodeStr) {
            case "11201": {
                ComplianceCompanyItemdata laborDispatchCount;
                ComplianceCompanyItemdata hasOccupationalTransfer = fieldsItemDataMap.get("hasOccupationalTransfer");
                if (hasOccupationalTransfer != null && "1".equals(hasOccupationalTransfer.getResultData())) {
                    return new BigDecimal("-5");
                }
                if (hasOccupationalTransfer != null && "2".equals(hasOccupationalTransfer.getResultData()) && (laborDispatchCount = fieldsItemDataMap.get("laborDispatchCount")) != null && "laborDispatchCount".equals(laborDispatchCount.getFieldName()) && !"0".equals(laborDispatchCount.getResultData())) {
                    return new BigDecimal("-5");
                }
                return BigDecimal.ZERO;
            }
            case "11202": {
                ComplianceCompanyItemdata implementation = fieldsItemDataMap.get("implementation");
                if (implementation != null && "0".equals(implementation.getResultData())) {
                    ComplianceCompanyItemdata laborDispatchCount = fieldsItemDataMap.get("laborDispatchCount");
                    String resultData = Optional.ofNullable(laborDispatchCount).map(ComplianceCompanyItemdata::getResultData).orElse("0");
                    return Convert.toBigDecimal((Object)resultData).multiply(new BigDecimal("-1"));
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public List<FristStepDataValidRule> fristStepDataValueRule(String importantTypeStr) {
        ArrayList<FristStepDataValidRule> rules = new ArrayList<FristStepDataValidRule>();
        rules.add(new FristStepDataValidRule(11201L, "hasOccupationalTransfer", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(11202L, "isExistOutWork", 1, "\u672a\u586b\u5199"));
        rules.add(new FristStepDataValidRule(11202L, "implementation", 1, "\u672a\u586b\u5199"));
        return rules;
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        ComplianceCompanyItemdata implementation;
        ComplianceCompanyItemdata laborDispatchCount;
        ComplianceCompanyItemdata hasOccupationalTransfer;
        boolean bool = false;
        StringBuilder sb = new StringBuilder();
        boolean hasContent = false;
        if (11201L == itemcodeId && Objects.nonNull(hasOccupationalTransfer = fieldsItemDataMap.get("hasOccupationalTransfer"))) {
            laborDispatchCount = fieldsItemDataMap.get("laborDispatchCount");
            if (hasOccupationalTransfer != null && "2".equals(hasOccupationalTransfer.getResultData())) {
                if (laborDispatchCount != null && "laborDispatchCount".equals(laborDispatchCount.getFieldName()) && !"0".equals(laborDispatchCount.getResultData())) {
                    bool = true;
                    this.appendWithComma(sb, "case1", hasContent);
                    hasContent = true;
                }
            } else if (hasOccupationalTransfer != null && "1".equals(hasOccupationalTransfer.getResultData()) && laborDispatchCount != null && "laborDispatchCount".equals(laborDispatchCount.getFieldName()) && "0".equals(laborDispatchCount.getResultData())) {
                bool = true;
                this.appendWithComma(sb, "case2", hasContent);
                hasContent = true;
            }
        }
        if (11202L == itemcodeId && Objects.nonNull(implementation = fieldsItemDataMap.get("implementation"))) {
            laborDispatchCount = fieldsItemDataMap.get("laborDispatchCount");
            if (implementation != null && "2".equals(implementation.getResultData())) {
                if (laborDispatchCount != null && "laborDispatchCount".equals(laborDispatchCount.getFieldName()) && !"0".equals(laborDispatchCount.getResultData())) {
                    bool = true;
                    this.appendWithComma(sb, "case3", hasContent);
                    hasContent = true;
                }
            } else if (laborDispatchCount != null && "laborDispatchCount".equals(laborDispatchCount.getFieldName()) && "0".equals(laborDispatchCount.getResultData())) {
                bool = true;
                this.appendWithComma(sb, "case4", hasContent);
                hasContent = true;
            }
        }
        return new Pair((Object)bool, (Object)sb.toString());
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (itemcodeId == null) {
            return resultData;
        }
        if ((filedName.equalsIgnoreCase("hasOccupationalTransfer") || filedName.equalsIgnoreCase("implementation")) && StringUtils.isNotBlank((CharSequence)resultData)) {
            switch (Byte.parseByte(resultData)) {
                case 0: {
                    return "\u5426";
                }
                case 1: {
                    return "\u662f";
                }
                case 2: {
                    return "\u5408\u7406\u7f3a\u9879";
                }
            }
        }
        return resultData;
    }

    private void appendWithComma(StringBuilder sb, String text, boolean hasContent) {
        if (!sb.toString().contains(text)) {
            if (hasContent) {
                sb.append(",");
            }
            sb.append(text);
        }
    }

    @Generated
    public LaborDispatchingScoreCalcHandle() {
    }
}

