/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.calcscore.rule.FristStepDataValidRule;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.service.IComplianceStaffInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceWorkerTrainRecordsService;
import cn.smarthse.modules.health.compliance.vo.ComplianceStaffInfoVo;
import cn.smarthse.modules.health.compliance.vo.ComplianceWorkerTrainRecordsVo;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class HealthTrainScoreCalcHandle
implements ScoreCalcHandle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthTrainScoreCalcHandle.class);
    private final IComplianceWorkerTrainRecordsService workerTrainRecordsService;
    private final ICompanyFunctionalOrganizationMemberService functionalOrganizationMemberService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IStaffWorkRoleService staffWorkRoleService;
    private final IComplianceStaffInfoService complianceStaffInfoService;
    private static final int ID1 = 10901;
    private static final int ID2 = 10902;
    private static final int ID3 = 10903;
    private static final Long ID1L = 10901L;
    private static final Long ID2L = 10902L;
    private static final Long ID3L = 10903L;
    private static final String IS_EXPIRE_COUNT_12 = "isExpireCount12";
    private static final String NO_EXPIRE_COUNT_12 = "noExpireCount12";
    private static final String IS_EXPIRE_COUNT_13 = "isExpireCount13";
    private static final String NO_EXPIRE_COUNT_13 = "noExpireCount13";
    private static final String TOUCH_HARM_PEOPLE_NUMBER = "touchHarmPeopleNumber";
    private static final String PRE_JOB_TRAIN_0 = "preJobTrain0";
    private static final String PRE_JOB_TRAIN_1 = "preJobTrain1";
    private static final String ON_JOB_TRAIN_0 = "onJobTrain0";
    private static final String ON_JOB_TRAIN_1 = "onJobTrain1";

    private Map<String, Object> initPageData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IS_EXPIRE_COUNT_12, 0L);
        data.put(NO_EXPIRE_COUNT_12, 0L);
        data.put(IS_EXPIRE_COUNT_13, 0L);
        data.put(NO_EXPIRE_COUNT_13, 0L);
        data.put(TOUCH_HARM_PEOPLE_NUMBER, 0L);
        data.put(PRE_JOB_TRAIN_0, 0L);
        data.put(PRE_JOB_TRAIN_1, 0L);
        data.put(ON_JOB_TRAIN_0, 0L);
        data.put(ON_JOB_TRAIN_1, 0L);
        return data;
    }

    @Override
    public String support() {
        return "09";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("10");
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cidList, Map<String, Object> params) {
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        StopWatch sw = new StopWatch("\u52a0\u8f7d <3.7\uff1a\u804c\u4e1a\u536b\u751f\u57f9\u8bad> \u5408\u89c4\u6570\u636e");
        DebugUtils.error((String)"[{}]\uff0c\u5f00\u59cb\u6267\u884c\u3002", (Object[])new Object[]{sw.getId()});
        sw.start("==========>> 1\u3001functionalOrganizationMemberService.getComplianceMemberListByCidList <<==========");
        List memberList = this.functionalOrganizationMemberService.getComplianceMemberListByCidList(cidList, null);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 2\u3001staffInfoService.getStaffInfoWorkNum <<==========");
        List staffList = this.staffInfoService.getStaffInfoWorkNum(cidList, params);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 3\u3001staffInfoService.getStaffInfoIdList <<==========");
        List staffIdList = this.staffInfoService.getStaffInfoIdList(cidList, params);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 4\u3001java.util.stream \u6d41\u5904\u7406 <<==========");
        Map<Long, List<CompanyFunctionalOrganizationMember>> memberMap = memberList.stream().collect(Collectors.groupingBy(CompanyFunctionalOrganizationMember::getCid));
        Map staffMap = staffList.stream().collect(Collectors.toMap(StaffInfo::getCid, Function.identity(), (v1, v2) -> v1));
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 5\u3001this.queryCompletedComplianceTrainInfo <<==========");
        Map<Long, Map<Integer, List<ComplianceWorkerTrainRecordsVo>>> complianceTrainMap = this.queryCompletedComplianceTrainInfo(cidList);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 6\u3001this.queryCompletedComplianceStaffInfo <<==========");
        Map<Long, Map<Integer, List<ComplianceStaffInfoVo>>> complianceStaffMap = this.queryCompletedComplianceStaffInfo(staffIdList);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 7\u3001this.getStaffWorkRoleInfo <<==========");
        Map<Long, List<StaffWorkRole>> staffWorkRoleMap = this.getStaffWorkRoleInfo(staffIdList);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("==========>> 8\u3001\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u9875\u9762\u6570\u636e\u7edf\u8ba1 <<==========");
        for (Long cid : cidList) {
            Map<String, Object> pageData = this.initPageData();
            List<CompanyFunctionalOrganizationMember> memList = memberMap.get(cid);
            StaffInfo staff = (StaffInfo)staffMap.get(cid);
            if (CollUtil.isNotEmpty(memList)) {
                pageData.put(IS_EXPIRE_COUNT_12, memList.stream().filter(m -> HealthTrainScoreCalcHandle.orgStaffTypeMatch(m.getOrgStaffType(), "1") && !Objects.equals(m.getLeaderCert(), 1)).count());
                pageData.put(NO_EXPIRE_COUNT_12, memList.stream().filter(m -> HealthTrainScoreCalcHandle.orgStaffTypeMatch(m.getOrgStaffType(), "1") && Objects.equals(m.getLeaderCert(), 1)).count());
                pageData.put(IS_EXPIRE_COUNT_13, memList.stream().filter(m -> HealthTrainScoreCalcHandle.orgStaffTypeMatch(m.getOrgStaffType(), "2") && !Objects.equals(m.getManagerCert(), 1)).count());
                pageData.put(NO_EXPIRE_COUNT_13, memList.stream().filter(m -> HealthTrainScoreCalcHandle.orgStaffTypeMatch(m.getOrgStaffType(), "2") && Objects.equals(m.getManagerCert(), 1)).count());
            }
            if (staff != null) {
                int touchHarmNum = staff.getLocalWorkNum() + staff.getOutWorkNum();
                pageData.put(TOUCH_HARM_PEOPLE_NUMBER, touchHarmNum);
                List<StaffWorkRole> staffWorkRoleList = staffWorkRoleMap.get(cid);
                Map<Integer, List<ComplianceWorkerTrainRecordsVo>> typeTrainMap = complianceTrainMap.get(cid);
                Map<Integer, List<ComplianceStaffInfoVo>> typeStaffMap = complianceStaffMap.get(cid);
                List distinctStaffIdList = staffWorkRoleList.stream().map(StaffWorkRole::getStaffId).distinct().collect(Collectors.toList());
                if (typeTrainMap == null) {
                    typeTrainMap = new HashMap<Integer, List<ComplianceWorkerTrainRecordsVo>>();
                }
                if (typeStaffMap == null) {
                    typeStaffMap = new HashMap<Integer, List<ComplianceStaffInfoVo>>();
                }
                Set<Long> preTrain0Set = HealthTrainScoreCalcHandle.getPreJobTrain0SetNew(typeTrainMap, typeStaffMap, staffWorkRoleList);
                Set<Long> preTrain1Set = HealthTrainScoreCalcHandle.getPreJobTrain1SetNew(typeTrainMap, typeStaffMap, staffWorkRoleList);
                Set<Long> onTrain0Set = HealthTrainScoreCalcHandle.getOnJobTrain0SetNew(typeTrainMap, typeStaffMap, staffWorkRoleList);
                Set<Long> onTrain1Set = HealthTrainScoreCalcHandle.getOnJobTrain1SetNew(typeTrainMap, typeStaffMap, staffWorkRoleList);
                pageData.put(PRE_JOB_TRAIN_0, preTrain0Set.size());
                pageData.put(PRE_JOB_TRAIN_1, preTrain1Set.size());
                pageData.put(ON_JOB_TRAIN_0, onTrain0Set.size());
                pageData.put(ON_JOB_TRAIN_1, onTrain1Set.size());
            }
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID1L, IS_EXPIRE_COUNT_12, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID1L, NO_EXPIRE_COUNT_12, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID2L, IS_EXPIRE_COUNT_13, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID2L, NO_EXPIRE_COUNT_13, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID3L, TOUCH_HARM_PEOPLE_NUMBER, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID3L, PRE_JOB_TRAIN_0, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID3L, PRE_JOB_TRAIN_1, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID3L, ON_JOB_TRAIN_0, pageData, result);
            HealthTrainScoreCalcHandle.encapsulateResultFormat1(cid, ID3L, ON_JOB_TRAIN_1, pageData, result);
        }
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        DebugUtils.error((String)sw.prettyPrint(), (Object[])new Object[0]);
        DebugUtils.error((String)"[{}]\uff0c\u6267\u884c\u7ed3\u675f\uff0c\u603b\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getId(), sw.getTotalTimeMillis()});
        return result;
    }

    private static List<Long> distinctStaffIdList(List<ComplianceStaffInfoVo> staffList) {
        return staffList.stream().map(ComplianceStaffInfoVo::getStaffId).distinct().collect(Collectors.toList());
    }

    private Map<Long, Map<Integer, List<ComplianceWorkerTrainRecordsVo>>> queryCompletedComplianceTrainInfo(List<Long> cidList) {
        StopWatch sw = new StopWatch();
        sw.start("---------->> 5.1\u3001\u67e5\u8be2 <<----------");
        List trainStaffList = this.workerTrainRecordsService.getTrainStaffListBatch(cidList);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("---------->> 5.2\u3001\u5206\u7ec4 <<----------");
        int expectCount = 500000;
        float loadFactor = 0.75f;
        Map resultMap = trainStaffList.stream().collect(Collectors.groupingBy(ComplianceWorkerTrainRecordsVo::getCid, () -> new HashMap(Math.round((float)expectCount / loadFactor) + 1, loadFactor), Collectors.groupingBy(ComplianceWorkerTrainRecordsVo::getType, HashMap::new, Collectors.toList())));
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        return resultMap;
    }

    private Map<Long, Map<Integer, List<ComplianceStaffInfoVo>>> queryCompletedComplianceStaffInfo(List<StaffInfo> staffList) {
        StopWatch sw = new StopWatch();
        sw.start("---------->> 6.1\u3001\u67e5\u8be2 <<----------");
        List staffIdList = staffList.stream().map(StaffInfo::getId).collect(Collectors.toList());
        List complianceStaffList = this.complianceStaffInfoService.queryCompletedWorkerTrainInfo(staffIdList);
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        sw.start("---------->> 6.2\u3001\u5206\u7ec4 <<----------");
        int expectCount = 500000;
        float loadFactor = 0.75f;
        Map resultMap = complianceStaffList.stream().collect(Collectors.groupingBy(ComplianceStaffInfoVo::getCid, () -> new HashMap(Math.round((float)expectCount / loadFactor) + 1, loadFactor), Collectors.groupingBy(ComplianceStaffInfoVo::getTrainType, HashMap::new, Collectors.toList())));
        sw.stop();
        DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
        return resultMap;
    }

    private Map<Long, List<StaffWorkRole>> getStaffWorkRoleInfo(List<StaffInfo> staffList) {
        List staffIdList = staffList.stream().map(StaffInfo::getId).collect(Collectors.toList());
        List staffWorkRoleList = this.staffWorkRoleService.getStaffWorkRoleListBatch(staffIdList);
        return staffWorkRoleList.stream().collect(Collectors.groupingBy(StaffWorkRole::getCid));
    }

    public static Set<Long> getPreJobTrain0SetNew(Map<Integer, List<ComplianceWorkerTrainRecordsVo>> typeTrainMap, Map<Integer, List<ComplianceStaffInfoVo>> typeStaffMap, List<StaffWorkRole> staffWorkRoleList) {
        if (CollUtil.isEmpty(staffWorkRoleList)) {
            return Collections.emptySet();
        }
        List trainList = typeTrainMap.getOrDefault(1, Collections.emptyList());
        Map<Long, List<Long>> staffTrainMap = HealthTrainScoreCalcHandle.getStaffTrainMap(typeStaffMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return staffWorkRoleList.stream().filter(swr -> {
            boolean okTime;
            Long staffId = swr.getStaffId();
            Byte status = swr.getStatus();
            Date beginTime = swr.getBeginTime();
            boolean onJob = Objects.equals(status, StaffWorkStatusEnum.ONWORKING.getValue());
            boolean offJob = Objects.equals(status, StaffWorkStatusEnum.NOWORKED.getValue());
            boolean bl = okTime = beginTime == null || DateUtil.compare((Date)beginTime, (Date)HealthTrainScoreCalcHandle.firstDayOfLastYear()) >= 0;
            if (!okTime || !onJob && !offJob) {
                return Boolean.FALSE;
            }
            List trainIdList = staffTrainMap.getOrDefault(staffId, Collections.emptyList());
            List oneTrainList = trainList.stream().filter(t -> trainIdList.contains(t.getId())).collect(Collectors.toList());
            if (beginTime == null) {
                return oneTrainList.isEmpty();
            }
            Date last3MonthDate = HealthTrainScoreCalcHandle.getLast3Month(beginTime);
            Date next3MonthDate = HealthTrainScoreCalcHandle.getNext3Month(beginTime);
            return oneTrainList.stream().noneMatch(train -> HealthTrainScoreCalcHandle.dateRangesOverlap(train.getTrainBeginTime(), train.getTrainBeginTime(), last3MonthDate, next3MonthDate));
        }).map(StaffWorkRole::getStaffId).collect(Collectors.toSet());
    }

    public static Set<Long> getPreJobTrain1SetNew(Map<Integer, List<ComplianceWorkerTrainRecordsVo>> typeTrainMap, Map<Integer, List<ComplianceStaffInfoVo>> typeStaffMap, List<StaffWorkRole> staffWorkRoleList) {
        if (CollUtil.isEmpty(staffWorkRoleList)) {
            return Collections.emptySet();
        }
        List trainList = typeTrainMap.getOrDefault(1, Collections.emptyList());
        Map<Long, List<Long>> staffTrainMap = HealthTrainScoreCalcHandle.getStaffTrainMap(typeStaffMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return staffWorkRoleList.stream().filter(swr -> {
            boolean okTime;
            Long staffId = swr.getStaffId();
            Byte status = swr.getStatus();
            Date beginTime = swr.getBeginTime();
            boolean onJob = Objects.equals(status, StaffWorkStatusEnum.ONWORKING.getValue());
            boolean offJob = Objects.equals(status, StaffWorkStatusEnum.NOWORKED.getValue());
            boolean bl = okTime = beginTime == null || DateUtil.compare((Date)beginTime, (Date)HealthTrainScoreCalcHandle.firstDayOfLastYear()) >= 0;
            if (!okTime || !onJob && !offJob) {
                return Boolean.FALSE;
            }
            List trainIdList = staffTrainMap.getOrDefault(staffId, Collections.emptyList());
            List oneTrainList = trainList.stream().filter(t -> trainIdList.contains(t.getId())).collect(Collectors.toList());
            if (beginTime == null) {
                return CollUtil.isNotEmpty(oneTrainList);
            }
            Date last3MonthDate = HealthTrainScoreCalcHandle.getLast3Month(beginTime);
            Date next3MonthDate = HealthTrainScoreCalcHandle.getNext3Month(beginTime);
            return oneTrainList.stream().anyMatch(train -> HealthTrainScoreCalcHandle.dateRangesOverlap(train.getTrainBeginTime(), train.getTrainBeginTime(), last3MonthDate, next3MonthDate));
        }).map(StaffWorkRole::getStaffId).collect(Collectors.toSet());
    }

    private static List<StaffWorkRole> getPreJobTrain0List(List<StaffWorkRole> staffWorkRoleList, List<Long> preTrain1List) {
        return staffWorkRoleList.stream().filter(wr -> {
            boolean legalTime;
            Byte status = wr.getStatus();
            Date beginTime = wr.getBeginTime();
            boolean onJob = Objects.equals(status, StaffWorkStatusEnum.ONWORKING.getValue());
            boolean offJob = Objects.equals(status, StaffWorkStatusEnum.NOWORKED.getValue());
            boolean bl = legalTime = beginTime == null || DateUtil.compare((Date)beginTime, (Date)HealthTrainScoreCalcHandle.firstDayOfLastYear()) >= 0;
            if (!legalTime || !onJob && !offJob) {
                return Boolean.FALSE;
            }
            if (CollUtil.isEmpty((Collection)preTrain1List)) {
                return Boolean.TRUE;
            }
            return preTrain1List.stream().noneMatch(s -> Objects.equals(s, wr.getStaffId()));
        }).collect(Collectors.toList());
    }

    public static Set<Long> getOnJobTrain0SetNew(Map<Integer, List<ComplianceWorkerTrainRecordsVo>> typeTrainMap, Map<Integer, List<ComplianceStaffInfoVo>> typeStaffMap, List<StaffWorkRole> staffWorkRoleList) {
        if (CollUtil.isEmpty(staffWorkRoleList)) {
            return Collections.emptySet();
        }
        List trainList = typeTrainMap.getOrDefault(2, Collections.emptyList());
        Map<Long, List<Long>> staffTrainMap = HealthTrainScoreCalcHandle.getStaffTrainMap(typeStaffMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        Date currDate = new Date();
        return staffWorkRoleList.stream().filter(swr -> {
            boolean onJobTrain0;
            boolean ok;
            Long staffId = swr.getStaffId();
            Byte status = swr.getStatus();
            Date firstBeginTime = swr.getFirstBeginTime();
            Date leaveTime = swr.getLeaveTime();
            boolean onJob = Objects.equals(status, StaffWorkStatusEnum.ONWORKING.getValue());
            boolean offJob = Objects.equals(status, StaffWorkStatusEnum.NOWORKED.getValue());
            boolean bl = ok = firstBeginTime != null && (onJob || offJob && leaveTime != null);
            if (!ok) {
                return Boolean.FALSE;
            }
            List trainIdList = staffTrainMap.getOrDefault(staffId, Collections.emptyList());
            List oneTrainList = trainList.stream().filter(t -> trainIdList.contains(t.getId())).collect(Collectors.toList());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(firstBeginTime);
            int leftYear = calendar.get(1);
            Date rigthDate = onJob ? currDate : leaveTime;
            calendar.setTime(rigthDate);
            int rightYear = calendar.get(1);
            if (++leftYear > --rightYear) {
                return Boolean.FALSE;
            }
            if (leftYear < 2023) {
                leftYear = 2023;
            }
            if (leftYear > rightYear) {
                return Boolean.FALSE;
            }
            int needTrainYearNum = rightYear - leftYear + 1;
            int trainYearNum = 0;
            while (leftYear <= rightYear) {
                for (ComplianceWorkerTrainRecordsVo train : oneTrainList) {
                    Date trainEndDate;
                    Date trainBeginDate = train.getTrainBeginTime();
                    if (!HealthTrainScoreCalcHandle.isTrainingWithinCustomYear(trainBeginDate, trainEndDate = train.getTrainEndTime(), leftYear)) continue;
                    ++trainYearNum;
                    break;
                }
                ++leftYear;
            }
            boolean bl2 = onJobTrain0 = trainYearNum != needTrainYearNum;
            if (onJobTrain0) {
                // empty if block
            }
            return onJobTrain0;
        }).map(StaffWorkRole::getStaffId).collect(Collectors.toSet());
    }

    public static Set<Long> getOnJobTrain1SetNew(Map<Integer, List<ComplianceWorkerTrainRecordsVo>> typeTrainMap, Map<Integer, List<ComplianceStaffInfoVo>> typeStaffMap, List<StaffWorkRole> staffWorkRoleList) {
        if (CollUtil.isEmpty(staffWorkRoleList)) {
            return Collections.emptySet();
        }
        List trainList = typeTrainMap.getOrDefault(2, Collections.emptyList());
        Map<Long, List<Long>> staffTrainMap = HealthTrainScoreCalcHandle.getStaffTrainMap(typeStaffMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        Date currDate = new Date();
        return staffWorkRoleList.stream().filter(swr -> {
            boolean ok;
            Long staffId = swr.getStaffId();
            Byte status = swr.getStatus();
            Date firstBeginTime = swr.getFirstBeginTime();
            Date leaveTime = swr.getLeaveTime();
            boolean onJob = Objects.equals(status, StaffWorkStatusEnum.ONWORKING.getValue());
            boolean offJob = Objects.equals(status, StaffWorkStatusEnum.NOWORKED.getValue());
            boolean bl = ok = firstBeginTime != null && (onJob || offJob && leaveTime != null);
            if (!ok) {
                return Boolean.FALSE;
            }
            List trainIdList = staffTrainMap.getOrDefault(staffId, Collections.emptyList());
            List oneTrainList = trainList.stream().filter(t -> trainIdList.contains(t.getId())).collect(Collectors.toList());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(firstBeginTime);
            int leftYear = calendar.get(1);
            Date rightDate = onJob ? currDate : leaveTime;
            calendar.setTime(rightDate);
            int rightYear = calendar.get(1);
            if (++leftYear > --rightYear) {
                return oneTrainList.stream().anyMatch(train -> HealthTrainScoreCalcHandle.isTrainingWithinCurrentYear(train.getTrainBeginTime(), train.getTrainEndTime()));
            }
            if (leftYear < 2023) {
                leftYear = 2023;
            }
            if (leftYear > rightYear) {
                return Boolean.FALSE;
            }
            int needTrainYearNum = rightYear - leftYear + 1;
            int trainYearNum = 0;
            while (leftYear <= rightYear) {
                for (ComplianceWorkerTrainRecordsVo train2 : oneTrainList) {
                    Date trainEndDate;
                    Date trainBeginDate = train2.getTrainBeginTime();
                    if (!HealthTrainScoreCalcHandle.isTrainingWithinCustomYear(trainBeginDate, trainEndDate = train2.getTrainEndTime(), leftYear)) continue;
                    ++trainYearNum;
                    break;
                }
                ++leftYear;
            }
            return trainYearNum == needTrainYearNum;
        }).map(StaffWorkRole::getStaffId).collect(Collectors.toSet());
    }

    private static List<StaffWorkRole> getOnJobTrain0List(List<StaffWorkRole> staffWorkRoleList, List<Long> onTrain1List) {
        return staffWorkRoleList.stream().filter(wr -> {
            boolean ok;
            Byte status = wr.getStatus();
            Date firstBeginTime = wr.getFirstBeginTime();
            Date beginTime = wr.getBeginTime();
            Date leaveTime = wr.getLeaveTime();
            boolean onJob = Objects.equals(status, StaffWorkStatusEnum.ONWORKING.getValue());
            boolean offJob = Objects.equals(status, StaffWorkStatusEnum.NOWORKED.getValue());
            boolean bl = ok = firstBeginTime != null && (onJob && beginTime != null || offJob && leaveTime != null);
            if (!ok) {
                return Boolean.FALSE;
            }
            if (CollUtil.isEmpty((Collection)onTrain1List)) {
                return Boolean.TRUE;
            }
            return onTrain1List.stream().noneMatch(s -> Objects.equals(s, wr.getStaffId()));
        }).collect(Collectors.toList());
    }

    public static Map<Long, List<Long>> getStaffTrainMap(List<ComplianceStaffInfoVo> staffList) {
        HashMap<Long, List<Long>> staffTrainMap = new HashMap<Long, List<Long>>();
        for (ComplianceStaffInfoVo staff : staffList) {
            Long staffId = staff.getStaffId();
            Long trainId = staff.getStaffTrainId();
            if (staffTrainMap.containsKey(staffId)) {
                ((List)staffTrainMap.get(staffId)).add(trainId);
                continue;
            }
            ArrayList<Long> trainIds = new ArrayList<Long>();
            trainIds.add(trainId);
            staffTrainMap.put(staffId, trainIds);
        }
        return staffTrainMap;
    }

    private static Date firstDayOfYear() {
        Calendar c = Calendar.getInstance();
        c.set(6, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    private static Date firstDayOfLastYear() {
        Calendar c = Calendar.getInstance();
        c.set(1, c.get(1) - 1);
        c.set(6, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static boolean isTrainingWithinCurrentYear(Date trainBeginDate, Date trainEndDate) {
        return HealthTrainScoreCalcHandle.isTrainingWithinCustomYear(trainBeginDate, trainEndDate, Calendar.getInstance().get(1));
    }

    public static boolean isTrainingWithinCustomYear(Date trainBeginDate, Date trainEndDate, int year) {
        Calendar c = Calendar.getInstance();
        Integer beginYear = null;
        Boolean isBegin = Boolean.FALSE;
        if (trainBeginDate != null) {
            c.setTime(trainBeginDate);
            beginYear = c.get(1);
            isBegin = Boolean.TRUE;
        }
        Integer endYear = null;
        Boolean isEnd = Boolean.FALSE;
        if (trainEndDate != null) {
            c.setTime(trainEndDate);
            endYear = c.get(1);
            isEnd = Boolean.TRUE;
        }
        boolean edge = Objects.equals(beginYear, year) || Objects.equals(endYear, year);
        boolean btw = isBegin != false && year > beginYear && isEnd != false && year < endYear;
        return edge || btw;
    }

    public static Date getLastMonth(Date date) {
        return HealthTrainScoreCalcHandle.getIndex_N_Month(date, -1);
    }

    public static Date getNextMonth(Date date) {
        return HealthTrainScoreCalcHandle.getIndex_N_Month(date, 1);
    }

    public static Date getLast3Month(Date date) {
        return HealthTrainScoreCalcHandle.getIndex_N_Month(date, -3);
    }

    public static Date getNext3Month(Date date) {
        return HealthTrainScoreCalcHandle.getIndex_N_Month(date, 3);
    }

    public static Date getIndex_N_Month(Date date, Integer n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, n);
        return calendar.getTime();
    }

    public static boolean isFirstDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        int dayOfMonth = calendar.get(5);
        return month == 0 && dayOfMonth == 1;
    }

    public static boolean isLastDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 11);
        calendar.set(5, 31);
        Date lastDayOfYear = calendar.getTime();
        return Objects.equals(date, lastDayOfYear);
    }

    public static boolean dateRangesOverlap(Date trainBeginDate, Date trainEndDate, Date preDate, Date posDate) {
        return DateUtil.compare((Date)trainBeginDate, (Date)posDate) <= 0 && DateUtil.compare((Date)preDate, (Date)trainEndDate) <= 0;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (CollUtil.isEmpty(fieldsItemDataMap)) {
            return BigDecimal.ZERO;
        }
        return this.evaluationLossScoreB(itemcodeId, fieldsItemDataMap);
    }

    @Override
    public Pair<Boolean, String> promiseDataClash(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        ComplianceCompanyItemdata harm;
        Pair result = new Pair((Object)Boolean.FALSE, (Object)"");
        if (Objects.equals(itemcodeId, ID3L) && ((harm = fieldsItemDataMap.get(TOUCH_HARM_PEOPLE_NUMBER)) == null || Objects.equals(harm.getResultData(), "0"))) {
            result = new Pair((Object)Boolean.TRUE, (Object)TOUCH_HARM_PEOPLE_NUMBER);
        }
        return result;
    }

    private BigDecimal evaluationLossScoreA(Long itemcodeId, Map<String, ComplianceCompanyItemdata> dataMap) {
        int isExpire = this.getDataOrDefault(dataMap.get(IS_EXPIRE_COUNT_12));
        int noExpire = this.getDataOrDefault(dataMap.get(NO_EXPIRE_COUNT_12));
        if (isExpire > 0 || noExpire == 0) {
            return BigDecimal.ZERO;
        }
        switch (Convert.toInt((Object)itemcodeId)) {
            case 10901: {
                return this.calculateCertScore(dataMap, IS_EXPIRE_COUNT_12);
            }
            case 10902: {
                return this.calculateCertScore(dataMap, IS_EXPIRE_COUNT_13);
            }
            case 10903: {
                return this.calculateWorkerTrainingScore(dataMap);
            }
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal evaluationLossScoreB(Long itemcodeId, Map<String, ComplianceCompanyItemdata> dataMap) {
        switch (Convert.toInt((Object)itemcodeId)) {
            case 10901: {
                return this.calculateCertScore(dataMap, IS_EXPIRE_COUNT_12, NO_EXPIRE_COUNT_12);
            }
            case 10902: {
                return this.calculateCertScore(dataMap, IS_EXPIRE_COUNT_13, NO_EXPIRE_COUNT_13);
            }
            case 10903: {
                return this.calculateWorkerTrainingScore(dataMap);
            }
        }
        return BigDecimal.ZERO;
    }

    private static List<Long> getStaffIdList(List<StaffInfo> staffList) {
        if (CollUtil.isEmpty(staffList)) {
            return Collections.emptyList();
        }
        return staffList.stream().map(StaffInfo::getLocalOutWorkStaffIds).filter(CharSequenceUtil::isNotBlank).flatMap(ids -> Arrays.stream(ids.split(","))).map(Long::valueOf).collect(Collectors.toList());
    }

    public String getCertListData(Long itemcodeId, List<CompanyFunctionalOrganizationMember> memList) {
        List mList = memList.stream().filter(m -> {
            if (Objects.equals(itemcodeId, ID1L)) {
                return m.getOrgStaffType().contains("1");
            }
            if (Objects.equals(itemcodeId, ID2L)) {
                return m.getOrgStaffType().contains("2");
            }
            return Boolean.FALSE;
        }).collect(Collectors.toList());
        ArrayList list = new ArrayList();
        for (CompanyFunctionalOrganizationMember m2 : mList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", m2.getStaffName());
            map.put("staffType", this.getMemberTypeName(m2.getMemberType()));
            map.put("expire", m2.getLeaderCert());
            map.put("dataType", switch (Convert.toInt((Object)m2.getLeaderDataSource())) {
                case 1, 2, 4 -> "\u5176\u4ed6\u6765\u6e90";
                case 3 -> "\u6d59\u91cc\u536b\u4f01";
                case 5 -> "\u4e07\u8fbe\u4ed3-\u676d\u5dde\u57f9\u8bad";
                default -> "";
            });
            list.add(map);
        }
        return JSON.toJSONString(list);
    }

    private static void encapsulateResultFormat1(Long cid, long itemcodeId, String fieldName, Map<String, Object> pageData, List<ComplianceCompanyItemdata> result) {
        result.add(new ComplianceCompanyItemdata().setCid(cid).setItemcodeId(Long.valueOf(itemcodeId)).setFieldName(fieldName).setResultData(Convert.toStr((Object)pageData.get(fieldName))).setFormat(Integer.valueOf(1)));
    }

    private static void encapsulateResultFormat2(Long cid, long itemcodeId, String fieldName, Map<String, Object> pageData, List<ComplianceCompanyItemdata> result) {
        result.add(new ComplianceCompanyItemdata().setCid(cid).setItemcodeId(Long.valueOf(itemcodeId)).setFieldName(fieldName).setResultData(Convert.toStr((Object)pageData.get(fieldName))).setFormat(Integer.valueOf(2)));
    }

    private BigDecimal calculateCertScore(Map<String, ComplianceCompanyItemdata> dataMap, String field) {
        ComplianceCompanyItemdata data = dataMap.get(field);
        if (this.getDataOrDefault(data) > 0) {
            return Convert.toBigDecimal((Object)data.getResultData()).multiply(Convert.toBigDecimal((Object)-2));
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calculateCertScore(Map<String, ComplianceCompanyItemdata> dataMap, String isExpireField, String noExpireField) {
        int isExpire = this.getDataOrDefault(dataMap.get(isExpireField));
        int noExpire = this.getDataOrDefault(dataMap.get(noExpireField));
        if (isExpire > 0 || noExpire == 0) {
            return Convert.toBigDecimal((Object)-2);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calculateWorkerTrainingScore(Map<String, ComplianceCompanyItemdata> dataMap) {
        int harmNum = this.getDataOrDefault(dataMap.get(TOUCH_HARM_PEOPLE_NUMBER));
        if (harmNum == 0) {
            return BigDecimal.ZERO;
        }
        int preNum = this.getDataOrDefault(dataMap.get(PRE_JOB_TRAIN_0));
        int onNum = this.getDataOrDefault(dataMap.get(ON_JOB_TRAIN_0));
        return Convert.toBigDecimal((Object)(preNum + onNum)).multiply(Convert.toBigDecimal((Object)-0.5));
    }

    private int getDataOrDefault(ComplianceCompanyItemdata data) {
        return data != null ? NumberUtil.parseInt((String)data.getResultData()) : 0;
    }

    private String getMemberTypeName(Byte memberType) {
        if (memberType == null) {
            return "";
        }
        switch (memberType) {
            case 1: {
                return "\u4e13\u804c";
            }
            case 2: {
                return "\u517c\u804c";
            }
        }
        return "";
    }

    private static boolean isItemComplete(Map<String, String> dataMap, String ... fields) {
        return Stream.of(fields).allMatch(f -> Optional.ofNullable((String)dataMap.get(f)).map(Integer::parseInt).orElse(null) != null);
    }

    private static boolean orgStaffTypeMatch(String orgStaffType, Object type) {
        if (StrUtil.isNotBlank((CharSequence)orgStaffType)) {
            Object[] array = orgStaffType.split(",");
            return ArrayUtil.indexOf((Object[])array, (Object)Convert.toStr((Object)type)) != -1;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<FristStepDataValidRule> fristStepDataValueRule(String importantTypeStr) {
        ArrayList<FristStepDataValidRule> rules = new ArrayList<FristStepDataValidRule>();
        rules.add(new FristStepDataValidRule(10903L, TOUCH_HARM_PEOPLE_NUMBER, 2, "\u4e0d\u80fd\u4e3a\u96f6"));
        return rules;
    }

    @Generated
    public HealthTrainScoreCalcHandle(IComplianceWorkerTrainRecordsService workerTrainRecordsService, ICompanyFunctionalOrganizationMemberService functionalOrganizationMemberService, IComplianceStaffInfoService complianceStaffInfoService) {
        this.workerTrainRecordsService = workerTrainRecordsService;
        this.functionalOrganizationMemberService = functionalOrganizationMemberService;
        this.complianceStaffInfoService = complianceStaffInfoService;
    }
}

