/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyChangeRecordMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtraScoreCalcHandle
implements ScoreCalcHandle {
    @Autowired
    private OssClientBean ossBean;
    @Autowired
    private ComplianceCompanyChangeRecordMapper recordMapper;
    @DubboReference
    private ICompanyService companyService;
    @DubboReference
    private ICompanyFunctionalOrganizationService functionalOrganizationService;
    @DubboReference
    private ICompanyFunctionalOrganizationMemberService functionalOrganizationMemberService;
    private static final int ID1 = 11501;
    private static final int ID2 = 11502;
    private static final Long ID1L = 11501L;
    private static final Long ID2L = 11502L;
    private static final String IS_JC_JK = "isJcJk";
    private static final String CERT_IS_EXPIRE_NUM = "certIsExpireNum";
    private static final String CERT_NO_EXPIRE_NUM = "certNoExpireNum";
    private static final String MAIN_PERSON_AS_FIRST_LEADER = "mainPersonAsFirstLeader";
    private static final String LEADER_PROVE_FILE_ID = "leaderProveFileId";
    private static final String LEADER_PROVE_FILE_NAME = "leaderProveFileName";
    private static final String LEADER_PROVE_FILE_URL = "leaderProveFileUrl";

    @Override
    public String support() {
        return "15";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return null;
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cidList, Map<String, Object> params) {
        List jcJkCidList = this.companyService.judgeIsJcAndJk(cidList);
        List<ComplianceCompanyItemdata> result = cidList.stream().map(cid -> this.createItemData((Long)cid, jcJkCidList.contains(cid))).collect(Collectors.toList());
        List memberList = this.functionalOrganizationMemberService.getComplianceMemberListByCidList(cidList, Boolean.valueOf(true));
        Map<Long, List<CompanyFunctionalOrganizationMember>> memberMap = memberList.stream().collect(Collectors.groupingBy(CompanyFunctionalOrganizationMember::getCid));
        List funcOrgList = this.functionalOrganizationService.getFuncOrgListByCidList(cidList);
        Map<Long, SysFileModel> funcOrgFileInfo = this.getFuncOrgFileInfo(funcOrgList);
        Map<Long, List<CompanyFunctionalOrganization>> funcOrgMap = funcOrgList.stream().collect(Collectors.groupingBy(CompanyFunctionalOrganization::getCid));
        cidList.forEach(cid -> {
            List memList = memberMap.getOrDefault(cid, Collections.emptyList());
            long isExpire = memList.stream().filter(m -> !this.getIsValid((CompanyFunctionalOrganizationMember)m)).count();
            long noExpire = memList.stream().filter(this::getIsValid).count();
            ExtraScoreCalcHandle.encapsulateResult(cid, CERT_IS_EXPIRE_NUM, isExpire, result);
            ExtraScoreCalcHandle.encapsulateResult(cid, CERT_NO_EXPIRE_NUM, noExpire, result);
            List foList = (List)funcOrgMap.get(cid);
            boolean mainAsFirst = CollUtil.isNotEmpty((Collection)foList) ? foList.stream().anyMatch(o -> o.getMainPersonAsFirstleader() != null && o.getMainPersonAsFirstleader() != false) : Boolean.FALSE.booleanValue();
            ExtraScoreCalcHandle.encapsulateResult(cid, MAIN_PERSON_AS_FIRST_LEADER, mainAsFirst, result);
            SysFileModel file = (SysFileModel)funcOrgFileInfo.get(cid);
            if (file != null) {
                ExtraScoreCalcHandle.encapsulateResult(cid, LEADER_PROVE_FILE_ID, file.getId(), result);
                ExtraScoreCalcHandle.encapsulateResult(cid, LEADER_PROVE_FILE_NAME, file.getFileName(), result);
                ExtraScoreCalcHandle.encapsulateResult(cid, LEADER_PROVE_FILE_URL, file.getOssUrl(), result);
            }
        });
        return result;
    }

    private Map<Long, SysFileModel> getFuncOrgFileInfo(List<CompanyFunctionalOrganization> funcOrgList) {
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        funcOrgList.forEach(org -> {
            String fileId = org.getMainPersonAsFirstleaderProvefiles();
            if (CharSequenceUtil.isNotBlank((CharSequence)fileId)) {
                fileIdList.add(Convert.toLong((Object)fileId));
            }
        });
        List fileList = fileIdList.isEmpty() ? Collections.emptyList() : this.recordMapper.selectFileInfoBatch(fileIdList);
        Map<Long, String> fileIdNameMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, SysFileModel::getFileName, (a, b) -> b));
        Map<Long, String> fileIdUrlMap = fileList.stream().collect(Collectors.toMap(SysFileModel::getId, file -> this.ossBean.getUrl(file.getOssUrl()), (a, b) -> b));
        HashMap<Long, SysFileModel> cidFile = new HashMap<Long, SysFileModel>();
        for (CompanyFunctionalOrganization org2 : funcOrgList) {
            String fileId = org2.getMainPersonAsFirstleaderProvefiles();
            if (!CharSequenceUtil.isNotBlank((CharSequence)fileId)) continue;
            SysFileModel file2 = new SysFileModel();
            Long fileIdL = Convert.toLong((Object)fileId);
            file2.setId(fileIdL);
            file2.setFileName(fileIdNameMap.get(fileIdL));
            file2.setOssUrl(fileIdUrlMap.get(fileIdL));
            cidFile.put(org2.getCid(), file2);
        }
        return cidFile;
    }

    private boolean getIsValid(CompanyFunctionalOrganizationMember m) {
        boolean res = "1".equals(m.getOrgStaffType()) ? m.getLeaderCert() == 1 : ("2".equals(m.getOrgStaffType()) ? m.getManagerCert() == 1 : m.getLeaderCert() == 1 || m.getManagerCert() == 1);
        return res;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (CollUtil.isEmpty(fieldsItemDataMap)) {
            return BigDecimal.ZERO;
        }
        switch (Convert.toInt((Object)itemcodeId)) {
            case 11501: {
                boolean isJcJk = fieldsItemDataMap.entrySet().stream().anyMatch(e -> IS_JC_JK.equals(e.getKey()) && Convert.toBool((Object)((ComplianceCompanyItemdata)e.getValue()).getResultData()) != false);
                return isJcJk ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case 11502: {
                boolean valid = fieldsItemDataMap.entrySet().stream().anyMatch(e -> CERT_NO_EXPIRE_NUM.equals(e.getKey()) && Convert.toInt((Object)((ComplianceCompanyItemdata)e.getValue()).getResultData()) > 0);
                boolean main = fieldsItemDataMap.entrySet().stream().anyMatch(e -> MAIN_PERSON_AS_FIRST_LEADER.equals(e.getKey()) && Convert.toBool((Object)((ComplianceCompanyItemdata)e.getValue()).getResultData()) != false);
                return valid && main ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (Objects.equals(itemcodeId, ID1L) && Objects.equals(filedName, IS_JC_JK) || Objects.equals(itemcodeId, ID2L) && Objects.equals(filedName, MAIN_PERSON_AS_FIRST_LEADER)) {
            switch (resultData) {
                case "true": {
                    return "\u662f";
                }
                case "false": {
                    return "\u5426";
                }
            }
            return resultData;
        }
        return resultData;
    }

    public String getCertListData(List<CompanyFunctionalOrganizationMember> memList) {
        List mList = memList.stream().filter(CompanyFunctionalOrganizationMember::getIsComplianceManager).collect(Collectors.toList());
        ArrayList list = new ArrayList();
        for (CompanyFunctionalOrganizationMember m : mList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", m.getStaffName());
            map.put("staffType", this.getMemberTypeName(m.getMemberType()));
            map.put("expire", m.getLeaderCert());
            map.put("dataType", switch (Convert.toInt((Object)m.getLeaderDataSource())) {
                case 1, 2, 4 -> "\u5176\u4ed6\u6765\u6e90";
                case 3 -> "\u6d59\u91cc\u536b\u4f01";
                case 5 -> "\u4e07\u8fbe\u4ed3-\u676d\u5dde\u57f9\u8bad";
                default -> "";
            });
            list.add(map);
        }
        return JSON.toJSONString(list);
    }

    private ComplianceCompanyItemdata createItemData(Long cid, boolean isJcJk) {
        return new ComplianceCompanyItemdata().setCid(cid).setItemcodeId(ID1L).setFieldName(IS_JC_JK).setResultData(Convert.toStr((Object)isJcJk));
    }

    private static void encapsulateResult(Long cid, String fieldName, Object fieldValue, List<ComplianceCompanyItemdata> result) {
        result.add(new ComplianceCompanyItemdata().setCid(cid).setItemcodeId(ID2L).setFieldName(fieldName).setResultData(Convert.toStr((Object)fieldValue)).setFormat(Integer.valueOf(1)));
    }

    private String getMemberTypeName(Byte memberType) {
        if (memberType == null) {
            return "";
        }
        switch (memberType) {
            case 1: {
                return "\u4e13\u804c";
            }
            case 2: {
                return "\u517c\u804c";
            }
        }
        return "";
    }

    private static boolean isItemComplete(Map<String, String> dataMap, String ... fields) {
        return Stream.of(fields).allMatch(f -> Optional.ofNullable((String)dataMap.get(f)).map(Integer::parseInt).orElse(null) != null);
    }
}

