/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore.handle;

import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemdataService;
import cn.smarthse.modules.health.service.base.selfjudge.ISelfInspectionRiskAssessmentReportInfoService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyGradeScoreCalcHandle
implements ScoreCalcHandle {
    @Autowired
    ICompanyGradeV3RecService gradeV3Service;
    @DubboReference
    ISelfInspectionRiskAssessmentReportInfoService reportInfoService;
    @Autowired
    IComplianceCompanyItemdataService itemdataService;

    @Override
    public String support() {
        return "01";
    }

    @Override
    public BigDecimal itemTotalScore() {
        return new BigDecimal("5");
    }

    @Override
    public List<ComplianceCompanyItemdata> loadRefData(List<Long> cids, Map<String, Object> params) {
        List lastRiskExposeEvaluate = this.reportInfoService.listLastRiskExposeEvaluate(cids);
        Map<Object, Object> cidRiskLevelMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)lastRiskExposeEvaluate)) {
            cidRiskLevelMap = lastRiskExposeEvaluate.stream().filter(f -> f.getCid() != null && f.getRiskLevel() != null).collect(Collectors.toMap(RiskExposeEvaluate::getCid, RiskExposeEvaluate::getRiskLevel, (v1, v2) -> v1));
        }
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        for (Long cid : cids) {
            ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
            itemdata.setCid(cid);
            String gradeLevel = cidRiskLevelMap.get(cid) == null ? "" : ((Integer)cidRiskLevelMap.get(cid)).toString();
            itemdata.setResultData(gradeLevel);
            itemdata.setFieldName("riskLevel");
            itemdata.setItemcodeId(Long.valueOf(10101L));
            result.add(itemdata);
        }
        return result;
    }

    @Override
    public BigDecimal calcLoseScore(Long itemcodeId, Map<String, ComplianceCompanyItemdata> fieldsItemDataMap, String importantTypeStr) {
        if (MapUtils.isEmpty(fieldsItemDataMap)) {
            return this.itemTotalScore().negate();
        }
        String refData = Optional.ofNullable(fieldsItemDataMap.get("riskLevel")).map(ComplianceCompanyItemdata::getResultData).orElse("");
        if (Objects.equals(itemcodeId, 10101L)) {
            if (Objects.equals(refData, "3")) {
                return new BigDecimal("-3");
            }
            if (Objects.equals(refData, "2")) {
                return new BigDecimal("-2");
            }
            if (Objects.equals(refData, "1")) {
                return new BigDecimal("0");
            }
        }
        return this.itemTotalScore().negate();
    }

    @Override
    public String template(Long itemcodeId, String filedName, String resultData) {
        if (itemcodeId == 10101L && "riskLevel".equals(filedName)) {
            switch (resultData) {
                case "1": {
                    return "I\u7ea7";
                }
                case "2": {
                    return "II\u7ea7";
                }
                case "3": {
                    return "III\u7ea7";
                }
                case "": {
                    return "\u672a\u8bc4\u4f30";
                }
            }
            return resultData;
        }
        return resultData;
    }
}

