/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.compliance.calcscore.CalcLog;
import cn.smarthse.modules.health.compliance.calcscore.CalcScoreBusService;
import cn.smarthse.modules.health.compliance.dao.ComplianceTryCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemcode;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.entity.ComplianceScoreChangeRecord;
import cn.smarthse.modules.health.compliance.entity.ComplianceTryCompanyInfo;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDataModel;
import cn.smarthse.modules.health.compliance.model.ComplianceNeedRefreshModel;
import cn.smarthse.modules.health.compliance.model.ComplianceValidModel;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyExitItemService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemdataService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyLabelService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreChangeRecordService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceTryCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceTryCompanyWorkService;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.ListUtils;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class ComplianceScoreRefreshServiceImpl
implements IComplianceScoreRefreshService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComplianceScoreRefreshServiceImpl.class);
    private static final String COLLECTSCOREREFRESHMUTIL_LOCKNAME = "third-service:ComplianceScoreRefreshMutil:lock";
    private static final String COLLECTSCOREREFRESHSINGLE_LOCKNAME = "third-service:ComplianceScoreRefreshSingle:lock";
    private static final String COLLECTSCOREREFRESH_DELAY_SET = "third-service:ComplianceScoreRefresh:delayset";
    @Autowired
    protected IdWorker idWorker;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private CalcScoreBusService busService;
    @Autowired
    private IComplianceCompanyInfoService infoService;
    @Autowired
    IComplianceCompanyItemcodeService itemcodeService;
    @Autowired
    IComplianceCompanyItemdataService itemdataService;
    @Resource
    IComplianceCompanyLabelService labelService;
    @Autowired
    IComplianceTryCompanyWorkService tryCompanyWorkService;
    @Autowired
    IComplianceTryCompanyInfoService tryCompanyInfoService;
    @Resource
    private IComplianceCompanyExitItemService complianceCompanyExitItemService;
    @Resource
    private IComplianceCompanyItemdataService complianceCompanyItemdataService;
    @Resource
    IComplianceScoreChangeRecordService complianceScoreChangeRecordService;
    @Resource
    IComplianceCompanyInfoService complianceCompanyInfoService;

    public void syncRefresh(Long cid, Map<String, Object> params, String ... itemCodes) {
        if (cid == null) {
            log.warn("cid\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        List allItemcode = this.itemcodeService.getCacheAllItemcode();
        Set<String> codeSet = allItemcode.stream().filter(f -> Objects.equals(f.getType(), 1)).map(ComplianceCompanyItemcode::getCode).collect(Collectors.toSet());
        if (ArrayUtils.isEmpty((Object[])itemCodes)) {
            itemCodes = codeSet.toArray(new String[0]);
        }
        this.reloadRefData(Arrays.asList(cid), params, itemCodes);
    }

    public void reloadRefData(List<Long> cids, Map<String, Object> params, String ... itemCodes) {
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        List complianceStatuCids = this.infoService.getComplianceCids(cids, Arrays.asList(ComplianceInfoStatusEnum.COMPLIANT.getKey(), ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey(), ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey(), ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey()));
        if (CollectionUtils.isEmpty((Collection)complianceStatuCids)) {
            return;
        }
        cids = complianceStatuCids.stream().map(ComplianceCompanyInfo::getCid).collect(Collectors.toList());
        ScheduledExecutorService debugExecutor = Executors.newSingleThreadScheduledExecutor();
        if (CalcLog.getJobId() > 0L) {
            debugExecutor.scheduleAtFixedRate(() -> CalcLog.printTaskInfo("compliance_calc_score_loadtime", CalcLog.getJobId()), 10L, 15L, TimeUnit.SECONDS);
        }
        for (List itemCidList : ListUtil.partition(cids, (int)500)) {
            try {
                CalcLog.countIncr("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step1:reloadCompanyNum", 0);
                this.busService.refreshRefData(itemCidList, params, false, itemCodes);
                CalcLog.countIncr("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step1:reloadCompanyNum", itemCidList.size());
            }
            catch (Exception e) {
                log.error("\u603b\u7ebf\u52a0\u8f7d\u5408\u89c4\u7cfb\u7edf\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
        for (List itemCidList : ListUtil.partition(cids, (int)1000)) {
            try {
                CalcLog.countIncr("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step2:calcScoreCompanyNum", 0);
                this.refreshScore(itemCidList);
                CalcLog.countIncr("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step2:calcScoreCompanyNum", itemCidList.size());
            }
            catch (Exception e) {
                log.error("\u603b\u7ebf\u5237\u65b0\u5408\u89c4\u4f01\u4e1a\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
        if (CalcLog.getJobId() > 0L) {
            debugExecutor.shutdownNow();
            CalcLog.printTaskInfo("compliance_calc_score_loadtime", CalcLog.getJobId());
            this.redisClient.delPrefix("compliance_calc_score_loadtime:" + CalcLog.getJobId());
        }
    }

    public void tryToolsReloadRefData(Long workId) {
        if (workId == null) {
            log.warn("workId\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        List tryCompanyWorks = this.tryCompanyWorkService.getTryCompanyRefInfo(workId);
        if (CollectionUtils.isEmpty((Collection)tryCompanyWorks)) {
            return;
        }
        List tryCompanyInfos = tryCompanyWorks.stream().filter(f -> f.getId() == null).map(m -> {
            ComplianceTryCompanyInfo info = new ComplianceTryCompanyInfo();
            info.setCid(m.getCid());
            info.setId(Long.valueOf(this.idWorker.nextId()));
            info.setIsValid(Boolean.valueOf(true));
            info.setCreateDate(new Date());
            return info;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tryCompanyInfos)) {
            this.tryCompanyInfoService.batchUpdateOrInsert(tryCompanyInfos, ComplianceTryCompanyInfoMapper.class, (item, mapper) -> mapper.insert(item));
        }
        List<Long> cids = tryCompanyWorks.stream().map(m -> m.getCid()).collect(Collectors.toList());
        String[] itemCodes = new String[]{"01", "02", "05", "07", "08", "10"};
        int page = 0;
        for (List itemCidList : ListUtil.partition(cids, (int)1000)) {
            ++page;
            try {
                this.busService.refreshRefData(itemCidList, null, true, itemCodes);
                this.busService.doRefreshScore(cids, true);
            }
            catch (Exception e) {
                log.error("\u603b\u7ebf\u5237\u65b0\u5408\u89c4\u8bd5\u7b97\u4f01\u4e1a\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
    }

    public List<ComplianceCompanyItemdata> loadItemData(Long cid, Long complianceId, String itemCode, Integer loadRefFlag) {
        List<ComplianceCompanyItemdata> loadRefDataList;
        List lastByCid;
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        if (complianceId == null && cid != null && (lastByCid = this.infoService.getComplianceCids(Arrays.asList(cid))) != null) {
            complianceId = ((ComplianceCompanyInfo)lastByCid.get(0)).getId();
        }
        List dbItemDataList = this.itemdataService.listItemDataByCode(complianceId, itemCode);
        Map<Object, Object> codeIdFieldMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbItemDataList)) {
            codeIdFieldMap = dbItemDataList.stream().collect(Collectors.toMap(k -> k.getItemcodeId().toString() + k.getFieldName(), v -> v, (v1, v2) -> v1));
        }
        if (Objects.equals(loadRefFlag, 1) && CollectionUtils.isNotEmpty(loadRefDataList = this.busService.loadRefData(cid, null, itemCode))) {
            result.addAll(loadRefDataList);
            for (ComplianceCompanyItemdata itemdata : loadRefDataList) {
                if (!codeIdFieldMap.containsKey(itemdata.getItemcodeId().toString() + itemdata.getFieldName())) continue;
                codeIdFieldMap.remove(itemdata.getItemcodeId().toString() + itemdata.getFieldName());
            }
        }
        if (MapUtils.isNotEmpty(codeIdFieldMap)) {
            List itemdataList = codeIdFieldMap.values().stream().collect(Collectors.toList());
            result.addAll(itemdataList);
        }
        return result;
    }

    public Boolean savePromiseData(List<ComplianceCompanyItemdata> promiseDataList) {
        if (CollectionUtils.isEmpty(promiseDataList)) {
            return null;
        }
        ComplianceCompanyItemdata promiseData = promiseDataList.get(0);
        Long complianceId = promiseData.getComplianceId();
        ComplianceCompanyInfo info = (ComplianceCompanyInfo)this.infoService.getById(complianceId);
        Long cid = info.getCid();
        boolean needRefresh = true;
        if (info.getStatus() == null || Objects.equals(info.getStatus(), ComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey()) || Objects.equals(info.getStatus(), ComplianceInfoStatusEnum.NON_COMPLIANCE.getKey())) {
            needRefresh = false;
        }
        this.busService.savePromiseData(promiseDataList, cid, needRefresh);
        if (needRefresh) {
            this.refreshScore(Arrays.asList(cid));
        }
        return true;
    }

    public void refreshScore(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        for (List cidList : ListUtil.partition(cids, (int)1000)) {
            this.doRefreshScore(cidList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRefreshScore(List<Long> cids) {
        if (CollectionUtils.isEmpty(cids)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        RSet delayCidSet = this.redissonClient.getSet(COLLECTSCOREREFRESH_DELAY_SET);
        RLock mutilLock = this.redissonClient.getLock(COLLECTSCOREREFRESHMUTIL_LOCKNAME);
        if (cids.size() > 1) {
            try {
                if (mutilLock.tryLock(10L, TimeUnit.MINUTES)) {
                    this.busService.doRefreshScore(cids, false);
                    if (!CollectionUtils.isNotEmpty((Collection)delayCidSet)) return;
                    List<Long> delayCidList = delayCidSet.stream().collect(Collectors.toList());
                    this.busService.doRefreshScore(delayCidList, false);
                    return;
                }
                log.error("\u6b63\u5728\u6267\u884c\u6279\u91cf\u4efb\u52a1\uff0c \u5f53\u524d\u64cd\u4f5c\u4f5c\u5e9f");
                return;
            }
            catch (InterruptedException e) {
                log.error("\u591a\u4efb\u52a1\u5237\u65b0\u5f02\u5e38\uff1f\uff1f", (Throwable)e);
                return;
            }
            finally {
                mutilLock.unlock();
            }
        }
        if (mutilLock.isLocked()) {
            delayCidSet.add((Object)cids.get(0));
            log.error("\u6b63\u5728\u6267\u884c\u5168\u91cf\u5b9a\u65f6\u4efb\u52a1\uff0c \u5f53\u524d\u6570\u636e\u52a0\u5165\u4e4b\u540e\u6267\u884c, cid:{}", cids);
        }
        String singleLockName = "third-service:ComplianceScoreRefreshSingle:lock:" + String.valueOf(cids.get(0));
        RLock singleLock = this.redissonClient.getLock(singleLockName);
        try {
            if (!singleLock.tryLock(30L, TimeUnit.SECONDS)) return;
            this.busService.doRefreshScore(cids, false);
            return;
        }
        catch (InterruptedException e) {
            log.error("\u5355\u4efb\u52a1\u5237\u65b0\u5f02\u5e38\uff1f\uff1flock:{}", (Object)singleLockName, (Object)e);
            return;
        }
        finally {
            singleLock.unlock();
        }
    }

    public List<ComplianceValidModel> validaFristStepData(Long cid, String ... itemCodes) {
        return this.busService.validaFristStepData(cid, itemCodes);
    }

    @Transactional
    public void recordDailyChangeLog(List<Long> cidList) {
        int pageSize = 1000;
        log.info("=========================\u8bb0\u5f55\u5408\u89c4\u4f01\u4e1a\u6bcf\u65e5\u5206\u6570\u53d8\u5316\u65e5\u5fd7\u4efb\u52a1\u5f00\u59cb=========================");
        long start = System.currentTimeMillis();
        ArrayList<ComplianceScoreChangeRecord> logList = new ArrayList<ComplianceScoreChangeRecord>();
        ArrayList refreshCidList = new ArrayList();
        if (CollectionUtils.isEmpty(cidList)) {
            cidList = this.infoService.getCidList();
        }
        List split = ListUtils.split(cidList, (int)pageSize);
        for (int i = 0; i < split.size(); ++i) {
            List cids = (List)split.get(i);
            List newScoreList = this.infoService.queryScoreByCidList(cids);
            List complianceIds = newScoreList.stream().map(ComplianceCompanyInfo::getId).collect(Collectors.toList());
            List yesterdayRecords = this.complianceScoreChangeRecordService.queryLatestRecords(complianceIds);
            for (ComplianceCompanyInfo newScore : newScoreList) {
                ComplianceScoreChangeRecord record = this.getById(newScore.getId(), yesterdayRecords);
                if (Objects.nonNull(record) && ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey().equals(newScore.getStatus()) && ComplianceInfoStatusEnum.NON_COMPLIANT_EXIT_ITEMS.getKey().equals(record.getStatus())) continue;
                this.addLogs(newScore.getId(), newScore.getComplianceScore(), newScore.getStatus(), logList);
            }
        }
        if (CollectionUtils.isNotEmpty(logList)) {
            log.info("\u5f00\u59cb\u4fdd\u5b58\u65e5\u5fd7");
            this.complianceScoreChangeRecordService.insertComplianceScoreChangeBatch(logList);
            log.info("\u4fdd\u5b58\u65e5\u5fd7\u5b8c\u6210");
        }
        log.info("=========================\u8bb0\u5f55\u5408\u89c4\u4f01\u4e1a\u6bcf\u65e5\u5206\u6570\u53d8\u5316\u65e5\u5fd7\u4efb\u52a1\u7ed3\u675f=========================");
    }

    private void addLogs(Long complianceId, BigDecimal complianceScore, Integer status, List<ComplianceScoreChangeRecord> logList) {
        Date now = DateUtils.addDay((Date)new Date(), (int)-1);
        ComplianceScoreChangeRecord log = new ComplianceScoreChangeRecord();
        log.setId(Long.valueOf(this.idWorker.nextId()));
        log.setComplianceId(complianceId);
        log.setComplianceScore(complianceScore);
        log.setStatus(status);
        log.setUpdateDate(now);
        logList.add(log);
    }

    private List<ComplianceNeedRefreshModel> queryRowData(List<Long> cidList) {
        ArrayList<ComplianceNeedRefreshModel> result = new ArrayList<ComplianceNeedRefreshModel>();
        List exitItemList = this.complianceCompanyExitItemService.queryIsExistExitItems(cidList);
        Map<Long, ComplianceNeedRefreshModel> exitItemMap = exitItemList.stream().collect(Collectors.toMap(ComplianceNeedRefreshModel::getCid, v -> v));
        List exitSuperviseObjectionList = this.complianceCompanyInfoService.judgeExistObjectionByCidList(cidList);
        Map<Long, ComplianceNeedRefreshModel> superviseObjMap = exitSuperviseObjectionList.stream().collect(Collectors.toMap(ComplianceNeedRefreshModel::getCid, v -> v));
        for (Long cid : cidList) {
            ComplianceNeedRefreshModel exitItem = exitItemMap.get(cid);
            ComplianceNeedRefreshModel superviseObj = superviseObjMap.get(cid);
            ComplianceNeedRefreshModel info = null;
            if (Objects.nonNull(exitItem)) {
                info = new ComplianceNeedRefreshModel();
                BeanUtils.copyProperties((Object)exitItem, (Object)info);
            }
            if (Objects.nonNull(superviseObj)) {
                if (Objects.isNull(info)) {
                    info = new ComplianceNeedRefreshModel();
                    BeanUtils.copyProperties((Object)superviseObj, (Object)info);
                } else {
                    info.setExitSuperviseObjection(superviseObj.getExitSuperviseObjection());
                }
            }
            if (!Objects.nonNull(info)) continue;
            result.add(info);
        }
        return result;
    }

    private ComplianceCompanyDataModel getByItemCodeId(Long itemCodeId, String fileName, List<ComplianceCompanyDataModel> sysItemList) {
        return sysItemList.stream().filter(i -> i.getFieldName().equalsIgnoreCase(fileName) && i.getCodeId().equals(itemCodeId)).findFirst().orElse(null);
    }

    private ComplianceScoreChangeRecord getById(Long id, List<ComplianceScoreChangeRecord> yesterdayRecords) {
        return yesterdayRecords.stream().filter(i -> i.getComplianceId().equals(id)).findFirst().orElse(null);
    }

    @Transactional
    public void addDefaultValue(Long complianceId, String type) {
        this.itemdataService.addDefaultValue(complianceId, type);
    }
}

