/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.modules.health.compliance.calcscore.CalcLog;
import cn.smarthse.modules.health.compliance.calcscore.handle.ScoreCalcHandle;
import cn.smarthse.modules.health.compliance.calcscore.rule.FristStepDataValidRule;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanyItemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceCompanySubitemMapper;
import cn.smarthse.modules.health.compliance.dao.ComplianceTryCompanyInfoMapper;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyChangeRecord;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItem;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemcode;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyLabel;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanySubitem;
import cn.smarthse.modules.health.compliance.entity.ComplianceTryCompanyInfo;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoLabelEnum;
import cn.smarthse.modules.health.compliance.enums.ComplianceInfoStatusEnum;
import cn.smarthse.modules.health.compliance.enums.SourceEnum;
import cn.smarthse.modules.health.compliance.model.ComplianceCompanyDataModel;
import cn.smarthse.modules.health.compliance.model.ComplianceValidModel;
import cn.smarthse.modules.health.compliance.model.FieldValidResultModel;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyChangeRecordService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemdataService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyLabelService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanySubitemService;
import cn.smarthse.modules.health.compliance.service.ICompliancePrepareSmsService;
import cn.smarthse.modules.health.compliance.service.IComplianceTryCompanyInfoService;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.util.common.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.xxl.job.core.context.XxlJobHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
public class CalcScoreBusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalcScoreBusService.class);
    @Autowired
    IComplianceCompanyInfoService companyInfoService;
    @Autowired
    IComplianceCompanyItemService itemService;
    @Autowired
    IComplianceCompanySubitemService subitemService;
    @Autowired
    IComplianceCompanyItemdataService itemdataService;
    @Autowired
    IComplianceCompanyItemcodeService itemcodeService;
    @Autowired
    List<ScoreCalcHandle> loseScoreCalcStrategy;
    @Autowired
    private IComplianceCompanyChangeRecordService changeRecordService;
    @Autowired
    private IComplianceCompanyLabelService companyLabelService;
    @Autowired
    private ICompliancePrepareSmsService prepareSmsService;
    @Autowired
    IComplianceTryCompanyInfoService companyTryInfoService;
    @Resource(name="complianceReloadDataThreadPoolExecutor")
    private ThreadPoolExecutor complianceReloadDataThreadPoolExecutor;
    private static final BigDecimal COMPLIANT_SCORE = new BigDecimal("90");
    private static final BigDecimal BASIC_COMPLIANT_SCORE = new BigDecimal("80");
    public static final String COMPLIANCE_CALC_SCORE_LOADTIME = "compliance_calc_score_loadtime";
    Map<String, ScoreCalcHandle> loseStrategyMap = new HashMap<String, ScoreCalcHandle>();

    @PostConstruct
    public void initLoseStrategyMap() {
        for (ScoreCalcHandle scoreCalcStrategy : this.loseScoreCalcStrategy) {
            this.loseStrategyMap.put(scoreCalcStrategy.support(), scoreCalcStrategy);
        }
    }

    public void refreshRefData(List<Long> cids, Map<String, Object> params, Boolean isTrytool, String ... itemCodes) {
        if (ArrayUtils.isEmpty((Object[])itemCodes)) {
            return;
        }
        Map<Long, Long> cidInfoIdRelaMap = this.buildCidInfoIdRelaMap(cids, isTrytool);
        if (MapUtils.isEmpty(cidInfoIdRelaMap)) {
            return;
        }
        List itemCodesList = Arrays.stream(itemCodes).distinct().collect(Collectors.toList());
        List<ComplianceCompanyItemdata> newList = Collections.synchronizedList(new ArrayList());
        CompletableFuture[] futures = (CompletableFuture[])itemCodesList.stream().map(itemCode -> CompletableFuture.runAsync(() -> {
            ScoreCalcHandle loseScoreCalc = this.loseStrategyMap.get(itemCode);
            if (loseScoreCalc == null) {
                return;
            }
            CalcLog timeLog = new CalcLog("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step1:>>" + itemCode);
            List<ComplianceCompanyItemdata> newItemDataList = loseScoreCalc.loadRefData(cids, params);
            timeLog.stop();
            if (CollectionUtils.isEmpty(newItemDataList)) {
                return;
            }
            for (ComplianceCompanyItemdata itemdata : newItemDataList) {
                if (itemdata.getCid() == null) {
                    log.error("\u5f02\u5e38\u6570\u636e\uff0c cid \u4e0d\u80fd\u4e3a\u7a7a\uff0cfinalCids\uff1a{},params:{}", (Object)cids, (Object)params);
                    continue;
                }
                itemdata.setDataType(Integer.valueOf(2));
                itemdata.setComplianceId((Long)cidInfoIdRelaMap.get(itemdata.getCid()));
                newList.add(itemdata);
            }
        }, this.complianceReloadDataThreadPoolExecutor).exceptionally(e -> {
            log.error("complianceReloadDataThreadPoolExecutor\u7ebf\u7a0b\u6c60\u52a0\u8f7d\u7cfb\u7edf\u6570\u636e\u5f02\u5e38", e);
            if (e instanceof InterruptedException) {
                try {
                    throw e;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
            return null;
        })).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        CalcLog loadItemDataTime = new CalcLog("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step1:loadItemDataTime");
        List<ComplianceCompanyItemdata> oldList = Collections.synchronizedList(new ArrayList());
        List dbitemdataList = this.itemdataService.listItemDataByCid(cids, itemCodesList, isTrytool);
        List<ComplianceCompanyItemdata> dbItemDataList = this.model2ItemData(dbitemdataList);
        loadItemDataTime.stop();
        if (CollectionUtils.isNotEmpty(dbItemDataList)) {
            oldList.addAll(dbItemDataList);
        }
        CalcLog saveItemDataCl = new CalcLog("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step1:saveItemData");
        this.itemdataService.saveDataItemData(newList, oldList);
        saveItemDataCl.stop();
        if (Objects.equals(isTrytool, false)) {
            CalcLog saveChangeLogDataCl = new CalcLog("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step1:saveChangeLogData");
            this.handleChangeLogBatch(Arrays.asList(itemCodes), oldList, newList, SourceEnum.SYSTEM);
            saveChangeLogDataCl.stop();
        }
    }

    private Map<Long, Long> buildCidInfoIdRelaMap(List<Long> cids, Boolean isTrytool) {
        if (Boolean.TRUE.equals(isTrytool)) {
            List complianceCids = this.companyTryInfoService.getComplianceCids(cids);
            return complianceCids.stream().collect(Collectors.toMap(ComplianceTryCompanyInfo::getCid, ComplianceTryCompanyInfo::getId, (v1, v2) -> v1));
        }
        List complianceCids = this.companyInfoService.getComplianceCids(cids);
        return complianceCids.stream().collect(Collectors.toMap(ComplianceCompanyInfo::getCid, ComplianceCompanyInfo::getId, (v1, v2) -> v1));
    }

    public List<ComplianceCompanyItemdata> loadRefData(Long cid, Map<String, Object> params, String itemCode) {
        if (StringUtils.isBlank((CharSequence)itemCode)) {
            return null;
        }
        List complianceCids = this.companyInfoService.getComplianceCids(Arrays.asList(cid));
        if (CollectionUtils.isEmpty((Collection)complianceCids)) {
            return null;
        }
        StopWatch st = new StopWatch();
        ScoreCalcHandle loseScoreCalc = this.loseStrategyMap.get(itemCode);
        if (loseScoreCalc == null) {
            log.error("\u672a\u627e\u5230\u8ba1\u7b97\u7b56\u7565,itemCode:{}", (Object)itemCode);
            return null;
        }
        st.start(String.format("\u5f00\u59cb\u52a0\u8f7d\u7cfb\u7edf\u6570\u636ecode:%s ", itemCode));
        List<ComplianceCompanyItemdata> newItemDataList = loseScoreCalc.loadRefData(Arrays.asList(cid), params);
        st.stop();
        log.info("loadRefData\u52a0\u8f7d\u6570\u636e\u8017\u65f6:{}", (Object)st.prettyPrint());
        log.info("loadRefData\u52a0\u8f7d\u6570\u636e\u603b\u8017\u65f6:{}s", (Object)st.getTotalTimeSeconds());
        return newItemDataList;
    }

    public List<ComplianceCompanyItemdata> batchLoadRefData(List<Long> cids, Map<String, Object> params, List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList) || CollectionUtils.isEmpty(cids)) {
            return Collections.emptyList();
        }
        ArrayList<ComplianceCompanyItemdata> result = new ArrayList<ComplianceCompanyItemdata>();
        for (String itemCode : itemCodeList) {
            ScoreCalcHandle loseScoreCalc = this.loseStrategyMap.get(itemCode);
            List<ComplianceCompanyItemdata> itemdataList = loseScoreCalc.loadRefData(cids, params);
            result.addAll(itemdataList);
        }
        return result;
    }

    public void savePromiseData(List<ComplianceCompanyItemdata> promiseDataList, Long cid, boolean needRefresh) {
        if (CollectionUtils.isEmpty(promiseDataList)) {
            return;
        }
        promiseDataList.forEach(p -> p.setCid(cid));
        ComplianceCompanyItemdata promiseData = promiseDataList.get(0);
        Long itemcodeId = promiseData.getItemcodeId();
        Map codeId2Code = this.itemcodeService.getCodeId2Code();
        List<Long> codeIdList = promiseDataList.stream().map(ComplianceCompanyItemdata::getItemcodeId).distinct().collect(Collectors.toList());
        List dbItemDataList = this.itemdataService.listItemDataByCodeId(promiseData.getComplianceId(), codeIdList.toArray(new Long[0]));
        dbItemDataList.forEach(p -> p.setCid(cid));
        try {
            if (needRefresh) {
                this.handleChangeLogBatch(CollUtil.toList((Object[])new String[]{(String)codeId2Code.get(itemcodeId)}), dbItemDataList, promiseDataList, SourceEnum.COMPANY);
            }
        }
        catch (Exception e) {
            log.error("\u627f\u8bfa\u6570\u636e\u4fdd\u5b58\uff1a\u5904\u7406\u53d8\u66f4\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c ", (Throwable)e);
        }
        this.itemdataService.saveDataItemData(promiseDataList, dbItemDataList);
    }

    public List<ComplianceCompanyItemdata> model2ItemData(List<ComplianceCompanyDataModel> dbitemdataList) {
        if (CollectionUtils.isEmpty(dbitemdataList)) {
            return null;
        }
        List<ComplianceCompanyItemdata> list = dbitemdataList.stream().map(model -> {
            ComplianceCompanyItemdata item = new ComplianceCompanyItemdata();
            item.setId(model.getDataId());
            item.setCid(model.getCid());
            item.setFormat(model.getFormat());
            item.setDataType(model.getDataType());
            item.setFieldName(model.getFieldName());
            item.setResultData(model.getResultData());
            item.setComplianceId(model.getInfoId());
            item.setItemcodeId(model.getCodeId());
            return item;
        }).collect(Collectors.toList());
        return list;
    }

    public void handleChangeLogBatch(List<String> codeList, List<ComplianceCompanyItemdata> oldList, List<ComplianceCompanyItemdata> newList, SourceEnum source) {
        if (CollUtil.isEmpty(oldList) || CollUtil.isEmpty(newList)) {
            return;
        }
        long jobId = XxlJobHelper.getJobId();
        CalcLog copyTimeCl = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":step1:handleChangeLogBatch:copyTime");
        CalcScoreBusService.copyMissingData(oldList, newList);
        copyTimeCl.stop();
        CalcLog loadDateCl = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":step1:handleChangeLogBatch:loadDate");
        List cids = newList.stream().map(ComplianceCompanyItemdata::getCid).distinct().collect(Collectors.toList());
        List importantTypeByCids = this.companyInfoService.getImportantTypeByCids(cids);
        Map<Object, Object> cid2ImportantTypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)importantTypeByCids)) {
            cid2ImportantTypeMap = importantTypeByCids.stream().collect(Collectors.toMap(ImportantIndustryCategory::getId, ImportantIndustryCategory::getImportantTypeStr));
        }
        Map<Long, Map<Long, Map<Long, Map<String, ComplianceCompanyItemdata>>>> oldMap = this.buildDataMap(oldList);
        Map<Long, Map<Long, Map<Long, Map<String, ComplianceCompanyItemdata>>>> newMap = this.buildDataMap(newList);
        List itemcodeList = this.itemcodeService.getCacheAllItemcode();
        Map<Long, ComplianceCompanyItemcode> codeMap = itemcodeList.stream().collect(Collectors.toMap(ComplianceCompanyItemcode::getId, v -> v, (v1, v2) -> v1));
        loadDateCl.stop();
        CalcLog handDateCl = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":step1:handleChangeLogBatch:handDate");
        Date currentDate = new Date();
        ArrayList<ComplianceCompanyChangeRecord> logList = new ArrayList<ComplianceCompanyChangeRecord>();
        for (Map.Entry<Long, Map<Long, Map<Long, Map<String, ComplianceCompanyItemdata>>>> oldEntry : oldMap.entrySet()) {
            Long cid = oldEntry.getKey();
            String importantTypeStr = (String)cid2ImportantTypeMap.get(cid);
            Map<Long, Map<Long, Map<String, ComplianceCompanyItemdata>>> oldComplianceMap = oldEntry.getValue();
            Map<Long, Map<Long, Map<String, ComplianceCompanyItemdata>>> newComplianceMap = newMap.get(cid);
            if (!CollUtil.isNotEmpty(newComplianceMap)) continue;
            for (Map.Entry<Long, Map<Long, Map<String, ComplianceCompanyItemdata>>> oldComplianceEntry : oldComplianceMap.entrySet()) {
                Long complianceId = oldComplianceEntry.getKey();
                Map<Long, Map<String, ComplianceCompanyItemdata>> oldItemMap = oldComplianceEntry.getValue();
                Map<Long, Map<String, ComplianceCompanyItemdata>> newItemMap = newComplianceMap.get(complianceId);
                if (!CollUtil.isNotEmpty(newItemMap)) continue;
                for (Map.Entry<Long, Map<String, ComplianceCompanyItemdata>> oldItemEntry : oldItemMap.entrySet()) {
                    boolean noChange;
                    ComplianceCompanyItemcode item;
                    Long itemcodeId = oldItemEntry.getKey();
                    Map<String, ComplianceCompanyItemdata> oldDataMap = oldItemEntry.getValue();
                    Map<String, ComplianceCompanyItemdata> newDataMap = newItemMap.get(itemcodeId);
                    if (!CollUtil.isNotEmpty(newDataMap) || (item = codeMap.get(itemcodeId)) == null) continue;
                    String code = item.getCode();
                    String template = switch (Convert.toInt((Object)itemcodeId)) {
                        case 10501 -> "\u5c97\u524d\u672a\u4f53\u68c0\u4eba\u6570${noBeforeWorkNum}";
                        case 10502 -> "\u5c97\u4e2d\u672a\u4f53\u68c0\u4eba\u6570${noOnWorkNum}";
                        case 10503 -> "\u79bb\u5c97\u672a\u4f53\u68c0\u4eba\u6570${noLeaveWorkNum}";
                        default -> item.getTemplate();
                    };
                    if (itemcodeId == 11502L) {
                        boolean boo1 = Objects.equals(String.valueOf(oldDataMap.get("mainPersonAsFirstLeader").getResultData()), "true");
                        boolean boo2 = Objects.equals(String.valueOf(newDataMap.get("mainPersonAsFirstLeader").getResultData()), "false");
                        if (boo1 && boo2) {
                            ComplianceCompanyItemdata newBean = new ComplianceCompanyItemdata();
                            BeanUtils.copyProperties((Object)newDataMap.get("leaderProveFileName"), (Object)newBean);
                            newBean.setResultData("-");
                            newDataMap.put("leaderProveFileName", newBean);
                        }
                    }
                    String oldData = this.replaceTemplateData(code, itemcodeId, oldDataMap, template);
                    String newData = this.replaceTemplateData(code, itemcodeId, newDataMap, template);
                    ScoreCalcHandle scoreCalcHandle = this.loseStrategyMap.get(code);
                    BigDecimal newScore = scoreCalcHandle.calcLoseScore(itemcodeId, newDataMap, importantTypeStr);
                    BigDecimal oldScore = null;
                    if (oldDataMap != null) {
                        oldScore = scoreCalcHandle.calcLoseScore(itemcodeId, oldDataMap, importantTypeStr);
                    }
                    BigDecimal changeScore = BigDecimal.ZERO;
                    if (newScore != null && oldScore != null) {
                        changeScore = newScore.subtract(oldScore);
                    }
                    if (noChange = Objects.equals(oldData, newData) && BigDecimal.ZERO.compareTo(changeScore) == 0) continue;
                    ComplianceCompanyChangeRecord changeRecord = new ComplianceCompanyChangeRecord().setId(Long.valueOf(IdWorker.getId())).setCid(cid).setComplianceId(complianceId).setItemcodeId(itemcodeId).setOriginalData(oldData).setFinalData(newData).setChangeScore(changeScore).setChangeTime(currentDate).setChangeReason(null).setSource(source.getKey());
                    Long createBy = null;
                    switch (source) {
                        case COMPANY: {
                            createBy = cid;
                            break;
                        }
                        case SUPERVISE: {
                            createBy = newDataMap.values().stream().map(ComplianceCompanyItemdata::getCreateBy).filter(Objects::nonNull).findFirst().orElse(null);
                            break;
                        }
                        case SYSTEM: {
                            createBy = -1L;
                            break;
                        }
                    }
                    changeRecord.setCreateBy(createBy);
                    changeRecord.setCreateDate(currentDate);
                    logList.add(changeRecord);
                }
            }
        }
        handDateCl.stop();
        CalcLog.countIncr("compliance_calc_score_loadtime:" + jobId + ":step1:handleChangeLogBatch:logListSize", logList.size());
        CalcLog saveDateCl = new CalcLog("compliance_calc_score_loadtime:" + jobId + ":step1:handleChangeLogBatch:saveDate");
        this.changeRecordService.doSaveRecordLog(logList);
        saveDateCl.stop();
    }

    public void doRefreshScore(List<Long> cids, boolean isTrytool) {
        CalcLog loadDbScoreDataCl = new CalcLog("loadDbScoreData");
        List dbitemdataList = this.itemdataService.listItemDataByCid(cids, null, Boolean.valueOf(isTrytool));
        if (CollectionUtils.isEmpty((Collection)dbitemdataList)) {
            return;
        }
        List importantTypeByCids = this.companyInfoService.getImportantTypeByCids(cids);
        Map<Object, Object> cid2ImportantTypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)importantTypeByCids)) {
            cid2ImportantTypeMap = importantTypeByCids.stream().collect(Collectors.toMap(ImportantIndustryCategory::getId, v -> v, (v1, v2) -> v1));
        }
        Map<Object, Object> complianceIdMap = new HashMap();
        if (Objects.equals(isTrytool, false)) {
            List complianceStatus = this.companyInfoService.queryScoreByCidList(cids);
            complianceIdMap = complianceStatus.stream().collect(Collectors.toMap(ComplianceCompanyInfo::getId, Function.identity()));
        }
        loadDbScoreDataCl.stop();
        CalcLog handItemDataCl = new CalcLog("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step2:handItemData");
        Map<Long, List<ComplianceCompanyDataModel>> cidDataMap = dbitemdataList.stream().collect(Collectors.groupingBy(ComplianceCompanyDataModel::getCid));
        Set<Long> cidSet = cidDataMap.keySet();
        ArrayList<ComplianceCompanyInfo> infoList = new ArrayList<ComplianceCompanyInfo>();
        ArrayList<ComplianceTryCompanyInfo> tryInfoList = new ArrayList<ComplianceTryCompanyInfo>();
        ArrayList<ComplianceCompanyItem> allitemList = new ArrayList<ComplianceCompanyItem>();
        ArrayList<ComplianceCompanyItem> delitemList = new ArrayList<ComplianceCompanyItem>();
        ArrayList<ComplianceCompanySubitem> allsubitemList = new ArrayList<ComplianceCompanySubitem>();
        Set codeSet = this.itemcodeService.getCode();
        for (Long cid : cidSet) {
            String importantTypeStr = Optional.ofNullable((ImportantIndustryCategory)cid2ImportantTypeMap.get(cid)).map(ImportantIndustryCategory::getImportantTypeStr).orElse(null);
            ArrayList itemList = new ArrayList();
            ArrayList subitemList = new ArrayList();
            List<ComplianceCompanyDataModel> cidDataModels = cidDataMap.get(cid);
            if (CollectionUtils.isEmpty(cidDataModels)) continue;
            Long complianceId = cidDataModels.get(0).getInfoId();
            Map<Long, List<ComplianceCompanyDataModel>> codeIdDataModelMap = cidDataModels.stream().collect(Collectors.groupingBy(ComplianceCompanyDataModel::getCodeId));
            if (MapUtils.isEmpty(codeIdDataModelMap)) continue;
            codeIdDataModelMap.forEach((itemcodeId, itemdataList) -> {
                List subIdSet = itemdataList.stream().map(ComplianceCompanyDataModel::getSubId).distinct().collect(Collectors.toList());
                Long subId = null;
                if (CollectionUtils.isNotEmpty(subIdSet)) {
                    subId = (Long)subIdSet.get(0);
                    if (subIdSet.size() > 1) {
                        for (int i = 1; i < subIdSet.size(); ++i) {
                            ComplianceCompanySubitem subitem = new ComplianceCompanySubitem();
                            subitem.setIsValid(Boolean.valueOf(false));
                            subitem.setId((Long)subIdSet.get(i));
                            subitemList.add(subitem);
                        }
                    }
                }
                ComplianceCompanyDataModel complianceCompanyDataModel = (ComplianceCompanyDataModel)itemdataList.get(0);
                String codecode = complianceCompanyDataModel.getCode();
                ScoreCalcHandle loseScoreCalc = this.loseStrategyMap.get(codecode);
                ComplianceCompanySubitem subitem = new ComplianceCompanySubitem();
                subitem.setComplianceId(complianceId);
                subitem.setItemcodeId(itemcodeId);
                subitem.setItemcodeCode(codecode);
                subitem.setId(subId);
                Map<String, ComplianceCompanyItemdata> fieldsItemDataMap = itemdataList.stream().collect(Collectors.toMap(ComplianceCompanyDataModel::getFieldName, v -> {
                    ComplianceCompanyItemdata itemdata = new ComplianceCompanyItemdata();
                    itemdata.setItemcodeId(v.getCodeId());
                    itemdata.setResultData(v.getResultData());
                    itemdata.setFieldName(v.getFieldName());
                    itemdata.setComplianceId(v.getInfoId());
                    return itemdata;
                }, (v1, v2) -> v1));
                if (MapUtils.isNotEmpty(fieldsItemDataMap)) {
                    try {
                        BigDecimal lose = loseScoreCalc.calcLoseScore((Long)itemcodeId, fieldsItemDataMap, importantTypeStr);
                        subitem.setLoseScore(lose);
                    }
                    catch (Exception e) {
                        log.error("\u8ba1\u7b97\u5931\u5206\u5f02\u5e38, cid:{}, codecode:{},itemcodeId:{}, \u5f02\u5e38\uff1a{}", new Object[]{cid, codecode, itemcodeId, e});
                    }
                    try {
                        Pair<Boolean, String> hasClash = loseScoreCalc.promiseDataClash((Long)itemcodeId, fieldsItemDataMap, importantTypeStr);
                        if (hasClash != null) {
                            subitem.setPromiseDataClash((Boolean)hasClash.getKey());
                            subitem.setPromiseDataClashFieldname(StringUtils.isBlank((CharSequence)((CharSequence)hasClash.getValue())) ? "" : (String)hasClash.getValue());
                        } else {
                            subitem.setPromiseDataClash(Boolean.valueOf(false));
                            subitem.setPromiseDataClashFieldname("");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u627f\u8bfa\u5185\u5bb9\u5f02\u5e38, cid:{}, codecode:{},itemcodeId:{}, \u5f02\u5e38\uff1a{}", new Object[]{cid, codecode, itemcodeId, e});
                    }
                    subitemList.add(subitem);
                }
            });
            if (CollectionUtils.isEmpty(subitemList)) continue;
            allsubitemList.addAll(subitemList);
            Map<String, List<ComplianceCompanyDataModel>> codeModelList = cidDataModels.stream().collect(Collectors.groupingBy(ComplianceCompanyDataModel::getCode));
            HashMap codeItemIdMap = new HashMap();
            codeModelList.forEach((code, itemdataList) -> {
                List itemIdList = itemdataList.stream().map(ComplianceCompanyDataModel::getItemId).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(itemIdList)) {
                    codeItemIdMap.put(code, (Long)itemIdList.get(0));
                    if (CollectionUtils.isNotEmpty(itemIdList)) {
                        for (int i = 1; i < itemIdList.size(); ++i) {
                            ComplianceCompanyItem item = new ComplianceCompanyItem();
                            item.setIsValid(Boolean.valueOf(false));
                            item.setId((Long)itemIdList.get(i));
                            item.setUpdateDate(new Date());
                            item.setUpdateBy(Long.valueOf(110L));
                            itemList.add(item);
                        }
                    }
                }
            });
            Map<String, List<ComplianceCompanySubitem>> subCodeMap = subitemList.stream().filter(f -> Objects.nonNull(f.getItemcodeCode())).collect(Collectors.groupingBy(ComplianceCompanySubitem::getItemcodeCode));
            subCodeMap.forEach((subCode, subItemList) -> {
                ComplianceCompanyItem item = new ComplianceCompanyItem();
                item.setIsValid(Boolean.valueOf(true));
                item.setComplianceId(complianceId);
                item.setItemcodeCode(subCode);
                ScoreCalcHandle loseScoreCalc = this.loseStrategyMap.get(subCode);
                item.setId((Long)codeItemIdMap.get(subCode));
                item.setStatus(Integer.valueOf(1));
                BigDecimal totalScore = loseScoreCalc.itemTotalScore();
                if (totalScore == null) {
                    totalScore = BigDecimal.ZERO;
                }
                BigDecimal totalLoseScore = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty((Collection)subItemList)) {
                    boolean hasClash;
                    for (ComplianceCompanySubitem subitem : subItemList) {
                        if (subitem.getLoseScore() == null) continue;
                        totalLoseScore = totalLoseScore.add(subitem.getLoseScore());
                        totalScore = totalScore.add(subitem.getLoseScore());
                    }
                    if (totalScore.compareTo(BigDecimal.ZERO) < 0) {
                        totalScore = BigDecimal.ZERO;
                    }
                    if (!(hasClash = subItemList.stream().anyMatch(m -> Objects.equals(m.getPromiseDataClash(), true)))) {
                        item.setScore(totalScore);
                    } else {
                        item.setScore(null);
                    }
                    item.setTotalLoseScore(totalLoseScore);
                    item.setPromiseDataClash(Integer.valueOf(hasClash ? 1 : 0));
                }
                itemList.add(item);
            });
            if (CollectionUtils.isEmpty(itemList)) continue;
            Set newDataCodeSet = itemList.stream().map(ComplianceCompanyItem::getItemcodeCode).collect(Collectors.toSet());
            Set surplusCodes = codeSet.stream().filter(f -> !newDataCodeSet.contains(f)).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(surplusCodes)) {
                for (String surplusCode : surplusCodes) {
                    ComplianceCompanyItem delItem = new ComplianceCompanyItem();
                    delItem.setComplianceId(complianceId);
                    delItem.setItemcodeCode(surplusCode);
                    delitemList.add(delItem);
                }
            }
            allitemList.addAll(itemList);
            if (!CollectionUtils.isNotEmpty(itemList)) continue;
            if (Objects.equals(isTrytool, false)) {
                BigDecimal totalScore = itemList.stream().filter(f -> Objects.nonNull(f.getScore())).map(f -> f.getScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
                ComplianceCompanyInfo info2 = new ComplianceCompanyInfo();
                if (totalScore != null && totalScore.compareTo(new BigDecimal("100")) > 0) {
                    totalScore = new BigDecimal("100");
                }
                info2.setComplianceScore(totalScore);
                info2.setId(complianceId);
                ComplianceCompanyInfo oldInfo = (ComplianceCompanyInfo)complianceIdMap.get(complianceId);
                boolean hasClash = itemList.stream().anyMatch(m -> Objects.equals(m.getPromiseDataClash(), 1));
                List<Object> oldLabelList = new ArrayList();
                if (oldInfo != null) {
                    String labels = oldInfo.getLabels();
                    oldLabelList = CommonUtil.str2list((String)labels).stream().distinct().collect(Collectors.toList());
                }
                String clashLabel = String.valueOf(ComplianceInfoLabelEnum.PROMISEDATACLASH.getKey());
                oldLabelList.remove(clashLabel);
                if (hasClash) {
                    oldLabelList.add(clashLabel);
                }
                info2.setLabels(StringUtils.join(oldLabelList, (String)","));
                info2 = this.computedComplianceStatus(info2, oldInfo);
                infoList.add(info2);
                continue;
            }
            ComplianceTryCompanyInfo tryCompanyInfo = new ComplianceTryCompanyInfo();
            tryCompanyInfo.setId(complianceId);
            tryCompanyInfo.setCid(cid);
            BigDecimal totalLoseScore = BigDecimal.ZERO;
            BigDecimal loseScore01 = itemList.stream().filter(f -> Objects.nonNull(f.getTotalLoseScore()) && Objects.equals(f.getItemcodeCode(), "01")).map(f -> f.getTotalLoseScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal loseScore02 = itemList.stream().filter(f -> Objects.nonNull(f.getTotalLoseScore()) && Objects.equals(f.getItemcodeCode(), "02")).map(f -> f.getTotalLoseScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal loseScore05 = itemList.stream().filter(f -> Objects.nonNull(f.getTotalLoseScore()) && Objects.equals(f.getItemcodeCode(), "05")).map(f -> f.getTotalLoseScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal loseScore07 = itemList.stream().filter(f -> Objects.nonNull(f.getTotalLoseScore()) && Objects.equals(f.getItemcodeCode(), "07")).map(f -> f.getTotalLoseScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal loseScore08 = itemList.stream().filter(f -> Objects.nonNull(f.getTotalLoseScore()) && Objects.equals(f.getItemcodeCode(), "08")).map(f -> f.getTotalLoseScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal loseScore10 = itemList.stream().filter(f -> Objects.nonNull(f.getTotalLoseScore()) && Objects.equals(f.getItemcodeCode(), "10")).map(f -> f.getTotalLoseScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
            tryCompanyInfo.setCode01LoseScore(loseScore01);
            tryCompanyInfo.setCode02LoseScore(loseScore02);
            tryCompanyInfo.setCode05LoseScore(loseScore05);
            tryCompanyInfo.setCode07LoseScore(loseScore07);
            tryCompanyInfo.setCode08LoseScore(loseScore08);
            tryCompanyInfo.setCode10LoseScore(loseScore10);
            totalLoseScore = totalLoseScore.add(loseScore01).add(loseScore02).add(loseScore05).add(loseScore07).add(loseScore08).add(loseScore10);
            tryCompanyInfo.setTotalLoseScore(totalLoseScore);
            tryInfoList.add(tryCompanyInfo);
        }
        handItemDataCl.stop();
        CalcLog saveItemDataTimeCl = new CalcLog("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step2:saveItemDataTime");
        if (CollectionUtils.isNotEmpty(infoList)) {
            CalcLog updateComplianceLabelTimeCl = new CalcLog("compliance_calc_score_loadtime:" + CalcLog.getJobId() + ":step2:updateComplianceLabelTime");
            List labels = infoList.stream().map(info -> {
                ComplianceCompanyLabel label = new ComplianceCompanyLabel();
                label.setComplianceId(info.getId());
                label.setLabel(Integer.valueOf(4));
                label.setIsValid(Boolean.valueOf(false));
                List newInfoLabels = CommonUtil.str2list((String)info.getLabels());
                if (newInfoLabels.contains("4")) {
                    label.setIsValid(Boolean.valueOf(true));
                }
                return label;
            }).collect(Collectors.toList());
            this.companyLabelService.updateClashLabel(labels);
            updateComplianceLabelTimeCl.stop();
        }
        ((CalcScoreBusService)SpringContextHolder.getBean(CalcScoreBusService.class)).saveData(allsubitemList, allitemList, delitemList, infoList, tryInfoList);
        saveItemDataTimeCl.stop();
    }

    @Transactional(readOnly=false)
    public void saveData(List<ComplianceCompanySubitem> subitemList, List<ComplianceCompanyItem> itemList, List<ComplianceCompanyItem> delitemList, List<ComplianceCompanyInfo> infoList, List<ComplianceTryCompanyInfo> tryInfoList) {
        if (CollectionUtils.isNotEmpty(delitemList)) {
            this.itemService.delInvalid(delitemList);
        }
        this.itemService.batchUpdateOrInsert(itemList, ComplianceCompanyItemMapper.class, (item, m) -> {
            if (item.getId() == null) {
                item.setCreateDate(new Date());
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setIsValid(Boolean.valueOf(true));
                return m.insert(item);
            }
            item.setUpdateDate(new Date());
            return m.updateComplianceItemByCaclScore((ComplianceCompanyItem)item);
        }, 1000);
        this.subitemService.batchUpdateOrInsert(subitemList, ComplianceCompanySubitemMapper.class, (item, m) -> {
            if (item.getId() == null) {
                item.setCreateDate(new Date());
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setIsValid(Boolean.valueOf(true));
                return m.insert(item);
            }
            item.setUpdateDate(new Date());
            return m.updateByPrimaryKeySelective(item);
        }, 1000);
        this.companyInfoService.batchUpdateOrInsert(infoList, ComplianceCompanyInfoMapper.class, (item, m) -> {
            if (item.getId() == null) {
                item.setCreateDate(new Date());
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setIsValid(Boolean.valueOf(true));
                return m.insert(item);
            }
            item.setUpdateDate(new Date());
            return m.refreshCompliance((ComplianceCompanyInfo)item);
        }, 1000);
        if (CollectionUtils.isNotEmpty(tryInfoList)) {
            this.companyTryInfoService.batchUpdateOrInsert(tryInfoList, ComplianceTryCompanyInfoMapper.class, (item, m) -> {
                if (item.getId() == null) {
                    item.setCreateDate(new Date());
                    item.setId(Long.valueOf(IdWorker.getId()));
                    item.setIsValid(Boolean.valueOf(true));
                    return m.insert(item);
                }
                item.setUpdateDate(new Date());
                return m.updateByPrimaryKeySelective(item);
            }, 1000);
        }
    }

    private Map<Long, Map<Long, Map<Long, Map<String, ComplianceCompanyItemdata>>>> buildDataMap(List<ComplianceCompanyItemdata> dataList) {
        return dataList.stream().filter(f -> f != null && f.getCid() != null && f.getComplianceId() != null && f.getFieldName() != null).collect(Collectors.groupingBy(ComplianceCompanyItemdata::getCid, Collectors.groupingBy(ComplianceCompanyItemdata::getComplianceId, Collectors.groupingBy(ComplianceCompanyItemdata::getItemcodeId, Collectors.toMap(ComplianceCompanyItemdata::getFieldName, Function.identity(), (v1, v2) -> v1)))));
    }

    public String replaceTemplateData(String code, Long itemcodeId, Map<String, ComplianceCompanyItemdata> dataMap, String template) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)template)) {
            return "[" + dataMap.entrySet().stream().map(e -> (String)e.getKey() + "\uff1a" + ((ComplianceCompanyItemdata)e.getValue()).getResultData()).collect(Collectors.joining("]\uff0c[")) + "]";
        }
        String result = template;
        ArrayList<String> changelogList = new ArrayList<String>();
        for (Map.Entry<String, ComplianceCompanyItemdata> entry : dataMap.entrySet()) {
            String placeholder = CalcScoreBusService.getPlaceholder(entry.getKey());
            String replacement = this.loseStrategyMap.get(code).template(itemcodeId, entry.getKey(), entry.getValue().getResultData());
            replacement = replacement == null ? "" : replacement;
            boolean jsonVal = Objects.equals(entry.getValue().getFormat(), 2);
            if (jsonVal) {
                List<JSONObject> jsonArray = new ArrayList();
                if (JSON.isValidArray((String)replacement)) {
                    jsonArray = JSON.parseArray((String)replacement, JSONObject.class);
                } else if (JSON.isValidObject((String)replacement)) {
                    JSONObject jsonObject = JSON.parseObject((String)replacement);
                    jsonArray.add(jsonObject);
                }
                for (JSONObject jsonObj : jsonArray) {
                    if (jsonObj == null) continue;
                    String changelog = template;
                    Set keySet = jsonObj.keySet();
                    for (String s : keySet) {
                        changelog = changelog.replaceAll(CalcScoreBusService.getPlaceholder(s), jsonObj.getString(s));
                    }
                    changelogList.add(changelog);
                }
                continue;
            }
            try {
                result = result.replaceAll(placeholder, replacement);
            }
            catch (Exception e2) {
                result = result.replaceAll(placeholder, Matcher.quoteReplacement(replacement));
            }
        }
        if (CollUtil.isNotEmpty(changelogList)) {
            return changelogList.stream().collect(Collectors.joining("\uff1b"));
        }
        result = result.replaceAll("\\$\\{[^}]*\\}", "-");
        return result;
    }

    private static String getPlaceholder(String fieldName) {
        return "\\$\\{" + fieldName + "\\}";
    }

    public List<ComplianceValidModel> validaFristStepData(Long cid, String ... itemCodes) {
        if (ArrayUtils.isEmpty((Object[])itemCodes)) {
            return Collections.emptyList();
        }
        List itemCodesList = null;
        if (ArrayUtils.isNotEmpty((Object[])itemCodes)) {
            itemCodesList = Arrays.stream(itemCodes).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(itemCodesList)) {
            return Collections.emptyList();
        }
        List dbitemdataList = this.itemdataService.listItemDataByCid(Arrays.asList(cid), itemCodesList, Boolean.valueOf(false));
        ArrayList<ComplianceValidModel> validModels = new ArrayList<ComplianceValidModel>();
        Map<Object, Object> codeCodeIdFieldMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dbitemdataList)) {
            codeCodeIdFieldMap = dbitemdataList.stream().filter(f -> f != null && StringUtils.isNotBlank((CharSequence)f.getCode()) && StringUtils.isNotBlank((CharSequence)f.getFieldName())).collect(Collectors.groupingBy(ComplianceCompanyDataModel::getCode, Collectors.mapping(v -> {
                ComplianceCompanyItemdata d = new ComplianceCompanyItemdata();
                d.setFormat(v.getFormat());
                d.setResultData(v.getResultData());
                d.setFieldName(v.getFieldName());
                d.setItemcodeId(v.getCodeId());
                d.setComplianceId(v.getInfoId());
                return d;
            }, Collectors.toList())));
        }
        List importantTypeByCids = this.companyInfoService.getImportantTypeByCids((List)ListUtil.toList((Object[])new Long[]{cid}));
        String importantTypeStr = null;
        if (CollectionUtils.isNotEmpty((Collection)importantTypeByCids)) {
            importantTypeStr = ((ImportantIndustryCategory)importantTypeByCids.get(0)).getImportantTypeStr();
        }
        for (String itemCode : itemCodesList) {
            ScoreCalcHandle loseScoreCalc = this.loseStrategyMap.get(itemCode);
            if (loseScoreCalc == null) continue;
            List itemdataList = (List)codeCodeIdFieldMap.get(itemCode);
            Map<Object, Object> dbFieldMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)itemdataList)) {
                dbFieldMap = itemdataList.stream().collect(Collectors.toMap(k -> k.getItemcodeId().toString() + k.getFieldName(), v -> v));
            }
            ArrayList<Object> result = new ArrayList<Object>();
            List<ComplianceCompanyItemdata> refDataList = loseScoreCalc.loadRefData(Arrays.asList(cid), null);
            if (CollectionUtils.isNotEmpty(refDataList)) {
                result.addAll(refDataList);
                for (ComplianceCompanyItemdata itemdata : refDataList) {
                    String keyName = itemdata.getItemcodeId().toString() + itemdata.getFieldName();
                    dbFieldMap.remove(keyName);
                }
            }
            if (MapUtils.isNotEmpty(dbFieldMap)) {
                List collect = dbFieldMap.values().stream().collect(Collectors.toList());
                result.addAll(collect);
            }
            Map<Long, Map<String, String>> codeIdFieldMap = null;
            if (CollectionUtils.isNotEmpty(result)) {
                codeIdFieldMap = result.stream().filter(f -> f.getResultData() != null).collect(Collectors.groupingBy(ComplianceCompanyItemdata::getItemcodeId, Collectors.toMap(k -> k.getFieldName(), v -> v.getResultData(), (v1, v2) -> v1)));
            }
            ComplianceValidModel validModel = new ComplianceValidModel();
            List<FieldValidResultModel> fieldResultList = this.getValidResultList(loseScoreCalc, codeIdFieldMap, importantTypeStr);
            if (itemCode.equals("12")) {
                List<FieldValidResultModel> fieldResultListSupply = this.validaCommitmentContent(cid);
                fieldResultList.addAll(fieldResultListSupply);
            }
            if (!CollectionUtils.isNotEmpty(fieldResultList)) continue;
            validModel.setCode(itemCode);
            validModel.setFields(fieldResultList);
            validModels.add(validModel);
        }
        return validModels;
    }

    public List<FieldValidResultModel> validaCommitmentContent(Long cid) {
        ArrayList<FieldValidResultModel> fields = new ArrayList<FieldValidResultModel>();
        Long complianceId = null;
        List complianceCids = this.companyInfoService.getComplianceCids(Collections.singletonList(cid));
        if (CollectionUtils.isNotEmpty((Collection)complianceCids) && complianceCids.get(0) != null) {
            complianceId = ((ComplianceCompanyInfo)complianceCids.get(0)).getId();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("complianceId", complianceId);
        List staffBasicInfo = this.companyInfoService.getCommitmentContent(cid, "staffBasicInfo", map);
        int totalNum = 0;
        for (ComplianceCompanyItemdata itemdata : staffBasicInfo) {
            if (itemdata == null) continue;
            FieldValidResultModel fieldValidResultModel = new FieldValidResultModel();
            if (itemdata.getFieldName().equals("staffTotalNum") && (itemdata.getResultData() == null || itemdata.getResultData().equals("0"))) {
                fieldValidResultModel.setFiledName("staffTotalNum").setReason("\u804c\u5de5\u603b\u4eba\u6570\u4e0d\u80fd\u4e3a\u96f6");
                fields.add(fieldValidResultModel);
            }
            if (itemdata.getFieldName().equals("localNum")) {
                totalNum += StringUtils.isBlank((CharSequence)itemdata.getResultData()) ? 0 : Integer.parseInt(itemdata.getResultData());
            }
            if (!itemdata.getFieldName().equals("outNum")) continue;
            totalNum += StringUtils.isBlank((CharSequence)itemdata.getResultData()) ? 0 : Integer.parseInt(itemdata.getResultData());
        }
        if (totalNum == 0) {
            fields.add(new FieldValidResultModel().setFiledName("localNum").setReason("\u672c\u4f01\u4e1a\u63a5\u5bb3\u4eba\u5458\u548c\u5916\u6765\u63a5\u5bb3\u4eba\u5458\u4e0d\u80fd\u540c\u65f6\u4e3a\u96f6"));
            fields.add(new FieldValidResultModel().setFiledName("outNum").setReason("\u672c\u4f01\u4e1a\u63a5\u5bb3\u4eba\u5458\u548c\u5916\u6765\u63a5\u5bb3\u4eba\u5458\u4e0d\u80fd\u540c\u65f6\u4e3a\u96f6"));
        }
        return fields;
    }

    public List<FieldValidResultModel> getValidResultList(ScoreCalcHandle loseScoreCalc, Map<Long, Map<String, String>> codeIdFieldMap, String importantTypeStr) {
        List<FristStepDataValidRule> fristStepDataValidRules = loseScoreCalc.fristStepDataValueRule(importantTypeStr);
        ArrayList<FieldValidResultModel> resultModels = new ArrayList<FieldValidResultModel>();
        if (CollectionUtils.isNotEmpty(fristStepDataValidRules)) {
            for (FristStepDataValidRule fristStepDataValidRule : fristStepDataValidRules) {
                Long longValue;
                Map<String, String> fieldMap;
                FieldValidResultModel resultModel = new FieldValidResultModel();
                resultModel.setFiledName(fristStepDataValidRule.getFieldName());
                resultModel.setReason(fristStepDataValidRule.getTips());
                resultModels.add(resultModel);
                if (codeIdFieldMap == null || (fieldMap = codeIdFieldMap.get(fristStepDataValidRule.getCodeId())) == null) continue;
                String value = fieldMap.get(fristStepDataValidRule.getFieldName());
                Integer dataType = fristStepDataValidRule.getDataType();
                if (Objects.equals(dataType, 1)) {
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    resultModels.remove(resultModel);
                    continue;
                }
                if (!Objects.equals(dataType, 2) || (longValue = MapUtils.getLong(fieldMap, (Object)fristStepDataValidRule.getFieldName(), (Long)0L)) <= 0L) continue;
                resultModels.remove(resultModel);
            }
        }
        return resultModels;
    }

    public static void copyMissingData(List<ComplianceCompanyItemdata> oldList, List<ComplianceCompanyItemdata> newList) {
        if (CollUtil.isEmpty(oldList) || CollUtil.isEmpty(newList) || oldList.size() == newList.size()) {
            return;
        }
        Set newSet = newList.stream().map(n -> n.getComplianceId() + "-" + n.getItemcodeId() + "-" + n.getFieldName()).collect(Collectors.toSet());
        oldList.stream().filter(o -> !newSet.contains(o.getComplianceId() + "-" + o.getItemcodeId() + "-" + o.getFieldName())).forEach(newList::add);
    }

    public ComplianceCompanyInfo computedComplianceStatus(ComplianceCompanyInfo newScore, ComplianceCompanyInfo oldScore) {
        ComplianceCompanyInfo info = new ComplianceCompanyInfo();
        info.setId(newScore.getId());
        if (oldScore != null) {
            Integer status = oldScore.getStatus();
            info.setStatus(status);
            info.setReformRemainDate(oldScore.getReformRemainDate());
            if (Objects.equals(ComplianceInfoStatusEnum.PRE_COMPLIANCE.getKey(), status) || Objects.equals(ComplianceInfoStatusEnum.NON_COMPLIANCE.getKey(), status)) {
                log.error("\u8fdb\u5165\u5230\u8fd9\u91cc\u662f\u4e0d\u5e94\u8be5\u7684\uff0c \u591a\u5224\u65ad\u4e00\u5c42\uff0c newScore\uff1a{}\uff0c oldScore\uff1a{}", (Object)newScore.toString(), (Object)oldScore.toString());
                info.setStatus(status);
                return info;
            }
        }
        Date oldReformRemainDate = Optional.ofNullable(oldScore).map(ComplianceCompanyInfo::getReformRemainDate).orElse(null);
        BigDecimal oldComplianceScore = Optional.ofNullable(oldScore).map(ComplianceCompanyInfo::getComplianceScore).orElse(null);
        info.setComplianceScore(newScore.getComplianceScore());
        info.setReformRemainDate(oldReformRemainDate);
        if (StringUtils.isNotEmpty((String)newScore.getLabels())) {
            List labelList = CommonUtil.str2IntegerList((String)newScore.getLabels(), (String)",");
            if (ComplianceInfoStatusEnum.COMPLIANT.getKey() == oldScore.getStatus() && labelList.contains(ComplianceInfoLabelEnum.PROMISEDATACLASH.getKey())) {
                try {
                    this.prepareSmsService.addPrepareSms(newScore.getId());
                }
                catch (Exception e) {
                    log.error("\u5408\u89c4\u72b6\u6001\u53d8\u5316-\u53d1\u9001\u77ed\u4fe1\u5931\u8d25", (Throwable)e);
                }
            }
            newScore.setReformRemainDate(oldReformRemainDate);
            newScore.setStatus(ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
            if (oldScore != null && oldScore.getComplianceScore() != null && oldScore.getComplianceScore().compareTo(COMPLIANT_SCORE) >= 0 && newScore.getComplianceScore().compareTo(COMPLIANT_SCORE) < 0) {
                newScore.setReformRemainDate(DateUtils.addDay((Date)new Date(), (int)90));
            }
            if (newScore != null && newScore.getComplianceScore() != null && newScore.getComplianceScore().compareTo(COMPLIANT_SCORE) >= 0 || oldScore != null && oldScore.getReformRemainDate() != null && oldScore.getReformRemainDate().before(new Date())) {
                newScore.setReformRemainDate(null);
            }
            if (oldScore != null && oldScore.getComplianceScore() != null && oldScore.getComplianceScore().compareTo(COMPLIANT_SCORE) >= 0 && Objects.equals(oldScore.getStatus(), ComplianceInfoStatusEnum.COMPLIANT.getKey())) {
                newScore.setLastExitQualifyDate(new Date());
            }
            return newScore;
        }
        if (newScore.getComplianceScore().compareTo(COMPLIANT_SCORE) >= 0) {
            info.setStatus(ComplianceInfoStatusEnum.COMPLIANT.getKey());
            info.setReformRemainDate(null);
            if (oldScore == null || !Objects.equals(oldScore.getStatus(), ComplianceInfoStatusEnum.COMPLIANT.getKey())) {
                info.setQualifyDate(new Date());
            }
        } else if (oldScore != null && oldScore.getComplianceScore() != null && oldScore.getComplianceScore().compareTo(COMPLIANT_SCORE) >= 0 && newScore.getComplianceScore().compareTo(COMPLIANT_SCORE) < 0) {
            info.setStatus(ComplianceInfoStatusEnum.EVALUATION_IN_PROGRESS.getKey());
            info.setReformRemainDate(DateUtils.addDay((Date)new Date(), (int)90));
            if (Objects.equals(oldScore.getStatus(), ComplianceInfoStatusEnum.COMPLIANT.getKey())) {
                info.setLastExitQualifyDate(new Date());
            }
            this.prepareSmsService.addPrepareSms(newScore.getId());
        } else if (oldScore != null && oldScore.getReformRemainDate() != null) {
            if (oldScore.getReformRemainDate().before(new Date())) {
                if (newScore.getComplianceScore().compareTo(BASIC_COMPLIANT_SCORE) >= 0) {
                    info.setStatus(ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey());
                } else {
                    info.setStatus(ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey());
                }
                info.setReformRemainDate(null);
            }
        } else if (newScore.getComplianceScore().compareTo(BASIC_COMPLIANT_SCORE) >= 0) {
            info.setStatus(ComplianceInfoStatusEnum.BASIC_COMPLIANT.getKey());
        } else if (newScore.getComplianceScore().compareTo(BASIC_COMPLIANT_SCORE) < 0) {
            info.setStatus(ComplianceInfoStatusEnum.NON_COMPLIANT_INDEX.getKey());
        }
        if (newScore.getComplianceScore().compareTo(BASIC_COMPLIANT_SCORE) >= 0 && newScore.getComplianceScore().compareTo(COMPLIANT_SCORE) < 0 && (oldComplianceScore == null || oldComplianceScore.compareTo(BASIC_COMPLIANT_SCORE) < 0 || oldComplianceScore.compareTo(COMPLIANT_SCORE) >= 0)) {
            info.setBasicQualifyDate(new Date());
        }
        return info;
    }
}

