/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.Nullable;

public class CalcLog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalcLog.class);
    static RedissonClient redissonClient = (RedissonClient)SpringContextHolder.getBean(RedissonClient.class);
    static RedisTemplate redisTemplate = (RedisTemplate)SpringContextHolder.getBean((String)"redisTemplate");
    static ThreadPoolExecutor complianceReloadDataThreadPoolExecutor = (ThreadPoolExecutor)SpringContextHolder.getBean((String)"complianceReloadDataThreadPoolExecutor");
    static RedisClient redisClient = (RedisClient)SpringContextHolder.getBean(RedisClient.class);
    private long startTime;
    long jobId = 0L;
    @Nullable
    private String taskName;

    public CalcLog(String taskName) {
        this.taskName = taskName;
        this.startTime = System.currentTimeMillis();
        long jobIdTemp = CalcLog.getJobId();
        if (jobIdTemp > 0L) {
            this.jobId = jobIdTemp;
            redisClient.incr(taskName, 0L);
            if (Objects.equals(CalcLog.isDebug(), true)) {
                log.error("\u5f00\u59cb\u6267\u884c\u8282\u70b9:{}", (Object)taskName);
            }
        }
    }

    public CalcLog(String taskName, long jobId) {
        this.taskName = taskName;
        this.startTime = System.currentTimeMillis();
        if (jobId > 0L) {
            this.jobId = jobId;
            redisClient.incr(taskName, 0L);
            if (Objects.equals(CalcLog.isDebug(), true)) {
                log.error("\u5f00\u59cb\u6267\u884c\u8282\u70b9:{}", (Object)taskName);
            }
        }
    }

    public static boolean isDebug() {
        JSONObject jsonObject;
        String jobParam = XxlJobHelper.getJobParam();
        Boolean debug = false;
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObject = JSON.parseObject((String)jobParam)) != null && jsonObject.containsKey("debug")) {
            debug = jsonObject.getBoolean("debug");
        }
        return debug;
    }

    public void stop() throws IllegalStateException {
        if (this.taskName == null) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long lastTime = System.currentTimeMillis() - this.startTime;
        if (this.jobId > 0L) {
            redisClient.incr(this.taskName, lastTime);
            if (Objects.equals(CalcLog.isDebug(), true)) {
                log.error("\u6267\u884c\u8282\u70b9:{} \u7ed3\u675f, \u8017\u65f6\uff1a{} ms", (Object)this.taskName, (Object)lastTime);
            }
        }
        this.taskName = null;
    }

    public static long getJobId() {
        long jobId = XxlJobHelper.getJobId();
        return jobId;
    }

    public static void debug(Runnable r) {
        if (CalcLog.getJobId() > 0L) {
            r.run();
        }
    }

    public static void countIncr(String taskName, int nums) throws IllegalStateException {
        CalcLog.countIncr(taskName, Long.valueOf(nums));
    }

    public static void countIncr(String taskName, Long nums) throws IllegalStateException {
        long jobId = CalcLog.getJobId();
        if (jobId > 0L) {
            redisClient.incr(taskName, nums.longValue());
            if (Objects.equals(CalcLog.isDebug(), true)) {
                log.error("\u6267\u884c\u8282\u70b9:{}, \u6570\u91cf\uff1a{}", (Object)taskName, (Object)nums);
            }
        }
    }

    public static void printTaskInfo(String jobPrefixName, long jobId) {
        try {
            Runtime runtime = Runtime.getRuntime();
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            long maxMemory = runtime.maxMemory();
            long totalMemoryMB = totalMemory / 0x100000L;
            long freeMemoryMB = freeMemory / 0x100000L;
            long maxMemoryMB = maxMemory / 0x100000L;
            XxlJobHelper.log((String)"===================================", (Object[])new Object[0]);
            int activeCount = complianceReloadDataThreadPoolExecutor.getActiveCount();
            int maximumPoolSize = complianceReloadDataThreadPoolExecutor.getMaximumPoolSize();
            int poolSize = complianceReloadDataThreadPoolExecutor.getPoolSize();
            long taskCount = complianceReloadDataThreadPoolExecutor.getTaskCount();
            long completedTaskCount = complianceReloadDataThreadPoolExecutor.getCompletedTaskCount();
            XxlJobHelper.log((String)"activeCount:{},maximumPoolSize:{},poolSize:{},taskCount:{},completedTaskCount:{}", (Object[])new Object[]{activeCount, maximumPoolSize, poolSize, taskCount, completedTaskCount});
            XxlJobHelper.log((String)"Total Memory:{}MB,Free Memory:{}MB,Max Memory:{}MB", (Object[])new Object[]{totalMemoryMB, freeMemoryMB, maxMemoryMB});
            Set keys = redisTemplate.keys((Object)(jobPrefixName + ":" + jobId + "*"));
            if (CollUtil.isNotEmpty((Collection)keys)) {
                List keyList = keys.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                XxlJobHelper.log((String)"  start------------------", (Object[])new Object[0]);
                for (String key : keyList) {
                    if (key.contains("reloadCompanyNum") || key.contains("calcScoreCompanyNum")) {
                        XxlJobHelper.log((String)"\u52a0\u8f7d\u5404\u9879\u6570\u636e\u5206\u522b\u8017\u65f6--key:{},\u5904\u7406\u6570:{}\u4e2a", (Object[])new Object[]{key, redissonClient.getAtomicLong(key)});
                        continue;
                    }
                    RAtomicLong atomicLong = redissonClient.getAtomicLong(key);
                    if (atomicLong == null) continue;
                    XxlJobHelper.log((String)"\u52a0\u8f7d\u5404\u9879\u6570\u636e\u5206\u522b\u8017\u65f6--key:{},\u8017\u65f6:{}s", (Object[])new Object[]{key, atomicLong.get() / 1000L});
                }
                XxlJobHelper.log((String)"  end------------------", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u65e5\u5fd7\u8f93\u51fa\u5f02\u5e38...", (Throwable)e);
        }
    }
}

