/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.compliance.calcscore;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.compliance.calcscore.CalcScoreBusService;
import cn.smarthse.modules.health.compliance.calcscore.handle.PhysicalCheckScoreCalcHandle;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyInfo;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.model.ScoreRefreshModel;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoService;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyItemcodeService;
import cn.smarthse.modules.health.compliance.service.IComplianceScoreRefreshService;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceCodeEnum;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class BusinessDataUpdateRefreshServiceImpl
implements IBusinessDataUpdateRefreshService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessDataUpdateRefreshServiceImpl.class);
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private IComplianceScoreRefreshService refreshService;
    @Autowired
    private IComplianceCompanyInfoService infoService;
    @Autowired
    IComplianceCompanyItemcodeService itemcodeService;
    @Autowired
    private CalcScoreBusService busService;
    @Resource
    PhysicalCheckScoreCalcHandle physicalCheckScoreCalcHandle;
    @Autowired
    private INewBusinessDataUpdateRefreshService newBusinessDataUpdateRefreshService;
    @Resource(name="batchBusinessUpdateThreadPoolExecutor")
    private ThreadPoolExecutor batchBusinessUpdateThreadPoolExecutor;
    private static final String BUSINESSDATA_UPDATE_CID_QUEUE = "third-service:businessdata_updatecid:queuev2";
    private static final String RELOADREFDATA_QUEUE = "third-service:reloadRefData:queue";
    private static final String RELOADREFDATA_LOCKNAME = "third-service:reloadRefData:lock";
    private static final String BUSINESSUPDATE_LOCKNAME = "third-service:businessupdate:lock";
    private static final String CACHE_NAME = "third-service:BusinessDataUpdateRefreshServiceImpl";

    public void realTimeAsyncRefresh(Long cid, Map<String, Object> params, String ... itemCodes) {
        List infoList = (List)this.redisClient.get(CACHE_NAME, "realTimeAsyncRefresh:" + cid, 3600L, () -> {
            List complianceCids = this.infoService.getComplianceCids(Arrays.asList(cid));
            if (CollectionUtils.isEmpty((Collection)complianceCids)) {
                return null;
            }
            return complianceCids;
        });
        if (CollectionUtils.isEmpty((Collection)infoList)) {
            return;
        }
        ScoreRefreshModel sm = new ScoreRefreshModel(Collections.singletonList(cid), params, CommonUtil.str2SortStr((String[])itemCodes));
        RQueue list = this.redissonClient.getQueue(RELOADREFDATA_QUEUE);
        if (!list.contains((Object)sm)) {
            list.add((Object)sm);
        } else {
            log.info("\u5df2\u5b58\u5728\u4efb\u52a1\uff1a{}", (Object)sm.toString());
        }
    }

    public void realTimeAsyncConsumer() {
        RQueue queue = this.redissonClient.getQueue(RELOADREFDATA_QUEUE);
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        List poll;
                        if (CollectionUtils.isNotEmpty((Collection)(poll = queue.poll(1)))) {
                            this.processPollResults(poll);
                            continue;
                        }
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.info("\u961f\u5217\u6570\u636e\u5904\u7406\u7ebf\u7a0b\u5f02\u5e38\u7ec8\u6b62.", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("\u5237\u65b0\u6570\u636e\u65f6\u53d1\u751f\u672a\u77e5\u9519\u8bef: {}", (Throwable)e);
                    continue;
                }
                break;
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPollResults(List<Object> poll) {
        for (Object o : poll) {
            if (o == null) continue;
            if (o instanceof ScoreRefreshModel) {
                ScoreRefreshModel sm = (ScoreRefreshModel)o;
                RLock refreshLock = this.redissonClient.getLock("third-service:reloadRefData:lock:" + sm.hashCode());
                try {
                    if (!refreshLock.tryLock(10L, TimeUnit.SECONDS)) continue;
                    log.info("\u5f00\u59cb\u6d88\u8d39\u6570\u636e\uff1a{}", (Object)sm.toString());
                    this.refreshService.reloadRefData(sm.getCids(), sm.getParams(), new String[]{sm.getItemCodes()});
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("\u83b7\u53d6\u9501\u65f6\u4e2d\u65ad\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                finally {
                    if (refreshLock.isHeldByCurrentThread()) {
                        refreshLock.unlock();
                    }
                    continue;
                }
            }
            log.warn("\u8df3\u8fc7\u975eScoreRefreshModel\u7c7b\u578b\u7684\u5bf9\u8c61: {}", (Object)o.getClass().getName());
        }
    }

    public void handData2Queue(List<Long> cids, Map<String, Object> params, ComplianceCodeEnum ... itemCodes) {
        if (CollectionUtils.isEmpty(cids) || ArrayUtils.isEmpty((Object[])itemCodes)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        try {
            ScoreRefreshModel sm;
            List<Long> finalCids = cids;
            List complianceCids = (List)this.redisClient.get(CACHE_NAME, "handData2Queue" + cids.hashCode(), 7200L, () -> {
                List dbdataList = this.infoService.getComplianceCids(finalCids);
                if (CollectionUtils.isEmpty((Collection)dbdataList)) {
                    return null;
                }
                return dbdataList;
            });
            if (CollectionUtils.isEmpty((Collection)complianceCids)) {
                return;
            }
            cids = complianceCids.stream().map(ComplianceCompanyInfo::getCid).collect(Collectors.toList());
            List itemCodeList = Arrays.stream(itemCodes).map(ComplianceCodeEnum::getCode).collect(Collectors.toList());
            RQueue dataUpdatedQueue = this.redissonClient.getQueue(BUSINESSDATA_UPDATE_CID_QUEUE);
            if (!dataUpdatedQueue.contains((Object)(sm = new ScoreRefreshModel(cids, params, CommonUtil.str2SortStr(itemCodeList))))) {
                dataUpdatedQueue.add((Object)sm);
            } else {
                log.info("\u5df2\u5b58\u5728\u4efb\u52a1\uff1a{}", (Object)sm.toString());
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u6570\u636e\u53d8\u5316\u5165\u961f\u52a8\u4f5c\u51fa\u9519\uff0c{}", (Throwable)e);
        }
    }

    public void batchBusinessDataUpdateMsg(List<Long> cids, Map<String, Object> params, ComplianceCodeEnum ... itemCodes) {
        if (CollectionUtils.isEmpty(cids)) {
            return;
        }
        NewComplianceCodeEnum[] newCodes = (NewComplianceCodeEnum[])Arrays.stream(itemCodes).map(oldEnum -> NewComplianceCodeEnum.valueOf((String)oldEnum.name())).toArray(NewComplianceCodeEnum[]::new);
        this.newBusinessDataUpdateRefreshService.batchBusinessDataUpdateMsg(cids, params, newCodes);
        log.error("\u4e1a\u52a1\u6570\u636e\u53d8\u5316\u6279\u91cf\u5165\u961f\uff0ccids\uff1a{}, params:{}, itemCodes\uff1a{}\uff0c ", new Object[]{cids.size(), params, itemCodes});
    }

    public void addBusinessDataUpdateMsg(Long cid, Map<String, Object> params, ComplianceCodeEnum ... itemCodes) {
        NewComplianceCodeEnum[] newCodes = (NewComplianceCodeEnum[])Arrays.stream(itemCodes).map(oldEnum -> NewComplianceCodeEnum.valueOf((String)oldEnum.name())).toArray(NewComplianceCodeEnum[]::new);
        this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, params, newCodes);
    }

    /*
     * Exception decompiling
     */
    public void exeBussinessDataUpdateTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 6[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void exeBussinessDataUpdateTaskByCid(Long cid) {
        RQueue dataUpdatedQueue = this.redissonClient.getQueue(BUSINESSDATA_UPDATE_CID_QUEUE);
        try {
            List<ScoreRefreshModel> taskList;
            List scoreRefreshModelList = dataUpdatedQueue.readAll();
            if (CollectionUtils.isNotEmpty((Collection)scoreRefreshModelList) && CollectionUtils.isNotEmpty(taskList = scoreRefreshModelList.stream().filter(f -> {
                List cids = f.getCids();
                return cids.size() == 1 && Objects.equals(cid, cids.get(0));
            }).collect(Collectors.toList()))) {
                dataUpdatedQueue.removeAll(taskList);
                this.handleDelayRefreshOneByOneCid(taskList);
            }
        }
        catch (Exception e) {
            log.error("exeBussinessDataUpdateTaskByCid\u5ef6\u8fdf\u6570\u636e\u5904\u7406 cid\u96c6\u5408:{}", (Object)cid);
            log.error("exeBussinessDataUpdateTaskByCid\u5ef6\u8fdf\u6570\u636e\u5904\u7406\u5237\u65b0\u6570\u636e\u65f6\u53d1\u751f\u672a\u77e5\u9519\u8bef: {}", (Throwable)e);
        }
    }

    public void refreshNotComplianceCompanyStaffCheckInfo(List<Long> cidList) {
        this.physicalCheckScoreCalcHandle.loadStaffPhysicalCheckMap(cidList);
    }

    private void handleDelayRefresh(List<ScoreRefreshModel> refreshModels) throws InterruptedException {
        if (CollectionUtils.isEmpty(refreshModels)) {
            log.warn("refreshModels\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        Map<Boolean, List<ScoreRefreshModel>> paramsMap = refreshModels.stream().filter(f -> CollectionUtils.isNotEmpty((Collection)f.getCids())).collect(Collectors.partitioningBy(m -> m.getCids().size() == 1));
        List<ScoreRefreshModel> singleScoreRefreshModelList = paramsMap.get(true);
        List<ScoreRefreshModel> batchScoreRefreshModelList = paramsMap.get(false);
        if (CollectionUtils.isNotEmpty(batchScoreRefreshModelList)) {
            for (ScoreRefreshModel scoreRefreshModel2 : batchScoreRefreshModelList) {
                this.refreshService.reloadRefData(scoreRefreshModel2.getCids(), scoreRefreshModel2.getParams(), StringUtils.splitByWholeSeparator((String)scoreRefreshModel2.getItemCodes(), (String)","));
            }
        }
        if (CollectionUtils.isNotEmpty(singleScoreRefreshModelList)) {
            CompletableFuture[] futures = (CompletableFuture[])singleScoreRefreshModelList.stream().map(scoreRefreshModel -> CompletableFuture.runAsync(() -> this.refreshService.reloadRefData(scoreRefreshModel.getCids(), scoreRefreshModel.getParams(), StringUtils.splitByWholeSeparator((String)scoreRefreshModel.getItemCodes(), (String)",")), this.batchBusinessUpdateThreadPoolExecutor)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
        }
    }

    private void handleDelayRefreshOneByOneCid(List<ScoreRefreshModel> modelList) {
        if (CollectionUtils.isEmpty(modelList)) {
            log.warn("cids\u4e3a\u7a7a\u4e0d\u8fdb\u884c\u6570\u636e\u52a0\u8f7d...");
            return;
        }
        if (CollectionUtils.isNotEmpty(modelList)) {
            ArrayList codeList = new ArrayList();
            for (ScoreRefreshModel scoreRefreshModel : modelList) {
                List strings = CommonUtil.str2list((String)scoreRefreshModel.getItemCodes());
                if (!CollectionUtils.isNotEmpty((Collection)strings)) continue;
                codeList.addAll(strings);
            }
            HashMap paramsResult = new HashMap();
            for (ScoreRefreshModel scoreRefreshModel : modelList) {
                Map params = scoreRefreshModel.getParams();
                if (params == null) continue;
                params.forEach((k, v) -> {
                    if (!paramsResult.containsKey(k)) {
                        paramsResult.put(k, v);
                    } else {
                        Object o = paramsResult.get(k);
                        if (o instanceof String) {
                            List stringList = CommonUtil.str2list((String)((String)o));
                            stringList.add((String)v);
                            paramsResult.put(k, StringUtils.join(new HashSet(stringList), (String)","));
                        }
                    }
                });
            }
            List list = modelList.get(0).getCids();
            this.refreshService.reloadRefData(list, paramsResult, codeList.toArray(new String[codeList.size()]));
        }
    }
}

