/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.utils;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailReturnLogV3;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoTimeCalculationVo;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeConfirmTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeReturnTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeWorkStartEnum;
import cn.smarthse.modules.sys.utils.HolidayUtils;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyChangeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyChangeUtils.class);
    private static final int workCountdown = 2;
    private static final int level3ConfirmedCountdown = 15;

    public static void timeCalculation(CompanyChangeInfoTimeCalculationVo dto, List<CompanyChangeInfoDetailReturnLogV3> returnLogList) {
        if (CompanyChangeConfirmTypeEnum.hand.getCode().equals(dto.getConfirmType()) || CompanyChangeConfirmTypeEnum.auto.getCode().equals(dto.getConfirmType())) {
            return;
        }
        if (CollUtil.isEmpty(returnLogList)) {
            if (CompanyChangeWorkStartEnum.no.getCode().equals(dto.getWorkStart())) {
                dto.setWorkCountdownEnd(HolidayUtils.addWorkDay((Date)dto.getWorkCountdownStart(), (int)2));
            } else if (CompanyChangeWorkStartEnum.hand.getCode().equals(dto.getWorkStart()) || CompanyChangeWorkStartEnum.auto.getCode().equals(dto.getWorkStart())) {
                if (Objects.isNull(dto.getLevel3ConfirmedCountdownStart())) {
                    throw new HealthException("\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5de5\u4f5c\u5df2\u5b89\u6392\u65f6\uff0c\u5fc5\u987b\u6709\u786e\u8ba4\u5012\u8ba1\u65f6\u5f00\u59cb\u65f6\u95f4");
                }
                dto.setLevel3ConfirmedCountdownEnd(HolidayUtils.addWorkDay((Date)dto.getLevel3ConfirmedCountdownStart(), (int)15));
            }
        } else if (CompanyChangeWorkStartEnum.no.getCode().equals(dto.getWorkStart())) {
            dto.setWorkCountdownEnd(HolidayUtils.addWorkDay((Date)dto.getWorkCountdownStart(), (int)2));
        } else if (CompanyChangeWorkStartEnum.hand.getCode().equals(dto.getWorkStart()) || CompanyChangeWorkStartEnum.auto.getCode().equals(dto.getWorkStart())) {
            if (Objects.isNull(dto.getLevel3ConfirmedCountdownStart())) {
                throw new HealthException("\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u5de5\u4f5c\u5df2\u5b89\u6392\u65f6\uff0c\u5fc5\u987b\u6709\u786e\u8ba4\u5012\u8ba1\u65f6\u5f00\u59cb\u65f6\u95f4");
            }
            List returnLogDTOList = returnLogList.stream().filter(i -> Objects.equals(i.getReturnType(), CompanyChangeReturnTypeEnum.already.getCode())).sorted(Comparator.comparing(CompanyChangeInfoDetailReturnLogV3::getReturnTime)).collect(Collectors.toList());
            if (CollUtil.isEmpty(returnLogDTOList)) {
                dto.setLevel3ConfirmedCountdownEnd(HolidayUtils.addWorkDay((Date)dto.getLevel3ConfirmedCountdownStart(), (int)15));
            } else {
                long totalExcludedMillis = 0L;
                for (CompanyChangeInfoDetailReturnLogV3 returnLog : returnLogDTOList) {
                    Date returnTime = returnLog.getReturnTime();
                    Date resubmissionTime = returnLog.getResubmissionTime();
                    if (!Objects.nonNull(returnTime) || !Objects.nonNull(resubmissionTime) || !returnTime.before(resubmissionTime)) continue;
                    Date tempDate = returnTime;
                    long excludedMillis = 0L;
                    while (tempDate.before(resubmissionTime)) {
                        Date nextWorkDay = HolidayUtils.getNextWorkDayDate((Date)tempDate);
                        if (!nextWorkDay.after(resubmissionTime)) {
                            excludedMillis += nextWorkDay.getTime() - tempDate.getTime();
                            tempDate = nextWorkDay;
                            continue;
                        }
                        excludedMillis += resubmissionTime.getTime() - tempDate.getTime();
                        break;
                    }
                    totalExcludedMillis += excludedMillis;
                }
                Date baseDate = HolidayUtils.addWorkDay((Date)dto.getLevel3ConfirmedCountdownStart(), (int)15);
                Date finalDate = new Date(baseDate.getTime() + totalExcludedMillis);
                dto.setLevel3ConfirmedCountdownEnd(finalDate);
            }
        }
    }

    @Generated
    private CompanyChangeUtils() {
    }
}

