/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailReturnLogV3;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoChangeStatusParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeJurisdictionWorkStartParam;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoTimeCalculationVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeNeedAutoAuditChangeVo;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailReturnLogV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.CompanyChangeStatusService;
import cn.smarthse.modules.health.companyChange.v3.utils.CompanyChangeUtils;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeConfirmTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeWorkStartEnum;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.rpc.RpcContext;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Component
public class CompanyChangeTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyChangeTask.class);
    private final CompanyChangeStatusService companyChangeStatusService;
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    private final ICompanyChangeInfoDetailReturnLogV3Service companyChangeInfoDetailReturnLogV3Service;
    private final RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="CompanyChangeTask-v3-autoAudit")
    @Transactional(propagation=Propagation.REQUIRED)
    public void autoAudit() {
        RLock rLock = this.redissonClient.getLock("CompanyChangeTask:v3:autoAudit");
        if (rLock.tryLock()) {
            try {
                XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\u5f00\u59cb", (Object[])new Object[0]);
                StopWatch stopWatch = new StopWatch(this.getClass().getSimpleName());
                stopWatch.start();
                List<CompanyChangeNeedAutoAuditChangeVo> needAutoAuditList = this.companyChangeInfoDetailV3Service.getNeedAutoAuditList();
                if (CollUtil.isNotEmpty(needAutoAuditList)) {
                    XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\uff0c\u9700\u8981\u5904\u7406\u6570\u636e{}\u6761", (Object[])new Object[]{needAutoAuditList.size()});
                    ArrayList<Long> needWorkStartChangeInfoDetailIdList = new ArrayList<Long>();
                    ArrayList<CompanyChangeNeedAutoAuditChangeVo> needConfirmList = new ArrayList<CompanyChangeNeedAutoAuditChangeVo>();
                    Date now = new Date();
                    List<Pair<Long, Long>> changeInfoIdCidPairs = needAutoAuditList.stream().map(item -> new Pair((Object)item.getChangeInfoId(), (Object)item.getCid())).collect(Collectors.toList());
                    Map<Pair<Long, Long>, List<CompanyChangeInfoDetailReturnLogV3>> returnLogMap = this.companyChangeInfoDetailReturnLogV3Service.getResubmissionLogListMap(changeInfoIdCidPairs);
                    for (CompanyChangeNeedAutoAuditChangeVo item2 : needAutoAuditList) {
                        try {
                            List returnLogList = returnLogMap.getOrDefault(new Pair((Object)item2.getChangeInfoId(), (Object)item2.getCid()), new ArrayList());
                            CompanyChangeUtils.timeCalculation((CompanyChangeInfoTimeCalculationVo)item2, returnLogList);
                            if (CompanyChangeWorkStartEnum.no.getCode().equals(item2.getWorkStart())) {
                                if (!item2.getWorkCountdownEnd().before(now)) continue;
                                needWorkStartChangeInfoDetailIdList.add(item2.getChangeInfoDetailId());
                                continue;
                            }
                            if (!item2.getLevel3ConfirmedCountdownEnd().before(now)) continue;
                            needConfirmList.add(item2);
                        }
                        catch (Exception e) {
                            XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4-\u5faa\u73af]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\u51fa\u9519\uff0c\u4f01\u4e1aid\uff1a{}\uff0c\u53d8\u66f4\u8be6\u60c5id\uff1a{}\uff0cexception:{}", (Object[])new Object[]{item2.getCid(), item2.getChangeInfoDetailId(), e.getMessage()});
                            throw e;
                        }
                    }
                    if (CollUtil.isNotEmpty(needWorkStartChangeInfoDetailIdList)) {
                        XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\uff0c\u9700\u8981\u5904\u7406\u6570\u636e{}\u6761", (Object[])new Object[]{needWorkStartChangeInfoDetailIdList.size()});
                        CompanyChangeJurisdictionWorkStartParam param = new CompanyChangeJurisdictionWorkStartParam();
                        param.setChangeInfoDetailIdList(needWorkStartChangeInfoDetailIdList);
                        param.setWorkStart(CompanyChangeWorkStartEnum.auto.getCode());
                        param.setUserId(Constants.SYSTEM_AUTOMATIC_CONFIRMATION_KEY);
                        this.companyChangeInfoDetailV3Service.updateWorkStartWhereStillEq0(param);
                    }
                    if (CollUtil.isNotEmpty(needConfirmList)) {
                        XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4]\u81ea\u52a8\u5ba1\u6838\uff0c\u9700\u8981\u5904\u7406\u6570\u636e{}\u6761", (Object[])new Object[]{needConfirmList.size()});
                        Map needConfirmMap = needConfirmList.stream().collect(Collectors.groupingBy(CompanyChangeNeedAutoAuditChangeVo::getChangeInfoId, Collectors.mapping(CompanyChangeNeedAutoAuditChangeVo::getCid, Collectors.toList())));
                        if (MapUtil.isNotEmpty(needConfirmMap)) {
                            needConfirmMap.forEach((changeInfoId, cidList) -> {
                                CompanyChangeInfoChangeStatusParam param = new CompanyChangeInfoChangeStatusParam();
                                param.setChangeInfoId(changeInfoId);
                                param.setCidList(cidList);
                                param.setStatus(CompanyChangeStatusEnum.CONFIRMED.getCode());
                                param.setFileIds(null);
                                param.setReason(null);
                                param.setConfirmType(CompanyChangeConfirmTypeEnum.auto.getCode());
                                param.setUserAreaId(null);
                                param.setUserId(Constants.SYSTEM_AUTOMATIC_CONFIRMATION_KEY);
                                param.setUserName("\u7cfb\u7edf\u81ea\u52a8\u786e\u8ba4");
                                param.setUserOrgId(null);
                                param.setUserOrgName(null);
                                String operatorId = RpcContext.getServiceContext().getAttachment("operator_id");
                                String operatorName = RpcContext.getServiceContext().getAttachment("operator_name");
                                String ipAddr = RpcContext.getServiceContext().getAttachment("ip_addr");
                                RpcContext.getServiceContext().setAttachment("operator_id", Convert.toStr((Object)Constants.SYSTEM_AUTOMATIC_CONFIRMATION_KEY));
                                RpcContext.getServiceContext().setAttachment("operator_name", "\u7cfb\u7edf\u81ea\u52a8\u786e\u8ba4");
                                RpcContext.getServiceContext().setAttachment("ip_addr", "");
                                this.companyChangeStatusService.changeStatus(param);
                                RpcContext.getServiceContext().setAttachment("operator_id", operatorId);
                                RpcContext.getServiceContext().setAttachment("operator_name", operatorName);
                                RpcContext.getServiceContext().setAttachment("ip_addr", ipAddr);
                            });
                        }
                    }
                }
                stopWatch.stop();
                XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\u7ed3\u675f\uff0c\u5171\u8017\u65f6\uff1a{}\u79d2", (Object[])new Object[]{stopWatch.getTotalTimeSeconds()});
            }
            catch (Exception e) {
                log.error("[\u4fe1\u606f\u53d8\u66f4-result]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\u51fa\u9519\uff1a", (Throwable)e);
                XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\u51fa\u9519\uff1a", (Object[])new Object[]{e});
                XxlJobHelper.handleFail((String)("\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\u51fa\u9519\uff1a" + e.getMessage()));
            }
            finally {
                rLock.unlock();
            }
        } else {
            XxlJobHelper.log((String)"[\u4fe1\u606f\u53d8\u66f4]\u53d8\u66f4\u5de5\u4f5c\u72b6\u6001\u3001\u81ea\u52a8\u5ba1\u6838\uff0c\u5e76\u53d1\u672a\u83b7\u5f97\u9501", (Object[])new Object[0]);
        }
    }

    @Generated
    public CompanyChangeTask(CompanyChangeStatusService companyChangeStatusService, ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ICompanyChangeInfoDetailReturnLogV3Service companyChangeInfoDetailReturnLogV3Service, RedissonClient redissonClient) {
        this.companyChangeStatusService = companyChangeStatusService;
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.companyChangeInfoDetailReturnLogV3Service = companyChangeInfoDetailReturnLogV3Service;
        this.redissonClient = redissonClient;
    }
}

