/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.smarthse.modules.datacentre.enums.CompanyBaseChangeTypeEnum;
import cn.smarthse.modules.datacentre.model.companyBaseChangeInfo.CompanyBaseChangeInfoAddParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyBaseChangeInfoProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByVictimsInfoService;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoVictimsHistoryV3;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoVictimsHistoryV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmOtherAsyncTaskContext;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeVictimsIdentifyEnum;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RefreshService;
import cn.smarthse.snowflake.IdWorker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType8Strategy
extends AbstractCompanyChangeStrategy {
    private final IdWorker idworker;
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoVictimsHistoryV3Service companyChangeInfoVictimsHistoryV3Service;
    @Autowired
    private ICompanyGradeV3RefreshService companyGradeV3RefreshService;
    @DubboReference
    private ICompanyBaseChangeInfoProviderService companyBaseChangeInfoProviderService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByVictimsInfoService victimsInfoService;

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        Long changeInfoId = context.getCompanyChangeInfo().getId();
        Long subOrgId = context.getCompanyChangeInfo().getSubOrgId();
        String subOrgName = context.getCompanyChangeInfo().getSubOrgName();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        LocalDateTime now = LocalDateTime.now();
        int year = now.getYear();
        Map<Long, CompanySuperviseModel> companySuperviseModelMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(cidList);
        ArrayList<CompanyChangeInfoVictimsHistoryV3> changeInfoVictimsHistoryList = new ArrayList<CompanyChangeInfoVictimsHistoryV3>(cidList.size());
        ArrayList<CompanyBaseChangeInfoAddParam> changeInfoList = new ArrayList<CompanyBaseChangeInfoAddParam>(cidList.size());
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setVictimsIdentify(CompanyChangeVictimsIdentifyEnum.L.getCode());
            updateCompanyList.add(company);
            if (!companySuperviseModelMap.containsKey(cid)) continue;
            CompanyChangeInfoVictimsHistoryV3 changeInfoVictimsHistory = new CompanyChangeInfoVictimsHistoryV3();
            changeInfoVictimsHistory.setId(Long.valueOf(this.idworker.nextId()));
            changeInfoVictimsHistory.setYear(Integer.valueOf(year));
            changeInfoVictimsHistory.setChangeInfoId(changeInfoId);
            changeInfoVictimsHistory.setChangeType(CompanyChangeTypeEnum.victimsL3Last.getCode());
            changeInfoVictimsHistory.setCid(cid);
            changeInfoVictimsHistory.setAreaId(companySuperviseModelMap.get(cid).getAreaDetailId());
            changeInfoVictimsHistory.setConfirmTime(now);
            changeInfoVictimsHistory.setSubOrgId(subOrgId);
            changeInfoVictimsHistory.setSubOrgName(subOrgName);
            changeInfoVictimsHistory.setCreateBy(userId);
            changeInfoVictimsHistory.setCreateDate(now);
            changeInfoVictimsHistory.setUpdateBy(userId);
            changeInfoVictimsHistory.setUpdateDate(now);
            changeInfoVictimsHistory.setIsValid(Integer.valueOf(1));
            changeInfoVictimsHistoryList.add(changeInfoVictimsHistory);
            CompanyBaseChangeInfoAddParam cbc = new CompanyBaseChangeInfoAddParam();
            cbc.setCid(cid);
            cbc.setBeforeValue(String.valueOf(companySuperviseModelMap.get(cid).getVictimsIdentify()));
            cbc.setAfterValue(String.valueOf(CompanyChangeVictimsIdentifyEnum.L.getCode()));
            cbc.setBeforeValue2(Objects.isNull(companySuperviseModelMap.get(cid).getPickupCount()) ? "" : String.valueOf(companySuperviseModelMap.get(cid).getPickupCount()));
            cbc.setAfterValue2(null);
            cbc.setChangeType(CompanyBaseChangeTypeEnum.PICKUPCOUNT_VICTIMS.getValue());
            cbc.setChangeTime(new Date());
            cbc.setCreateBy(userId);
            cbc.setUpdateBy(userId);
            changeInfoList.add(cbc);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        this.companyChangeInfoVictimsHistoryV3Service.batchSaveCompanyChangeInfoVictimsHistory(changeInfoVictimsHistoryList);
        this.companyBaseChangeInfoProviderService.batchAddChangeInfo(changeInfoList);
    }

    @Override
    public void handleConfirmOtherAsyncTasks(CompanyChangeConfirmOtherAsyncTaskContext context) {
        List<Long> cidList = context.getCidList();
        this.companyGradeV3RefreshService.refreshCompanyGradeByCids(cidList, CompanyGradeEventSource.COMPANYCHANGE);
        this.victimsInfoService.saveCompanyVictimsTime(cidList);
        this.victimsInfoService.updateIdentifyRealNumSetNull(cidList);
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.victimsL3.getCode();
    }

    @Generated
    public CompanyChangeType8Strategy(IdWorker idworker, ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoVictimsHistoryV3Service companyChangeInfoVictimsHistoryV3Service, ICompanyGradeV3RefreshService companyGradeV3RefreshService, ICompanyBaseChangeInfoProviderService companyBaseChangeInfoProviderService, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyProvideByVictimsInfoService victimsInfoService) {
        this.idworker = idworker;
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoVictimsHistoryV3Service = companyChangeInfoVictimsHistoryV3Service;
        this.companyGradeV3RefreshService = companyGradeV3RefreshService;
        this.companyBaseChangeInfoProviderService = companyBaseChangeInfoProviderService;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.victimsInfoService = victimsInfoService;
    }
}

