/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaDTO;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.AreaModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType6Strategy
extends AbstractCompanyChangeStrategy {
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private IOrganizationService organizationService;

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        Long changeInfoId = context.getCompanyChangeInfo().getId();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<CompanyChangeInfoDetailV3> infoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        if (CollUtil.isEmpty(infoDetailList)) {
            return;
        }
        Map<Long, Long> transferAreaIdMap = infoDetailList.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, CompanyChangeInfoDetailV3::getTransferAreaId));
        List transferAreaIdList = infoDetailList.stream().map(CompanyChangeInfoDetailV3::getTransferAreaId).distinct().collect(Collectors.toList());
        Map transferAreaMap = this.sysAreaProvideService.getAreaMapByIdList(transferAreaIdList);
        List<Long> innnerCidList = infoDetailList.stream().map(CompanyChangeInfoDetailV3::getCid).toList();
        Map<Long, CompanySuperviseModel> companySuperviseMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(innnerCidList);
        List transferRealLevelAreaIdList = companySuperviseMap.values().stream().map(i -> {
            Long transferAreaId = (Long)transferAreaIdMap.get(i.getCid());
            AreaModel area = (AreaModel)transferAreaMap.get(transferAreaId);
            Long areaId = Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : (Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : area.getAreaId());
            return areaId;
        }).distinct().collect(Collectors.toList());
        Map organizationMap = this.organizationService.getOrganizationMapByAreaIdList(transferRealLevelAreaIdList);
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : innnerCidList) {
            Long areaDetailId = transferAreaIdMap.get(cid);
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setAreaDetailId(areaDetailId);
            AreaModel areaModel = (AreaModel)transferAreaMap.get(areaDetailId);
            if (Objects.nonNull(areaModel)) {
                Organization org;
                Long areaId;
                CompanySuperviseModel superviseModel = companySuperviseMap.get(cid);
                if (Objects.nonNull(superviseModel) && Objects.nonNull(areaId = Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getProvinceId() : (Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getCityId() : ((AreaModel)transferAreaMap.get(areaDetailId)).getAreaId())) && Objects.nonNull(org = (Organization)organizationMap.get(areaId))) {
                    company.setSupervisionUnit(org.getId());
                    company.setSupervisionAreaId(org.getAreaId());
                }
            } else {
                company.setSupervisionUnit(Long.valueOf(0L));
                company.setSupervisionAreaId(Long.valueOf(0L));
                company.setBelongType(CompanyBelongTypeEnum.NO.getValue());
            }
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        this.companyProvideBySuperviseService.updateCompanySuperviseByCidList(updateCompanyList, userId);
        CompanyProposedChangeStatusForAreaParam companyProposedChangeStatusForAreaParam = new CompanyProposedChangeStatusForAreaParam();
        companyProposedChangeStatusForAreaParam.setUserId(userId);
        companyProposedChangeStatusForAreaParam.setStopType(StopTypeEnums.CHANGEDISTRICTWITHIN.getCode());
        companyProposedChangeStatusForAreaParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForAreaParam.setConfirmTime(LocalDateTime.now());
        companyProposedChangeStatusForAreaParam.setDtoList(infoDetailList.stream().map(i -> {
            CompanyProposedChangeStatusForAreaDTO dto = new CompanyProposedChangeStatusForAreaDTO();
            dto.setCid(i.getCid());
            dto.setStopAreaId(i.getTransferAreaId());
            return dto;
        }).toList());
        this.companyProposedChangeProviderService.updateStatusForArea(companyProposedChangeStatusForAreaParam);
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.districtMigration.getCode();
    }

    @Generated
    public CompanyChangeType6Strategy(ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyProposedChangeProviderService companyProposedChangeProviderService, ISysAreaProvideService sysAreaProvideService, IOrganizationService organizationService) {
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.companyProposedChangeProviderService = companyProposedChangeProviderService;
        this.sysAreaProvideService = sysAreaProvideService;
        this.organizationService = organizationService;
    }
}

