/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForCidParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmOtherAsyncTaskContext;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.platform.model.AreaModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType5Strategy
extends AbstractCompanyChangeStrategy {
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ISysUserThirdService sysUserThirdService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private IOrganizationService organizationService;

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        Map<Long, CompanySuperviseModel> companySuperviseMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(cidList);
        CompanyChangeType5Strategy.judgeCompanyIrsBusinessState(new ArrayList<CompanySuperviseModel>(companySuperviseMap.values()), null);
        Map<Long, Long> transferAreaIdMap = companySuperviseMap.values().stream().collect(Collectors.toMap(CompanyBaseInfoModel::getCid, CompanyBaseInfoModel::getAreaDetailId));
        List transferAreaIdList = companySuperviseMap.values().stream().map(CompanyBaseInfoModel::getAreaDetailId).distinct().collect(Collectors.toList());
        Map transferAreaMap = this.sysAreaProvideService.getAreaMapByIdList(transferAreaIdList);
        List transferRealLevelAreaIdList = companySuperviseMap.values().stream().map(i -> {
            Long transferAreaId = (Long)transferAreaIdMap.get(i.getCid());
            AreaModel area = (AreaModel)transferAreaMap.get(transferAreaId);
            Long areaId = Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : (Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : area.getAreaId());
            return areaId;
        }).distinct().collect(Collectors.toList());
        Map organizationMap = this.organizationService.getOrganizationMapByAreaIdList(transferRealLevelAreaIdList);
        Date date = new Date();
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            Long areaDetailId = transferAreaIdMap.get(cid);
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setBusinessState(Byte.valueOf(CompanyBusinessState.NORMAL.getCode().byteValue()));
            company.setBusinessUpdateTime(date);
            AreaModel areaModel = (AreaModel)transferAreaMap.get(areaDetailId);
            if (Objects.nonNull(areaModel)) {
                Organization org;
                Long areaId;
                CompanySuperviseModel superviseModel = companySuperviseMap.get(cid);
                if (Objects.nonNull(superviseModel) && Objects.nonNull(areaId = Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getProvinceId() : (Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getCityId() : ((AreaModel)transferAreaMap.get(areaDetailId)).getAreaId())) && Objects.nonNull(org = (Organization)organizationMap.get(areaId))) {
                    company.setSupervisionUnit(org.getId());
                    company.setSupervisionAreaId(org.getAreaId());
                }
            } else {
                company.setSupervisionUnit(Long.valueOf(0L));
                company.setSupervisionAreaId(Long.valueOf(0L));
                company.setBelongType(CompanyBelongTypeEnum.NO.getValue());
            }
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        this.companyProvideBySuperviseService.updateCompanySuperviseByCidList(updateCompanyList, userId);
    }

    @Override
    public void handleConfirmOtherAsyncTasks(CompanyChangeConfirmOtherAsyncTaskContext context) {
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        CompanyProposedChangeStatusForCidParam companyProposedChangeStatusForCidParam = new CompanyProposedChangeStatusForCidParam();
        companyProposedChangeStatusForCidParam.setUserId(userId);
        companyProposedChangeStatusForCidParam.setCidList(cidList);
        companyProposedChangeStatusForCidParam.setStopType(StopTypeEnums.NORMAL.getCode());
        companyProposedChangeStatusForCidParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForCidParam.setConfirmTime(LocalDateTime.now());
        this.companyProposedChangeProviderService.updateStatusForCid(companyProposedChangeStatusForCidParam);
        this.sysUserThirdService.disableOrEnableUserByCidList(cidList, Integer.valueOf(0), userId);
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.restore.getCode();
    }

    @Generated
    public CompanyChangeType5Strategy(ICompanyChangeInfoV3Service companyChangeInfoV3Service, ISysUserThirdService sysUserThirdService, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyProposedChangeProviderService companyProposedChangeProviderService, ISysAreaProvideService sysAreaProvideService, IOrganizationService organizationService) {
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.sysUserThirdService = sysUserThirdService;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.companyProposedChangeProviderService = companyProposedChangeProviderService;
        this.sysAreaProvideService = sysAreaProvideService;
        this.organizationService = organizationService;
    }
}

