/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaDTO;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoV3;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeBackContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeStopContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeSubmitContext;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeDetailStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType4Strategy
extends AbstractCompanyChangeStrategy {
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;

    @Override
    public void handleSubmit(CompanyChangeSubmitContext context) {
        CompanyChangeInfoV3 companyChangeInfo = context.getCompanyChangeInfo();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<Object> infoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(companyChangeInfo.getId(), cidList);
        if (CollUtil.isNotEmpty(infoDetailList) && CollUtil.isNotEmpty(infoDetailList = infoDetailList.stream().filter(i -> CompanyChangeDetailStatusEnum.RETURNED.getCode().equals(i.getDetailStatus()) || CompanyChangeDetailStatusEnum.DRAFT.getCode().equals(i.getDetailStatus())).collect(Collectors.toList()))) {
            CompanyProposedChangeStatusForAreaParam companyProposedChangeStatusForAreaParam = new CompanyProposedChangeStatusForAreaParam();
            companyProposedChangeStatusForAreaParam.setIfSubmit(Boolean.valueOf(true));
            companyProposedChangeStatusForAreaParam.setUserId(userId);
            companyProposedChangeStatusForAreaParam.setStopType(StopTypeEnums.CHANGEWITHIN.getCode());
            companyProposedChangeStatusForAreaParam.setStatus(StopStatusEnums.PROCESS.getCode());
            companyProposedChangeStatusForAreaParam.setConfirmTime(LocalDateTime.now());
            companyProposedChangeStatusForAreaParam.setDtoList(infoDetailList.stream().map(i -> {
                CompanyProposedChangeStatusForAreaDTO dto = new CompanyProposedChangeStatusForAreaDTO();
                dto.setCid(i.getCid());
                dto.setStopAreaId(i.getTransferAreaId());
                return dto;
            }).toList());
            this.companyProposedChangeProviderService.updateStatusForArea(companyProposedChangeStatusForAreaParam);
        }
    }

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        Long changeInfoId = context.getCompanyChangeInfo().getId();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<CompanyChangeInfoDetailV3> infoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        if (CollUtil.isEmpty(infoDetailList)) {
            return;
        }
        Map<Long, Long> transferAreaIdMap = infoDetailList.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, CompanyChangeInfoDetailV3::getTransferAreaId));
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setAreaDetailId(transferAreaIdMap.get(cid));
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        CompanyProposedChangeStatusForAreaParam companyProposedChangeStatusForAreaParam = new CompanyProposedChangeStatusForAreaParam();
        companyProposedChangeStatusForAreaParam.setUserId(userId);
        companyProposedChangeStatusForAreaParam.setStopType(StopTypeEnums.CHANGEWITHIN.getCode());
        companyProposedChangeStatusForAreaParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForAreaParam.setConfirmTime(LocalDateTime.now());
        companyProposedChangeStatusForAreaParam.setDtoList(infoDetailList.stream().map(i -> {
            CompanyProposedChangeStatusForAreaDTO dto = new CompanyProposedChangeStatusForAreaDTO();
            dto.setCid(i.getCid());
            dto.setStopAreaId(i.getTransferAreaId());
            return dto;
        }).toList());
        this.companyProposedChangeProviderService.updateStatusForArea(companyProposedChangeStatusForAreaParam);
    }

    @Override
    public void handleBack(CompanyChangeBackContext context) {
        CompanyChangeInfoV3 companyChangeInfo = context.getCompanyChangeInfo();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
    }

    @Override
    public void handleStop(CompanyChangeStopContext context) {
        CompanyChangeInfoV3 companyChangeInfo = context.getCompanyChangeInfo();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<Object> infoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(companyChangeInfo.getId(), cidList);
        if (CollUtil.isNotEmpty(infoDetailList) && CollUtil.isNotEmpty(infoDetailList = infoDetailList.stream().filter(i -> CompanyChangeDetailStatusEnum.RETURNED.getCode().equals(i.getDetailStatus()) || CompanyChangeDetailStatusEnum.DRAFT.getCode().equals(i.getDetailStatus())).collect(Collectors.toList()))) {
            CompanyProposedChangeStatusForAreaParam companyProposedChangeStatusForAreaParam = new CompanyProposedChangeStatusForAreaParam();
            companyProposedChangeStatusForAreaParam.setUserId(userId);
            companyProposedChangeStatusForAreaParam.setStopType(StopTypeEnums.CHANGEWITHIN.getCode());
            companyProposedChangeStatusForAreaParam.setStatus(StopStatusEnums.RETURNED.getCode());
            companyProposedChangeStatusForAreaParam.setConfirmTime(LocalDateTime.now());
            companyProposedChangeStatusForAreaParam.setDtoList(infoDetailList.stream().map(i -> {
                CompanyProposedChangeStatusForAreaDTO dto = new CompanyProposedChangeStatusForAreaDTO();
                dto.setCid(i.getCid());
                dto.setStopAreaId(i.getTransferAreaId());
                return dto;
            }).toList());
            this.companyProposedChangeProviderService.updateStatusForArea(companyProposedChangeStatusForAreaParam);
        }
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.intraMigration.getCode();
    }

    @Generated
    public CompanyChangeType4Strategy(ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyProposedChangeProviderService companyProposedChangeProviderService) {
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.companyProposedChangeProviderService = companyProposedChangeProviderService;
    }
}

