/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeSubmitContext;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType26Strategy
extends AbstractCompanyChangeStrategy {
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    private final ISysUserThirdService sysUserThirdService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private IOrganizationService organizationService;
    private final IWorkOperateLogService workOperateLogService;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutorToCompanyChange;

    @Override
    public void handleSubmit(CompanyChangeSubmitContext context) {
        Long changeInfoId = context.getCompanyChangeInfo().getId();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<CompanyChangeInfoDetailV3> detailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        for (CompanyChangeInfoDetailV3 detail : detailList) {
            Byte afterScale = detail.getAfterScale();
            if (afterScale != null) continue;
            throw new HealthException("\u8bf7\u9009\u62e9\uff1a\u53d8\u66f4\u540e\u4f01\u4e1a\u89c4\u6a21\uff01");
        }
    }

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        Long changeInfoId = context.getCompanyChangeInfo().getId();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<CompanyChangeInfoDetailV3> detailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        if (CollUtil.isEmpty(detailList)) {
            return;
        }
        this.ycq(detailList, userId);
    }

    private void ycq(List<CompanyChangeInfoDetailV3> detailList, Long userId) {
        this.companyChangeInfoDetailV3Service.updateYcqScaleByDetailList(detailList, userId);
    }

    private void zlwq(List<CompanyChangeInfoDetailV3> detailList, List<Long> cidList, Long userId) {
        Map<Long, Byte> detailScaleMap = detailList.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, CompanyChangeInfoDetailV3::getAfterScale, (v1, v2) -> v2));
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            Byte scale = detailScaleMap.get(cid);
            if (scale != null) {
                company.setScale(Convert.toStr((Object)scale));
            }
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.changeCompanyScale.getCode();
    }

    @Generated
    public CompanyChangeType26Strategy(ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ISysUserThirdService sysUserThirdService, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyProposedChangeProviderService companyProposedChangeProviderService, ISysAreaProvideService sysAreaProvideService, IOrganizationService organizationService, IWorkOperateLogService workOperateLogService, ThreadPoolTaskExecutor threadPoolTaskExecutorToCompanyChange) {
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.sysUserThirdService = sysUserThirdService;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.companyProposedChangeProviderService = companyProposedChangeProviderService;
        this.sysAreaProvideService = sysAreaProvideService;
        this.organizationService = organizationService;
        this.workOperateLogService = workOperateLogService;
        this.threadPoolTaskExecutorToCompanyChange = threadPoolTaskExecutorToCompanyChange;
    }
}

