/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3ChangeClassc;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3ChangeClasscService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RefreshService;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType23Strategy
extends AbstractCompanyChangeStrategy {
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyGradeV3RefreshService companyGradeV3RefreshService;
    @Autowired
    private ICompanyGradeV3ChangeClasscService companyGradeV3ChangeClasscService;

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        Date currentDate = new Date();
        Long changeInfoId = context.getCompanyChangeInfo().getId();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<CompanyChangeInfoDetailV3> detailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        if (CollUtil.isEmpty(detailList)) {
            return;
        }
        ArrayList<CompanyGradeV3ChangeClassc> classcList = new ArrayList<CompanyGradeV3ChangeClassc>();
        for (Long cid : cidList) {
            CompanyGradeV3ChangeClassc classc = new CompanyGradeV3ChangeClassc();
            classc.setId(Long.valueOf(IdWorker.getId()));
            classc.setCid(cid);
            classc.setEvaluateId(null);
            classc.setChangeId(changeInfoId);
            classc.setChangeTime(currentDate);
            classc.setCreateBy(userId);
            classc.setCreateDate(currentDate);
            classc.setUpdateBy(userId);
            classc.setUpdateDate(currentDate);
            classc.setIsValid(Boolean.TRUE);
            classcList.add(classc);
        }
        this.companyGradeV3ChangeClasscService.insertClasscList(classcList);
        this.companyGradeV3RefreshService.refreshCompanyGradeByCids(cidList, CompanyGradeEventSource.COMPANYCHANGE);
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.changeToClassC.getCode();
    }

    @Generated
    public CompanyChangeType23Strategy(ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyGradeV3RefreshService companyGradeV3RefreshService, ICompanyGradeV3ChangeClasscService companyGradeV3ChangeClasscService) {
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.companyGradeV3RefreshService = companyGradeV3RefreshService;
        this.companyGradeV3ChangeClasscService = companyGradeV3ChangeClasscService;
    }
}

