/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType21Strategy
extends AbstractCompanyChangeStrategy {
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        Long changeInfoId = context.getCompanyChangeInfo().getId();
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<CompanyChangeInfoDetailV3> detailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        if (CollUtil.isEmpty(detailList)) {
            return;
        }
        Map<Long, Integer> detailChangeTypeMap = detailList.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, CompanyChangeInfoDetailV3::getChangeType, (v1, v2) -> v2));
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            Integer detailChangeType = detailChangeTypeMap.get(cid);
            CompanyChangeTypeEnum changeTypeEnum = CompanyChangeTypeEnum.getEnum((Integer)detailChangeType);
            boolean isFcyth = changeTypeEnum == CompanyChangeTypeEnum.addDustImportantCompany;
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setIsFcyth(Boolean.valueOf(isFcyth));
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.addDustImportantCompany.getCode();
    }

    @Generated
    public CompanyChangeType21Strategy(ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ICompanyProvideBySuperviseService companyProvideBySuperviseService) {
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
    }
}

