/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForCidParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeBackContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmOtherAsyncTaskContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeStopContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeSubmitContext;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeType1Strategy
extends AbstractCompanyChangeStrategy {
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ISysUserThirdService sysUserThirdService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;

    @Override
    public void handleSubmit(CompanyChangeSubmitContext context) {
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        CompanyProposedChangeStatusForCidParam companyProposedChangeStatusForCidParam = new CompanyProposedChangeStatusForCidParam();
        companyProposedChangeStatusForCidParam.setUserId(userId);
        companyProposedChangeStatusForCidParam.setCidList(cidList);
        companyProposedChangeStatusForCidParam.setStopType(StopTypeEnums.CLOSE.getCode());
        companyProposedChangeStatusForCidParam.setStatus(StopStatusEnums.PROCESS.getCode());
        companyProposedChangeStatusForCidParam.setConfirmTime(LocalDateTime.now());
        this.companyProposedChangeProviderService.updateStatusForCid(companyProposedChangeStatusForCidParam);
    }

    @Override
    public void handleConfirm(CompanyChangeConfirmContext context) {
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        List<CompanySuperviseModel> companyList = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseListByCidExcludeDelete(cidList);
        CompanyChangeType1Strategy.judgeCompanyIrsBusinessState(companyList, null);
        Date date = new Date();
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setBusinessState(Byte.valueOf(CompanyBusinessState.CLOSE.getCode().byteValue()));
            company.setBusinessUpdateTime(date);
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanySuperviseByCidList(updateCompanyList, userId);
    }

    @Override
    public void handleConfirmOtherAsyncTasks(CompanyChangeConfirmOtherAsyncTaskContext context) {
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        CompanyProposedChangeStatusForCidParam companyProposedChangeStatusForCidParam = new CompanyProposedChangeStatusForCidParam();
        companyProposedChangeStatusForCidParam.setUserId(userId);
        companyProposedChangeStatusForCidParam.setCidList(cidList);
        companyProposedChangeStatusForCidParam.setStopType(StopTypeEnums.CLOSE.getCode());
        companyProposedChangeStatusForCidParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForCidParam.setConfirmTime(LocalDateTime.now());
        this.companyProposedChangeProviderService.updateStatusForCid(companyProposedChangeStatusForCidParam);
        this.sysUserThirdService.disableOrEnableUserByCidList(cidList, Integer.valueOf(1), userId);
    }

    @Override
    public void handleBack(CompanyChangeBackContext context) {
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
    }

    @Override
    public void handleStop(CompanyChangeStopContext context) {
        List<Long> cidList = context.getCidList();
        Long userId = context.getUserId();
        if (CollUtil.isNotEmpty(cidList)) {
            CompanyProposedChangeStatusForCidParam companyProposedChangeStatusForCidParam = new CompanyProposedChangeStatusForCidParam();
            companyProposedChangeStatusForCidParam.setUserId(userId);
            companyProposedChangeStatusForCidParam.setCidList(cidList);
            companyProposedChangeStatusForCidParam.setStopType(StopTypeEnums.CLOSE.getCode());
            companyProposedChangeStatusForCidParam.setStatus(StopStatusEnums.RETURNED.getCode());
            companyProposedChangeStatusForCidParam.setConfirmTime(LocalDateTime.now());
            this.companyProposedChangeProviderService.updateStatusForCid(companyProposedChangeStatusForCidParam);
        }
    }

    @Override
    public Integer getSupportedChangeType() {
        return CompanyChangeTypeEnum.delete.getCode();
    }

    @Generated
    public CompanyChangeType1Strategy(ICompanyChangeInfoV3Service companyChangeInfoV3Service, ISysUserThirdService sysUserThirdService, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyProposedChangeProviderService companyProposedChangeProviderService) {
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.sysUserThirdService = sysUserThirdService;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.companyProposedChangeProviderService = companyProposedChangeProviderService;
    }
}

