/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.smarthse.modules.health.companyChange.v3.strategy.CompanyChangeStrategy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyChangeStrategyFactory {
    private final Map<Integer, CompanyChangeStrategy> strategyMap;

    @Autowired
    public CompanyChangeStrategyFactory(List<CompanyChangeStrategy> strategies) {
        this.strategyMap = strategies.stream().collect(Collectors.toMap(CompanyChangeStrategy::getSupportedChangeType, strategy -> strategy, (existing, replacement) -> existing));
    }

    public CompanyChangeStrategy getStrategy(Integer changeType) {
        CompanyChangeStrategy strategy = this.strategyMap.get(changeType);
        if (Objects.isNull(strategy)) {
            throw new HealthException("\u4e0d\u652f\u6301\u7684\u53d8\u66f4\u7c7b\u578b: " + changeType);
        }
        return strategy;
    }
}

