/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailReturnLogV3;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoV3;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoChangeStatusParam;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailReturnLogV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.CompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.CompanyChangeStrategyFactory;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeBackContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeConfirmOtherAsyncTaskContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeStopContext;
import cn.smarthse.modules.health.companyChange.v3.strategy.context.CompanyChangeSubmitContext;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeConfirmTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.snowflake.IdWorker;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class CompanyChangeStatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyChangeStatusService.class);
    private final IdWorker idWorker;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutorToCompanyChange;
    private final CompanyChangeStrategyFactory strategyFactory;
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    private final ICompanyChangeInfoDetailReturnLogV3Service companyChangeInfoDetailReturnLogV3Service;
    private final IWorkOperateLogService workOperateLogService;

    public boolean changeStatus(CompanyChangeInfoChangeStatusParam param) {
        Integer status = param.getStatus();
        if (!(CompanyChangeStatusEnum.DRAFT.getCode().equals(status) || CompanyChangeStatusEnum.SUBMITTED.getCode().equals(status) || CompanyChangeStatusEnum.RETURNED.getCode().equals(status) || CompanyChangeStatusEnum.CONFIRMED.getCode().equals(status) || CompanyChangeStatusEnum.STOPPED.getCode().equals(status))) {
            throw new HealthException("status\u53c2\u6570\u72b6\u6001\u975e\u6cd5");
        }
        CompanyChangeInfoV3 companyChangeInfo = (CompanyChangeInfoV3)this.companyChangeInfoV3Service.getById(param.getChangeInfoId());
        if (Objects.isNull(companyChangeInfo)) {
            throw new HealthException("\u8be5\u53d8\u66f4\u8868\u5355\u4e0d\u5b58\u5728");
        }
        Integer changeType = companyChangeInfo.getChangeType();
        boolean isSpecialType = CompanyChangeTypeEnum.restore.getCode().equals(changeType) || CompanyChangeTypeEnum.districtMigration.getCode().equals(changeType) || CompanyChangeTypeEnum.victimsGE3.getCode().equals(changeType);
        CompanyChangeStrategy strategy = this.strategyFactory.getStrategy(changeType);
        if (Objects.isNull(strategy)) {
            throw new HealthException("\u8be5\u53d8\u66f4\u7c7b\u578b\u5c1a\u672a\u5b9e\u73b0");
        }
        companyChangeInfo.setUpdateBy(param.getUserId());
        companyChangeInfo.setUpdateDate(LocalDateTime.now());
        String fileIds = param.getFileIds();
        if (CompanyChangeStatusEnum.DRAFT.getCode().equals(status)) {
            param.setConfirmType(CompanyChangeConfirmTypeEnum.no.getCode());
            if (StrUtil.isNotBlank((CharSequence)fileIds) && !StrUtil.split((CharSequence)fileIds, (CharSequence)",").isEmpty()) {
                String existingFileIds = companyChangeInfo.getFileIds();
                companyChangeInfo.setFileIds((String)(StrUtil.isNotBlank((CharSequence)existingFileIds) ? existingFileIds + "," + fileIds : fileIds));
            }
            companyChangeInfo.setIsTransProvincial(Integer.valueOf(this.companyChangeInfoV3Service.getIsTransProvincialCount(companyChangeInfo.getId()) > 0L ? 1 : 0));
            return this.handleDraft(strategy, companyChangeInfo);
        }
        if (CompanyChangeStatusEnum.SUBMITTED.getCode().equals(status)) {
            param.setConfirmType(CompanyChangeConfirmTypeEnum.no.getCode());
            if (!isSpecialType && !CompanyChangeTypeEnum.intraMigration.getCode().equals(changeType) && (StrUtil.isBlank((CharSequence)fileIds) || StrUtil.split((CharSequence)fileIds, (CharSequence)",").isEmpty())) {
                throw new HealthException("\u8bf7\u4e0a\u4f20\u51ed\u8bc1");
            }
            companyChangeInfo.setIsTransProvincial(Integer.valueOf(this.companyChangeInfoV3Service.getIsTransProvincialCount(companyChangeInfo.getId()) > 0L ? 1 : 0));
            String existingFileIds = companyChangeInfo.getFileIds();
            companyChangeInfo.setFileIds((String)(StrUtil.isNotBlank((CharSequence)existingFileIds) ? existingFileIds + "," + fileIds : fileIds));
            companyChangeInfo.setAreaId(param.getUserAreaId());
            companyChangeInfo.setSubOrgId(param.getUserOrgId());
            companyChangeInfo.setSubOrgName(param.getUserOrgName());
            companyChangeInfo.setSubTime(LocalDateTime.now());
            if (isSpecialType) {
                param.setConfirmType(CompanyChangeConfirmTypeEnum.hand.getCode());
                companyChangeInfo.setStatus(CompanyChangeStatusEnum.CONFIRMED.getCode());
                companyChangeInfo.setAuditOrgId(param.getUserOrgId());
                companyChangeInfo.setAuditTime(LocalDateTime.now());
                return this.handleConfirm(strategy, companyChangeInfo, param.getCidList(), param.getUserName(), param.getConfirmType(), true);
            }
            companyChangeInfo.setStatus(CompanyChangeStatusEnum.SUBMITTED.getCode());
            return this.handleSubmit(strategy, companyChangeInfo, param.getUserName());
        }
        if (CompanyChangeStatusEnum.RETURNED.getCode().equals(status)) {
            if (StrUtil.isBlank((CharSequence)param.getReason())) {
                throw new HealthException("\u8bf7\u586b\u5199\u9000\u56de\u539f\u56e0");
            }
            companyChangeInfo.setStatus(CompanyChangeStatusEnum.RETURNED.getCode());
            companyChangeInfo.setAuditOrgId(param.getUserOrgId());
            companyChangeInfo.setAuditTime(LocalDateTime.now());
            return this.handleBack(strategy, companyChangeInfo, param.getCidList(), param.getUserName(), param.getReason());
        }
        if (CompanyChangeStatusEnum.CONFIRMED.getCode().equals(status)) {
            if (Objects.isNull(param.getConfirmType())) {
                throw new HealthException("\u8bf7\u9009\u62e9\u786e\u8ba4\u7c7b\u578b");
            }
            companyChangeInfo.setStatus(CompanyChangeStatusEnum.CONFIRMED.getCode());
            companyChangeInfo.setAuditOrgId(param.getUserOrgId());
            companyChangeInfo.setAuditTime(LocalDateTime.now());
            return this.handleConfirm(strategy, companyChangeInfo, param.getCidList(), param.getUserName(), param.getConfirmType(), isSpecialType);
        }
        companyChangeInfo.setStatus(CompanyChangeStatusEnum.STOPPED.getCode());
        companyChangeInfo.setAuditOrgId(param.getUserOrgId());
        companyChangeInfo.setAuditTime(LocalDateTime.now());
        return this.handleStop(strategy, companyChangeInfo, param.getUserName());
    }

    private boolean handleDraft(CompanyChangeStrategy strategy, CompanyChangeInfoV3 companyChangeInfo) {
        strategy.handleDraft();
        boolean b2 = this.companyChangeInfoV3Service.updateStatusForEntity(companyChangeInfo);
        return b2;
    }

    private boolean handleSubmit(CompanyChangeStrategy strategy, CompanyChangeInfoV3 companyChangeInfo, String submitUserName) {
        List<Long> cidList = this.companyChangeInfoDetailV3Service.getOnlyPendingSubmitCidListByChangeInfoId(companyChangeInfo.getId());
        if (CollUtil.isEmpty(cidList)) {
            throw new HealthException("\u6ca1\u6709\u6709\u6548\u6570\u636e");
        }
        try {
            strategy.handleSubmit(new CompanyChangeSubmitContext(companyChangeInfo, cidList, companyChangeInfo.getUpdateBy()));
        }
        catch (Exception e) {
            throw new HealthException(e.getMessage());
        }
        boolean b = this.companyChangeInfoDetailV3Service.updateDetailStatusForSubmit(companyChangeInfo.getId(), companyChangeInfo.getUpdateBy());
        if (!b) {
            return false;
        }
        boolean b2 = this.companyChangeInfoV3Service.updateStatusForEntity(companyChangeInfo);
        if (!b2) {
            return false;
        }
        this.threadPoolTaskExecutorToCompanyChange.execute(() -> this.companyChangeInfoDetailReturnLogV3Service.setResubmissionTime(companyChangeInfo.getId(), (Date)DateUtil.date((TemporalAccessor)companyChangeInfo.getUpdateDate()), cidList, companyChangeInfo.getUpdateBy()));
        this.threadPoolTaskExecutorToCompanyChange.execute(() -> this.workOperateLogService.addCompanyChangeLog(companyChangeInfo.getId(), companyChangeInfo.getUpdateBy(), submitUserName, WorkOperateLogStatusEnum.report.getVal(), cidList, null));
        return true;
    }

    private boolean handleBack(CompanyChangeStrategy strategy, CompanyChangeInfoV3 companyChangeInfo, List<Long> cidList, String auditUserName, String reason) {
        List<CompanyChangeInfoDetailV3> companyChangeInfoDetailV3List;
        if (CollUtil.isEmpty(cidList)) {
            companyChangeInfoDetailV3List = this.companyChangeInfoDetailV3Service.getOnlyPendingConfirmationCompanyChangeInfoDetailV3ListByChangeInfoId(companyChangeInfo.getId(), false, true);
            cidList = companyChangeInfoDetailV3List.stream().map(CompanyChangeInfoDetailV3::getCid).distinct().collect(Collectors.toList());
        } else {
            companyChangeInfoDetailV3List = this.companyChangeInfoDetailV3Service.getOnlyPendingConfirmationCompanyChangeInfoDetailV3ListByChangeInfoIdAndCidList(companyChangeInfo.getId(), cidList, false);
        }
        if (CollUtil.isEmpty(cidList)) {
            throw new HealthException("\u6ca1\u6709\u6709\u6548\u6570\u636e");
        }
        strategy.handleBack(new CompanyChangeBackContext(companyChangeInfo, cidList, companyChangeInfo.getUpdateBy()));
        boolean b = this.companyChangeInfoDetailV3Service.updateDetailStatusForBack(cidList, companyChangeInfo.getId(), companyChangeInfo.getUpdateBy());
        if (!b) {
            return false;
        }
        boolean b2 = this.companyChangeInfoV3Service.updateStatusForEntity(companyChangeInfo);
        if (!b2) {
            return false;
        }
        ArrayList<CompanyChangeInfoDetailReturnLogV3> addCompanyChangeInfoDetailReturnLogV3List = new ArrayList<CompanyChangeInfoDetailReturnLogV3>(companyChangeInfoDetailV3List.size());
        for (CompanyChangeInfoDetailV3 companyChangeInfoDetailV3 : companyChangeInfoDetailV3List) {
            CompanyChangeInfoDetailReturnLogV3 companyChangeInfoDetailReturnLogV3 = new CompanyChangeInfoDetailReturnLogV3();
            companyChangeInfoDetailReturnLogV3.setId(Long.valueOf(this.idWorker.nextId()));
            companyChangeInfoDetailReturnLogV3.setChangeInfoId(companyChangeInfoDetailV3.getChangeInfoId());
            companyChangeInfoDetailReturnLogV3.setChangeInfoDetailId(companyChangeInfoDetailV3.getId());
            companyChangeInfoDetailReturnLogV3.setChangeType(companyChangeInfoDetailV3.getChangeType());
            companyChangeInfoDetailReturnLogV3.setCid(companyChangeInfoDetailV3.getCid());
            companyChangeInfoDetailReturnLogV3.setReturnType(companyChangeInfoDetailV3.getWorkStart());
            companyChangeInfoDetailReturnLogV3.setReturnTime((Date)DateUtil.date((TemporalAccessor)companyChangeInfo.getUpdateDate()));
            companyChangeInfoDetailReturnLogV3.setResubmissionTime(null);
            companyChangeInfoDetailReturnLogV3.setCreateBy(companyChangeInfo.getUpdateBy());
            companyChangeInfoDetailReturnLogV3.setCreateDate(companyChangeInfo.getUpdateDate());
            companyChangeInfoDetailReturnLogV3.setUpdateBy(companyChangeInfo.getUpdateBy());
            companyChangeInfoDetailReturnLogV3.setUpdateDate(companyChangeInfo.getUpdateDate());
            companyChangeInfoDetailReturnLogV3.setIsValid(Integer.valueOf(1));
            addCompanyChangeInfoDetailReturnLogV3List.add(companyChangeInfoDetailReturnLogV3);
        }
        List<Long> finalCidList = cidList;
        this.threadPoolTaskExecutorToCompanyChange.execute(() -> this.companyChangeInfoDetailReturnLogV3Service.addBatch(addCompanyChangeInfoDetailReturnLogV3List));
        this.threadPoolTaskExecutorToCompanyChange.execute(() -> this.workOperateLogService.addCompanyChangeLog(companyChangeInfo.getId(), companyChangeInfo.getUpdateBy(), auditUserName, WorkOperateLogStatusEnum.back.getVal(), finalCidList, reason));
        return true;
    }

    private boolean handleConfirm(CompanyChangeStrategy strategy, CompanyChangeInfoV3 companyChangeInfo, List<Long> cidList, String auditUserName, Integer confirmType, boolean isSpecialType) {
        boolean b2;
        if (CollUtil.isEmpty(cidList)) {
            cidList = this.companyChangeInfoDetailV3Service.getOnlyPendingConfirmationCidListByChangeInfoId(companyChangeInfo.getId(), isSpecialType, true);
        }
        if (CollUtil.isEmpty(cidList)) {
            throw new HealthException("\u6ca1\u6709\u6709\u6548\u6570\u636e");
        }
        try {
            strategy.handleConfirm(new CompanyChangeConfirmContext(companyChangeInfo, cidList, companyChangeInfo.getUpdateBy()));
        }
        catch (Exception e) {
            log.error("[\u4fe1\u606f\u53d8\u66f4]handleConfirm\u5f02\u5e38: ", (Throwable)e);
            throw new HealthException(e.getMessage());
        }
        boolean b = this.companyChangeInfoDetailV3Service.updateDetailStatusForConfirm(cidList, companyChangeInfo.getId(), companyChangeInfo.getUpdateBy(), confirmType, isSpecialType);
        if (!b) {
            return false;
        }
        List<CompanyChangeInfoDetailV3> remainingAuditQuantityList = this.companyChangeInfoDetailV3Service.getRemainingAuditQuantityList(companyChangeInfo.getId());
        if (CollUtil.isEmpty(remainingAuditQuantityList) && !(b2 = this.companyChangeInfoV3Service.updateStatusForEntity(companyChangeInfo))) {
            return false;
        }
        List<Long> finalCidList = cidList;
        this.threadPoolTaskExecutorToCompanyChange.execute(() -> this.workOperateLogService.addCompanyChangeLog(companyChangeInfo.getId(), companyChangeInfo.getUpdateBy(), auditUserName, WorkOperateLogStatusEnum.pass.getVal(), finalCidList, null));
        this.threadPoolTaskExecutorToCompanyChange.execute(() -> strategy.handleConfirmOtherAsyncTasks(new CompanyChangeConfirmOtherAsyncTaskContext(finalCidList, companyChangeInfo.getUpdateBy())));
        return true;
    }

    private boolean handleStop(CompanyChangeStrategy strategy, CompanyChangeInfoV3 companyChangeInfo, String auditUserName) {
        List<Long> cidList = this.companyChangeInfoDetailV3Service.getOnlyPendingStopCidListByChangeInfoId(companyChangeInfo.getId());
        strategy.handleStop(new CompanyChangeStopContext(companyChangeInfo, cidList, companyChangeInfo.getUpdateBy()));
        boolean b2 = this.companyChangeInfoV3Service.updateStatusForEntity(companyChangeInfo);
        if (!b2) {
            return false;
        }
        if (CollUtil.isNotEmpty(cidList)) {
            this.threadPoolTaskExecutorToCompanyChange.execute(() -> this.workOperateLogService.addCompanyChangeLog(companyChangeInfo.getId(), companyChangeInfo.getUpdateBy(), auditUserName, WorkOperateLogStatusEnum.ignore.getVal(), cidList, null));
        }
        this.threadPoolTaskExecutorToCompanyChange.execute(() -> this.workOperateLogService.addCompanyChangeLog(companyChangeInfo.getId(), companyChangeInfo.getUpdateBy(), auditUserName, WorkOperateLogStatusEnum.ignore.getVal(), null, null));
        return true;
    }

    @Generated
    public CompanyChangeStatusService(IdWorker idWorker, ThreadPoolTaskExecutor threadPoolTaskExecutorToCompanyChange, CompanyChangeStrategyFactory strategyFactory, ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ICompanyChangeInfoDetailReturnLogV3Service companyChangeInfoDetailReturnLogV3Service, IWorkOperateLogService workOperateLogService) {
        this.idWorker = idWorker;
        this.threadPoolTaskExecutorToCompanyChange = threadPoolTaskExecutorToCompanyChange;
        this.strategyFactory = strategyFactory;
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.companyChangeInfoDetailReturnLogV3Service = companyChangeInfoDetailReturnLogV3Service;
        this.workOperateLogService = workOperateLogService;
    }
}

