/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.companyChange.v3.dao.CompanyChangeInfoV3Mapper;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoV3;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexAuditAOrViewParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexSubAParam;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoIndexAuditAOrViewAListVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoIndexSubAVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoIndexVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeVictimsL3DataVo;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3Rec;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.fcyth.dao.FcythTbcCompanyMapper;
import cn.smarthse.modules.health.fcyth.entity.FcythTbcCompany;
import cn.smarthse.modules.health.fcyth.service.IFcythTbcCompanyClueService;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@Service
public class CompanyChangeInfoV3ServiceImpl
extends BaseServiceImpl<CompanyChangeInfoV3Mapper, CompanyChangeInfoV3>
implements ICompanyChangeInfoV3Service {
    @Autowired
    private FcythTbcCompanyMapper tbcCompanyMapper;
    @Autowired
    private IFcythTbcCompanyClueService fcythTbcCompanyClueService;
    @Autowired
    private ICompanyGradeV3RecService companyGradeV3RecService;

    @Override
    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseListByCidExcludeDelete(List<Long> cidList) {
        return ((CompanyChangeInfoV3Mapper)this.dao).getCompanyAndCompanySuperviseListByCidExcludeDelete(cidList);
    }

    @Override
    public Map<Long, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByCidExcludeDelete(List<Long> cidList) {
        List<CompanySuperviseModel> list = this.getCompanyAndCompanySuperviseListByCidExcludeDelete(cidList);
        if (CollUtil.isEmpty(list)) {
            return MapUtil.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(CompanyBaseInfoModel::getId, Function.identity()));
    }

    @Override
    public Map<String, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByNameExcludeDelete(List<String> nameList) {
        List<CompanySuperviseModel> list = ((CompanyChangeInfoV3Mapper)this.dao).getCompanyAndCompanySuperviseListByNameExcludeDelete(nameList);
        if (CollUtil.isEmpty(list)) {
            return MapUtil.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(i -> StringUtils.toDBC((String)i.getName()).replaceAll("\uff08", "(").replaceAll("\uff09", ")"), Function.identity()));
    }

    @Override
    public Map<String, List<CompanySuperviseModel>> getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete(List<String> codeList) {
        List<CompanySuperviseModel> list = ((CompanyChangeInfoV3Mapper)this.dao).getCompanyAndCompanySuperviseListByUnitCodeExcludeDelete(codeList);
        if (CollUtil.isEmpty(list)) {
            return MapUtil.newHashMap();
        }
        return list.stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
    }

    @Override
    public PageInfo<CompanyChangeInfoIndexVo> getIndexPage(CompanyChangeInfoIndexParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Integer changeType = param.getChangeType();
        CompanyChangeTypeEnum changeTypeEnum = CompanyChangeTypeEnum.getEnum((Integer)changeType);
        if (changeTypeEnum == CompanyChangeTypeEnum.changeCompanyScale) {
            this.preSetKeywordInfo(param);
        }
        List<CompanyChangeInfoIndexVo> list = ((CompanyChangeInfoV3Mapper)this.dao).getIndexList(param);
        if (changeTypeEnum == CompanyChangeTypeEnum.victimsL3) {
            list.stream().peek(i -> {
                CompanyChangeVictimsL3DataVo dataVo = ((CompanyChangeInfoV3Mapper)this.dao).getVictimsL3DataVo(i.getAreaId(), i.getAreaLevel());
                if (Objects.nonNull(dataVo)) {
                    i.setIsVictimsL3ExceedsHalf(Boolean.valueOf((double)dataVo.getIsVictimsL3Num().intValue() >= (double)dataVo.getIsDecNum().intValue() * 0.3));
                }
            }).collect(Collectors.toList());
        }
        if (changeTypeEnum == CompanyChangeTypeEnum.ocStateChange || changeTypeEnum == CompanyChangeTypeEnum.ocAndComStateChange) {
            for (CompanyChangeInfoIndexVo change : list) {
                Integer dbChangeType = change.getChangeType();
                CompanyChangeTypeEnum dbChangeTypeEnum = CompanyChangeTypeEnum.getEnum((Integer)dbChangeType);
                if (dbChangeTypeEnum == CompanyChangeTypeEnum.ocStateChange) {
                    change.setOption(Integer.valueOf(1));
                    continue;
                }
                if (dbChangeTypeEnum != CompanyChangeTypeEnum.ocChangToEmployUnit) continue;
                change.setOption(Integer.valueOf(2));
            }
        }
        return new PageInfo(list);
    }

    @Override
    public PageInfo<CompanyChangeInfoIndexSubAVo> getIndexSubAPage(CompanyChangeInfoIndexSubAParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<CompanyChangeInfoIndexSubAVo> list = ((CompanyChangeInfoV3Mapper)this.dao).getIndexSubAList(param);
        this.judgementInClueTag(list);
        this.judgeDustForbiddenExit(param, list);
        this.postSetCompanyGradeInfo(param, list);
        return new PageInfo(list);
    }

    @Override
    public PageInfo<CompanyChangeInfoIndexAuditAOrViewAListVo> getIndexSubOrAuditBPage(CompanyChangeInfoIndexAuditAOrViewParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<CompanyChangeInfoIndexAuditAOrViewAListVo> list = ((CompanyChangeInfoV3Mapper)this.dao).getIndexSubOrAuditBList(param);
        return new PageInfo(list);
    }

    @Override
    public long getIndexSubOrAuditBCount(CompanyChangeInfoIndexAuditAOrViewParam param) {
        return PageHelper.count(() -> ((CompanyChangeInfoV3Mapper)this.dao).getIndexSubOrAuditBList(param));
    }

    @Override
    public long getIsTransProvincialCount(Long changeInfoId) {
        return ((CompanyChangeInfoV3Mapper)this.dao).getIsTransProvincialCount(changeInfoId);
    }

    @Override
    @Transactional
    public boolean updateStatusForEntity(CompanyChangeInfoV3 companyChangeInfo) {
        return ((CompanyChangeInfoV3Mapper)this.dao).updateByPrimaryKeySelective(companyChangeInfo) > 0;
    }

    private void preSetKeywordInfo(CompanyChangeInfoIndexParam param) {
        String keyword = param.getKeyword();
        if (CharSequenceUtil.isNotBlank((CharSequence)keyword)) {
            List<Long> changeIdList = ((CompanyChangeInfoV3Mapper)this.dao).getChangeIdListByKeyword(keyword);
            param.setChangeIdList(changeIdList);
        }
    }

    private void judgementInClueTag(List<CompanyChangeInfoIndexSubAVo> companyChangeList) {
        if (CollUtil.isEmpty(companyChangeList)) {
            return;
        }
        List changeCidList = companyChangeList.stream().map(CompanyChangeInfoIndexSubAVo::getCid).collect(Collectors.toList());
        Example example = new Example(FcythTbcCompany.class);
        example.createCriteria().andIn("cid", changeCidList).andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("state", (Object)0);
        List dbCompanyList = this.tbcCompanyMapper.selectByExample(example);
        companyChangeList.forEach(c -> {
            Long changeCid = c.getCid();
            boolean isInDb = dbCompanyList.stream().anyMatch(d -> Objects.equals(changeCid, d.getCid()));
            if (isInDb) {
                c.setAlreadyInClue(Integer.valueOf(1));
            }
        });
    }

    private void judgeDustForbiddenExit(CompanyChangeInfoIndexSubAParam param, List<CompanyChangeInfoIndexSubAVo> companyList) {
        if (CompanyChangeTypeEnum.getEnum((Integer)param.getChangeType()) != CompanyChangeTypeEnum.removeDustImportantCompany) {
            return;
        }
        List cidList = companyList.stream().map(CompanyChangeInfoIndexSubAVo::getCid).collect(Collectors.toList());
        List forbiddenCidList = this.fcythTbcCompanyClueService.getCanNotExitCid(cidList);
        if (forbiddenCidList.isEmpty()) {
            return;
        }
        Set classACidList = Optional.ofNullable(this.companyGradeV3RecService.getGradeByCids(forbiddenCidList)).orElse(Collections.emptyList()).stream().filter(g -> Objects.equals(Convert.toByte((Object)g.getGrade()), CompanyGradeEnum.CLASSA.getValue())).map(CompanyGradeV3Rec::getCid).collect(Collectors.toSet());
        companyList.forEach(company -> {
            if (forbiddenCidList.contains(company.getCid()) && !classACidList.contains(company.getCid())) {
                company.setIsDustForbiddenExit(Boolean.TRUE);
            }
        });
    }

    private void postSetCompanyGradeInfo(CompanyChangeInfoIndexSubAParam param, List<CompanyChangeInfoIndexSubAVo> companyList) {
        if (CompanyChangeTypeEnum.getEnum((Integer)param.getChangeType()) != CompanyChangeTypeEnum.changeToClassC) {
            return;
        }
        for (CompanyChangeInfoIndexSubAVo company : companyList) {
            GradeSourceEnum gradeSource;
            CompanyGradeEnum grade = CompanyGradeEnum.getEnum((Byte)company.getGrade());
            if (grade != null) {
                company.setGradeName(grade.getName());
            }
            if ((gradeSource = GradeSourceEnum.getEnum((Integer)Convert.toInt((Object)company.getGradeSource()))) == null) continue;
            company.setGradeSourceName(gradeSource.getName());
        }
    }
}

