/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.CompanyProposedChange;
import cn.smarthse.modules.health.companyChange.v3.dao.CompanyChangeInfoDetailV3Mapper;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeIndexClueParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeJurisdictionIndexParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeJurisdictionWorkStartParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeStatisticsSearchParam;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeIndexClueVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeJurisdictionAutoAuditChangeVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeJurisdictionIndexVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeNeedAutoAuditChangeVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeStatisticsWithIdentifyDTO;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeConfirmTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeDetailStatusEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@Service
public class CompanyChangeInfoDetailV3ServiceImpl
extends BaseServiceImpl<CompanyChangeInfoDetailV3Mapper, CompanyChangeInfoDetailV3>
implements ICompanyChangeInfoDetailV3Service {
    @Override
    public CompanyChangeInfoDetailV3 getDataByChangeInfoIdAndCid(Long changeInfoId, Long cid) {
        if (Objects.isNull(changeInfoId) || Objects.isNull(cid)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andEqualTo("cid", (Object)cid);
        return (CompanyChangeInfoDetailV3)((CompanyChangeInfoDetailV3Mapper)this.dao).selectOneByExample(example);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getListByChangeInfoIdAndCidList(Long changeInfoId, List<Long> cidList) {
        if (Objects.isNull(changeInfoId) || CollUtil.isEmpty(cidList)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("cid", cidList);
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getListForSubmitValidation(Long changeInfoId) {
        if (Objects.isNull(changeInfoId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("detailStatus", Arrays.asList(CompanyChangeDetailStatusEnum.RETURNED.getCode(), CompanyChangeDetailStatusEnum.DRAFT.getCode()));
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getListByChangeInfoDetailId(List<Long> changeInfoDetailId) {
        if (CollUtil.isEmpty(changeInfoDetailId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("id", changeInfoDetailId);
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getOnlyPendingSubmitCompanyChangeInfoDetailV3ListByChangeInfoId(Long changeInfoId) {
        if (Objects.isNull(changeInfoId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("detailStatus", Arrays.asList(CompanyChangeDetailStatusEnum.RETURNED.getCode(), CompanyChangeDetailStatusEnum.DRAFT.getCode()));
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<Long> getOnlyPendingSubmitCidListByChangeInfoId(Long changeInfoId) {
        return this.getOnlyPendingSubmitCompanyChangeInfoDetailV3ListByChangeInfoId(changeInfoId).stream().map(CompanyChangeInfoDetailV3::getCid).collect(Collectors.toList());
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getOnlyPendingConfirmationListByChangeInfoId(Long changeInfoId, boolean isSpecialType) {
        if (Objects.isNull(changeInfoId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true);
        c.andEqualTo("changeInfoId", (Object)changeInfoId);
        if (isSpecialType) {
            c.andIn("detailStatus", Arrays.asList(CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode(), CompanyChangeDetailStatusEnum.DRAFT.getCode()));
        } else {
            c.andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
        }
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getOnlyPendingConfirmationCompanyChangeInfoDetailV3ListByChangeInfoId(Long changeInfoId, boolean isSpecialType, boolean throwException) {
        List<CompanyChangeInfoDetailV3> list = this.getOnlyPendingConfirmationListByChangeInfoId(changeInfoId, isSpecialType);
        if (CollUtil.isEmpty(list)) {
            if (throwException) {
                throw new HealthException("\u6ca1\u6709\u9700\u8981\u5f85\u786e\u8ba4\u7684\u4f01\u4e1a");
            }
            return CollUtil.newArrayList((Object[])new CompanyChangeInfoDetailV3[0]);
        }
        return list;
    }

    @Override
    public List<Long> getOnlyPendingConfirmationCidListByChangeInfoId(Long changeInfoId, boolean isSpecialType, boolean throwException) {
        return this.getOnlyPendingConfirmationCompanyChangeInfoDetailV3ListByChangeInfoId(changeInfoId, isSpecialType, throwException).stream().map(CompanyChangeInfoDetailV3::getCid).distinct().collect(Collectors.toList());
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getOnlyPendingConfirmationCompanyChangeInfoDetailV3ListByChangeInfoIdAndCidList(Long changeInfoId, List<Long> cidList, boolean isSpecialType) {
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true);
        c.andEqualTo("changeInfoId", (Object)changeInfoId);
        c.andIn("cid", cidList);
        if (isSpecialType) {
            c.andIn("detailStatus", Arrays.asList(CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode(), CompanyChangeDetailStatusEnum.DRAFT.getCode()));
        } else {
            c.andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
        }
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getOnlyPendingStopCompanyChangeInfoDetailV3ListByChangeInfoId(Long changeInfoId) {
        if (Objects.isNull(changeInfoId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.RETURNED.getCode());
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<Long> getOnlyPendingStopCidListByChangeInfoId(Long changeInfoId) {
        return this.getOnlyPendingStopCompanyChangeInfoDetailV3ListByChangeInfoId(changeInfoId).stream().map(CompanyChangeInfoDetailV3::getCid).collect(Collectors.toList());
    }

    @Override
    public List<Long> getCidListInOtherForm(Long changeInfoId, List<Long> toSubmitCidList) {
        if (Objects.isNull(changeInfoId) || CollUtil.isEmpty(toSubmitCidList)) {
            throw new HealthException("\u53c2\u6570\u6709\u8bef");
        }
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).getCidListInOtherForm(changeInfoId, toSubmitCidList);
    }

    @Override
    @Transactional
    public boolean deleteByChangeInfoIdAndCidList(Long changeInfoId, List<Long> cidList) {
        if (Objects.isNull(changeInfoId) || CollUtil.isEmpty(cidList)) {
            return false;
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("cid", cidList);
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).deleteByExample(example) > 0;
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getListByChangeInfoId(Long changeInfoId) {
        if (Objects.isNull(changeInfoId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId);
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getListByChangeInfoIdList(List<Long> changeInfoIdList) {
        if (CollUtil.isEmpty(changeInfoIdList)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("changeInfoId", changeInfoIdList);
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public PageInfo<WorkOperateLog> getJurisdictionOperatePage(JqGridParam jParam, Long areaId, Byte areaLevel, Byte workModule) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<WorkOperateLog> list = ((CompanyChangeInfoDetailV3Mapper)this.dao).getJurisdictionOperateList(areaId, areaLevel, workModule);
        return new PageInfo(list);
    }

    @Override
    @Transactional
    public boolean updateDetailStatusForSubmit(Long changeInfoId, Long userId) {
        if (Objects.isNull(changeInfoId) || Objects.isNull(userId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        CompanyChangeInfoDetailV3 companyChangeInfoDetail = new CompanyChangeInfoDetailV3();
        companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
        companyChangeInfoDetail.setConfirmTime(null);
        companyChangeInfoDetail.setConfirmType(CompanyChangeConfirmTypeEnum.no.getCode());
        companyChangeInfoDetail.setWorkCountdownStart(new Date());
        companyChangeInfoDetail.setUpdateBy(userId);
        companyChangeInfoDetail.setUpdateDate(LocalDateTime.now());
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("detailStatus", Arrays.asList(CompanyChangeDetailStatusEnum.RETURNED.getCode(), CompanyChangeDetailStatusEnum.DRAFT.getCode()));
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).updateByExampleSelective(companyChangeInfoDetail, example) > 0;
    }

    @Override
    @Transactional
    public boolean updateDetailStatusForBack(List<Long> cidList, Long changeInfoId, Long userId) {
        if (CollUtil.isEmpty(cidList) || Objects.isNull(changeInfoId) || Objects.isNull(userId)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        CompanyChangeInfoDetailV3 companyChangeInfoDetail = new CompanyChangeInfoDetailV3();
        companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.RETURNED.getCode());
        companyChangeInfoDetail.setConfirmTime(null);
        companyChangeInfoDetail.setConfirmType(CompanyChangeConfirmTypeEnum.no.getCode());
        companyChangeInfoDetail.setWorkCountdownStart(null);
        companyChangeInfoDetail.setUpdateBy(userId);
        companyChangeInfoDetail.setUpdateDate(LocalDateTime.now());
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("cid", cidList).andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).updateByExampleSelective(companyChangeInfoDetail, example) > 0;
    }

    @Override
    @Transactional
    public boolean updateDetailStatusForConfirm(List<Long> cidList, Long changeInfoId, Long userId, Integer confirmType, boolean isSpecialType) {
        if (CollUtil.isEmpty(cidList) || Objects.isNull(changeInfoId) || Objects.isNull(userId) || Objects.isNull(confirmType)) {
            throw new HealthException("\u53c2\u6570\u9519\u8bef");
        }
        CompanyChangeInfoDetailV3 companyChangeInfoDetail = new CompanyChangeInfoDetailV3();
        companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.CONFIRMED.getCode());
        companyChangeInfoDetail.setConfirmTime(LocalDateTime.now());
        companyChangeInfoDetail.setConfirmType(confirmType);
        companyChangeInfoDetail.setUpdateBy(userId);
        companyChangeInfoDetail.setUpdateDate(LocalDateTime.now());
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("cid", cidList);
        if (isSpecialType) {
            c.andIn("detailStatus", Arrays.asList(CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode(), CompanyChangeDetailStatusEnum.DRAFT.getCode()));
        } else {
            c.andEqualTo("detailStatus", (Object)CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode());
        }
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).updateByExampleSelective(companyChangeInfoDetail, example) > 0;
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getRemainingAuditQuantityList(Long changeInfoId) {
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).getRemainingAuditQuantityList(changeInfoId);
    }

    @Override
    public PageInfo<CompanyChangeJurisdictionIndexVo> getJurisdictionPage(CompanyChangeJurisdictionIndexParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<CompanyChangeJurisdictionIndexVo> list = ((CompanyChangeInfoDetailV3Mapper)this.dao).getJurisdictionList(param);
        return new PageInfo(list);
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getCompanyIsFormalProcessListByCidList(Long changeInfoId, List<Long> cidList) {
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).getCompanyIsFormalProcessListByCidList(changeInfoId, cidList);
    }

    @Override
    public Map<Long, CompanyChangeInfoDetailV3> getCompanyIsFormalProcessMapByCidList(Long changeInfoId, List<Long> cidList) {
        List<CompanyChangeInfoDetailV3> list = this.getCompanyIsFormalProcessListByCidList(changeInfoId, cidList);
        if (CollUtil.isEmpty(list)) {
            return MapUtil.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, Function.identity()));
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getCompanyVictimsListByCidList(int year, Integer changeType, List<Long> cidList) {
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).getCompanyVictimsListByCidList(year, changeType, cidList);
    }

    @Override
    public Map<Long, CompanyChangeInfoDetailV3> getCompanyVictimsMapByCidList(int year, Integer changeType, List<Long> cidList) {
        List<CompanyChangeInfoDetailV3> list = this.getCompanyVictimsListByCidList(year, changeType, cidList);
        if (CollUtil.isEmpty(list)) {
            return MapUtil.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, Function.identity()));
    }

    @Override
    public PageInfo<CompanyChangeJurisdictionAutoAuditChangeVo> getJurisdictionAutoChangeList(JqGridParam jParam, Long areaId, Byte areaLevel) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows(), (boolean)jParam.getCount());
        List<CompanyChangeJurisdictionAutoAuditChangeVo> rst = ((CompanyChangeInfoDetailV3Mapper)this.dao).getJurisdictionAutoChangeList(jParam, areaId, areaLevel);
        return new PageInfo(rst);
    }

    @Override
    @Transactional
    public boolean updateWorkStartWhereStillEq0(CompanyChangeJurisdictionWorkStartParam param) {
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).updateWorkStartWhereStillEq0(param) > 0;
    }

    @Override
    public List<CompanyChangeNeedAutoAuditChangeVo> getNeedAutoAuditList() {
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).getNeedAutoAuditList();
    }

    @Override
    public List<CompanyChangeInfoDetailV3> getJurisdictionListByAreaId(Long areaId, Byte areaLevel) {
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).getJurisdictionListByAreaId(areaId, areaLevel);
    }

    @Override
    public PageInfo<CompanyChangeIndexClueVo> getIndexCluePage(CompanyChangeIndexClueParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<CompanyChangeIndexClueVo> list = ((CompanyChangeInfoDetailV3Mapper)this.dao).getIndexClueList(param);
        return new PageInfo(list);
    }

    @Override
    public List<CompanyProposedChange> getClueStopStatusListByStopTypeAndAreaId(Integer stopType, Long areaId, Byte areaLevel) {
        return ((CompanyChangeInfoDetailV3Mapper)this.dao).getClueStopStatusListByStopTypeAndAreaId(stopType, areaId, areaLevel);
    }

    @Override
    public Map<Long, CompanyChangeStatisticsWithIdentifyDTO> getComChangeStatisticsWithIdentifyCountMap(CompanyChangeStatisticsSearchParam param) {
        List<CompanyChangeStatisticsWithIdentifyDTO> list = ((CompanyChangeInfoDetailV3Mapper)this.dao).getComChangeStatisticsWithIdentifyCountList(param);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(CompanyChangeStatisticsWithIdentifyDTO::getAreaId, item -> item, (v1, v2) -> v1));
    }

    @Override
    @Transactional
    public void updateYcqScaleByDetailList(List<CompanyChangeInfoDetailV3> detailList, Long userId) {
        for (CompanyChangeInfoDetailV3 detail : detailList) {
            ((CompanyChangeInfoDetailV3Mapper)this.dao).updateYcqScaleByDetail(detail, userId);
        }
    }
}

