/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.companyChange.v3.dao.CompanyChangeInfoDetailReturnLogV3Mapper;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailReturnLogV3;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailReturnLogV3Service;
import cn.smarthse.snowflake.IdWorker;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@Service
public class CompanyChangeInfoDetailReturnLogV3ServiceImpl
extends BaseServiceImpl<CompanyChangeInfoDetailReturnLogV3Mapper, CompanyChangeInfoDetailReturnLogV3>
implements ICompanyChangeInfoDetailReturnLogV3Service {
    private final IdWorker idWorker;

    @Override
    @Transactional
    public void addBatch(List<CompanyChangeInfoDetailReturnLogV3> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        this.batchUpdateOrInsert(list, CompanyChangeInfoDetailReturnLogV3Mapper.class, (item, mapper) -> mapper.insertSelective(item));
    }

    @Override
    public List<CompanyChangeInfoDetailReturnLogV3> getResubmissionLogListByChangeInfoIdAndCid(Long changeInfoId, Long cid) {
        if (Objects.isNull(changeInfoId) || Objects.isNull(cid)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailReturnLogV3.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)1).andIsNotNull("resubmissionTime").andEqualTo("changeInfoId", (Object)changeInfoId).andEqualTo("cid", (Object)cid);
        return ((CompanyChangeInfoDetailReturnLogV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    public Map<Pair<Long, Long>, List<CompanyChangeInfoDetailReturnLogV3>> getResubmissionLogListMap(List<Pair<Long, Long>> changeInfoIdCidPairs) {
        if (CollUtil.isEmpty(changeInfoIdCidPairs)) {
            return MapUtil.newHashMap();
        }
        HashSet<Pair<Long, Long>> pairSet = new HashSet<Pair<Long, Long>>(changeInfoIdCidPairs);
        List changeInfoIdList = changeInfoIdCidPairs.stream().map(Pair::getKey).distinct().collect(Collectors.toList());
        List cidList = changeInfoIdCidPairs.stream().map(Pair::getValue).distinct().collect(Collectors.toList());
        Example example = new Example(CompanyChangeInfoDetailReturnLogV3.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)1).andIsNotNull("resubmissionTime").andIn("changeInfoId", changeInfoIdList).andIn("cid", cidList);
        List list = ((CompanyChangeInfoDetailReturnLogV3Mapper)this.dao).selectByExample(example);
        return list.stream().filter(log -> pairSet.contains(new Pair((Object)log.getChangeInfoId(), (Object)log.getCid()))).collect(Collectors.groupingBy(log -> new Pair((Object)log.getChangeInfoId(), (Object)log.getCid())));
    }

    @Override
    public List<CompanyChangeInfoDetailReturnLogV3> getReturnLogListByChangeInfoIdAndCidList(Long changeInfoId, List<Long> cidList) {
        if (Objects.isNull(changeInfoId) || CollUtil.isEmpty(cidList)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Example example = new Example(CompanyChangeInfoDetailReturnLogV3.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)1).andEqualTo("changeInfoId", (Object)changeInfoId).andIn("cid", cidList);
        return ((CompanyChangeInfoDetailReturnLogV3Mapper)this.dao).selectByExample(example);
    }

    @Override
    @Transactional
    public void setResubmissionTime(Long changeInfoId, Date resubmissionTime, List<Long> cidList, Long updateBy) {
        if (CollUtil.isEmpty(cidList)) {
            return;
        }
        List<CompanyChangeInfoDetailReturnLogV3> returnLogV3List = this.getReturnLogListByChangeInfoIdAndCidList(changeInfoId, cidList);
        if (CollUtil.isEmpty(returnLogV3List)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        Map<Long, CompanyChangeInfoDetailReturnLogV3> latestLogMap = returnLogV3List.stream().collect(Collectors.toMap(CompanyChangeInfoDetailReturnLogV3::getCid, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(CompanyChangeInfoDetailReturnLogV3::getCreateDate))));
        latestLogMap.values().forEach(log -> {
            log.setResubmissionTime(resubmissionTime);
            log.setUpdateBy(updateBy);
            log.setUpdateDate(now);
        });
        this.batchUpdateOrInsert(new ArrayList<CompanyChangeInfoDetailReturnLogV3>(latestLogMap.values()), CompanyChangeInfoDetailReturnLogV3Mapper.class, (log, mapper) -> mapper.updateByPrimaryKeySelective(log));
    }

    @Override
    @Transactional
    public void setResubmissionTimeAndTakeCareMiss(Long changeInfoId, Date resubmissionTime, List<CompanyChangeInfoDetailV3> companyChangeInfoDetailV3List, Long updateBy) {
        if (CollUtil.isEmpty(companyChangeInfoDetailV3List)) {
            return;
        }
        List<Long> cidList = companyChangeInfoDetailV3List.stream().map(CompanyChangeInfoDetailV3::getCid).collect(Collectors.toList());
        List<CompanyChangeInfoDetailReturnLogV3> returnLogList = this.getReturnLogListByChangeInfoIdAndCidList(changeInfoId, cidList);
        LocalDateTime now = LocalDateTime.now();
        if (CollUtil.isNotEmpty(returnLogList)) {
            Map<Long, CompanyChangeInfoDetailReturnLogV3> latestLogMap = returnLogList.stream().collect(Collectors.toMap(CompanyChangeInfoDetailReturnLogV3::getCid, Function.identity(), BinaryOperator.maxBy(Comparator.comparing(CompanyChangeInfoDetailReturnLogV3::getCreateDate))));
            latestLogMap.values().forEach(log -> {
                log.setResubmissionTime(resubmissionTime);
                log.setUpdateBy(updateBy);
                log.setUpdateDate(now);
            });
            this.batchUpdateOrInsert(new ArrayList<CompanyChangeInfoDetailReturnLogV3>(latestLogMap.values()), CompanyChangeInfoDetailReturnLogV3Mapper.class, (log, mapper) -> mapper.updateByPrimaryKeySelective(log));
            Set existingCidSet = returnLogList.stream().map(CompanyChangeInfoDetailReturnLogV3::getCid).collect(Collectors.toSet());
            List missingDetails = companyChangeInfoDetailV3List.stream().filter(detail -> !existingCidSet.contains(detail.getCid())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(missingDetails)) {
                ArrayList<CompanyChangeInfoDetailReturnLogV3> addCompanyChangeInfoDetailReturnLogV3List = new ArrayList<CompanyChangeInfoDetailReturnLogV3>(missingDetails.size());
                for (CompanyChangeInfoDetailV3 companyChangeInfoDetailV3 : missingDetails) {
                    CompanyChangeInfoDetailReturnLogV3 companyChangeInfoDetailReturnLogV3 = new CompanyChangeInfoDetailReturnLogV3();
                    companyChangeInfoDetailReturnLogV3.setId(Long.valueOf(this.idWorker.nextId()));
                    companyChangeInfoDetailReturnLogV3.setChangeInfoId(companyChangeInfoDetailV3.getChangeInfoId());
                    companyChangeInfoDetailReturnLogV3.setChangeInfoDetailId(companyChangeInfoDetailV3.getId());
                    companyChangeInfoDetailReturnLogV3.setChangeType(companyChangeInfoDetailV3.getChangeType());
                    companyChangeInfoDetailReturnLogV3.setCid(companyChangeInfoDetailV3.getCid());
                    companyChangeInfoDetailReturnLogV3.setReturnType(companyChangeInfoDetailV3.getWorkStart());
                    companyChangeInfoDetailReturnLogV3.setReturnTime(resubmissionTime);
                    companyChangeInfoDetailReturnLogV3.setResubmissionTime(null);
                    companyChangeInfoDetailReturnLogV3.setCreateBy(updateBy);
                    companyChangeInfoDetailReturnLogV3.setCreateDate(now);
                    companyChangeInfoDetailReturnLogV3.setUpdateBy(updateBy);
                    companyChangeInfoDetailReturnLogV3.setUpdateDate(now);
                    companyChangeInfoDetailReturnLogV3.setIsValid(Integer.valueOf(1));
                    addCompanyChangeInfoDetailReturnLogV3List.add(companyChangeInfoDetailReturnLogV3);
                }
                this.addBatch(addCompanyChangeInfoDetailReturnLogV3List);
            }
        } else {
            ArrayList<CompanyChangeInfoDetailReturnLogV3> addCompanyChangeInfoDetailReturnLogV3List = new ArrayList<CompanyChangeInfoDetailReturnLogV3>(companyChangeInfoDetailV3List.size());
            for (CompanyChangeInfoDetailV3 companyChangeInfoDetailV3 : companyChangeInfoDetailV3List) {
                CompanyChangeInfoDetailReturnLogV3 companyChangeInfoDetailReturnLogV3 = new CompanyChangeInfoDetailReturnLogV3();
                companyChangeInfoDetailReturnLogV3.setId(Long.valueOf(this.idWorker.nextId()));
                companyChangeInfoDetailReturnLogV3.setChangeInfoId(companyChangeInfoDetailV3.getChangeInfoId());
                companyChangeInfoDetailReturnLogV3.setChangeInfoDetailId(companyChangeInfoDetailV3.getId());
                companyChangeInfoDetailReturnLogV3.setChangeType(companyChangeInfoDetailV3.getChangeType());
                companyChangeInfoDetailReturnLogV3.setCid(companyChangeInfoDetailV3.getCid());
                companyChangeInfoDetailReturnLogV3.setReturnType(companyChangeInfoDetailV3.getWorkStart());
                companyChangeInfoDetailReturnLogV3.setReturnTime(resubmissionTime);
                companyChangeInfoDetailReturnLogV3.setResubmissionTime(null);
                companyChangeInfoDetailReturnLogV3.setCreateBy(updateBy);
                companyChangeInfoDetailReturnLogV3.setCreateDate(now);
                companyChangeInfoDetailReturnLogV3.setUpdateBy(updateBy);
                companyChangeInfoDetailReturnLogV3.setUpdateDate(now);
                companyChangeInfoDetailReturnLogV3.setIsValid(Integer.valueOf(1));
                addCompanyChangeInfoDetailReturnLogV3List.add(companyChangeInfoDetailReturnLogV3);
            }
            this.addBatch(addCompanyChangeInfoDetailReturnLogV3List);
        }
    }

    @Generated
    public CompanyChangeInfoDetailReturnLogV3ServiceImpl(IdWorker idWorker) {
        this.idWorker = idWorker;
    }
}

