/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.provider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.entity.CompanyProposedChange;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaDTO;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForAreaParam;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForCidParam;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForIdParam;
import cn.smarthse.modules.datacentre.model.micro.MicrocomCompanyYcqModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.IMicrocomCompanyYcqProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.companyChange.v3.dao.CompanyChangeInfoDetailV3Mapper;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailReturnLogV3;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoV3;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForChangeToClassCImportDTO;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForChangeToClassCImportListener;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForCrossMigrationImportDTO;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForCrossMigrationImportListener;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForDistrictMigrationImportDTO;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForDistrictMigrationImportListener;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForIntraMigrationImportDTO;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForIntraMigrationImportListener;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForOcStateChangeImportDTO;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForOcStateChangeImportListener;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ImportDTO;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ImportListener;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeIndexClueIfAdoptClueParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeIndexClueParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoChangeStatusJurisdictionParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoChangeStatusParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoCreateParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexAuditAOrViewParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexForAreaSubAddFromExcelParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexForAreaSubAddParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexSubAParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexSubAddParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexSubRemoveParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoVictimsHistoryIndexAParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeJurisdictionIndexParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeJurisdictionWorkStartParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeStatisticsSearchParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeVictimsHistoryIndexParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeVictimsHistoryYearParam;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeIndexClueVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoIndexAuditAOrViewAListVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoIndexSubAVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoIndexVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoTimeCalculationVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeInfoVictimsHistoryIndexAVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeJurisdictionAutoAuditChangeVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeJurisdictionIndexVo;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeStatisticsWithIdentifyDTO;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeStatisticsWithIdentifyVoForLayUi;
import cn.smarthse.modules.health.companyChange.v3.model.vo.CompanyChangeVictimsHistoryIndexVo;
import cn.smarthse.modules.health.companyChange.v3.provider.ICompanyChangeV3ProviderService;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailReturnLogV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoVictimsHistoryV3Service;
import cn.smarthse.modules.health.companyChange.v3.strategy.AbstractCompanyChangeStrategy;
import cn.smarthse.modules.health.companyChange.v3.strategy.CompanyChangeStatusService;
import cn.smarthse.modules.health.companyChange.v3.task.CompanyChangeTask;
import cn.smarthse.modules.health.companyChange.v3.utils.CompanyChangeUtils;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.operate.WorkOperateLog;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeConfirmTypeEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeDetailStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeStatusEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3RecService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3Param;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class CompanyChangeV3ProviderServiceImpl
implements ICompanyChangeV3ProviderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyChangeV3ProviderServiceImpl.class);
    private final CompanyChangeTask companyChangeTask;
    private final IdWorker idWorker;
    private final CompanyChangeStatusService companyChangeStatusService;
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;
    private final ICompanyChangeInfoDetailReturnLogV3Service companyChangeInfoDetailReturnLogV3Service;
    private final ICompanyChangeInfoVictimsHistoryV3Service companyChangeInfoVictimsHistoryV3Service;
    private final ICompanyGradeV3RecService companyGradeV3RecService;
    private final IWorkOperateLogService workOperateLogService;
    private final ISysUserThirdService sysUserThirdService;
    @DubboReference(version="1.0.0")
    private IMicrocomCompanyYcqProvideService microcomCompanyYcqProvideService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @DubboReference
    private IOrganizationUserService organizationUserService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private IOrganizationService organizationService;

    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseListByCidExcludeDelete(List<Long> cidList) {
        return this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseListByCidExcludeDelete(cidList);
    }

    public Map<Long, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByCidExcludeDelete(List<Long> cidList) {
        return this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(cidList);
    }

    public Map<String, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByNameExcludeDelete(List<String> nameList) {
        return this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByNameExcludeDelete(nameList);
    }

    public Map<String, List<CompanySuperviseModel>> getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete(List<String> codeList) {
        return this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete(codeList);
    }

    public void autoAudit() {
        this.companyChangeTask.autoAudit();
    }

    public Long createChangeInfo(CompanyChangeInfoCreateParam param) {
        LocalDateTime now = LocalDateTime.now();
        CompanyChangeInfoV3 companyChangeInfo = new CompanyChangeInfoV3();
        companyChangeInfo.setChangeType(param.getChangeType());
        companyChangeInfo.setStatus(CompanyChangeStatusEnum.DRAFT.getCode());
        companyChangeInfo.setAreaId(param.getAreaId());
        companyChangeInfo.setSubOrgId(param.getSubOrgId());
        companyChangeInfo.setSubOrgName(param.getSubOrgName());
        companyChangeInfo.setCreateBy(param.getCreateBy());
        companyChangeInfo.setCreateDate(now);
        companyChangeInfo.setUpdateBy(param.getCreateBy());
        companyChangeInfo.setUpdateDate(now);
        companyChangeInfo = (CompanyChangeInfoV3)this.companyChangeInfoV3Service.add(companyChangeInfo);
        if (Objects.isNull(companyChangeInfo)) {
            throw new HealthException("\u521b\u5efa\u53d8\u66f4\u8868\u5355\u5931\u8d25");
        }
        return companyChangeInfo.getId();
    }

    public PageInfo<CompanyChangeInfoIndexVo> getIndexPage(CompanyChangeInfoIndexParam param) {
        return this.companyChangeInfoV3Service.getIndexPage(param);
    }

    public PageInfo<CompanyChangeVictimsHistoryIndexVo> getVictimsHistoryIndexPage(CompanyChangeVictimsHistoryIndexParam param) {
        return this.companyChangeInfoVictimsHistoryV3Service.getVictimsHistoryIndexPage(param);
    }

    public List<Integer> getVictimsHistoryYearList(CompanyChangeVictimsHistoryYearParam param) {
        return this.companyChangeInfoVictimsHistoryV3Service.getVictimsHistoryYearListData(param);
    }

    public PageInfo<CompanyChangeInfoIndexSubAVo> getIndexSubAPage(CompanyChangeInfoIndexSubAParam param) {
        CompanyChangeInfoV3 companyChangeInfoV3 = (CompanyChangeInfoV3)this.companyChangeInfoV3Service.getById(param.getChangeInfoId());
        if (Objects.isNull(companyChangeInfoV3)) {
            throw new HealthException("\u8be5\u53d8\u66f4\u8868\u5355\u4e0d\u5b58\u5728");
        }
        if (CompanyChangeTypeEnum.delete.getCode().equals(companyChangeInfoV3.getChangeType())) {
            param.setStopType(StopTypeEnums.CLOSE.getCode());
        } else if (CompanyChangeTypeEnum.crossMigration.getCode().equals(companyChangeInfoV3.getChangeType())) {
            param.setStopType(StopTypeEnums.CHANGECROSS.getCode());
        } else if (CompanyChangeTypeEnum.intraMigration.getCode().equals(companyChangeInfoV3.getChangeType())) {
            param.setStopType(StopTypeEnums.CHANGEWITHIN.getCode());
        } else if (CompanyChangeTypeEnum.districtMigration.getCode().equals(companyChangeInfoV3.getChangeType())) {
            param.setStopType(StopTypeEnums.CHANGEDISTRICTWITHIN.getCode());
        } else if (CompanyChangeTypeEnum.restore.getCode().equals(companyChangeInfoV3.getChangeType())) {
            param.setStopType(StopTypeEnums.NORMAL.getCode());
        } else if (CompanyChangeTypeEnum.victimsGE3.getCode().equals(companyChangeInfoV3.getChangeType())) {
            param.setReversalChangeType(CompanyChangeTypeEnum.victimsL3.getCode());
            param.setYear(Integer.valueOf(LocalDateTime.now().getYear()));
        } else if (CompanyChangeTypeEnum.victimsL3.getCode().equals(companyChangeInfoV3.getChangeType())) {
            param.setReversalChangeType(CompanyChangeTypeEnum.victimsGE3.getCode());
            param.setYear(Integer.valueOf(LocalDateTime.now().getYear()));
        } else {
            param.setStopType(StopTypeEnums.NONE.getCode());
        }
        param.setChangeType(companyChangeInfoV3.getChangeType());
        PageInfo<CompanyChangeInfoIndexSubAVo> changeInfoPage = this.companyChangeInfoV3Service.getIndexSubAPage(param);
        List changeInfoList = changeInfoPage.getList();
        this.postSetCompanyScaleNameForStep1(changeInfoList);
        return changeInfoPage;
    }

    public PageInfo<CompanyChangeInfoVictimsHistoryIndexAVo> getVictimsHistoryIndexAPage(CompanyChangeInfoVictimsHistoryIndexAParam param) {
        return this.companyChangeInfoVictimsHistoryV3Service.getVictimsHistoryIndexAPage(param);
    }

    public Boolean checkArea(Integer changeType, Long areaId, Long userAreaId) {
        if (Objects.isNull(areaId)) {
            return false;
        }
        AreaModel area = this.sysAreaProvideService.getAreaById(areaId);
        AreaModel userArea = this.sysAreaProvideService.getAreaById(userAreaId);
        if (Objects.isNull(area) || Objects.isNull(userArea)) {
            return false;
        }
        if (CompanyChangeTypeEnum.crossMigration.getCode().equals(changeType)) {
            if (area.getLevel() < 3) {
                return false;
            }
            return !Objects.equals(area.getCityId(), userArea.getCityId());
        }
        if (CompanyChangeTypeEnum.intraMigration.getCode().equals(changeType)) {
            if (area.getLevel() < 3) {
                return false;
            }
            return !Objects.equals(area.getAreaId(), userArea.getAreaId());
        }
        if (CompanyChangeTypeEnum.districtMigration.getCode().equals(changeType)) {
            if (area.getLevel() < 4) {
                return false;
            }
            if (userArea.getLevel() == 1) {
                return Objects.equals(area.getProvinceId(), userArea.getProvinceId());
            }
            if (userArea.getLevel() == 2) {
                return Objects.equals(area.getCityId(), userArea.getCityId());
            }
            if (userArea.getLevel() == 3) {
                return Objects.equals(area.getAreaId(), userArea.getAreaId());
            }
            return false;
        }
        throw new HealthException("\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    public Boolean addCompany(CompanyChangeInfoIndexSubAddParam param) {
        Long changeInfoId = param.getChangeInfoId();
        List cidList = param.getCidList();
        Long submitUserId = param.getSubmitUserId();
        Integer changeDetailType = param.getChangeType();
        Map cidChangeTypeMap = param.getCidChangeTypeMap();
        if (Objects.isNull(changeInfoId) || CollUtil.isEmpty((Collection)cidList) || Objects.isNull(submitUserId)) {
            throw new HealthException("\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        CompanyChangeInfoV3 companyChangeInfo = this.getById(changeInfoId);
        if (Objects.isNull(companyChangeInfo)) {
            throw new HealthException("\u8be5\u8868\u5355\u5df2\u4e0d\u5b58\u5728");
        }
        Map<Long, CompanySuperviseModel> companySuperviseModelMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(cidList);
        if (MapUtil.isEmpty(companySuperviseModelMap)) {
            throw new HealthException("\u65e0\u516c\u53f8\u4fe1\u606f");
        }
        Integer changeType = companyChangeInfo.getChangeType();
        if (CompanyChangeTypeEnum.crossMigration.getCode().equals(changeType) || CompanyChangeTypeEnum.intraMigration.getCode().equals(changeType) || CompanyChangeTypeEnum.districtMigration.getCode().equals(changeType)) {
            Long stopAreaId;
            Integer isTransProvincial = param.getIsTransProvincial();
            if (Objects.isNull(isTransProvincial) || cidList.size() > 1) {
                throw new HealthException("\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            if (isTransProvincial == 1) {
                param.setStopAreaId(Long.valueOf(0L));
            }
            if (Objects.isNull(stopAreaId = param.getStopAreaId())) {
                throw new HealthException("\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            CompanyChangeInfoIndexForAreaSubAddParam areaParam = new CompanyChangeInfoIndexForAreaSubAddParam();
            areaParam.setChangeInfoId(changeInfoId);
            areaParam.setCid((Long)cidList.get(0));
            areaParam.setIsTransProvincial(isTransProvincial);
            areaParam.setSituationExplanation(param.getSituationExplanation());
            areaParam.setStopAreaId(stopAreaId);
            areaParam.setChangeType(changeType);
            areaParam.setSubmitUserId(submitUserId);
            return this.addCompanyForArea(areaParam, companySuperviseModelMap.get(areaParam.getCid()));
        }
        if (CompanyChangeTypeEnum.victimsGE3.getCode().equals(changeType)) {
            invalidNames = new ArrayList<String>(cidList.size());
            for (Long cid : cidList) {
                model = companySuperviseModelMap.get(cid);
                if (model == null || model.getVictimsIdentify() == null || model.getVictimsIdentify() != 2) continue;
                invalidNames.add(model.getName());
            }
            if (!invalidNames.isEmpty()) {
                names = String.join((CharSequence)"\u3001", invalidNames);
                throw new HealthException("\u4ee5\u4e0b\u4f01\u4e1a\u5df2\u5904\u4e8e\u63a5\u5bb3\u4eba\u6570\u22653\u4eba\u72b6\u6001\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\uff1a" + (String)names);
            }
        } else if (CompanyChangeTypeEnum.victimsL3.getCode().equals(changeType)) {
            invalidNames = new ArrayList(cidList.size());
            for (Long cid : cidList) {
                model = companySuperviseModelMap.get(cid);
                if (model == null || model.getVictimsIdentify() == null || model.getVictimsIdentify() != 1) continue;
                invalidNames.add(model.getName());
            }
            if (!invalidNames.isEmpty()) {
                names = String.join((CharSequence)"\u3001", invalidNames);
                throw new HealthException("\u4ee5\u4e0b\u4f01\u4e1a\u5df2\u5904\u4e8e\u63a5\u5bb3\u4eba\u6570<3\u4eba\u72b6\u6001\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\uff1a" + (String)names);
            }
        } else if (CompanyChangeTypeEnum.changeCompanyScale.getCode().equals(changeType)) {
            List ycqList = this.microcomCompanyYcqProvideService.getMicroYcqList(cidList);
            Map<Long, MicrocomCompanyYcqModel> ycqMap = ycqList.stream().collect(Collectors.toMap(MicrocomCompanyYcqModel::getCid, Function.identity(), (v1, v2) -> v2));
            return this.addCompanyForScale(companyChangeInfo, ycqMap, submitUserId);
        }
        List<CompanyChangeInfoDetailV3> companyChangeInfoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        Map<Object, Object> companyChangeInfoDetailMap = new HashMap();
        if (CollUtil.isNotEmpty(companyChangeInfoDetailList)) {
            companyChangeInfoDetailMap = companyChangeInfoDetailList.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, item -> item, (v1, v2) -> v1));
        }
        LocalDateTime now = LocalDateTime.now();
        ArrayList<CompanyChangeInfoDetailV3> addList = new ArrayList<CompanyChangeInfoDetailV3>(cidList.size());
        ArrayList<CompanyChangeInfoDetailV3> updateList = new ArrayList<CompanyChangeInfoDetailV3>(cidList.size());
        for (Long cid : cidList) {
            boolean ocChange;
            CompanyChangeInfoDetailV3 companyChangeInfoDetail;
            CompanySuperviseModel companySuperviseModel = companySuperviseModelMap.get(cid);
            if (companyChangeInfoDetailMap.containsKey(cid)) {
                companyChangeInfoDetail = (CompanyChangeInfoDetailV3)companyChangeInfoDetailMap.get(cid);
                companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
                companyChangeInfoDetail.setBusinessStatus(companySuperviseModel.getBusinessState());
                companyChangeInfoDetail.setSituationExplanation(param.getSituationExplanation());
                companyChangeInfoDetail.setUpdateBy(submitUserId);
                companyChangeInfoDetail.setUpdateDate(now);
                updateList.add(companyChangeInfoDetail);
                continue;
            }
            companyChangeInfoDetail = new CompanyChangeInfoDetailV3();
            companyChangeInfoDetail.setId(Long.valueOf(this.idWorker.nextId()));
            companyChangeInfoDetail.setChangeInfoId(changeInfoId);
            CompanyChangeTypeEnum changeTypeEnum = CompanyChangeTypeEnum.getEnum((Integer)changeType);
            boolean bl = ocChange = changeTypeEnum == CompanyChangeTypeEnum.ocStateChange || changeTypeEnum == CompanyChangeTypeEnum.ocAndComStateChange || changeTypeEnum == CompanyChangeTypeEnum.ocChangToEmployUnit || changeTypeEnum == CompanyChangeTypeEnum.ocChangToEmployAndOcUnit;
            if (ocChange) {
                if (changeDetailType != null) {
                    companyChangeInfoDetail.setChangeType(changeDetailType);
                } else if (cidChangeTypeMap != null) {
                    Integer detailType = (Integer)cidChangeTypeMap.get(cid);
                    companyChangeInfoDetail.setChangeType(detailType != null ? detailType : changeType);
                } else {
                    companyChangeInfoDetail.setChangeType(changeType);
                }
            } else {
                companyChangeInfoDetail.setChangeType(changeType);
            }
            companyChangeInfoDetail.setCid(cid);
            companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
            companyChangeInfoDetail.setBusinessStatus(companySuperviseModel.getBusinessState());
            companyChangeInfoDetail.setSituationExplanation(param.getSituationExplanation());
            companyChangeInfoDetail.setCreateBy(submitUserId);
            companyChangeInfoDetail.setCreateDate(now);
            companyChangeInfoDetail.setUpdateBy(submitUserId);
            companyChangeInfoDetail.setUpdateDate(now);
            addList.add(companyChangeInfoDetail);
        }
        try {
            int a = this.companyChangeInfoDetailV3Service.batchUpdateOrInsert(addList, CompanyChangeInfoDetailV3Mapper.class, (item, mapper) -> mapper.insertSelective(item));
            int b = this.companyChangeInfoDetailV3Service.batchUpdateOrInsert(updateList, CompanyChangeInfoDetailV3Mapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            return a > 0 || b > 0;
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u53d8\u66f4\u6279\u91cf\u63d2\u5165\u6216\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private boolean addCompanyForArea(CompanyChangeInfoIndexForAreaSubAddParam param, CompanySuperviseModel companySuperviseModel) {
        Long changeInfoId = param.getChangeInfoId();
        Long cid = param.getCid();
        Integer isTransProvincial = param.getIsTransProvincial();
        Long stopAreaId = param.getStopAreaId();
        Integer changeType = param.getChangeType();
        Long submitUserId = param.getSubmitUserId();
        LocalDateTime now = LocalDateTime.now();
        List<CompanyChangeInfoDetailV3> companyChangeInfoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, Collections.singletonList(cid));
        if (CollUtil.isNotEmpty(companyChangeInfoDetailList)) {
            CompanyChangeInfoDetailV3 companyChangeInfoDetail = companyChangeInfoDetailList.get(0);
            companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
            companyChangeInfoDetail.setBusinessStatus(companySuperviseModel.getBusinessState());
            companyChangeInfoDetail.setSituationExplanation(param.getSituationExplanation());
            companyChangeInfoDetail.setTransferBeforeAreaId(companySuperviseModel.getAreaDetailId());
            companyChangeInfoDetail.setTransferAreaId(Long.valueOf(isTransProvincial == 0 ? stopAreaId : 0L));
            companyChangeInfoDetail.setIsTransProvincial(isTransProvincial);
            companyChangeInfoDetail.setUpdateBy(submitUserId);
            companyChangeInfoDetail.setUpdateDate(now);
            this.companyChangeInfoDetailV3Service.update(companyChangeInfoDetail);
        } else {
            CompanyChangeInfoDetailV3 companyChangeInfoDetail = new CompanyChangeInfoDetailV3();
            companyChangeInfoDetail.setId(Long.valueOf(this.idWorker.nextId()));
            companyChangeInfoDetail.setChangeInfoId(changeInfoId);
            companyChangeInfoDetail.setChangeType(changeType);
            companyChangeInfoDetail.setCid(cid);
            companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
            companyChangeInfoDetail.setBusinessStatus(companySuperviseModel.getBusinessState());
            companyChangeInfoDetail.setSituationExplanation(param.getSituationExplanation());
            companyChangeInfoDetail.setTransferBeforeAreaId(companySuperviseModel.getAreaDetailId());
            companyChangeInfoDetail.setTransferAreaId(Long.valueOf(isTransProvincial == 0 ? stopAreaId : 0L));
            companyChangeInfoDetail.setIsTransProvincial(isTransProvincial);
            companyChangeInfoDetail.setCreateBy(submitUserId);
            companyChangeInfoDetail.setCreateDate(now);
            this.companyChangeInfoDetailV3Service.add(companyChangeInfoDetail);
        }
        return true;
    }

    @Deprecated
    private boolean addCompanyForScale(CompanyChangeInfoV3 changeInfo, MicrocomCompanyYcqModel ycqModel, Long submitUserId) {
        LocalDateTime now = LocalDateTime.now();
        Long cid = ycqModel.getCid();
        Long changeId = changeInfo.getId();
        Integer changeType = changeInfo.getChangeType();
        List<CompanyChangeInfoDetailV3> changeDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeId, Collections.singletonList(cid));
        if (CollUtil.isNotEmpty(changeDetailList)) {
            CompanyChangeInfoDetailV3 changeDetail = changeDetailList.get(0);
            changeDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
            changeDetail.setBusinessStatus(ycqModel.getBusinessState());
            changeDetail.setBeforeScale(ycqModel.getScale());
            changeDetail.setUpdateBy(submitUserId);
            changeDetail.setUpdateDate(now);
            this.companyChangeInfoDetailV3Service.update(changeDetail);
        } else {
            CompanyChangeInfoDetailV3 changeDetail = new CompanyChangeInfoDetailV3();
            changeDetail.setId(Long.valueOf(this.idWorker.nextId()));
            changeDetail.setCid(cid);
            changeDetail.setChangeInfoId(changeId);
            changeDetail.setChangeType(changeType);
            changeDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
            changeDetail.setBusinessStatus(ycqModel.getBusinessState());
            changeDetail.setBeforeScale(ycqModel.getScale());
            changeDetail.setCreateBy(submitUserId);
            changeDetail.setCreateDate(now);
            this.companyChangeInfoDetailV3Service.add(changeDetail);
        }
        return Boolean.TRUE;
    }

    private Boolean addCompanyForScale(CompanyChangeInfoV3 changeInfo, Map<Long, MicrocomCompanyYcqModel> ycqMap, Long submitUserId) {
        boolean doInsert;
        LocalDateTime now = LocalDateTime.now();
        ArrayList<Long> cidList = new ArrayList<Long>(ycqMap.keySet());
        ArrayList<Long> dbCidList = new ArrayList<Long>();
        Long changeId = changeInfo.getId();
        Integer changeType = changeInfo.getChangeType();
        List<CompanyChangeInfoDetailV3> changeDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeId, cidList);
        if (CollUtil.isNotEmpty(changeDetailList)) {
            for (CompanyChangeInfoDetailV3 changeDetail : changeDetailList) {
                Long cid = changeDetail.getCid();
                dbCidList.add(cid);
                MicrocomCompanyYcqModel ycqModel = ycqMap.get(cid);
                changeDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
                changeDetail.setBusinessStatus(ycqModel.getBusinessState());
                changeDetail.setBeforeScale(ycqModel.getScale());
                changeDetail.setUpdateBy(submitUserId);
                changeDetail.setUpdateDate(now);
            }
            this.companyChangeInfoDetailV3Service.batchUpdateOrInsert(changeDetailList, CompanyChangeInfoDetailV3Mapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        }
        boolean bl = doInsert = CollUtil.isEmpty(dbCidList) || dbCidList.size() < ycqMap.size();
        if (doInsert) {
            ArrayList<CompanyChangeInfoDetailV3> insertChangeDetailList = new ArrayList<CompanyChangeInfoDetailV3>();
            for (Map.Entry<Long, MicrocomCompanyYcqModel> ycqModelEntry : ycqMap.entrySet()) {
                Long cid = ycqModelEntry.getKey();
                if (dbCidList.contains(cid)) continue;
                MicrocomCompanyYcqModel ycqModel = ycqModelEntry.getValue();
                CompanyChangeInfoDetailV3 changeDetail = new CompanyChangeInfoDetailV3();
                changeDetail.setId(Long.valueOf(this.idWorker.nextId()));
                changeDetail.setCid(cid);
                changeDetail.setChangeInfoId(changeId);
                changeDetail.setChangeType(changeType);
                changeDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
                changeDetail.setBusinessStatus(ycqModel.getBusinessState());
                changeDetail.setBeforeScale(ycqModel.getScale());
                changeDetail.setCreateBy(submitUserId);
                changeDetail.setCreateDate(now);
                insertChangeDetailList.add(changeDetail);
            }
            this.companyChangeInfoDetailV3Service.batchUpdateOrInsert(insertChangeDetailList, CompanyChangeInfoDetailV3Mapper.class, (item, mapper) -> mapper.insertSelective(item));
        }
        return Boolean.TRUE;
    }

    public Boolean addCompanyForAreaFromExcel(List<CompanyChangeInfoIndexForAreaSubAddFromExcelParam> list, Long changeInfoId, Long submitUserId) {
        CompanyChangeInfoV3 companyChangeInfo = this.getById(changeInfoId);
        if (Objects.isNull(companyChangeInfo)) {
            throw new HealthException("\u8be5\u8868\u5355\u5df2\u4e0d\u5b58\u5728");
        }
        Integer changeType = companyChangeInfo.getChangeType();
        if (!(CompanyChangeTypeEnum.crossMigration.getCode().equals(changeType) || CompanyChangeTypeEnum.intraMigration.getCode().equals(changeType) || CompanyChangeTypeEnum.districtMigration.getCode().equals(changeType))) {
            throw new HealthException("\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        List<Long> cidList = list.stream().map(CompanyChangeInfoIndexForAreaSubAddFromExcelParam::getCid).collect(Collectors.toList());
        Map<Long, CompanySuperviseModel> companySuperviseModelMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(cidList);
        if (MapUtil.isEmpty(companySuperviseModelMap)) {
            throw new HealthException("\u65e0\u516c\u53f8\u4fe1\u606f");
        }
        List<CompanyChangeInfoDetailV3> companyChangeInfoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdAndCidList(changeInfoId, cidList);
        Map<Object, Object> companyChangeInfoDetailMap = new HashMap();
        if (CollUtil.isNotEmpty(companyChangeInfoDetailList)) {
            companyChangeInfoDetailMap = companyChangeInfoDetailList.stream().collect(Collectors.toMap(CompanyChangeInfoDetailV3::getCid, item -> item, (v1, v2) -> v1));
        }
        LocalDateTime now = LocalDateTime.now();
        ArrayList<CompanyChangeInfoDetailV3> addList = new ArrayList<CompanyChangeInfoDetailV3>(list.size());
        ArrayList<CompanyChangeInfoDetailV3> updateList = new ArrayList<CompanyChangeInfoDetailV3>(cidList.size());
        for (CompanyChangeInfoIndexForAreaSubAddFromExcelParam param : list) {
            CompanyChangeInfoDetailV3 companyChangeInfoDetail;
            Long cid = param.getCid();
            CompanySuperviseModel companySuperviseModel = companySuperviseModelMap.get(cid);
            if (companyChangeInfoDetailMap.containsKey(cid)) {
                companyChangeInfoDetail = (CompanyChangeInfoDetailV3)companyChangeInfoDetailMap.get(cid);
                companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
                companyChangeInfoDetail.setBusinessStatus(companySuperviseModel.getBusinessState());
                companyChangeInfoDetail.setTransferBeforeAreaId(companySuperviseModel.getAreaDetailId());
                companyChangeInfoDetail.setTransferAreaId(param.getStopAreaId());
                companyChangeInfoDetail.setIsTransProvincial(param.getIsTransProvincial());
                companyChangeInfoDetail.setSituationExplanation(param.getSituationExplanation());
                companyChangeInfoDetail.setUpdateBy(submitUserId);
                companyChangeInfoDetail.setUpdateDate(now);
                updateList.add(companyChangeInfoDetail);
                continue;
            }
            companyChangeInfoDetail = new CompanyChangeInfoDetailV3();
            companyChangeInfoDetail.setId(Long.valueOf(this.idWorker.nextId()));
            companyChangeInfoDetail.setChangeInfoId(changeInfoId);
            companyChangeInfoDetail.setChangeType(changeType);
            companyChangeInfoDetail.setCid(cid);
            companyChangeInfoDetail.setDetailStatus(CompanyChangeDetailStatusEnum.DRAFT.getCode());
            companyChangeInfoDetail.setBusinessStatus(companySuperviseModel.getBusinessState());
            companyChangeInfoDetail.setTransferBeforeAreaId(companySuperviseModel.getAreaDetailId());
            companyChangeInfoDetail.setTransferAreaId(param.getStopAreaId());
            companyChangeInfoDetail.setIsTransProvincial(param.getIsTransProvincial());
            companyChangeInfoDetail.setSituationExplanation(param.getSituationExplanation());
            companyChangeInfoDetail.setCreateBy(submitUserId);
            companyChangeInfoDetail.setCreateDate(now);
            addList.add(companyChangeInfoDetail);
        }
        try {
            int a = this.companyChangeInfoDetailV3Service.batchUpdateOrInsert(addList, CompanyChangeInfoDetailV3Mapper.class, (item, mapper) -> mapper.insertSelective(item));
            int b = this.companyChangeInfoDetailV3Service.batchUpdateOrInsert(updateList, CompanyChangeInfoDetailV3Mapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
            return a > 0 || b > 0;
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u53d8\u66f4\u6279\u91cf\u63d2\u5165\u6216\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public Boolean removeCompany(CompanyChangeInfoIndexSubRemoveParam param) {
        return this.companyChangeInfoDetailV3Service.deleteByChangeInfoIdAndCidList(param.getChangeInfoId(), param.getCidList());
    }

    public Boolean importCompanyData(Long fileId, Long changeInfoId, Long userId, Long userAreaId) {
        AnalysisEventListener readListener;
        Class clazz;
        SysFileModel file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            throw new HealthException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        CompanyChangeInfoV3 companyChangeInfo = (CompanyChangeInfoV3)this.companyChangeInfoV3Service.getById(changeInfoId);
        if (Objects.isNull(companyChangeInfo)) {
            throw new HealthException("\u8be5\u8868\u5355\u5df2\u4e0d\u5b58\u5728");
        }
        Integer changeType = companyChangeInfo.getChangeType();
        Integer headRowNumber = 2;
        if (CompanyChangeTypeEnum.crossMigration.getCode().equals(changeType)) {
            clazz = CompanyChangeV3ForCrossMigrationImportDTO.class;
            readListener = new CompanyChangeV3ForCrossMigrationImportListener(userId, userAreaId, changeInfoId, this, this.sysAreaProvideService, this.companyChangeInfoV3Service, this.companyChangeInfoDetailV3Service);
        } else if (CompanyChangeTypeEnum.intraMigration.getCode().equals(changeType)) {
            clazz = CompanyChangeV3ForIntraMigrationImportDTO.class;
            readListener = new CompanyChangeV3ForIntraMigrationImportListener(userId, userAreaId, changeInfoId, this, this.sysAreaProvideService, this.companyChangeInfoV3Service, this.companyChangeInfoDetailV3Service);
        } else if (CompanyChangeTypeEnum.districtMigration.getCode().equals(changeType)) {
            clazz = CompanyChangeV3ForDistrictMigrationImportDTO.class;
            readListener = new CompanyChangeV3ForDistrictMigrationImportListener(userId, userAreaId, changeInfoId, this, this.sysAreaProvideService, this.companyChangeInfoV3Service, this.companyChangeInfoDetailV3Service);
        } else if (CompanyChangeTypeEnum.ocStateChange.getCode().equals(changeType) || CompanyChangeTypeEnum.ocAndComStateChange.getCode().equals(changeType)) {
            clazz = CompanyChangeV3ForOcStateChangeImportDTO.class;
            readListener = new CompanyChangeV3ForOcStateChangeImportListener(userId, userAreaId, changeInfoId, companyChangeInfo, this, this.sysAreaProvideService, this.companyChangeInfoV3Service, this.companyChangeInfoDetailV3Service);
        } else if (CompanyChangeTypeEnum.ocChangToEmployUnit.getCode().equals(changeType) || CompanyChangeTypeEnum.ocChangToEmployAndOcUnit.getCode().equals(changeType)) {
            clazz = CompanyChangeV3ForOcStateChangeImportDTO.class;
            readListener = new CompanyChangeV3ForOcStateChangeImportListener(userId, userAreaId, changeInfoId, companyChangeInfo, this, this.sysAreaProvideService, this.companyChangeInfoV3Service, this.companyChangeInfoDetailV3Service);
        } else if (CompanyChangeTypeEnum.changeToClassC.getCode().equals(changeType)) {
            clazz = CompanyChangeV3ForChangeToClassCImportDTO.class;
            readListener = new CompanyChangeV3ForChangeToClassCImportListener(userId, userAreaId, changeInfoId, this, this.sysAreaProvideService, this.companyChangeInfoV3Service, this.companyChangeInfoDetailV3Service, this.companyGradeV3RecService);
        } else {
            clazz = CompanyChangeV3ImportDTO.class;
            readListener = new CompanyChangeV3ImportListener(userId, userAreaId, changeInfoId, companyChangeInfo, this, this.sysAreaProvideService, this.companyChangeInfoV3Service, this.companyChangeInfoDetailV3Service);
        }
        try (InputStream inputStream = ExcelUtil.getInstance().getOssInputStream(file.getFullOssurl());
             ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();){
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet().headRowNumber(headRowNumber)).head(clazz)).registerReadListener((ReadListener)readListener)).build()});
        }
        catch (Exception e) {
            throw new HealthException(ErrorEnum.FAIL_DEAL, e.getMessage());
        }
        return Boolean.TRUE;
    }

    public PageInfo<CompanyChangeInfoIndexAuditAOrViewAListVo> getIndexSubOrAuditBPage(CompanyChangeInfoIndexAuditAOrViewParam param) {
        PageInfo<CompanyChangeInfoIndexAuditAOrViewAListVo> page = this.companyChangeInfoV3Service.getIndexSubOrAuditBPage(param);
        List list = page.getList();
        if (Boolean.TRUE.equals(param.getCount()) && CollUtil.isNotEmpty((Collection)list)) {
            List<CompanyChangeInfoIndexAuditAOrViewAListVo> nonDraftItems = list.stream().filter(item -> !CompanyChangeDetailStatusEnum.DRAFT.getCode().equals(item.getDetailStatus())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(nonDraftItems)) {
                List workIdCidPairs = list.stream().map(item -> new Pair((Object)item.getChangeInfoId(), (Object)item.getCid())).collect(Collectors.toList());
                Map workOperateLogMap = this.workOperateLogService.getReasonBatch(WorkOperateLogEnum.companyChange.getTypeVal(), WorkOperateLogStatusEnum.back, workIdCidPairs);
                List<Pair<Long, Long>> changeInfoIdCidPairs = list.stream().filter(item -> CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode().equals(item.getDetailStatus()) && (CompanyChangeTypeEnum.crossMigration.getCode().equals(item.getChangeType()) || CompanyChangeTypeEnum.intraMigration.getCode().equals(item.getChangeType()) || CompanyChangeTypeEnum.districtMigration.getCode().equals(item.getChangeType()))).map(item -> new Pair((Object)item.getChangeInfoId(), (Object)item.getCid())).collect(Collectors.toList());
                Map<Pair<Long, Long>, List<CompanyChangeInfoDetailReturnLogV3>> returnLogMap = this.companyChangeInfoDetailReturnLogV3Service.getResubmissionLogListMap(changeInfoIdCidPairs);
                nonDraftItems.forEach(item -> {
                    Pair key = new Pair((Object)item.getChangeInfoId(), (Object)item.getCid());
                    WorkOperateLog workOperateLog = (WorkOperateLog)workOperateLogMap.get(key);
                    item.setReason(Objects.isNull(workOperateLog) ? "" : workOperateLog.getReason());
                    if (CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode().equals(item.getDetailStatus()) && (CompanyChangeTypeEnum.crossMigration.getCode().equals(item.getChangeType()) || CompanyChangeTypeEnum.intraMigration.getCode().equals(item.getChangeType()) || CompanyChangeTypeEnum.districtMigration.getCode().equals(item.getChangeType()))) {
                        List returnLogList = (List)returnLogMap.get(key);
                        CompanyChangeUtils.timeCalculation((CompanyChangeInfoTimeCalculationVo)item, returnLogList);
                    }
                });
            }
            this.postSetCompanyRegionAddressName(list);
            this.postSetCompanyScaleNameForIndex(list);
        }
        return page;
    }

    public void setAfterScale(Long changeInfoDetailId, Byte scale, Long loginUserId) {
        if (changeInfoDetailId == null) {
            return;
        }
        CompanyChangeInfoDetailV3 detail = (CompanyChangeInfoDetailV3)this.companyChangeInfoDetailV3Service.getById(changeInfoDetailId);
        if (detail == null) {
            return;
        }
        detail.setAfterScale(scale);
        this.companyChangeInfoDetailV3Service.updateByPrimaryKey(detail, loginUserId);
    }

    public Long getIndexSubOrAuditBCount(CompanyChangeInfoIndexAuditAOrViewParam param) {
        return this.companyChangeInfoV3Service.getIndexSubOrAuditBCount(param);
    }

    public Map<String, Integer> getDetailStatusNum(Long changeInfoId) {
        List<CompanyChangeInfoDetailV3> list = this.companyChangeInfoDetailV3Service.getListByChangeInfoId(changeInfoId);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CompanyChangeInfoDetailV3 infoDetail : list) {
            String key = "detailStatusNum" + infoDetail.getDetailStatus();
            map.put(key, map.getOrDefault(key, 0) + 1);
        }
        return map;
    }

    public Map<String, Integer> getJurisdictionDetailStatusNum(Long areaId, Byte areaLevel) {
        List<CompanyChangeInfoDetailV3> list = this.companyChangeInfoDetailV3Service.getJurisdictionListByAreaId(areaId, areaLevel);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CompanyChangeInfoDetailV3 infoDetail : list) {
            String key = "detailStatusNum" + infoDetail.getDetailStatus();
            map.put(key, map.getOrDefault(key, 0) + 1);
        }
        return map;
    }

    public Map<String, Integer> getClueStopStatusNum(Integer stopType, Long areaId, Byte areaLevel) {
        List<CompanyProposedChange> list = this.companyChangeInfoDetailV3Service.getClueStopStatusListByStopTypeAndAreaId(stopType, areaId, areaLevel);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CompanyProposedChange companyProposedChange : list) {
            String key = "stopStatusNum" + companyProposedChange.getStatus();
            map.put(key, map.getOrDefault(key, 0) + 1);
        }
        return map;
    }

    public Boolean checkBeforeSubmit(Long changeInfoId) {
        if (Objects.isNull(changeInfoId)) {
            throw new HealthException("changeInfoId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CompanyChangeInfoDetailV3> toSubmitList = this.companyChangeInfoDetailV3Service.getListForSubmitValidation(changeInfoId);
        if (CollUtil.isEmpty(toSubmitList)) {
            throw new HealthException("\u8bf7\u6dfb\u52a0\u8981\u53d8\u66f4\u7684\u4f01\u4e1a");
        }
        List<Long> toSubmitCidList = toSubmitList.stream().map(CompanyChangeInfoDetailV3::getCid).toList();
        return CollUtil.isEmpty(this.companyChangeInfoDetailV3Service.getCidListInOtherForm(changeInfoId, toSubmitCidList));
    }

    public PageInfo<WorkOperateLog> getOperatePage(JqGridParam jParam, Long workId) {
        PageInfo page = this.workOperateLogService.getPageList(jParam, workId, WorkOperateLogEnum.companyChange.getTypeVal());
        this.settingOperateListData((PageInfo<WorkOperateLog>)page);
        return page;
    }

    public PageInfo<WorkOperateLog> getJurisdictionOperatePage(JqGridParam jParam, Long areaId, Byte areaLevel) {
        PageInfo<WorkOperateLog> page = this.companyChangeInfoDetailV3Service.getJurisdictionOperatePage(jParam, areaId, areaLevel, WorkOperateLogEnum.companyChange.getTypeVal());
        this.settingOperateListData(page);
        return page;
    }

    private void settingOperateListData(PageInfo<WorkOperateLog> page) {
        List<CompanyChangeInfoDetailV3> detailList;
        List list = page.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return;
        }
        List<Long> cidList = list.stream().map(WorkOperateLog::getCid).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Long, CompanySuperviseModel> onlnyCompanyMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(cidList);
        List userIdList = list.stream().map(WorkOperateLog::getCreateBy).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map organizationUserList = this.organizationUserService.getUserInfoMapByIdList(userIdList);
        List<Long> workIdList = list.stream().map(WorkOperateLog::getWorkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> situationExplanationMap = new HashMap();
        if (CollUtil.isNotEmpty(workIdList) && CollUtil.isNotEmpty(detailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoIdList(workIdList))) {
            situationExplanationMap = detailList.stream().filter(detail -> Objects.nonNull(detail.getChangeInfoId()) && Objects.nonNull(detail.getCid())).collect(Collectors.toMap(detail -> detail.getChangeInfoId() + "_" + detail.getCid(), CompanyChangeInfoDetailV3::getSituationExplanation, (v1, v2) -> v1));
        }
        for (WorkOperateLog operateLog : list) {
            if (Constants.SYSTEM_AUTOMATIC_CONFIRMATION_KEY.equals(operateLog.getCreateBy())) {
                operateLog.setOrganizeName("\u7cfb\u7edf\u81ea\u52a8\u786e\u8ba4");
            } else {
                OrganizationUser organizationUser = (OrganizationUser)organizationUserList.get(operateLog.getCreateBy());
                if (Objects.nonNull(organizationUser)) {
                    operateLog.setOrganizeName(organizationUser.getOrganizationName());
                }
            }
            if (Objects.nonNull(operateLog.getCid()) && onlnyCompanyMap.containsKey(operateLog.getCid())) {
                operateLog.setCompanyName(onlnyCompanyMap.get(operateLog.getCid()).getName());
            }
            String reason = operateLog.getReason();
            String situationExplanation = (String)situationExplanationMap.get(operateLog.getWorkId() + "_" + operateLog.getCid());
            operateLog.setReason((reason != null ? reason : "") + "\n" + (situationExplanation != null ? situationExplanation : ""));
        }
    }

    public PageInfo<CompanyChangeJurisdictionIndexVo> getJurisdictionPage(CompanyChangeJurisdictionIndexParam param) {
        List list;
        PageInfo<CompanyChangeJurisdictionIndexVo> page = this.companyChangeInfoDetailV3Service.getJurisdictionPage(param);
        if (Boolean.TRUE.equals(param.getCount()) && CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode().equals(param.getDetailStatus()) && CollUtil.isNotEmpty((Collection)(list = page.getList()))) {
            List<Pair<Long, Long>> changeInfoIdCidPairs = list.stream().map(item -> new Pair((Object)item.getChangeInfoId(), (Object)item.getCid())).collect(Collectors.toList());
            Map<Pair<Long, Long>, List<CompanyChangeInfoDetailReturnLogV3>> returnLogMap = this.companyChangeInfoDetailReturnLogV3Service.getResubmissionLogListMap(changeInfoIdCidPairs);
            list.forEach(item -> {
                Pair key = new Pair((Object)item.getChangeInfoId(), (Object)item.getCid());
                List returnLogList = (List)returnLogMap.get(key);
                CompanyChangeUtils.timeCalculation((CompanyChangeInfoTimeCalculationVo)item, returnLogList);
            });
        }
        return page;
    }

    public Boolean changeStatus(CompanyChangeInfoChangeStatusParam param) {
        param.setConfirmType(CompanyChangeConfirmTypeEnum.hand.getCode());
        return this.companyChangeStatusService.changeStatus(param);
    }

    public CompanyChangeInfoV3 getById(Long changeInfoId) {
        return (CompanyChangeInfoV3)this.companyChangeInfoV3Service.getById(changeInfoId);
    }

    public PageInfo<CompanyChangeJurisdictionAutoAuditChangeVo> getJurisdictionAutoChangePage(JqGridParam jParam, Long areaId, Byte areaLevel) {
        return this.companyChangeInfoDetailV3Service.getJurisdictionAutoChangeList(jParam, areaId, areaLevel);
    }

    public Boolean workStart(CompanyChangeJurisdictionWorkStartParam param) {
        return this.companyChangeInfoDetailV3Service.updateWorkStartWhereStillEq0(param);
    }

    public Boolean changeStatusJurisdiction(CompanyChangeInfoChangeStatusJurisdictionParam param) {
        List<CompanyChangeInfoDetailV3> changeInfoDetailList = this.companyChangeInfoDetailV3Service.getListByChangeInfoDetailId(param.getChangeInfoDetailIdList());
        if (CollUtil.isEmpty(changeInfoDetailList)) {
            return Boolean.FALSE;
        }
        Map needConfirmMap = changeInfoDetailList.stream().filter(item -> CompanyChangeDetailStatusEnum.PENDING_CONFIRMATION.getCode().equals(item.getDetailStatus())).collect(Collectors.groupingBy(CompanyChangeInfoDetailV3::getChangeInfoId, Collectors.mapping(CompanyChangeInfoDetailV3::getCid, Collectors.toList())));
        if (MapUtil.isEmpty(needConfirmMap)) {
            return Boolean.FALSE;
        }
        needConfirmMap.forEach((changeInfoId, cidList) -> {
            CompanyChangeInfoChangeStatusParam auditParam = new CompanyChangeInfoChangeStatusParam();
            auditParam.setChangeInfoId(changeInfoId);
            auditParam.setCidList(cidList);
            auditParam.setStatus(param.getStatus());
            auditParam.setReason(param.getReason());
            auditParam.setConfirmType(CompanyChangeConfirmTypeEnum.hand.getCode());
            auditParam.setUserId(param.getUserId());
            auditParam.setUserOrgId(param.getUserOrgId());
            auditParam.setUserName(param.getUserName());
            this.companyChangeStatusService.changeStatus(auditParam);
        });
        return Boolean.TRUE;
    }

    public PageInfo<CompanyChangeIndexClueVo> getIndexCluePage(CompanyChangeIndexClueParam param) {
        PageInfo<CompanyChangeIndexClueVo> page = this.companyChangeInfoDetailV3Service.getIndexCluePage(param);
        if (Boolean.TRUE.equals(param.getCount()) && CollUtil.isNotEmpty((Collection)page.getList())) {
            List allFileIds = page.getList().stream().filter(enterpriseVo -> StrUtil.isNotBlank((CharSequence)enterpriseVo.getFileIds())).flatMap(enterpriseVo -> Arrays.stream(enterpriseVo.getFileIds().split(","))).map(String::trim).filter(CharSequenceUtil::isNotBlank).map(fileIdStr -> {
                try {
                    return Long.parseLong(fileIdStr);
                }
                catch (NumberFormatException e) {
                    log.warn("Invalid file id format: {}", fileIdStr);
                    return null;
                }
            }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> fileModelMap = new HashMap();
            if (CollUtil.isNotEmpty(allFileIds)) {
                String fileIdsStr = allFileIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                List fileModels = this.sysFileProvideService.getListByIds(fileIdsStr);
                fileModelMap = fileModels.stream().collect(Collectors.toMap(SysFileModel::getId, Function.identity(), (v1, v2) -> v1));
            }
            for (CompanyChangeIndexClueVo enterpriseVo2 : page.getList()) {
                if (!StrUtil.isNotBlank((CharSequence)enterpriseVo2.getFileIds())) continue;
                List files = Arrays.stream(enterpriseVo2.getFileIds().split(",")).map(String::trim).filter(CharSequenceUtil::isNotBlank).map(fileIdStr -> {
                    try {
                        return Long.parseLong(fileIdStr);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Invalid file id format: {}", fileIdStr);
                        return null;
                    }
                }).filter(Objects::nonNull).map(fileModelMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                enterpriseVo2.setFiles(files);
            }
        }
        return page;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean ifAdoptClue(CompanyChangeIndexClueIfAdoptClueParam param) {
        List pendingConfirmationList = this.companyProposedChangeProviderService.selectAllPendingConfirmationListDataByIdList(param.getIdList());
        if (CollUtil.isEmpty((Collection)pendingConfirmationList)) {
            return false;
        }
        Long userId = param.getUserId();
        if (param.getIfAdopt().booleanValue()) {
            if (SystemDeploymentSourceEnum.DONG_YANG.getCode().equals(param.getSystemDeploymentSource()) && StopTypeEnums.CLOSE.getCode().equals(param.getStopType())) {
                this.changeType1(userId, pendingConfirmationList);
                return true;
            } else if (SystemDeploymentSourceEnum.DONG_YANG.getCode().equals(param.getSystemDeploymentSource()) && StopTypeEnums.CHANGECROSS.getCode().equals(param.getStopType())) {
                this.changeType3(userId, pendingConfirmationList);
                return true;
            } else if (SystemDeploymentSourceEnum.DONG_YANG.getCode().equals(param.getSystemDeploymentSource()) && StopTypeEnums.CHANGEWITHIN.getCode().equals(param.getStopType())) {
                this.changeType4(userId, pendingConfirmationList);
                return true;
            } else if (StopTypeEnums.CHANGEDISTRICTWITHIN.getCode().equals(param.getStopType())) {
                this.changeType6(userId, pendingConfirmationList);
                return true;
            } else {
                if (!StopTypeEnums.NORMAL.getCode().equals(param.getStopType())) throw new HealthException("\u5165\u53c2\u4e0d\u5408\u6cd5");
                this.changeType5(userId, pendingConfirmationList);
            }
            return true;
        } else {
            CompanyProposedChangeStatusForIdParam dto = new CompanyProposedChangeStatusForIdParam();
            dto.setUserId(param.getUserId());
            dto.setIdList(param.getIdList());
            dto.setStatus(StopStatusEnums.RETURNED.getCode());
            dto.setConfirmTime(LocalDateTime.now());
            return this.companyProposedChangeProviderService.updateStatusForId(dto);
        }
    }

    private void changeType1(Long userId, List<CompanyProposedChange> pendingConfirmationList) {
        List cidList = pendingConfirmationList.stream().map(CompanyProposedChange::getCid).collect(Collectors.toList());
        Date date = new Date();
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setBusinessState(Byte.valueOf(CompanyBusinessState.CLOSE.getCode().byteValue()));
            company.setBusinessUpdateTime(date);
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanySuperviseByCidList(updateCompanyList, userId);
        CompanyProposedChangeStatusForCidParam companyProposedChangeStatusForCidParam = new CompanyProposedChangeStatusForCidParam();
        companyProposedChangeStatusForCidParam.setUserId(userId);
        companyProposedChangeStatusForCidParam.setCidList(cidList);
        companyProposedChangeStatusForCidParam.setStopType(StopTypeEnums.CLOSE.getCode());
        companyProposedChangeStatusForCidParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForCidParam.setConfirmTime(LocalDateTime.now());
        this.companyProposedChangeProviderService.updateStatusForCid(companyProposedChangeStatusForCidParam);
        this.sysUserThirdService.disableOrEnableUserByCidList(cidList, Integer.valueOf(1), userId);
    }

    private void changeType3(Long userId, List<CompanyProposedChange> pendingConfirmationList) {
        List cidList = pendingConfirmationList.stream().map(CompanyProposedChange::getCid).collect(Collectors.toList());
        Date date = new Date();
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(pendingConfirmationList.size());
        ArrayList<Long> disabaleUserCidList = new ArrayList<Long>();
        ArrayList<CompanyProposedChange> innerInfoDetailList = new ArrayList<CompanyProposedChange>();
        ArrayList<Long> outCidList = new ArrayList<Long>();
        for (CompanyProposedChange detail : pendingConfirmationList) {
            if (Objects.equals(detail.getStopAreaId(), 0L)) {
                outCidList.add(detail.getCid());
                continue;
            }
            innerInfoDetailList.add(detail);
        }
        if (CollUtil.isNotEmpty(outCidList)) {
            for (Long cid : outCidList) {
                CompanySuperviseModel company = new CompanySuperviseModel();
                company.setId(cid);
                company.setCid(cid);
                company.setAreaDetailId(Long.valueOf(0L));
                company.setBusinessState(Byte.valueOf(CompanyBusinessState.CLOSE.getCode().byteValue()));
                company.setBusinessUpdateTime(date);
                company.setSupervisionUnit(Long.valueOf(0L));
                company.setSupervisionAreaId(Long.valueOf(0L));
                company.setBelongType(CompanyBelongTypeEnum.NO.getValue());
                updateCompanyList.add(company);
                disabaleUserCidList.add(cid);
            }
        }
        if (CollUtil.isNotEmpty(innerInfoDetailList)) {
            Map<Long, Long> transferAreaIdMap = innerInfoDetailList.stream().collect(Collectors.toMap(CompanyProposedChange::getCid, CompanyProposedChange::getStopAreaId));
            List transferAreaIdList = innerInfoDetailList.stream().map(CompanyProposedChange::getStopAreaId).distinct().collect(Collectors.toList());
            Map transferAreaMap = this.sysAreaProvideService.getAreaMapByIdList(transferAreaIdList);
            List<Long> innnerCidList = innerInfoDetailList.stream().map(CompanyProposedChange::getCid).toList();
            Map<Long, CompanySuperviseModel> companySuperviseMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(innnerCidList);
            List transferRealLevelAreaIdList = companySuperviseMap.values().stream().map(i -> {
                Long transferAreaId = (Long)transferAreaIdMap.get(i.getCid());
                AreaModel area = (AreaModel)transferAreaMap.get(transferAreaId);
                Long areaId = Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : (Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : area.getAreaId());
                return areaId;
            }).distinct().collect(Collectors.toList());
            Map organizationMap = this.organizationService.getOrganizationMapByAreaIdList(transferRealLevelAreaIdList);
            for (Long cid : innnerCidList) {
                Long areaDetailId = transferAreaIdMap.get(cid);
                CompanySuperviseModel company = new CompanySuperviseModel();
                company.setId(cid);
                company.setCid(cid);
                company.setAreaDetailId(areaDetailId);
                AreaModel areaModel = (AreaModel)transferAreaMap.get(areaDetailId);
                if (Objects.nonNull(areaModel)) {
                    Organization org;
                    Long areaId;
                    CompanySuperviseModel superviseModel = companySuperviseMap.get(cid);
                    if (Objects.nonNull(superviseModel) && Objects.nonNull(areaId = Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getProvinceId() : (Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getCityId() : ((AreaModel)transferAreaMap.get(areaDetailId)).getAreaId())) && Objects.nonNull(org = (Organization)organizationMap.get(areaId))) {
                        company.setSupervisionUnit(org.getId());
                        company.setSupervisionAreaId(org.getAreaId());
                    }
                } else {
                    company.setSupervisionUnit(Long.valueOf(0L));
                    company.setSupervisionAreaId(Long.valueOf(0L));
                    company.setBelongType(CompanyBelongTypeEnum.NO.getValue());
                }
                updateCompanyList.add(company);
            }
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        this.companyProvideBySuperviseService.updateCompanySuperviseByCidList(updateCompanyList, userId);
        CompanyProposedChangeStatusForAreaParam companyProposedChangeStatusForAreaParam = new CompanyProposedChangeStatusForAreaParam();
        companyProposedChangeStatusForAreaParam.setUserId(userId);
        companyProposedChangeStatusForAreaParam.setStopType(StopTypeEnums.CHANGECROSS.getCode());
        companyProposedChangeStatusForAreaParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForAreaParam.setConfirmTime(LocalDateTime.now());
        companyProposedChangeStatusForAreaParam.setDtoList(pendingConfirmationList.stream().map(i -> {
            CompanyProposedChangeStatusForAreaDTO dto = new CompanyProposedChangeStatusForAreaDTO();
            dto.setCid(i.getCid());
            dto.setStopAreaId(i.getStopAreaId());
            return dto;
        }).toList());
        this.companyProposedChangeProviderService.updateStatusForArea(companyProposedChangeStatusForAreaParam);
        if (CollUtil.isNotEmpty(disabaleUserCidList)) {
            this.sysUserThirdService.disableOrEnableUserByCidList(disabaleUserCidList, Integer.valueOf(1), userId);
        }
    }

    private void changeType4(Long userId, List<CompanyProposedChange> pendingConfirmationList) {
        List<Long> cidList = pendingConfirmationList.stream().map(CompanyProposedChange::getCid).toList();
        Map<Long, Long> transferAreaIdMap = pendingConfirmationList.stream().collect(Collectors.toMap(CompanyProposedChange::getCid, CompanyProposedChange::getStopAreaId));
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setAreaDetailId(transferAreaIdMap.get(cid));
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        CompanyProposedChangeStatusForAreaParam companyProposedChangeStatusForAreaParam = new CompanyProposedChangeStatusForAreaParam();
        companyProposedChangeStatusForAreaParam.setUserId(userId);
        companyProposedChangeStatusForAreaParam.setStopType(StopTypeEnums.CHANGEWITHIN.getCode());
        companyProposedChangeStatusForAreaParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForAreaParam.setConfirmTime(LocalDateTime.now());
        companyProposedChangeStatusForAreaParam.setDtoList(pendingConfirmationList.stream().map(i -> {
            CompanyProposedChangeStatusForAreaDTO dto = new CompanyProposedChangeStatusForAreaDTO();
            dto.setCid(i.getCid());
            dto.setStopAreaId(i.getStopAreaId());
            return dto;
        }).toList());
        this.companyProposedChangeProviderService.updateStatusForArea(companyProposedChangeStatusForAreaParam);
    }

    private void changeType6(Long userId, List<CompanyProposedChange> pendingConfirmationList) {
        List<Long> cidList = pendingConfirmationList.stream().map(CompanyProposedChange::getCid).toList();
        Map<Long, Long> transferAreaIdMap = pendingConfirmationList.stream().collect(Collectors.toMap(CompanyProposedChange::getCid, CompanyProposedChange::getStopAreaId));
        List transferAreaIdList = pendingConfirmationList.stream().map(CompanyProposedChange::getStopAreaId).distinct().collect(Collectors.toList());
        Map transferAreaMap = this.sysAreaProvideService.getAreaMapByIdList(transferAreaIdList);
        List<Long> innnerCidList = pendingConfirmationList.stream().map(CompanyProposedChange::getCid).toList();
        Map<Long, CompanySuperviseModel> companySuperviseMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(innnerCidList);
        List transferRealLevelAreaIdList = companySuperviseMap.values().stream().map(i -> {
            Long transferAreaId = (Long)transferAreaIdMap.get(i.getCid());
            AreaModel area = (AreaModel)transferAreaMap.get(transferAreaId);
            Long areaId = Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : (Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : area.getAreaId());
            return areaId;
        }).distinct().collect(Collectors.toList());
        Map organizationMap = this.organizationService.getOrganizationMapByAreaIdList(transferRealLevelAreaIdList);
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : innnerCidList) {
            Long areaDetailId = transferAreaIdMap.get(cid);
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setAreaDetailId(areaDetailId);
            AreaModel areaModel = (AreaModel)transferAreaMap.get(areaDetailId);
            if (Objects.nonNull(areaModel)) {
                Organization org;
                Long areaId;
                CompanySuperviseModel superviseModel = companySuperviseMap.get(cid);
                if (Objects.nonNull(superviseModel) && Objects.nonNull(areaId = Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getProvinceId() : (Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getCityId() : ((AreaModel)transferAreaMap.get(areaDetailId)).getAreaId())) && Objects.nonNull(org = (Organization)organizationMap.get(areaId))) {
                    company.setSupervisionUnit(org.getId());
                    company.setSupervisionAreaId(org.getAreaId());
                }
            } else {
                company.setSupervisionUnit(Long.valueOf(0L));
                company.setSupervisionAreaId(Long.valueOf(0L));
                company.setBelongType(CompanyBelongTypeEnum.NO.getValue());
            }
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        this.companyProvideBySuperviseService.updateCompanySuperviseByCidList(updateCompanyList, userId);
        CompanyProposedChangeStatusForAreaParam companyProposedChangeStatusForAreaParam = new CompanyProposedChangeStatusForAreaParam();
        companyProposedChangeStatusForAreaParam.setUserId(userId);
        companyProposedChangeStatusForAreaParam.setStopType(StopTypeEnums.CHANGEDISTRICTWITHIN.getCode());
        companyProposedChangeStatusForAreaParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForAreaParam.setConfirmTime(LocalDateTime.now());
        companyProposedChangeStatusForAreaParam.setDtoList(pendingConfirmationList.stream().map(i -> {
            CompanyProposedChangeStatusForAreaDTO dto = new CompanyProposedChangeStatusForAreaDTO();
            dto.setCid(i.getCid());
            dto.setStopAreaId(i.getStopAreaId());
            return dto;
        }).toList());
        this.companyProposedChangeProviderService.updateStatusForArea(companyProposedChangeStatusForAreaParam);
    }

    private void changeType5(Long userId, List<CompanyProposedChange> pendingConfirmationList) {
        List<Long> cidList = pendingConfirmationList.stream().map(CompanyProposedChange::getCid).toList();
        Map<Long, CompanySuperviseModel> companySuperviseMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByCidExcludeDelete(cidList);
        AbstractCompanyChangeStrategy.judgeCompanyIrsBusinessState(new ArrayList<CompanySuperviseModel>(companySuperviseMap.values()), null);
        Map<Long, Long> transferAreaIdMap = companySuperviseMap.values().stream().collect(Collectors.toMap(CompanyBaseInfoModel::getCid, CompanyBaseInfoModel::getAreaDetailId));
        List transferAreaIdList = companySuperviseMap.values().stream().map(CompanyBaseInfoModel::getAreaDetailId).distinct().collect(Collectors.toList());
        Map transferAreaMap = this.sysAreaProvideService.getAreaMapByIdList(transferAreaIdList);
        List transferRealLevelAreaIdList = companySuperviseMap.values().stream().map(i -> {
            Long transferAreaId = (Long)transferAreaIdMap.get(i.getCid());
            AreaModel area = (AreaModel)transferAreaMap.get(transferAreaId);
            Long areaId = Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : (Objects.equals(i.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : area.getAreaId());
            return areaId;
        }).distinct().collect(Collectors.toList());
        Map organizationMap = this.organizationService.getOrganizationMapByAreaIdList(transferRealLevelAreaIdList);
        Date date = new Date();
        ArrayList<CompanySuperviseModel> updateCompanyList = new ArrayList<CompanySuperviseModel>(cidList.size());
        for (Long cid : cidList) {
            Long areaDetailId = transferAreaIdMap.get(cid);
            CompanySuperviseModel company = new CompanySuperviseModel();
            company.setId(cid);
            company.setCid(cid);
            company.setBusinessState(Byte.valueOf(CompanyBusinessState.NORMAL.getCode().byteValue()));
            company.setBusinessUpdateTime(date);
            AreaModel areaModel = (AreaModel)transferAreaMap.get(areaDetailId);
            if (Objects.nonNull(areaModel)) {
                Organization org;
                Long areaId;
                CompanySuperviseModel superviseModel = companySuperviseMap.get(cid);
                if (Objects.nonNull(superviseModel) && Objects.nonNull(areaId = Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHENG.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getProvinceId() : (Objects.equals(superviseModel.getBelongType(), CompanyBelongTypeEnum.SHI.getValue()) ? ((AreaModel)transferAreaMap.get(areaDetailId)).getCityId() : ((AreaModel)transferAreaMap.get(areaDetailId)).getAreaId())) && Objects.nonNull(org = (Organization)organizationMap.get(areaId))) {
                    company.setSupervisionUnit(org.getId());
                    company.setSupervisionAreaId(org.getAreaId());
                }
            } else {
                company.setSupervisionUnit(Long.valueOf(0L));
                company.setSupervisionAreaId(Long.valueOf(0L));
                company.setBelongType(CompanyBelongTypeEnum.NO.getValue());
            }
            updateCompanyList.add(company);
        }
        this.companyProvideBySuperviseService.updateCompanyByIdList(updateCompanyList, userId);
        this.companyProvideBySuperviseService.updateCompanySuperviseByCidList(updateCompanyList, userId);
        CompanyProposedChangeStatusForCidParam companyProposedChangeStatusForCidParam = new CompanyProposedChangeStatusForCidParam();
        companyProposedChangeStatusForCidParam.setUserId(userId);
        companyProposedChangeStatusForCidParam.setCidList(cidList);
        companyProposedChangeStatusForCidParam.setStopType(StopTypeEnums.NORMAL.getCode());
        companyProposedChangeStatusForCidParam.setStatus(StopStatusEnums.CONFIRMED.getCode());
        companyProposedChangeStatusForCidParam.setConfirmTime(LocalDateTime.now());
        this.companyProposedChangeProviderService.updateStatusForCid(companyProposedChangeStatusForCidParam);
        this.sysUserThirdService.disableOrEnableUserByCidList(cidList, Integer.valueOf(0), userId);
    }

    public List<CompanyChangeInfoDetailV3> getCompanyIsFormalProcessListByCidList(List<Long> cidList) {
        return this.companyChangeInfoDetailV3Service.getCompanyIsFormalProcessListByCidList(null, cidList);
    }

    public Boolean delCompanyIsFormalProcessByCid(Long cid, String name, Long areaId, Long userId, String userName) {
        if (Objects.isNull(cid) || StrUtil.isBlank((CharSequence)name) || Objects.isNull(areaId) || Objects.isNull(userId) || StrUtil.isBlank((CharSequence)userName)) {
            throw new HealthException("\u53c2\u6570\u5f02\u5e38");
        }
        Example example = new Example(CompanyChangeInfoDetailV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andIn("changeType", Arrays.asList(CompanyChangeTypeEnum.crossMigration.getCode(), CompanyChangeTypeEnum.intraMigration.getCode(), CompanyChangeTypeEnum.districtMigration.getCode()));
        List companyChangeInfoDetailList = this.companyChangeInfoDetailV3Service.getListByExample(example);
        if (CollUtil.isEmpty((Collection)companyChangeInfoDetailList)) {
            return false;
        }
        if (companyChangeInfoDetailList.size() > 1) {
            log.error("\u8be5\u4f01\u4e1a\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u8fc1\u79fb\u5de5\u5355,cid:{}", (Object)cid);
            return false;
        }
        CompanyChangeInfoDetailV3 companyChangeInfoDetail = (CompanyChangeInfoDetailV3)companyChangeInfoDetailList.get(0);
        Long changeInfoId = companyChangeInfoDetail.getChangeInfoId();
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(areaId);
        if (Objects.nonNull(changeInfoId) && Objects.nonNull(area)) {
            companyChangeInfoDetail.setIsValid(Boolean.valueOf(false));
            companyChangeInfoDetail.setUpdateBy(userId);
            companyChangeInfoDetail.setUpdateDate(LocalDateTime.now());
            this.companyChangeInfoDetailV3Service.delete(companyChangeInfoDetail, userId);
            this.workOperateLogService.addCompanyChangeLog(changeInfoId, userId, userName, WorkOperateLogStatusEnum.ignore.getVal(), Collections.singletonList(cid), "\u8be5\u4f01\u4e1a\u5df2\u88ab\u8fc1\u79fb\u81f3" + area.getCityName() + area.getAreaName() + area.getStreetName());
        }
        CompanyChangeInfoV3 companyChangeInfo = (CompanyChangeInfoV3)this.companyChangeInfoV3Service.getById(changeInfoId);
        List<CompanyChangeInfoDetailV3> remainingAuditQuantityList = this.companyChangeInfoDetailV3Service.getRemainingAuditQuantityList(changeInfoId);
        if (CollUtil.isEmpty(remainingAuditQuantityList)) {
            companyChangeInfo.setUpdateBy(userId);
            companyChangeInfo.setUpdateDate(LocalDateTime.now());
            companyChangeInfo.setStatus(CompanyChangeStatusEnum.STOPPED.getCode());
            companyChangeInfo.setAuditOrgId(Long.valueOf(-1L));
            companyChangeInfo.setAuditTime(LocalDateTime.now());
            this.companyChangeInfoV3Service.updateStatusForEntity(companyChangeInfo);
        }
        return true;
    }

    public CompanyChangeStatisticsWithIdentifyVoForLayUi getCompanyChangeStatisticsWithIdentifyVoList(CompanyChangeStatisticsSearchParam param) {
        if (param.getAreaLevel() > 3) {
            return new CompanyChangeStatisticsWithIdentifyVoForLayUi();
        }
        SysAreaV3Param areaV3Param = new SysAreaV3Param();
        areaV3Param.setId(param.getAreaId());
        List listByParentIdV3 = this.sysAreaProvideService.getNextLevelAreaListByParentIdV3(areaV3Param);
        if (CollUtil.isEmpty((Collection)listByParentIdV3)) {
            return new CompanyChangeStatisticsWithIdentifyVoForLayUi();
        }
        Map<Long, CompanyChangeStatisticsWithIdentifyDTO> map = this.companyChangeInfoDetailV3Service.getComChangeStatisticsWithIdentifyCountMap(param);
        ArrayList<CompanyChangeStatisticsWithIdentifyDTO> list = new ArrayList<CompanyChangeStatisticsWithIdentifyDTO>(listByParentIdV3.size());
        CompanyChangeStatisticsWithIdentifyDTO originalCompanyChangeStatisticsVo = new CompanyChangeStatisticsWithIdentifyDTO();
        listByParentIdV3.parallelStream().forEach(areaV3ListVo -> {
            CompanyChangeStatisticsWithIdentifyDTO statisticsVo = new CompanyChangeStatisticsWithIdentifyDTO();
            statisticsVo.setAreaId(areaV3ListVo.getId());
            statisticsVo.setAreaLevel(areaV3ListVo.getLevel());
            statisticsVo.setAreaName(areaV3ListVo.getName());
            CompanyChangeStatisticsWithIdentifyDTO companyChangeStatisticsVo = map.getOrDefault(areaV3ListVo.getId(), originalCompanyChangeStatisticsVo);
            statisticsVo.setNormalToPauseNum(companyChangeStatisticsVo.getNormalToPauseNum());
            statisticsVo.setNormalToCloseNum(companyChangeStatisticsVo.getNormalToCloseNum());
            statisticsVo.setNormalToCloseByTransNum(companyChangeStatisticsVo.getNormalToCloseByTransNum());
            statisticsVo.setPauseToNormalNum(companyChangeStatisticsVo.getPauseToNormalNum());
            statisticsVo.setPauseToCloseNum(companyChangeStatisticsVo.getPauseToCloseNum());
            statisticsVo.setPauseToCloseByTransNum(companyChangeStatisticsVo.getPauseToCloseByTransNum());
            statisticsVo.setCloseToNormalNum(companyChangeStatisticsVo.getCloseToNormalNum());
            statisticsVo.setVictimsNumD3(companyChangeStatisticsVo.getVictimsNumD3());
            statisticsVo.setVictimsNumX3(companyChangeStatisticsVo.getVictimsNumX3());
            statisticsVo.setLaborDispatchNum(companyChangeStatisticsVo.getLaborDispatchNum());
            statisticsVo.setEmployersNum(companyChangeStatisticsVo.getEmployersNum());
            statisticsVo.setLaborDispatchAndEmployersNum(companyChangeStatisticsVo.getLaborDispatchAndEmployersNum());
            list.add(statisticsVo);
        });
        list.sort(Comparator.comparing(CompanyChangeStatisticsWithIdentifyDTO::getAreaId));
        CompanyChangeStatisticsWithIdentifyDTO totalRow = list.stream().reduce(new CompanyChangeStatisticsWithIdentifyDTO(), (total, next) -> {
            total.setNormalToPauseNum(Integer.valueOf(total.getNormalToPauseNum() + next.getNormalToPauseNum()));
            total.setNormalToCloseNum(Integer.valueOf(total.getNormalToCloseNum() + next.getNormalToCloseNum()));
            total.setNormalToCloseByTransNum(Integer.valueOf(total.getNormalToCloseByTransNum() + next.getNormalToCloseByTransNum()));
            total.setPauseToNormalNum(Integer.valueOf(total.getPauseToNormalNum() + next.getPauseToNormalNum()));
            total.setPauseToCloseNum(Integer.valueOf(total.getPauseToCloseNum() + next.getPauseToCloseNum()));
            total.setPauseToCloseByTransNum(Integer.valueOf(total.getPauseToCloseByTransNum() + next.getPauseToCloseByTransNum()));
            total.setCloseToNormalNum(Integer.valueOf(total.getCloseToNormalNum() + next.getCloseToNormalNum()));
            total.setVictimsNumD3(Integer.valueOf(total.getVictimsNumD3() + next.getVictimsNumD3()));
            total.setVictimsNumX3(Integer.valueOf(total.getVictimsNumX3() + next.getVictimsNumX3()));
            total.setLaborDispatchNum(Integer.valueOf(total.getLaborDispatchNum() + next.getLaborDispatchNum()));
            total.setEmployersNum(Integer.valueOf(total.getEmployersNum() + next.getEmployersNum()));
            total.setLaborDispatchAndEmployersNum(Integer.valueOf(total.getLaborDispatchAndEmployersNum() + next.getLaborDispatchAndEmployersNum()));
            return total;
        });
        totalRow.setAreaName("\u5408\u8ba1");
        return new CompanyChangeStatisticsWithIdentifyVoForLayUi(list, totalRow);
    }

    private void postSetCompanyRegionAddressName(List<CompanyChangeInfoIndexAuditAOrViewAListVo> changeInfoList) {
        if (CollUtil.isEmpty(changeInfoList)) {
            return;
        }
        List<CompanyChangeInfoIndexAuditAOrViewAListVo> filteredList = changeInfoList.stream().filter(c -> Objects.equals(c.getChangeType(), CompanyChangeTypeEnum.changeCompanyScale.getCode())).collect(Collectors.toList());
        if (CollUtil.isEmpty(filteredList)) {
            return;
        }
        String regionIds = filteredList.stream().map(CompanyChangeInfoIndexAuditAOrViewAListVo::getRegionId).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        List regionList = this.sysAreaProvideService.getAreaListByIds(regionIds);
        Map<Long, String> regionMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, AreaModel::getName));
        Map<Long, String> regionFullMap = regionList.stream().collect(Collectors.toMap(AreaModel::getId, this::buildRegionFullName));
        filteredList.forEach(n -> {
            n.setRegionName((String)regionMap.get(n.getRegionId()));
            n.setRegionFullName((String)regionFullMap.get(n.getRegionId()));
        });
    }

    private void postSetCompanyScaleNameForIndex(List<CompanyChangeInfoIndexAuditAOrViewAListVo> changeInfoList) {
        if (CollUtil.isEmpty(changeInfoList)) {
            return;
        }
        for (CompanyChangeInfoIndexAuditAOrViewAListVo changeInfo : changeInfoList) {
            changeInfo.setBeforeScaleName(this.getScaleName(changeInfo.getBeforeScale()));
            changeInfo.setAfterScaleName(this.getScaleName(changeInfo.getAfterScale()));
        }
    }

    private void postSetCompanyScaleNameForStep1(List<CompanyChangeInfoIndexSubAVo> changeInfoList) {
        if (CollUtil.isEmpty(changeInfoList)) {
            return;
        }
        for (CompanyChangeInfoIndexSubAVo changeInfo : changeInfoList) {
            changeInfo.setScaleName(this.getScaleName(changeInfo.getScale()));
        }
    }

    private String buildRegionFullName(AreaModel region) {
        if (region == null) {
            return "-";
        }
        return switch (region.getLevel()) {
            case 0 -> "\u56fd\u5bb6";
            case 1 -> this.buildPath(region.getProvinceName());
            case 2 -> this.buildPath(region.getProvinceName(), region.getCityName());
            case 3 -> this.buildPath(region.getProvinceName(), region.getCityName(), region.getAreaName());
            case 4 -> this.buildPath(region.getProvinceName(), region.getCityName(), region.getAreaName(), region.getStreetName());
            default -> "-";
        };
    }

    private String buildPath(String ... parts) {
        return Arrays.stream(parts).map(part -> StrUtil.isBlank((CharSequence)part) ? "-" : part).collect(Collectors.joining("/"));
    }

    private String getScaleName(Byte scale) {
        if (scale == null) {
            return "";
        }
        return switch (scale) {
            case 1 -> "\u5927\u578b\u4f01\u4e1a";
            case 2 -> "\u4e2d\u578b\u4f01\u4e1a";
            case 3 -> "\u5c0f\u578b\u4f01\u4e1a";
            case 4 -> "\u5fae\u578b\u4f01\u4e1a";
            case 5 -> "\u672a\u5212\u5206";
            default -> "";
        };
    }

    @Generated
    public CompanyChangeV3ProviderServiceImpl(CompanyChangeTask companyChangeTask, IdWorker idWorker, CompanyChangeStatusService companyChangeStatusService, ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service, ICompanyChangeInfoDetailReturnLogV3Service companyChangeInfoDetailReturnLogV3Service, ICompanyChangeInfoVictimsHistoryV3Service companyChangeInfoVictimsHistoryV3Service, ICompanyGradeV3RecService companyGradeV3RecService, IWorkOperateLogService workOperateLogService, ISysUserThirdService sysUserThirdService, IMicrocomCompanyYcqProvideService microcomCompanyYcqProvideService, ICompanyProvideBySuperviseService companyProvideBySuperviseService, ICompanyProposedChangeProviderService companyProposedChangeProviderService, IOrganizationUserService organizationUserService, ISysAreaProvideService sysAreaProvideService, ISysFileProvideService sysFileProvideService, IOrganizationService organizationService) {
        this.companyChangeTask = companyChangeTask;
        this.idWorker = idWorker;
        this.companyChangeStatusService = companyChangeStatusService;
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
        this.companyChangeInfoDetailReturnLogV3Service = companyChangeInfoDetailReturnLogV3Service;
        this.companyChangeInfoVictimsHistoryV3Service = companyChangeInfoVictimsHistoryV3Service;
        this.companyGradeV3RecService = companyGradeV3RecService;
        this.workOperateLogService = workOperateLogService;
        this.sysUserThirdService = sysUserThirdService;
        this.microcomCompanyYcqProvideService = microcomCompanyYcqProvideService;
        this.companyProvideBySuperviseService = companyProvideBySuperviseService;
        this.companyProposedChangeProviderService = companyProposedChangeProviderService;
        this.organizationUserService = organizationUserService;
        this.sysAreaProvideService = sysAreaProvideService;
        this.sysFileProvideService = sysFileProvideService;
        this.organizationService = organizationService;
    }
}

