/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.companyChange.v3.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.excel.ExcelUtils;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoDetailV3;
import cn.smarthse.modules.health.companyChange.v3.entity.CompanyChangeInfoV3;
import cn.smarthse.modules.health.companyChange.v3.listener.CompanyChangeV3ForOcStateChangeImportDTO;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexSubAddParam;
import cn.smarthse.modules.health.companyChange.v3.model.param.CompanyChangeInfoIndexSubRemoveParam;
import cn.smarthse.modules.health.companyChange.v3.provider.ICompanyChangeV3ProviderService;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoDetailV3Service;
import cn.smarthse.modules.health.companyChange.v3.service.ICompanyChangeInfoV3Service;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeEnum;
import cn.smarthse.modules.platform.model.AreaModel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyChangeV3ForOcStateChangeImportListener
extends AnalysisEventListener<CompanyChangeV3ForOcStateChangeImportDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyChangeV3ForOcStateChangeImportListener.class);
    private static final int BATCH_COUNT = 1000;
    private final List<CompanyChangeV3ForOcStateChangeImportDTO> dataList = new ArrayList<CompanyChangeV3ForOcStateChangeImportDTO>();
    private final List<CompanyChangeV3ForOcStateChangeImportDTO> errDataList = new ArrayList<CompanyChangeV3ForOcStateChangeImportDTO>();
    private List<Long> cidList = null;
    private int dataCount = 0;
    private final Long userId;
    private final Long userAreaId;
    private final Long changeInfoId;
    private final CompanyChangeInfoV3 companyChangeInfo;
    private final ICompanyChangeV3ProviderService companyChangeV3ProviderService;
    private final ISysAreaProvideService sysAreaProvideService;
    private final ICompanyChangeInfoV3Service companyChangeInfoV3Service;
    private final ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service;

    public CompanyChangeV3ForOcStateChangeImportListener(Long userId, Long userAreaId, Long changeInfoId, CompanyChangeInfoV3 companyChangeInfo, ICompanyChangeV3ProviderService companyChangeV3ProviderService, ISysAreaProvideService sysAreaProvideService, ICompanyChangeInfoV3Service companyChangeInfoV3Service, ICompanyChangeInfoDetailV3Service companyChangeInfoDetailV3Service) {
        this.userId = userId;
        this.userAreaId = userAreaId;
        this.changeInfoId = changeInfoId;
        this.companyChangeInfo = companyChangeInfo;
        this.companyChangeV3ProviderService = companyChangeV3ProviderService;
        this.sysAreaProvideService = sysAreaProvideService;
        this.companyChangeInfoV3Service = companyChangeInfoV3Service;
        this.companyChangeInfoDetailV3Service = companyChangeInfoDetailV3Service;
    }

    public void invoke(CompanyChangeV3ForOcStateChangeImportDTO dto, AnalysisContext context) {
        int rowIndex = context.readRowHolder().getRowIndex() + 1;
        log.debug("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e\uff0c\u884c\u53f7: {} {}", (Object)rowIndex, (Object)dto);
        dto.setCompanyName(StringUtils.toDBC((String)StrUtil.trimToEmpty((CharSequence)dto.getCompanyName()).replaceAll("\uff08", "(").replaceAll("\uff09", ")")));
        dto.setUnifiedSocialCc(StrUtil.toUpperCase((CharSequence)StrUtil.trimToEmpty((CharSequence)dto.getUnifiedSocialCc())));
        dto.setCompanyTypeStr(StrUtil.trimToEmpty((CharSequence)dto.getCompanyTypeStr()));
        if (StrUtil.isBlank((CharSequence)dto.getCompanyName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)1)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getUnifiedSocialCc())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)2)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getCompanyTypeStr())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u52b3\u52a1\u6d3e\u9063\u53d8\u66f4\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)3)));
        } else {
            String companyTypeStr;
            Integer comType = switch (companyTypeStr = dto.getCompanyTypeStr().trim()) {
                case "\u7528\u5de5\u5355\u4f4d\u53d8\u66f4\u4e3a\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d" -> 10;
                case "\u7528\u5de5\u5355\u4f4d\u53d8\u66f4\u4e3a\u7528\u5de5\u5355\u4f4d\u517c\u5177\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d\u53cc\u91cd\u89d2\u8272" -> 11;
                case "\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d\u53d8\u66f4\u4e3a\u7528\u5de5\u5355\u4f4d" -> 24;
                case "\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d\u53d8\u66f4\u4e3a\u7528\u5de5\u5355\u4f4d\u517c\u5177\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d\u53cc\u91cd\u89d2\u8272" -> 25;
                default -> null;
            };
            dto.setCompanyType(comType);
        }
        dto.setRowIndex(rowIndex);
        ++this.dataCount;
        if (Boolean.TRUE.equals(dto.getHaveError())) {
            this.errDataList.add(dto);
        } else {
            this.dataList.add(dto);
        }
        if (this.dataCount >= 1000) {
            this.saveData();
            this.dataList.clear();
            this.dataCount = 0;
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.debug("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210");
        this.saveData();
    }

    private void saveData() {
        if (CollUtil.isEmpty(this.errDataList) && CollUtil.isEmpty(this.dataList)) {
            CompanyChangeV3ForOcStateChangeImportDTO dto = new CompanyChangeV3ForOcStateChangeImportDTO();
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            this.errDataList.add(dto);
            throw new HealthException(JSON.toJSONString(this.errDataList));
        }
        if (CollUtil.isNotEmpty(this.errDataList)) {
            throw new HealthException(JSON.toJSONString(this.errDataList));
        }
        log.debug("{} \u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.dataList.size());
        try {
            if (CollUtil.isNotEmpty(this.dataList)) {
                Set usernameSet = this.dataList.stream().map(CompanyChangeV3ForOcStateChangeImportDTO::getCompanyName).collect(Collectors.toSet());
                if (usernameSet.size() < this.dataList.size()) {
                    CompanyChangeV3ForOcStateChangeImportDTO dto = new CompanyChangeV3ForOcStateChangeImportDTO();
                    dto.setHaveError(Boolean.TRUE);
                    dto.setErrorReason("\u5b58\u5728\u91cd\u590d\u4f01\u4e1a\u540d\u79f0");
                    this.errDataList.add(dto);
                    throw new HealthException(JSON.toJSONString(this.errDataList));
                }
                Set companyNameSet = this.dataList.stream().filter(f -> StrUtil.isNotBlank((CharSequence)f.getCompanyName())).map(CompanyChangeV3ForOcStateChangeImportDTO::getCompanyName).collect(Collectors.toSet());
                Map<String, CompanySuperviseModel> companyNameModelMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByNameExcludeDelete(new ArrayList<String>(companyNameSet));
                Set companyUnitCodeSet = this.dataList.stream().filter(f -> StrUtil.isNotBlank((CharSequence)f.getUnifiedSocialCc())).map(CompanyChangeV3ForOcStateChangeImportDTO::getUnifiedSocialCc).collect(Collectors.toSet());
                Map<String, List<CompanySuperviseModel>> unifiedCcModelMap = this.companyChangeInfoV3Service.getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete(new ArrayList<String>(companyUnitCodeSet));
                Map areaMap = this.sysAreaProvideService.getAreaMap();
                for (Object dto : this.dataList) {
                    CompanySuperviseModel companySuperviseModel = companyNameModelMap.get(dto.getCompanyName());
                    if (Objects.isNull(companySuperviseModel)) {
                        dto.setHaveError(true);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)1)));
                    } else {
                        byte userAreaLevel;
                        dto.setCid(companySuperviseModel.getId());
                        String unifiedSocialCc = companySuperviseModel.getUnifiedSocialCc();
                        Integer companyType = companySuperviseModel.getCompanyType();
                        Integer changeType = this.companyChangeInfo.getChangeType();
                        if ((Objects.equals(changeType, CompanyChangeTypeEnum.ocStateChange.getCode()) || Objects.equals(changeType, CompanyChangeTypeEnum.ocAndComStateChange.getCode())) && !Objects.equals(companyType, 1) && !Objects.equals(companyType, 3)) {
                            dto.setHaveError(true);
                            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u975e\u7528\u4eba\u5355\u4f4d\u6216\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d\u517c\u5177\u7528\u5de5\u5355\u4f4d\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)1)));
                        }
                        if ((Objects.equals(changeType, CompanyChangeTypeEnum.ocChangToEmployUnit.getCode()) || Objects.equals(changeType, CompanyChangeTypeEnum.ocChangToEmployAndOcUnit.getCode())) && !Objects.equals(companyType, 2)) {
                            dto.setHaveError(true);
                            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u975e\u52b3\u52a1\u6d3e\u9063\u5355\u4f4d\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)1)));
                        }
                        if (StrUtil.isNotBlank((CharSequence)unifiedSocialCc)) {
                            if ("0".equals(dto.getUnifiedSocialCc())) {
                                dto.setHaveError(true);
                                dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u4fe1\u7528\u4ee3\u7801\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)3)));
                            } else if (!unifiedSocialCc.equals(dto.getUnifiedSocialCc())) {
                                dto.setHaveError(true);
                                dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\uff0c\u4f46\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u76f8\u540c\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)2)));
                            }
                        }
                        if (!this.checkArea(companySuperviseModel.getAreaDetailId(), this.userAreaId, areaMap)) {
                            dto.setHaveError(true);
                            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u4e0d\u5728\u8f96\u533a\u5185\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)1)));
                        }
                        if ((userAreaLevel = ((AreaModel)areaMap.get(this.userAreaId)).getLevel().byteValue()) > 2) {
                            userAreaLevel = 0;
                        }
                        if (!Objects.equals(userAreaLevel, companySuperviseModel.getBelongType().byteValue())) {
                            dto.setHaveError(true);
                            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u975e\u672c\u7ea7\u7ba1\u7406\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)1)));
                        }
                        if (CompanyBusinessState.CLOSE.getCode().equals(companySuperviseModel.getBusinessState().intValue())) {
                            dto.setHaveError(true);
                            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u5df2\u5173\u505c\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)2)));
                        }
                    }
                    if (!"0".equals(dto.getUnifiedSocialCc())) {
                        List<CompanySuperviseModel> companySuperviseModels = unifiedCcModelMap.get(dto.getUnifiedSocialCc());
                        if (CollUtil.isNotEmpty(companySuperviseModels)) {
                            if (!dto.getUnifiedSocialCc().equals(companySuperviseModels.get(0).getUnifiedSocialCc())) {
                                dto.setHaveError(true);
                                dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\uff0c\u4f46\u4f01\u4e1a\u540d\u79f0\u4e0d\u76f8\u540c\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)2)));
                            }
                        } else {
                            dto.setHaveError(true);
                            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u4fe1\u7528\u4ee3\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)2)));
                        }
                    }
                    if (!Boolean.TRUE.equals(dto.getHaveError())) continue;
                    this.errDataList.add((CompanyChangeV3ForOcStateChangeImportDTO)((Object)dto));
                }
                if (CollUtil.isNotEmpty(this.errDataList)) {
                    throw new HealthException(JSON.toJSONString(this.errDataList));
                }
                this.cidList = this.dataList.stream().map(CompanyChangeV3ForOcStateChangeImportDTO::getCid).collect(Collectors.toList());
                Map<Long, CompanyChangeInfoDetailV3> companyIsFormalProcessMap = this.companyChangeInfoDetailV3Service.getCompanyIsFormalProcessMapByCidList(this.changeInfoId, this.cidList);
                if (MapUtil.isNotEmpty(companyIsFormalProcessMap)) {
                    for (CompanyChangeV3ForOcStateChangeImportDTO dto : this.dataList) {
                        if (!companyIsFormalProcessMap.containsKey(dto.getCid())) continue;
                        dto.setHaveError(true);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u4f01\u4e1a\u5df2\u5728\u5176\u4ed6\u53d8\u66f4\u7533\u8bf7\u6e05\u5355\u4e2d\uff0c\u8bf7\u6838\u5b9e\uff01", ExcelUtils.getExcelColName((int)1)));
                        this.errDataList.add(dto);
                    }
                }
                if (CollUtil.isNotEmpty(this.errDataList)) {
                    throw new HealthException(JSON.toJSONString(this.errDataList));
                }
                CompanyChangeInfoIndexSubAddParam param = new CompanyChangeInfoIndexSubAddParam();
                param.setChangeInfoId(this.changeInfoId);
                param.setCidList(this.cidList);
                param.setSubmitUserId(this.userId);
                Map<Long, Integer> cidChangeTypeMap = this.dataList.stream().collect(Collectors.toMap(CompanyChangeV3ForOcStateChangeImportDTO::getCid, CompanyChangeV3ForOcStateChangeImportDTO::getCompanyType, (v1, v2) -> v2));
                param.setCidChangeTypeMap(cidChangeTypeMap);
                this.companyChangeV3ProviderService.addCompany(param);
            }
        }
        catch (Exception e) {
            CompanyChangeInfoIndexSubRemoveParam param = new CompanyChangeInfoIndexSubRemoveParam();
            param.setChangeInfoId(this.changeInfoId);
            param.setCidList(this.cidList);
            param.setSubmitUserId(this.userId);
            this.companyChangeV3ProviderService.removeCompany(param);
            log.error("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
            throw e;
        }
        log.debug("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    private boolean checkArea(Long areaId, Long userAreaId, Map<Long, AreaModel> areaMap) {
        if (areaId == null || userAreaId == null || MapUtil.isEmpty(areaMap)) {
            return false;
        }
        if (Objects.equals(userAreaId, 0L)) {
            return true;
        }
        AreaModel area = areaMap.get(areaId);
        if (area == null) {
            return false;
        }
        return userAreaId.equals(area.getProvinceId()) || userAreaId.equals(area.getCityId()) || userAreaId.equals(area.getAreaId()) || userAreaId.equals(area.getStreetId());
    }
}

