/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.company.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.number.SysConvertTool;
import cn.smarthse.modules.health.company.dao.OptimizeEnvEconomicAccountTableMapper;
import cn.smarthse.modules.health.company.service.IOptimizeEnvEconomicAccountTableService;
import cn.smarthse.modules.health.entity.base.company.OptimizeEnvEconomicAccountTable;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.entity.work.statistics.CumulativeEconomicAccountData;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicEconomyService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.riskResolve.RegionRiskNumInfoVo;
import cn.smarthse.modules.health.vo.riskResolve.RegionRiskStatisticsVo;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class OptimizeEnvEconomicAccountTableServiceImpl
extends BaseServiceImpl<OptimizeEnvEconomicAccountTableMapper, OptimizeEnvEconomicAccountTable>
implements IOptimizeEnvEconomicAccountTableService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptimizeEnvEconomicAccountTableServiceImpl.class);
    @DubboReference
    private IReformItemBasicEconomyService reformItemBasicEconomyService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    public static final BigDecimal TEN_THOUSAND = Convert.toBigDecimal((Object)10000);
    public static final Integer PRE_PUSH_RISK_NUM = 497500;
    public static final Integer PRE_RESOLVE_RISK_NUM = 469200;
    public static final BigDecimal PRE_FREE_PUNISH_AMOUNT = Convert.toBigDecimal((Object)101700.0);

    @Transactional
    public void generateEconomicAccountTable() {
        ((OptimizeEnvEconomicAccountTableMapper)this.dao).deleteByExample(new Example(OptimizeEnvEconomicAccountTable.class));
        ((OptimizeEnvEconomicAccountTableMapper)this.dao).generateEconomicAccountTable();
    }

    public List<RegionRiskNumInfoVo> getEconomicAccountTable(RiskResolveResSearch searchParam) {
        return ((OptimizeEnvEconomicAccountTableMapper)this.dao).getEconomicAccountTable(searchParam);
    }

    public void generateCumulativeData(Boolean breakTimeLimit) {
        if (!OptimizeEnvEconomicAccountTableServiceImpl.shouldGenerateOrUpdateEconomicData().booleanValue() && !Boolean.TRUE.equals(breakTimeLimit)) {
            return;
        }
        int nowYear = LocalDate.now().getYear();
        Integer count1 = 0;
        Integer count2 = 0;
        BigDecimal count3 = BigDecimal.ZERO;
        for (int year = 2025; year <= nowYear; ++year) {
            RiskResolveResSearch param1 = new RiskResolveResSearch();
            param1.setPage(Integer.valueOf(1));
            param1.setRows(Integer.valueOf(6));
            param1.setSearchType(Integer.valueOf(0));
            param1.setPushDate(nowYear + "\u5e74");
            param1.setIsClassified("olddec");
            param1.setSystemDeploymentSource(SystemDeploymentSourceEnum.NO.getCode());
            param1.setAreaId(Long.valueOf(330000000000L));
            param1.setAreaLevel(Byte.valueOf((byte)1));
            count1 = count1 + this.reformItemBasicService.getReformRiskResolveResListCount(param1);
            RiskResolveResSearch param2 = new RiskResolveResSearch();
            param2.setPage(Integer.valueOf(1));
            param2.setRows(Integer.valueOf(6));
            param2.setSearchType(Integer.valueOf(0));
            param2.setReformStatus(ReformStatusEnum.WC.getValue());
            param2.setPushDate(LocalDate.now().getYear() + "\u5e74");
            param2.setIsClassified("olddec");
            param2.setSystemDeploymentSource(SystemDeploymentSourceEnum.NO.getCode());
            param2.setAreaId(Long.valueOf(330000000000L));
            param2.setAreaLevel(Byte.valueOf((byte)1));
            count2 = count2 + this.reformItemBasicService.getReformRiskResolveResListCount(param2);
            RiskResolveResSearch param3 = new RiskResolveResSearch();
            param3.setPage(Integer.valueOf(1));
            param3.setLimit(Integer.valueOf(20));
            param3.setAreaId(Long.valueOf(330000000000L));
            param3.setCompanyLevel(Integer.valueOf(1));
            param3.setAreaLevel(Byte.valueOf((byte)1));
            PageInfo page = this.reformItemBasicEconomyService.regionRiskNumCountListDataOptimize(param3);
            if (!CollUtil.isNotEmpty((Collection)page.getList())) continue;
            count3 = count3.add(OptimizeEnvEconomicAccountTableServiceImpl.reverseConvertUnit(((RegionRiskStatisticsVo)page.getList().get(0)).getFreePunishAmount()));
        }
        CumulativeEconomicAccountData data = new CumulativeEconomicAccountData();
        data.setId(Long.valueOf(IdWorker.getId()));
        data.setPushRiskNum(Integer.valueOf(count1 + PRE_PUSH_RISK_NUM));
        data.setResolveRiskNum(Integer.valueOf(count2 + PRE_RESOLVE_RISK_NUM));
        data.setFreePunishAmount(SysConvertTool.convertUnit((BigDecimal)count3.add(PRE_FREE_PUNISH_AMOUNT)));
        ((OptimizeEnvEconomicAccountTableMapper)this.dao).saveCumulativeEconomicAccountData(data);
    }

    public static BigDecimal reverseConvertUnit(String formattedAmount) {
        if (formattedAmount == null || formattedAmount.trim().isEmpty()) {
            return null;
        }
        String trimmed = formattedAmount.trim();
        try {
            if (trimmed.endsWith("\u5143") && !trimmed.endsWith("\u4e07\u5143") && !trimmed.endsWith("\u4ebf\u5143")) {
                String numberStr = trimmed.replace(" \u5143", "").trim();
                return new BigDecimal(numberStr).divide(TEN_THOUSAND, 2, RoundingMode.HALF_UP);
            }
            if (trimmed.endsWith("\u4e07\u5143")) {
                String numberStr = trimmed.replace(" \u4e07\u5143", "").trim();
                return new BigDecimal(numberStr);
            }
            if (trimmed.endsWith("\u4ebf\u5143")) {
                String numberStr = trimmed.replace(" \u4ebf\u5143", "").trim();
                return new BigDecimal(numberStr).multiply(TEN_THOUSAND);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Boolean shouldGenerateOrUpdateEconomicData() {
        LocalDate today = LocalDate.now();
        if (OptimizeEnvEconomicAccountTableServiceImpl.is26thOfMonth(today)) {
            return Boolean.TRUE;
        }
        if (OptimizeEnvEconomicAccountTableServiceImpl.isBetween27thAndMonthEnd(today)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static boolean is26thOfMonth(LocalDate date) {
        return date.getDayOfMonth() == 26;
    }

    private static boolean isBetween27thAndMonthEnd(LocalDate date) {
        return date.getDayOfMonth() >= 27;
    }
}

